/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.utils;

import com.google.common.collect.ImmutableList;
import com.google.inject.Injector;
import it.unibz.inf.ontop.dbschema.DatabaseRelationDefinition;
import it.unibz.inf.ontop.dbschema.RDBMetadata;
import it.unibz.inf.ontop.dbschema.RDBMetadataExtractionTools;
import it.unibz.inf.ontop.exception.DuplicateMappingException;
import it.unibz.inf.ontop.injection.OntopSQLCredentialSettings;
import it.unibz.inf.ontop.injection.OntopSQLOWLAPIConfiguration;
import it.unibz.inf.ontop.model.atom.TargetAtomFactory;
import it.unibz.inf.ontop.model.term.TermFactory;
import it.unibz.inf.ontop.model.term.functionsymbol.db.DBFunctionSymbolFactory;
import it.unibz.inf.ontop.model.type.TypeFactory;
import it.unibz.inf.ontop.protege.core.OBDAModel;
import it.unibz.inf.ontop.protege.core.OBDAModelManager;
import it.unibz.inf.ontop.protege.utils.JDBCConnectionManager;
import it.unibz.inf.ontop.spec.mapping.OBDASQLQuery;
import it.unibz.inf.ontop.spec.mapping.SQLMappingFactory;
import it.unibz.inf.ontop.spec.mapping.bootstrap.impl.DirectMappingAxiomProducer;
import it.unibz.inf.ontop.spec.mapping.bootstrap.impl.DirectMappingEngine;
import it.unibz.inf.ontop.spec.mapping.impl.SQLMappingFactoryImpl;
import it.unibz.inf.ontop.spec.mapping.pp.SQLPPMapping;
import it.unibz.inf.ontop.spec.mapping.pp.SQLPPTriplesMap;
import it.unibz.inf.ontop.spec.mapping.pp.impl.OntopNativeSQLPPTriplesMap;
import it.unibz.inf.ontop.spec.mapping.util.MappingOntologyUtils;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.rdf.api.RDF;
import org.protege.editor.owl.model.OWLModelManager;
import org.semanticweb.owlapi.model.AddAxiom;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLOntologyManager;

public class BootstrapGenerator {
    private final JDBCConnectionManager connManager = JDBCConnectionManager.getJDBCConnectionManager();
    private final OntopSQLOWLAPIConfiguration configuration;
    private final OBDAModel activeOBDAModel;
    private final OWLModelManager owlManager;
    private static final SQLMappingFactory SQL_MAPPING_FACTORY = SQLMappingFactoryImpl.getInstance();
    private final TermFactory termFactory;
    private final TypeFactory typeFactory;
    private final TargetAtomFactory targetAtomFactory;
    private final RDF rdfFactory;
    private int currentMappingIndex = 1;
    private final DirectMappingEngine directMappingEngine;
    private final DBFunctionSymbolFactory dbFunctionSymbolFactory;

    public BootstrapGenerator(OBDAModelManager obdaModelManager, String baseUri, OWLModelManager owlManager) throws DuplicateMappingException, SQLException {
        this.owlManager = owlManager;
        this.configuration = obdaModelManager.getConfigurationManager().buildOntopSQLOWLAPIConfiguration(owlManager.getActiveOntology());
        this.activeOBDAModel = obdaModelManager.getActiveOBDAModel();
        this.termFactory = obdaModelManager.getTermFactory();
        this.typeFactory = obdaModelManager.getTypeFactory();
        this.targetAtomFactory = obdaModelManager.getTargetAtomFactory();
        Injector injector = this.configuration.getInjector();
        this.directMappingEngine = (DirectMappingEngine)injector.getInstance(DirectMappingEngine.class);
        this.dbFunctionSymbolFactory = (DBFunctionSymbolFactory)injector.getInstance(DBFunctionSymbolFactory.class);
        this.rdfFactory = this.configuration.getRdfFactory();
        this.bootstrapMappingAndOntologyProtege(baseUri);
    }

    private void bootstrapMappingAndOntologyProtege(String baseUri) throws DuplicateMappingException, SQLException {
        List<SQLPPTriplesMap> sqlppTriplesMaps = this.bootstrapMapping(this.activeOBDAModel.generatePPMapping(), baseUri);
        OWLOntologyManager manager = this.owlManager.getActiveOntology().getOWLOntologyManager();
        Set declarationAxioms = MappingOntologyUtils.extractDeclarationAxioms((OWLOntologyManager)manager, sqlppTriplesMaps.stream().flatMap(ax -> ax.getTargetAtoms().stream()), (TypeFactory)this.typeFactory, (boolean)true);
        List addAxioms = declarationAxioms.stream().map(ax -> new AddAxiom(this.owlManager.getActiveOntology(), (OWLAxiom)ax)).collect(Collectors.toList());
        this.owlManager.applyChanges(addAxioms);
    }

    private List<SQLPPTriplesMap> bootstrapMapping(SQLPPMapping ppMapping, String baseURI) throws DuplicateMappingException, SQLException {
        Connection conn;
        ArrayList<SQLPPTriplesMap> newTriplesMap = new ArrayList<SQLPPTriplesMap>();
        this.currentMappingIndex = ppMapping.getTripleMaps().size() + 1;
        try {
            conn = this.connManager.getConnection((OntopSQLCredentialSettings)this.configuration.getSettings());
        }
        catch (SQLException e) {
            throw new RuntimeException("JDBC connection is missing, have you setup Ontop Mapping properties? Message: " + e.getMessage());
        }
        RDBMetadata metadata = RDBMetadataExtractionTools.createMetadata((Connection)conn, (TypeFactory)this.typeFactory);
        RDBMetadataExtractionTools.loadMetadata((RDBMetadata)metadata, (Connection)conn, null);
        baseURI = baseURI == null || baseURI.isEmpty() ? ppMapping.getMetadata().getPrefixManager().getDefaultPrefix() : DirectMappingEngine.fixBaseURI((String)baseURI);
        Collection tables = metadata.getDatabaseRelations();
        for (DatabaseRelationDefinition td : tables) {
            newTriplesMap.addAll(this.getMapping(td, baseURI));
        }
        for (SQLPPTriplesMap triplesMap : newTriplesMap) {
            this.activeOBDAModel.addTriplesMap(triplesMap, true);
        }
        return newTriplesMap;
    }

    private List<SQLPPTriplesMap> getMapping(DatabaseRelationDefinition table, String baseUri) {
        DirectMappingAxiomProducer dmap = new DirectMappingAxiomProducer(baseUri, this.termFactory, this.targetAtomFactory, this.rdfFactory, this.dbFunctionSymbolFactory, this.typeFactory);
        ArrayList<SQLPPTriplesMap> axioms = new ArrayList<SQLPPTriplesMap>();
        HashMap bnodeTemplateMap = new HashMap();
        axioms.add((SQLPPTriplesMap)new OntopNativeSQLPPTriplesMap("MAPPING-ID" + this.currentMappingIndex, SQL_MAPPING_FACTORY.getSQLQuery(dmap.getSQL(table)), dmap.getCQ(table, bnodeTemplateMap)));
        ++this.currentMappingIndex;
        Map refAxioms = dmap.getRefAxioms(table, bnodeTemplateMap);
        for (Map.Entry e : refAxioms.entrySet()) {
            OBDASQLQuery sqlQuery = SQL_MAPPING_FACTORY.getSQLQuery((String)e.getKey());
            ImmutableList targetQuery = (ImmutableList)e.getValue();
            axioms.add((SQLPPTriplesMap)new OntopNativeSQLPPTriplesMap("MAPPING-ID" + this.currentMappingIndex, sqlQuery, targetQuery));
            ++this.currentMappingIndex;
        }
        return axioms;
    }
}

