/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.protege.utils;

import it.unibz.inf.ontop.protege.utils.QuickErrorDialog;
import java.awt.Component;
import java.awt.Container;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.net.URI;
import javax.swing.AbstractAction;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;

public class DialogUtils {
    private static final KeyStroke escapeStroke = KeyStroke.getKeyStroke(27, 0);
    public static final String dispatchWindowClosingActionMapKey = "com.spodding.tackline.dispatch:WINDOW_CLOSING";

    public static void showQuickErrorDialog(Component parent, Exception e) {
        DialogUtils.showQuickErrorDialog(parent, e, "An Error Has Occurred");
    }

    public static void open(URI uri, Component component) {
        if (Desktop.isDesktopSupported()) {
            try {
                Desktop.getDesktop().browse(uri);
            }
            catch (IOException e) {
                DialogUtils.showQuickErrorDialog(component, e);
            }
        } else {
            JOptionPane.showMessageDialog(component, "URL links are not supported in this Desktop", "Error", 0);
        }
    }

    public static synchronized void showQuickErrorDialog(Component parent, Exception e, String message) {
        QuickErrorDialog box = new QuickErrorDialog(parent, e, message);
        SwingUtilities.invokeLater(box);
    }

    public static void centerDialogWRTParent(Component parent, Component dialog) {
        int x = 0;
        int y = 0;
        Container myParent = (Container)parent;
        Point topLeft = myParent.getLocationOnScreen();
        Dimension parentSize = myParent.getSize();
        Dimension mySize = dialog.getSize();
        x = parentSize.width > mySize.width ? (parentSize.width - mySize.width) / 2 + topLeft.x : topLeft.x;
        y = parentSize.height > mySize.height ? (parentSize.height - mySize.height) / 2 + topLeft.y : topLeft.y;
        dialog.setLocation(x, y);
    }

    public static JDialog createDialogForPanel(JDialog parent, JPanel panel) {
        JDialog newdialog = new JDialog(parent);
        newdialog.getContentPane().add((Component)panel, "Center");
        newdialog.pack();
        return newdialog;
    }

    public static JDialog createDialogForPanel(JFrame parent, JPanel panel) {
        JDialog newdialog = new JDialog(parent);
        newdialog.getContentPane().add((Component)panel, "Center");
        newdialog.pack();
        return newdialog;
    }

    public static void installEscapeCloseOperation(final JDialog dialog) {
        AbstractAction dispatchClosing = new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent event) {
                dialog.dispatchEvent(new WindowEvent(dialog, 201));
            }
        };
        JRootPane root = dialog.getRootPane();
        root.getInputMap(2).put(escapeStroke, dispatchWindowClosingActionMapKey);
        root.getActionMap().put(dispatchWindowClosingActionMapKey, dispatchClosing);
    }
}

