/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.protege.panels;

import com.google.common.collect.ImmutableList;
import it.unibz.inf.ontop.exception.DuplicateMappingException;
import it.unibz.inf.ontop.exception.TargetQueryParserException;
import it.unibz.inf.ontop.model.atom.TargetAtom;
import it.unibz.inf.ontop.protege.core.OBDADataSource;
import it.unibz.inf.ontop.protege.core.OBDAModel;
import it.unibz.inf.ontop.protege.core.TargetQueryValidator;
import it.unibz.inf.ontop.protege.gui.IconLoader;
import it.unibz.inf.ontop.protege.gui.treemodels.IncrementalResultSetTableModel;
import it.unibz.inf.ontop.protege.gui.treemodels.ResultSetTableModel;
import it.unibz.inf.ontop.protege.utils.ConnectionTools;
import it.unibz.inf.ontop.protege.utils.CustomTraversalPolicy;
import it.unibz.inf.ontop.protege.utils.DatasourceSelectorListener;
import it.unibz.inf.ontop.protege.utils.DialogUtils;
import it.unibz.inf.ontop.protege.utils.OBDAProgressListener;
import it.unibz.inf.ontop.protege.utils.OBDAProgressMonitor;
import it.unibz.inf.ontop.protege.utils.QueryPainter;
import it.unibz.inf.ontop.spec.mapping.OBDASQLQuery;
import it.unibz.inf.ontop.spec.mapping.PrefixManager;
import it.unibz.inf.ontop.spec.mapping.SQLMappingFactory;
import it.unibz.inf.ontop.spec.mapping.impl.SQLMappingFactoryImpl;
import it.unibz.inf.ontop.spec.mapping.parser.TargetQueryParser;
import it.unibz.inf.ontop.spec.mapping.pp.SQLPPTriplesMap;
import it.unibz.inf.ontop.spec.mapping.pp.impl.OntopNativeSQLPPTriplesMap;
import it.unibz.inf.ontop.spec.mapping.serializer.SourceQueryRenderer;
import it.unibz.inf.ontop.spec.mapping.serializer.TargetQueryRenderer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Vector;
import java.util.concurrent.CountDownLatch;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.table.TableModel;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import org.apache.commons.rdf.api.IRI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NewMappingDialogPanel
extends JPanel
implements DatasourceSelectorListener {
    private static final long serialVersionUID = 4351696247473906680L;
    private OBDAModel obdaModel;
    private OBDADataSource dataSource;
    private JDialog parent;
    private static final SQLMappingFactory MAPPING_FACTORY = SQLMappingFactoryImpl.getInstance();
    private PrefixManager prefixManager;
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private JButton cmdCancel;
    private JButton cmdInsertMapping;
    private JButton cmdTestQuery;
    private JLabel lblMappingID;
    private JLabel lblSourceQuery;
    private JLabel lblTargetQuery;
    private JLabel lblTestQuery;
    private JPanel pnlCommandButton;
    private JPanel pnlQueryResult;
    private JPanel pnlSourceQueryEditor;
    private JPanel pnlTargetQueryEditor;
    private JPanel pnlTestButton;
    private JScrollPane scrQueryResult;
    private JScrollPane scrSourceQuery;
    private JScrollPane scrTargetQuery;
    private JSplitPane splitSQL;
    private JSplitPane splitTargetSource;
    private JTable tblQueryResult;
    private JTextField txtMappingID;
    private JTextPane txtSourceQuery;
    private JTextPane txtTargetQuery;
    private SQLPPTriplesMap mapping;

    public NewMappingDialogPanel(OBDAModel obdaModel, JDialog parent, OBDADataSource dataSource) {
        DialogUtils.installEscapeCloseOperation(parent);
        this.obdaModel = obdaModel;
        this.parent = parent;
        this.dataSource = dataSource;
        this.prefixManager = obdaModel.getMutablePrefixManager();
        this.initComponents();
        StyledDocument doc = this.txtSourceQuery.getStyledDocument();
        Style plainStyle = doc.addStyle("PLAIN_STYLE", null);
        StyleConstants.setItalic(plainStyle, false);
        StyleConstants.setSpaceAbove(plainStyle, 0.0f);
        StyleConstants.setFontSize(plainStyle, 12);
        StyleConstants.setFontFamily(plainStyle, new Font("Dialog", 0, 12).getFamily());
        doc.setParagraphAttributes(0, doc.getLength(), plainStyle, true);
        this.txtMappingID.setFont(new Font("Dialog", 1, 12));
        this.cmdInsertMapping.setEnabled(false);
        QueryPainter painter = new QueryPainter(obdaModel, this.txtTargetQuery);
        painter.addValidatorListener(result -> this.cmdInsertMapping.setEnabled(result));
        this.cmdInsertMapping.addActionListener(this::cmdInsertMappingActionPerformed);
        this.txtTargetQuery.addKeyListener(new TABKeyListener());
        this.txtSourceQuery.addKeyListener(new TABKeyListener());
        this.tblQueryResult.setFocusable(false);
        this.txtTargetQuery.addKeyListener(new CTRLEnterKeyListener());
        this.txtSourceQuery.addKeyListener(new CTRLEnterKeyListener());
        this.txtMappingID.addKeyListener(new CTRLEnterKeyListener());
        this.cmdTestQuery.setFocusable(true);
        Vector<Component> order = new Vector<Component>(7);
        order.add(this.txtMappingID);
        order.add(this.txtTargetQuery);
        order.add(this.txtSourceQuery);
        order.add(this.cmdTestQuery);
        order.add(this.cmdInsertMapping);
        order.add(this.cmdCancel);
        this.setFocusTraversalPolicy(new CustomTraversalPolicy(order));
    }

    private void insertMapping(String target, String source) {
        ImmutableList<TargetAtom> targetQuery = this.parse(target);
        if (targetQuery != null) {
            ImmutableList<IRI> invalidPredicates = TargetQueryValidator.validate(targetQuery, this.obdaModel.getCurrentVocabulary());
            if (invalidPredicates.isEmpty()) {
                try {
                    OBDAModel mapcon = this.obdaModel;
                    OBDASQLQuery body = MAPPING_FACTORY.getSQLQuery(source.trim());
                    String newId = this.txtMappingID.getText().trim();
                    this.log.info("Insert Mapping: \n" + target + "\n" + source);
                    if (this.mapping == null) {
                        OntopNativeSQLPPTriplesMap newmapping = new OntopNativeSQLPPTriplesMap(newId, body, targetQuery);
                        mapcon.addTriplesMap((SQLPPTriplesMap)newmapping, false);
                    } else {
                        mapcon.updateMappingId(this.mapping.getId(), newId);
                        mapcon.updateMappingsSourceQuery(newId, body);
                        mapcon.updateTargetQueryMapping(newId, targetQuery);
                    }
                }
                catch (DuplicateMappingException e) {
                    JOptionPane.showMessageDialog(this, "Error while inserting mapping: " + e.getMessage() + " is already taken");
                    return;
                }
                this.parent.setVisible(false);
                this.parent.dispose();
            } else {
                String invalidList = "";
                for (IRI predicate : invalidPredicates) {
                    invalidList = invalidList + "- " + predicate + "\n";
                }
                JOptionPane.showMessageDialog(this, "This list of predicates is unknown by the ontology: \n" + invalidList, "New Mapping", 2);
            }
        }
    }

    private void initComponents() {
        this.lblMappingID = new JLabel();
        this.pnlTestButton = new JPanel();
        this.cmdTestQuery = new JButton();
        this.lblTestQuery = new JLabel();
        this.pnlCommandButton = new JPanel();
        this.cmdInsertMapping = new JButton();
        this.cmdCancel = new JButton();
        this.txtMappingID = new JTextField();
        this.splitTargetSource = new JSplitPane();
        this.pnlTargetQueryEditor = new JPanel();
        this.lblTargetQuery = new JLabel();
        this.scrTargetQuery = new JScrollPane();
        this.txtTargetQuery = new JTextPane();
        this.splitSQL = new JSplitPane();
        this.pnlSourceQueryEditor = new JPanel();
        this.lblSourceQuery = new JLabel();
        this.scrSourceQuery = new JScrollPane();
        this.txtSourceQuery = new JTextPane();
        this.pnlQueryResult = new JPanel();
        this.scrQueryResult = new JScrollPane();
        this.tblQueryResult = new JTable();
        this.setFocusable(false);
        this.setMinimumSize(new Dimension(600, 500));
        this.setPreferredSize(new Dimension(600, 500));
        this.setLayout(new GridBagLayout());
        this.lblMappingID.setFont(new Font("Tahoma", 1, 11));
        this.lblMappingID.setText("Mapping ID:");
        this.lblMappingID.setFocusable(false);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(8, 10, 8, 0);
        this.add((Component)this.lblMappingID, gridBagConstraints);
        this.cmdTestQuery.setIcon(IconLoader.getImageIcon("images/execute.png"));
        this.cmdTestQuery.setMnemonic('t');
        this.cmdTestQuery.setText("Test SQL Query");
        this.cmdTestQuery.setToolTipText("Execute the SQL query in the SQL query text pane\nand display the first 100 results in the table.");
        this.cmdTestQuery.setActionCommand("Test SQL query");
        this.cmdTestQuery.setBorder(BorderFactory.createEtchedBorder());
        this.cmdTestQuery.setContentAreaFilled(false);
        this.cmdTestQuery.setIconTextGap(5);
        this.cmdTestQuery.setMaximumSize(new Dimension(115, 25));
        this.cmdTestQuery.setMinimumSize(new Dimension(115, 25));
        this.cmdTestQuery.setPreferredSize(new Dimension(115, 25));
        this.cmdTestQuery.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NewMappingDialogPanel.this.cmdTestQueryActionPerformed(evt);
            }
        });
        this.pnlTestButton.add(this.cmdTestQuery);
        this.lblTestQuery.setText("(100 rows)");
        this.pnlTestButton.add(this.lblTestQuery);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.insets = new Insets(4, 10, 0, 0);
        this.add((Component)this.pnlTestButton, gridBagConstraints);
        this.pnlCommandButton.setFocusable(false);
        this.pnlCommandButton.setLayout(new FlowLayout(2));
        this.cmdInsertMapping.setIcon(IconLoader.getImageIcon("images/accept.png"));
        this.cmdInsertMapping.setText("Accept");
        this.cmdInsertMapping.setToolTipText("This will add/edit the current mapping into the OBDA model");
        this.cmdInsertMapping.setActionCommand("OK");
        this.cmdInsertMapping.setBorder(BorderFactory.createEtchedBorder());
        this.cmdInsertMapping.setContentAreaFilled(false);
        this.cmdInsertMapping.setIconTextGap(5);
        this.cmdInsertMapping.setPreferredSize(new Dimension(90, 25));
        this.pnlCommandButton.add(this.cmdInsertMapping);
        this.cmdCancel.setIcon(IconLoader.getImageIcon("images/cancel.png"));
        this.cmdCancel.setText("Cancel");
        this.cmdCancel.setBorder(BorderFactory.createEtchedBorder());
        this.cmdCancel.setContentAreaFilled(false);
        this.cmdCancel.setIconTextGap(5);
        this.cmdCancel.setPreferredSize(new Dimension(90, 25));
        this.cmdCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NewMappingDialogPanel.this.cmdCancelActionPerformed(evt);
            }
        });
        this.pnlCommandButton.add(this.cmdCancel);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 0, 10, 4);
        this.add((Component)this.pnlCommandButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(8, 0, 8, 10);
        this.add((Component)this.txtMappingID, gridBagConstraints);
        this.splitTargetSource.setBorder(null);
        this.splitTargetSource.setOrientation(0);
        this.splitTargetSource.setResizeWeight(0.5);
        this.splitTargetSource.setDoubleBuffered(true);
        this.splitTargetSource.setFocusable(false);
        this.splitTargetSource.setMinimumSize(new Dimension(600, 430));
        this.splitTargetSource.setOneTouchExpandable(true);
        this.splitTargetSource.setPreferredSize(new Dimension(600, 430));
        this.pnlTargetQueryEditor.setFocusable(false);
        this.pnlTargetQueryEditor.setMinimumSize(new Dimension(600, 180));
        this.pnlTargetQueryEditor.setPreferredSize(new Dimension(600, 180));
        this.pnlTargetQueryEditor.setLayout(new BorderLayout());
        this.lblTargetQuery.setFont(new Font("Tahoma", 1, 11));
        this.lblTargetQuery.setText("Target (Triples Template):");
        this.lblTargetQuery.setFocusable(false);
        this.pnlTargetQueryEditor.add((Component)this.lblTargetQuery, "North");
        this.scrTargetQuery.setFocusable(false);
        this.scrTargetQuery.setMinimumSize(new Dimension(600, 170));
        this.scrTargetQuery.setPreferredSize(new Dimension(600, 170));
        this.txtTargetQuery.setFont(new Font("Lucida Sans Typewriter", 0, 13));
        this.txtTargetQuery.setFocusCycleRoot(false);
        this.txtTargetQuery.setMinimumSize(new Dimension(600, 170));
        this.txtTargetQuery.setPreferredSize(new Dimension(600, 170));
        this.scrTargetQuery.setViewportView(this.txtTargetQuery);
        this.pnlTargetQueryEditor.add((Component)this.scrTargetQuery, "Center");
        this.splitTargetSource.setLeftComponent(this.pnlTargetQueryEditor);
        this.splitSQL.setBorder(null);
        this.splitSQL.setOrientation(0);
        this.splitSQL.setResizeWeight(0.8);
        this.splitSQL.setFocusable(false);
        this.splitSQL.setMinimumSize(new Dimension(600, 280));
        this.splitSQL.setOneTouchExpandable(true);
        this.splitSQL.setPreferredSize(new Dimension(600, 280));
        this.pnlSourceQueryEditor.setFocusable(false);
        this.pnlSourceQueryEditor.setMinimumSize(new Dimension(600, 150));
        this.pnlSourceQueryEditor.setPreferredSize(new Dimension(600, 150));
        this.pnlSourceQueryEditor.setLayout(new BorderLayout());
        this.lblSourceQuery.setFont(new Font("Tahoma", 1, 11));
        this.lblSourceQuery.setText("Source (SQL Query):");
        this.lblSourceQuery.setFocusable(false);
        this.pnlSourceQueryEditor.add((Component)this.lblSourceQuery, "North");
        this.scrSourceQuery.setFocusable(false);
        this.txtSourceQuery.setFont(new Font("Lucida Sans Typewriter", 0, 13));
        this.txtSourceQuery.setFocusCycleRoot(false);
        this.scrSourceQuery.setViewportView(this.txtSourceQuery);
        this.pnlSourceQueryEditor.add((Component)this.scrSourceQuery, "Center");
        this.splitSQL.setTopComponent(this.pnlSourceQueryEditor);
        this.pnlQueryResult.setFocusable(false);
        this.pnlQueryResult.setMinimumSize(new Dimension(600, 120));
        this.pnlQueryResult.setPreferredSize(new Dimension(600, 120));
        this.pnlQueryResult.setLayout(new BorderLayout());
        this.scrQueryResult.setFocusable(false);
        this.scrQueryResult.setPreferredSize(new Dimension(454, 70));
        this.tblQueryResult.setMinimumSize(new Dimension(600, 180));
        this.scrQueryResult.setViewportView(this.tblQueryResult);
        this.pnlQueryResult.add((Component)this.scrQueryResult, "Center");
        this.splitSQL.setBottomComponent(this.pnlQueryResult);
        this.splitTargetSource.setRightComponent(this.splitSQL);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 10, 0, 10);
        this.add((Component)this.splitTargetSource, gridBagConstraints);
        this.getAccessibleContext().setAccessibleName("Mapping editor");
    }

    private void releaseResultset() {
        TableModel model = this.tblQueryResult.getModel();
        if (model == null) {
            return;
        }
        if (!(model instanceof IncrementalResultSetTableModel)) {
            return;
        }
        IncrementalResultSetTableModel imodel = (IncrementalResultSetTableModel)model;
        imodel.close();
    }

    private void cmdTestQueryActionPerformed(ActionEvent evt) {
        this.releaseResultset();
        OBDAProgressMonitor progMonitor = new OBDAProgressMonitor("Executing query...", this);
        CountDownLatch latch = new CountDownLatch(1);
        ExecuteSQLQueryAction action = new ExecuteSQLQueryAction(latch);
        progMonitor.addProgressListener(action);
        progMonitor.start();
        try {
            action.run();
            latch.await();
            progMonitor.stop();
            ResultSet set = action.getResult();
            if (set != null) {
                ResultSetTableModel model = new ResultSetTableModel(set);
                this.tblQueryResult.setModel(model);
                this.scrQueryResult.getParent().revalidate();
            }
        }
        catch (Exception e) {
            this.log.error(e.getMessage());
        }
    }

    private void cmdInsertMappingActionPerformed(ActionEvent e) {
        this.releaseResultset();
        String targetQueryString = this.txtTargetQuery.getText();
        String sourceQueryString = this.txtSourceQuery.getText();
        if (this.txtMappingID.getText().trim().length() == 0) {
            JOptionPane.showMessageDialog(this, "ERROR: The ID cannot be empty", "Error", 0);
            return;
        }
        if (targetQueryString.isEmpty()) {
            JOptionPane.showMessageDialog(this, "ERROR: The target cannot be empty", "Error", 0);
            return;
        }
        if (sourceQueryString.isEmpty()) {
            JOptionPane.showMessageDialog(this, "ERROR: The source cannot be empty", "Error", 0);
            return;
        }
        this.insertMapping(targetQueryString, sourceQueryString);
    }

    private void cmdCancelActionPerformed(ActionEvent evt) {
        this.parent.setVisible(false);
        this.parent.dispose();
        this.releaseResultset();
    }

    private ImmutableList<TargetAtom> parse(String query) {
        TargetQueryParser textParser = this.obdaModel.createTargetQueryParser();
        try {
            return textParser.parse(query);
        }
        catch (TargetQueryParserException e) {
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public void datasourceChanged(OBDADataSource oldSource, OBDADataSource newSource) {
        this.dataSource = newSource;
    }

    public void setID(String id) {
        this.txtMappingID.setText(id);
    }

    public void finalize() {
        this.releaseResultset();
    }

    public void setMapping(SQLPPTriplesMap mapping) {
        this.mapping = mapping;
        this.cmdInsertMapping.setText("Update");
        this.txtMappingID.setText(mapping.getId());
        OBDASQLQuery sourceQuery = mapping.getSourceQuery();
        String srcQuery = SourceQueryRenderer.encode((OBDASQLQuery)sourceQuery);
        this.txtSourceQuery.setText(srcQuery);
        ImmutableList targetQuery = mapping.getTargetAtoms();
        String trgQuery = TargetQueryRenderer.encode((ImmutableList)targetQuery, (PrefixManager)this.prefixManager);
        this.txtTargetQuery.setText(trgQuery);
    }

    private class ExecuteSQLQueryAction
    implements OBDAProgressListener {
        CountDownLatch latch = null;
        Thread thread = null;
        ResultSet result = null;
        Statement statement = null;
        private boolean isCancelled = false;
        private boolean errorShown = false;

        private ExecuteSQLQueryAction(CountDownLatch latch) {
            this.latch = latch;
        }

        @Override
        public void actionCanceled() throws SQLException {
            this.isCancelled = true;
            if (this.thread != null) {
                this.thread.interrupt();
            }
            if (this.statement != null && !this.statement.isClosed()) {
                this.statement.close();
            }
            this.result = null;
            this.latch.countDown();
        }

        public ResultSet getResult() {
            return this.result;
        }

        public void run() {
            this.thread = new Thread(){

                @Override
                public void run() {
                    try {
                        TableModel oldmodel = NewMappingDialogPanel.this.tblQueryResult.getModel();
                        if (oldmodel != null && oldmodel instanceof ResultSetTableModel) {
                            ResultSetTableModel rstm = (ResultSetTableModel)oldmodel;
                            rstm.close();
                        }
                        Connection c = ConnectionTools.getConnection(NewMappingDialogPanel.this.dataSource);
                        Statement st = c.createStatement(1003, 1007);
                        st.setMaxRows(100);
                        ExecuteSQLQueryAction.this.result = st.executeQuery(NewMappingDialogPanel.this.txtSourceQuery.getText().trim());
                        ExecuteSQLQueryAction.this.latch.countDown();
                    }
                    catch (Exception e) {
                        ExecuteSQLQueryAction.this.latch.countDown();
                        DialogUtils.showQuickErrorDialog(NewMappingDialogPanel.this.getRootPane(), e);
                        ExecuteSQLQueryAction.this.errorShown = true;
                    }
                }
            };
            this.thread.start();
        }

        @Override
        public boolean isCancelled() {
            return this.isCancelled;
        }

        @Override
        public boolean isErrorShown() {
            return this.errorShown;
        }
    }

    private class CTRLEnterKeyListener
    implements KeyListener {
        private CTRLEnterKeyListener() {
        }

        @Override
        public void keyTyped(KeyEvent e) {
        }

        @Override
        public void keyPressed(KeyEvent e) {
            if (NewMappingDialogPanel.this.cmdInsertMapping.isEnabled() && e.getModifiers() == 2 && e.getKeyCode() == 10) {
                NewMappingDialogPanel.this.cmdInsertMappingActionPerformed(null);
            } else if (e.getModifiers() == 2 && e.getKeyCode() == 84) {
                NewMappingDialogPanel.this.cmdTestQueryActionPerformed(null);
            }
        }

        @Override
        public void keyReleased(KeyEvent e) {
        }
    }

    private class TABKeyListener
    implements KeyListener {
        private TABKeyListener() {
        }

        @Override
        public void keyTyped(KeyEvent e) {
            this.typedOrPressed(e);
        }

        @Override
        public void keyReleased(KeyEvent e) {
        }

        @Override
        public void keyPressed(KeyEvent e) {
            this.typedOrPressed(e);
        }

        private void typedOrPressed(KeyEvent e) {
            if (e.getKeyCode() == 9) {
                if (e.getModifiers() == 1) {
                    e.getComponent().transferFocusBackward();
                } else {
                    e.getComponent().transferFocus();
                }
                e.consume();
            }
        }
    }
}

