/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.protege.panels;

import it.unibz.inf.ontop.exception.DuplicateMappingException;
import it.unibz.inf.ontop.injection.OntopSQLCredentialConfiguration;
import it.unibz.inf.ontop.protege.core.OBDADataSource;
import it.unibz.inf.ontop.protege.core.OBDAModel;
import it.unibz.inf.ontop.protege.dialogs.MappingValidationDialog;
import it.unibz.inf.ontop.protege.gui.IconLoader;
import it.unibz.inf.ontop.protege.gui.treemodels.FilteredModel;
import it.unibz.inf.ontop.protege.gui.treemodels.MappingPredicateTreeModelFilter;
import it.unibz.inf.ontop.protege.gui.treemodels.SynchronizedMappingListModel;
import it.unibz.inf.ontop.protege.gui.treemodels.TreeModelFilter;
import it.unibz.inf.ontop.protege.panels.NewMappingDialogPanel;
import it.unibz.inf.ontop.protege.panels.SQLQueryPanel;
import it.unibz.inf.ontop.protege.utils.DatasourceSelectorListener;
import it.unibz.inf.ontop.protege.utils.DialogUtils;
import it.unibz.inf.ontop.protege.utils.OBDAMappingListRenderer;
import it.unibz.inf.ontop.spec.mapping.parser.DataSource2PropertiesConvertor;
import it.unibz.inf.ontop.spec.mapping.pp.SQLPPTriplesMap;
import it.unibz.inf.ontop.spec.mapping.pp.impl.OntopNativeSQLPPTriplesMap;
import it.unibz.inf.ontop.spec.mapping.validation.SQLSourceQueryValidator;
import it.unibz.inf.ontop.utils.IDGenerator;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.URI;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import org.slf4j.LoggerFactory;

public class MappingManagerPanel
extends JPanel
implements DatasourceSelectorListener {
    private static final long serialVersionUID = -486013653814714526L;
    private Thread validatorThread;
    private SQLSourceQueryValidator validator;
    private OBDAModel apic;
    private OBDADataSource selectedSource;
    private boolean canceled;
    private JTree mappingsTree = new JTree();
    private JMenuItem menuValidateBody;
    private JMenuItem menuExecuteBody;
    private JCheckBox chkFilter;
    private JButton cmdAddMapping;
    private JButton cmdDeselectAll;
    private JButton cmdDuplicateMapping;
    private JButton cmdRemoveMapping;
    private JButton cmdSelectAll;
    private JTextField fieldMappings;
    private JPanel jPanel1;
    private JLabel labelMappings;
    private JLabel lblInsertFilter;
    private JList<SQLPPTriplesMap> mappingList;
    private JScrollPane mappingScrollPane;
    private JPopupMenu menuMappings;
    private JPanel pnlExtraButtons;
    private JPanel pnlMappingButtons;
    private JPanel pnlMappingManager;
    private JTextField txtFilter;

    public MappingManagerPanel(OBDAModel apic) {
        this.initComponents();
        this.addMenu();
        this.mappingList.setCellRenderer(new OBDAMappingListRenderer(apic));
        this.mappingList.setFixedCellWidth(-1);
        this.mappingList.setSelectionMode(2);
        this.mappingList.addMouseListener(new PopupListener());
        this.mappingList.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }

            @Override
            public void keyPressed(KeyEvent e) {
                switch (e.getKeyCode()) {
                    case 8: 
                    case 127: {
                        MappingManagerPanel.this.removeMapping();
                        break;
                    }
                    case 155: {
                        MappingManagerPanel.this.addMapping();
                        break;
                    }
                    case 32: {
                        MappingManagerPanel.this.editMapping();
                        break;
                    }
                }
            }
        });
        this.mappingList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                int count = e.getClickCount();
                if (count == 2) {
                    MappingManagerPanel.this.editMapping();
                }
            }
        });
        this.cmdAddMapping.setToolTipText("Create a new mapping");
        this.cmdRemoveMapping.setToolTipText("Remove selected mappings");
        this.cmdDuplicateMapping.setToolTipText("Copy selected mappings");
        this.setOBDAModel(apic);
    }

    public OBDADataSource getSelectedSource() {
        return this.selectedSource;
    }

    public void setOBDAModel(OBDAModel omodel) {
        this.apic = omodel;
        SynchronizedMappingListModel model = new SynchronizedMappingListModel(omodel);
        model.addListDataListener(new ListDataListener(){

            @Override
            public void intervalRemoved(ListDataEvent e) {
                MappingManagerPanel.this.fieldMappings.setText(String.valueOf(MappingManagerPanel.this.mappingList.getModel().getSize()));
            }

            @Override
            public void intervalAdded(ListDataEvent e) {
                MappingManagerPanel.this.fieldMappings.setText(String.valueOf(MappingManagerPanel.this.mappingList.getModel().getSize()));
            }

            @Override
            public void contentsChanged(ListDataEvent e) {
                MappingManagerPanel.this.fieldMappings.setText(String.valueOf(MappingManagerPanel.this.mappingList.getModel().getSize()));
            }
        });
        this.mappingList.setModel(model);
    }

    private void addMenu() {
        JMenuItem add = new JMenuItem();
        add.setText("Create mapping...");
        add.addActionListener(e -> this.addMapping());
        this.menuMappings.add(add);
        JMenuItem delete = new JMenuItem();
        delete.setText("Remove mapping(s)...");
        delete.addActionListener(e -> this.removeMapping());
        this.menuMappings.add(delete);
        JMenuItem editMapping = new JMenuItem();
        editMapping.setText("Edit mapping...");
        editMapping.addActionListener(e -> this.editMapping());
        this.menuMappings.add(editMapping);
        this.menuMappings.addSeparator();
        this.menuValidateBody = new JMenuItem();
        this.menuValidateBody.setText("Validate SQL");
        this.menuValidateBody.addActionListener(this::menuValidateBodyActionPerformed);
        this.menuMappings.add(this.menuValidateBody);
        this.menuExecuteBody = new JMenuItem();
        this.menuExecuteBody.setText("Execute SQL");
        this.menuExecuteBody.addActionListener(this::menuExecuteBodyActionPerformed);
        this.menuMappings.add(this.menuExecuteBody);
    }

    public void editMapping() {
        SQLPPTriplesMap mapping = this.mappingList.getSelectedValue();
        if (mapping == null) {
            return;
        }
        JDialog dialog = new JDialog();
        dialog.setTitle("Edit Mapping");
        dialog.setModal(true);
        NewMappingDialogPanel panel = new NewMappingDialogPanel(this.apic, dialog, this.selectedSource);
        panel.setMapping(mapping);
        dialog.setContentPane(panel);
        dialog.setSize(600, 500);
        dialog.setLocationRelativeTo(this);
        dialog.setVisible(true);
    }

    private void initComponents() {
        this.menuMappings = new JPopupMenu();
        this.pnlMappingManager = new JPanel();
        this.pnlMappingButtons = new JPanel();
        this.cmdAddMapping = new JButton();
        this.cmdRemoveMapping = new JButton();
        this.cmdDuplicateMapping = new JButton();
        this.jPanel1 = new JPanel();
        this.cmdSelectAll = new JButton();
        this.cmdDeselectAll = new JButton();
        this.pnlExtraButtons = new JPanel();
        this.labelMappings = new JLabel();
        this.fieldMappings = new JTextField();
        this.lblInsertFilter = new JLabel();
        this.txtFilter = new JTextField();
        this.chkFilter = new JCheckBox();
        this.mappingScrollPane = new JScrollPane();
        this.mappingList = new JList();
        this.setLayout(new GridBagLayout());
        this.pnlMappingManager.setAutoscrolls(true);
        this.pnlMappingManager.setPreferredSize(new Dimension(400, 300));
        this.pnlMappingManager.setLayout(new BorderLayout());
        this.pnlMappingButtons.setEnabled(false);
        this.pnlMappingButtons.setLayout(new GridBagLayout());
        this.cmdAddMapping.setIcon(IconLoader.getImageIcon("images/plus.png"));
        this.cmdAddMapping.setText("Create");
        this.cmdAddMapping.setToolTipText("Create a new mapping");
        this.cmdAddMapping.setBorder(BorderFactory.createEtchedBorder());
        this.cmdAddMapping.setContentAreaFilled(false);
        this.cmdAddMapping.setIconTextGap(5);
        this.cmdAddMapping.setMaximumSize(new Dimension(75, 25));
        this.cmdAddMapping.setMinimumSize(new Dimension(75, 25));
        this.cmdAddMapping.setPreferredSize(new Dimension(75, 25));
        this.cmdAddMapping.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MappingManagerPanel.this.cmdAddMappingActionPerformed(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.pnlMappingButtons.add((Component)this.cmdAddMapping, gridBagConstraints);
        this.cmdRemoveMapping.setIcon(IconLoader.getImageIcon("images/minus.png"));
        this.cmdRemoveMapping.setText("Remove");
        this.cmdRemoveMapping.setToolTipText("Remove the selected mapping");
        this.cmdRemoveMapping.setBorder(BorderFactory.createEtchedBorder());
        this.cmdRemoveMapping.setContentAreaFilled(false);
        this.cmdRemoveMapping.setIconTextGap(5);
        this.cmdRemoveMapping.setMaximumSize(new Dimension(75, 25));
        this.cmdRemoveMapping.setMinimumSize(new Dimension(75, 25));
        this.cmdRemoveMapping.setPreferredSize(new Dimension(75, 25));
        this.cmdRemoveMapping.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MappingManagerPanel.this.cmdRemoveMappingActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.pnlMappingButtons.add((Component)this.cmdRemoveMapping, gridBagConstraints);
        this.cmdDuplicateMapping.setIcon(IconLoader.getImageIcon("images/copy.png"));
        this.cmdDuplicateMapping.setText("Copy");
        this.cmdDuplicateMapping.setToolTipText("Make a duplicate of the selected mapping");
        this.cmdDuplicateMapping.setBorder(BorderFactory.createEtchedBorder());
        this.cmdDuplicateMapping.setContentAreaFilled(false);
        this.cmdDuplicateMapping.setIconTextGap(5);
        this.cmdDuplicateMapping.setMaximumSize(new Dimension(70, 25));
        this.cmdDuplicateMapping.setMinimumSize(new Dimension(70, 25));
        this.cmdDuplicateMapping.setPreferredSize(new Dimension(70, 25));
        this.cmdDuplicateMapping.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MappingManagerPanel.this.cmdDuplicateMappingActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.pnlMappingButtons.add((Component)this.cmdDuplicateMapping, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.pnlMappingButtons.add((Component)this.jPanel1, gridBagConstraints);
        this.cmdSelectAll.setIcon(IconLoader.getImageIcon("images/select-all.png"));
        this.cmdSelectAll.setText("Select all");
        this.cmdSelectAll.setToolTipText("Select all");
        this.cmdSelectAll.setBorder(BorderFactory.createEtchedBorder());
        this.cmdSelectAll.setContentAreaFilled(false);
        this.cmdSelectAll.setIconTextGap(5);
        this.cmdSelectAll.setMaximumSize(new Dimension(83, 25));
        this.cmdSelectAll.setMinimumSize(new Dimension(83, 25));
        this.cmdSelectAll.setPreferredSize(new Dimension(83, 25));
        this.cmdSelectAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MappingManagerPanel.this.cmdSelectAllActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 7;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.pnlMappingButtons.add((Component)this.cmdSelectAll, gridBagConstraints);
        this.cmdDeselectAll.setIcon(IconLoader.getImageIcon("images/select-none.png"));
        this.cmdDeselectAll.setText("Select none");
        this.cmdDeselectAll.setToolTipText("Select none");
        this.cmdDeselectAll.setBorder(BorderFactory.createEtchedBorder());
        this.cmdDeselectAll.setContentAreaFilled(false);
        this.cmdDeselectAll.setIconTextGap(5);
        this.cmdDeselectAll.setMaximumSize(new Dimension(92, 25));
        this.cmdDeselectAll.setMinimumSize(new Dimension(92, 25));
        this.cmdDeselectAll.setPreferredSize(new Dimension(92, 25));
        this.cmdDeselectAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MappingManagerPanel.this.cmdDeselectAllActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 8;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.pnlMappingButtons.add((Component)this.cmdDeselectAll, gridBagConstraints);
        this.pnlMappingManager.add((Component)this.pnlMappingButtons, "North");
        this.pnlExtraButtons.setMinimumSize(new Dimension(532, 25));
        this.pnlExtraButtons.setPreferredSize(new Dimension(532, 25));
        this.pnlExtraButtons.setLayout(new FlowLayout(0, 5, 2));
        this.labelMappings.setText("Mapping count:");
        this.pnlExtraButtons.add(this.labelMappings);
        this.fieldMappings.setEditable(false);
        this.fieldMappings.setText("0");
        this.fieldMappings.setPreferredSize(new Dimension(50, 28));
        this.pnlExtraButtons.add(this.fieldMappings);
        this.lblInsertFilter.setFont(new Font("Dialog", 1, 12));
        this.lblInsertFilter.setForeground(new Color(53, 113, 163));
        this.lblInsertFilter.setHorizontalAlignment(4);
        this.lblInsertFilter.setText("Search:");
        this.lblInsertFilter.setMinimumSize(new Dimension(120, 20));
        this.lblInsertFilter.setPreferredSize(new Dimension(75, 20));
        this.pnlExtraButtons.add(this.lblInsertFilter);
        this.txtFilter.setPreferredSize(new Dimension(250, 20));
        this.txtFilter.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                MappingManagerPanel.this.sendFilters(evt);
            }
        });
        this.pnlExtraButtons.add(this.txtFilter);
        this.chkFilter.setText("Enable filter");
        this.chkFilter.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                MappingManagerPanel.this.chkFilterItemStateChanged(evt);
            }
        });
        this.pnlExtraButtons.add(this.chkFilter);
        this.pnlMappingManager.add((Component)this.pnlExtraButtons, "South");
        this.mappingScrollPane.setViewportView(this.mappingList);
        this.pnlMappingManager.add((Component)this.mappingScrollPane, "Center");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.pnlMappingManager, gridBagConstraints);
    }

    private void cmdSelectAllActionPerformed(ActionEvent evt) {
        this.mappingList.setSelectionInterval(0, this.mappingList.getModel().getSize());
    }

    private void cmdDeselectAllActionPerformed(ActionEvent evt) {
        this.mappingList.clearSelection();
    }

    private void processFilterAction() {
        if (!this.chkFilter.isSelected()) {
            this.applyFilters(new ArrayList<TreeModelFilter<SQLPPTriplesMap>>());
        }
        if (this.chkFilter.isSelected()) {
            if (this.txtFilter.getText().isEmpty()) {
                this.chkFilter.setSelected(false);
                this.applyFilters(new ArrayList<TreeModelFilter<SQLPPTriplesMap>>());
                return;
            }
            try {
                List<TreeModelFilter<SQLPPTriplesMap>> filters = this.parseSearchString(this.txtFilter.getText());
                if (filters == null) {
                    throw new Exception("Impossible to parse search string");
                }
                this.applyFilters(filters);
            }
            catch (Exception e) {
                LoggerFactory.getLogger(this.getClass()).debug(e.getMessage(), (Throwable)e);
                JOptionPane.showMessageDialog(this, e.getMessage());
            }
        }
    }

    private void chkFilterItemStateChanged(ItemEvent evt) {
        this.processFilterAction();
    }

    private void sendFilters(KeyEvent evt) {
        int key = evt.getKeyCode();
        if (key == 10) {
            if (!this.chkFilter.isSelected()) {
                this.chkFilter.setSelected(true);
            } else {
                this.processFilterAction();
            }
        }
    }

    private void menuValidateBodyActionPerformed(ActionEvent evt) {
        MappingValidationDialog outputField = new MappingValidationDialog(this.mappingsTree);
        outputField.setLocationRelativeTo(this.getParent());
        Runnable action = () -> {
            this.canceled = false;
            List<SQLPPTriplesMap> path = this.mappingList.getSelectedValuesList();
            if (path == null) {
                JOptionPane.showMessageDialog(this, "Select at least one mapping");
                return;
            }
            outputField.addText("Validating " + path.size() + " SQL queries.\n", outputField.NORMAL);
            for (int i = 0; i < path.size(); ++i) {
                String output;
                long timestop;
                SQLPPTriplesMap o = path.get(i);
                String id = o.getId();
                outputField.addText("  id: '" + id + "'... ", outputField.NORMAL);
                OntopSQLCredentialConfiguration config = ((OntopSQLCredentialConfiguration.Builder)OntopSQLCredentialConfiguration.defaultBuilder().properties(DataSource2PropertiesConvertor.convert(this.selectedSource))).build();
                this.validator = new SQLSourceQueryValidator(config.getSettings(), o.getSourceQuery());
                long timestart = System.nanoTime();
                if (this.canceled) {
                    return;
                }
                if (this.validator.validate()) {
                    timestop = System.nanoTime();
                    output = " valid  \n";
                    outputField.addText("Time to query: " + (timestop - timestart) / 1000L + " ns. Result: ", outputField.NORMAL);
                    outputField.addText(output, outputField.VALID);
                } else {
                    timestop = System.nanoTime();
                    output = " invalid Reason: " + this.validator.getReason().getMessage() + " \n";
                    outputField.addText("Time to query: " + (timestop - timestart) / 1000L + " ns. Result: ", outputField.NORMAL);
                    outputField.addText(output, outputField.CRITICAL_ERROR);
                }
                if (!this.canceled) continue;
                return;
            }
            outputField.setVisible(true);
        };
        this.validatorThread = new Thread(action);
        this.validatorThread.start();
        Thread cancelThread = new Thread(() -> {
            while (!outputField.closed) {
                try {
                    Thread.currentThread();
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            if (this.validatorThread.isAlive()) {
                try {
                    Thread.currentThread();
                    Thread.sleep(250L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                try {
                    this.canceled = true;
                    if (this.validator != null) {
                        this.validator.cancelValidation();
                    }
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        });
        cancelThread.start();
    }

    private void menuExecuteBodyActionPerformed(ActionEvent evt) {
        SQLPPTriplesMap mapping = this.mappingList.getSelectedValue();
        if (mapping == null) {
            return;
        }
        String sqlQuery = mapping.getSourceQuery().toString();
        SQLQueryPanel pnlQueryResult = new SQLQueryPanel(this.selectedSource, sqlQuery);
        JDialog dlgQueryResult = new JDialog();
        DialogUtils.installEscapeCloseOperation(dlgQueryResult);
        dlgQueryResult.setContentPane(pnlQueryResult);
        dlgQueryResult.pack();
        dlgQueryResult.setLocationRelativeTo(this);
        dlgQueryResult.setVisible(true);
        dlgQueryResult.setTitle("SQL Query Result");
    }

    private void cmdDuplicateMappingActionPerformed(ActionEvent evt) {
        Object[] currentSelection = this.mappingList.getSelectedValues();
        if (currentSelection == null) {
            JOptionPane.showMessageDialog(this, "No mappings have been selected", "ERROR", 0);
            return;
        }
        int confirm = JOptionPane.showConfirmDialog(this, "This will create copies of the selected mappings. \nNumber of mappings selected = " + currentSelection.length + "\nContinue? ", "Copy confirmation", 0, 3);
        if (confirm == 1 || confirm == 2 || confirm == -1) {
            return;
        }
        OBDAModel controller = this.apic;
        URI current_srcuri = this.selectedSource.getSourceID();
        for (int i = 0; i < currentSelection.length; ++i) {
            SQLPPTriplesMap mapping = (SQLPPTriplesMap)currentSelection[i];
            String id = mapping.getId();
            int new_index = -1;
            for (int index = 0; index < 999999999; ++index) {
                if (controller.indexOf(id + "(" + index + ")") != -1) continue;
                new_index = index;
                break;
            }
            String newId = id + "(" + new_index + ")";
            try {
                SQLPPTriplesMap oldmapping = controller.getTriplesMap(id);
                OntopNativeSQLPPTriplesMap newmapping = new OntopNativeSQLPPTriplesMap(newId, oldmapping.getSourceQuery(), oldmapping.getTargetAtoms());
                controller.addTriplesMap(current_srcuri, (SQLPPTriplesMap)newmapping, false);
                continue;
            }
            catch (DuplicateMappingException e) {
                JOptionPane.showMessageDialog(this, "Duplicate Mapping: " + newId);
                return;
            }
        }
    }

    private void cmdRemoveMappingActionPerformed(ActionEvent evt) {
        this.removeMapping();
    }

    private void removeMapping() {
        int[] indexes = this.mappingList.getSelectedIndices();
        if (indexes == null) {
            return;
        }
        int confirm = JOptionPane.showConfirmDialog(this, "Proceed deleting " + indexes.length + " mappings?", "Conform", 2, 0);
        if (confirm == 2 || confirm == -1) {
            return;
        }
        Object[] values = this.mappingList.getSelectedValues();
        OBDAModel controller = this.apic;
        URI srcuri = this.selectedSource.getSourceID();
        for (int i = 0; i < values.length; ++i) {
            SQLPPTriplesMap mapping = (SQLPPTriplesMap)values[i];
            if (mapping == null) continue;
            controller.removeTriplesMap(srcuri, mapping.getId());
        }
        this.mappingList.clearSelection();
    }

    private void cmdAddMappingActionPerformed(ActionEvent evt) {
        if (this.selectedSource != null) {
            this.addMapping();
        } else {
            JOptionPane.showMessageDialog(this, "Select a data source to proceed", "Warning", 2);
        }
    }

    private void addMapping() {
        String id = IDGenerator.getNextUniqueID((String)"MAPID-");
        JDialog dialog = new JDialog();
        dialog.setTitle("New Mapping");
        dialog.setModal(true);
        NewMappingDialogPanel panel = new NewMappingDialogPanel(this.apic, dialog, this.selectedSource);
        panel.setID(id);
        dialog.setContentPane(panel);
        dialog.setSize(600, 500);
        dialog.setLocationRelativeTo(this);
        dialog.setVisible(true);
    }

    public void setFilter(String filter) {
        this.txtFilter.setText(filter);
        this.processFilterAction();
    }

    private List<TreeModelFilter<SQLPPTriplesMap>> parseSearchString(String textToParse) throws Exception {
        ArrayList<TreeModelFilter<SQLPPTriplesMap>> listOfFilters = new ArrayList<TreeModelFilter<SQLPPTriplesMap>>();
        String PRED = "pred:";
        if (textToParse != null) {
            MappingPredicateTreeModelFilter filter = new MappingPredicateTreeModelFilter();
            filter.addStringFilter(textToParse);
            listOfFilters.add(filter);
        }
        return listOfFilters;
    }

    private void applyFilters(List<TreeModelFilter<SQLPPTriplesMap>> filters) {
        FilteredModel model = (FilteredModel)((Object)this.mappingList.getModel());
        model.removeAllFilters();
        model.addFilters(filters);
    }

    @Override
    public void datasourceChanged(OBDADataSource oldSource, OBDADataSource newSource) {
        if (newSource == null) {
            return;
        }
        this.selectedSource = newSource;
        SynchronizedMappingListModel model = (SynchronizedMappingListModel)this.mappingList.getModel();
        model.setFocusedSource(newSource.getSourceID());
        this.mappingList.revalidate();
    }

    class PopupListener
    extends MouseAdapter {
        PopupListener() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        private void maybeShowPopup(MouseEvent e) {
            if (e.isPopupTrigger()) {
                MappingManagerPanel.this.menuMappings.show(e.getComponent(), e.getX(), e.getY());
            }
        }
    }
}

