/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.protege.panels;

import com.google.common.collect.ImmutableList;
import it.unibz.inf.ontop.answering.reformulation.generation.dialect.SQLDialectAdapter;
import it.unibz.inf.ontop.answering.reformulation.generation.dialect.impl.SQLServerSQLDialectAdapter;
import it.unibz.inf.ontop.dbschema.Attribute;
import it.unibz.inf.ontop.dbschema.DatabaseRelationDefinition;
import it.unibz.inf.ontop.dbschema.ParserViewDefinition;
import it.unibz.inf.ontop.dbschema.RDBMetadata;
import it.unibz.inf.ontop.dbschema.RDBMetadataExtractionTools;
import it.unibz.inf.ontop.dbschema.RelationDefinition;
import it.unibz.inf.ontop.exception.DuplicateMappingException;
import it.unibz.inf.ontop.injection.OntopSQLOWLAPIConfiguration;
import it.unibz.inf.ontop.model.atom.TargetAtom;
import it.unibz.inf.ontop.model.atom.TargetAtomFactory;
import it.unibz.inf.ontop.model.term.DBConstant;
import it.unibz.inf.ontop.model.term.ImmutableFunctionalTerm;
import it.unibz.inf.ontop.model.term.ImmutableTerm;
import it.unibz.inf.ontop.model.term.TermFactory;
import it.unibz.inf.ontop.model.term.Variable;
import it.unibz.inf.ontop.model.term.functionsymbol.FunctionSymbol;
import it.unibz.inf.ontop.model.type.TypeFactory;
import it.unibz.inf.ontop.model.vocabulary.OWL;
import it.unibz.inf.ontop.protege.core.OBDADataSource;
import it.unibz.inf.ontop.protege.core.OBDAModel;
import it.unibz.inf.ontop.protege.core.OntopConfigurationManager;
import it.unibz.inf.ontop.protege.gui.IconLoader;
import it.unibz.inf.ontop.protege.gui.MapItem;
import it.unibz.inf.ontop.protege.gui.PredicateItem;
import it.unibz.inf.ontop.protege.gui.SQLResultSetTableModel;
import it.unibz.inf.ontop.protege.gui.component.AutoSuggestComboBox;
import it.unibz.inf.ontop.protege.gui.component.PropertyMappingPanel;
import it.unibz.inf.ontop.protege.gui.component.SQLResultTable;
import it.unibz.inf.ontop.protege.gui.treemodels.IncrementalResultSetTableModel;
import it.unibz.inf.ontop.protege.utils.ConnectionTools;
import it.unibz.inf.ontop.protege.utils.DatasourceSelectorListener;
import it.unibz.inf.ontop.protege.utils.DialogUtils;
import it.unibz.inf.ontop.protege.utils.OBDAProgressListener;
import it.unibz.inf.ontop.protege.utils.OBDAProgressMonitor;
import it.unibz.inf.ontop.spec.mapping.PrefixManager;
import it.unibz.inf.ontop.spec.mapping.SQLMappingFactory;
import it.unibz.inf.ontop.spec.mapping.impl.SQLMappingFactoryImpl;
import it.unibz.inf.ontop.spec.mapping.pp.SQLPPTriplesMap;
import it.unibz.inf.ontop.spec.mapping.pp.impl.OntopNativeSQLPPTriplesMap;
import it.unibz.inf.ontop.spec.mapping.serializer.TargetQueryRenderer;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;
import java.util.concurrent.CountDownLatch;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.metal.MetalComboBoxButton;
import javax.swing.table.TableModel;
import org.apache.commons.rdf.api.IRI;
import org.protege.editor.owl.model.OWLModelManager;
import org.semanticweb.owlapi.model.OWLOntology;

public class MappingAssistantPanel
extends JPanel
implements DatasourceSelectorListener {
    private static final long serialVersionUID = 1L;
    private final OBDAModel obdaModel;
    private final OntopConfigurationManager configurationManager;
    private final OWLModelManager owlModelManager;
    private final PrefixManager prefixManager;
    private OBDADataSource selectedSource;
    private MapItem predicateSubjectMap;
    private boolean isSubjectClassValid = true;
    private static final SQLMappingFactory MAPPING_FACTORY = SQLMappingFactoryImpl.getInstance();
    private static final String EMPTY_TEXT = "";
    private static final Color DEFAULT_TEXTFIELD_BACKGROUND = UIManager.getDefaults().getColor("TextField.background");
    private static final Color ERROR_TEXTFIELD_BACKGROUND = new Color(255, 143, 143);
    private final TermFactory termFactory;
    private final TargetAtomFactory targetAtomFactory;
    private static final String formatSpecifier = "\\{([\\w.]+)?\\}";
    private static final Pattern chPattern = Pattern.compile("\\{([\\w.]+)?\\}");
    private JComboBox cboDataSet;
    private JButton cmdClearAll;
    private JButton cmdCreateMapping;
    private JButton cmdExecute;
    private JLabel jLabel1;
    private JLabel lblClass;
    private JLabel lblDataSet;
    private JLabel lblFocusOnURI;
    private JLabel lblProperties;
    private JLabel lblRows;
    private JLabel lblShow;
    private JPanel pnlClassMap;
    private JPanel pnlClassSeachComboBox;
    private AutoSuggestComboBox cboClassAutoSuggest;
    private JPanel pnlCommandButtons;
    private JPanel pnlConcept;
    private JPanel pnlDataBrowser;
    private JPanel pnlDataSet;
    private JPanel pnlEditor;
    private JPanel pnlFocusURI;
    private JPanel pnlOntologyBrowser;
    private JPanel pnlProperties;
    private JPanel pnlPropertiesLabel;
    private JPanel pnlPropertyList;
    private PropertyMappingPanel pnlPropertyEditorList;
    private JPanel pnlQueryEditor;
    private JPanel pnlResult;
    private JPanel pnlResultFilter;
    private JScrollPane scrQueryEditor;
    private JScrollPane scrQueryResult;
    private SQLResultTable tblQueryResult;
    private JSplitPane splMainSplitter;
    private JSplitPane splSqlQuery;
    private JTextField txtClassUriTemplate;
    private JEditorPane txtQueryEditor;
    private JTextField txtRowCount;

    public MappingAssistantPanel(OBDAModel model, OntopConfigurationManager configurationManager, OWLModelManager owlModelManager) {
        this.obdaModel = model;
        this.configurationManager = configurationManager;
        this.owlModelManager = owlModelManager;
        this.prefixManager = this.obdaModel.getMutablePrefixManager();
        this.termFactory = this.obdaModel.getTermFactory();
        this.targetAtomFactory = this.obdaModel.getTargetAtomFactory();
        this.initComponents();
        if (this.obdaModel.getSources().size() > 0) {
            this.datasourceChanged(this.selectedSource, (OBDADataSource)this.obdaModel.getSources().get(0));
        }
    }

    private void initComponents() {
        this.splMainSplitter = new JSplitPane();
        this.pnlDataBrowser = new JPanel();
        this.splSqlQuery = new JSplitPane();
        this.pnlEditor = new JPanel();
        this.pnlDataSet = new JPanel();
        this.lblDataSet = new JLabel();
        this.cboDataSet = new JComboBox();
        this.cmdExecute = new JButton();
        this.pnlQueryEditor = new JPanel();
        this.scrQueryEditor = new JScrollPane();
        this.txtQueryEditor = new JEditorPane();
        this.pnlResultFilter = new JPanel();
        this.lblShow = new JLabel();
        this.txtRowCount = new JTextField();
        this.lblRows = new JLabel();
        this.pnlResult = new JPanel();
        this.jLabel1 = new JLabel();
        this.scrQueryResult = new JScrollPane();
        this.pnlOntologyBrowser = new JPanel();
        this.pnlConcept = new JPanel();
        this.pnlFocusURI = new JPanel();
        this.lblFocusOnURI = new JLabel();
        this.txtClassUriTemplate = new JTextField();
        this.pnlClassMap = new JPanel();
        this.pnlClassSeachComboBox = new JPanel();
        this.lblClass = new JLabel();
        this.pnlProperties = new JPanel();
        this.pnlPropertiesLabel = new JPanel();
        this.lblProperties = new JLabel();
        this.pnlPropertyList = new JPanel();
        this.pnlCommandButtons = new JPanel();
        this.cmdClearAll = new JButton();
        this.cmdCreateMapping = new JButton();
        this.setAlignmentX(5.0f);
        this.setAlignmentY(5.0f);
        this.setFont(new Font("Arial", 0, 18));
        this.setName("panel_master");
        this.setPreferredSize(new Dimension(640, 480));
        this.setLayout(new BorderLayout());
        this.splMainSplitter.setDividerLocation(0.75);
        this.splMainSplitter.setResizeWeight(0.75);
        this.pnlDataBrowser.setName("panel_databrowser");
        this.pnlDataBrowser.setLayout(new BorderLayout());
        this.splSqlQuery.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        this.splSqlQuery.setOrientation(0);
        this.splSqlQuery.setResizeWeight(0.25);
        this.splSqlQuery.setMinimumSize(new Dimension(550, 400));
        this.splSqlQuery.setPreferredSize(new Dimension(550, 400));
        this.pnlEditor.setMinimumSize(new Dimension(156, 100));
        this.pnlEditor.setPreferredSize(new Dimension(156, 100));
        this.pnlEditor.setLayout(new BorderLayout());
        this.pnlDataSet.setLayout(new FlowLayout(0));
        this.lblDataSet.setFont(new Font("Tahoma", 1, 12));
        this.lblDataSet.setForeground(new Color(53, 113, 163));
        this.lblDataSet.setText("Data Set:");
        this.pnlDataSet.add(this.lblDataSet);
        this.cboDataSet.setMinimumSize(new Dimension(23, 23));
        this.cboDataSet.setPreferredSize(new Dimension(240, 23));
        this.cboDataSet.setRenderer(new DataSetItemRenderer());
        this.cboDataSet.addActionListener(this::cboDataSetActionPerformed);
        this.pnlDataSet.add(this.cboDataSet);
        this.cmdExecute.setToolTipText("Execute query");
        this.cmdExecute.setIcon(IconLoader.getImageIcon("images/execute.png"));
        this.cmdExecute.setBorder(BorderFactory.createEtchedBorder());
        this.cmdExecute.setContentAreaFilled(false);
        this.cmdExecute.setPreferredSize(new Dimension(25, 25));
        this.cmdExecute.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MappingAssistantPanel.this.cmdExecuteActionPerformed(evt);
            }
        });
        this.pnlDataSet.add(this.cmdExecute);
        this.pnlEditor.add((Component)this.pnlDataSet, "First");
        this.pnlQueryEditor.setLayout(new BorderLayout());
        this.txtQueryEditor.setBorder(null);
        this.txtQueryEditor.setFont(new Font("Courier New", 0, 12));
        this.txtQueryEditor.setMinimumSize(new Dimension(100, 20));
        this.txtQueryEditor.setPreferredSize(new Dimension(100, 20));
        this.txtQueryEditor.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                MappingAssistantPanel.this.txtQueryEditorKeyPressed(evt);
            }
        });
        this.scrQueryEditor.setViewportView(this.txtQueryEditor);
        this.pnlQueryEditor.add((Component)this.scrQueryEditor, "Center");
        this.pnlEditor.add((Component)this.pnlQueryEditor, "Center");
        this.pnlResultFilter.setLayout(new FlowLayout(2));
        this.lblShow.setFont(new Font("Tahoma", 1, 12));
        this.lblShow.setText("Show");
        this.pnlResultFilter.add(this.lblShow);
        this.txtRowCount.setText("20");
        this.txtRowCount.setToolTipText("Insert the limit for data preview or 0 to present all data");
        this.txtRowCount.setMinimumSize(new Dimension(25, 18));
        this.txtRowCount.setPreferredSize(new Dimension(25, 18));
        this.txtRowCount.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                MappingAssistantPanel.this.txtRowCountFocusLost(evt);
            }
        });
        this.txtRowCount.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                MappingAssistantPanel.this.txtRowCountKeyPressed(evt);
            }
        });
        this.pnlResultFilter.add(this.txtRowCount);
        this.lblRows.setText("rows");
        this.pnlResultFilter.add(this.lblRows);
        this.pnlEditor.add((Component)this.pnlResultFilter, "Last");
        this.splSqlQuery.setLeftComponent(this.pnlEditor);
        this.pnlResult.setLayout(new BorderLayout());
        this.jLabel1.setFont(new Font("Lucida Grande", 1, 13));
        this.jLabel1.setForeground(new Color(53, 113, 163));
        this.jLabel1.setText("SQL Query Result");
        this.jLabel1.setToolTipText("Double click the column headers to add them to the active templates on the right");
        this.jLabel1.setPreferredSize(new Dimension(108, 30));
        this.pnlResult.add((Component)this.jLabel1, "First");
        this.tblQueryResult = new SQLResultTable();
        this.tblQueryResult.setAutoResizeMode(0);
        this.scrQueryResult.setViewportView(this.tblQueryResult);
        this.scrQueryResult.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.pnlResult.add((Component)this.scrQueryResult, "Center");
        this.splSqlQuery.setRightComponent(this.pnlResult);
        this.pnlDataBrowser.add((Component)this.splSqlQuery, "Center");
        this.splMainSplitter.setLeftComponent(this.pnlDataBrowser);
        this.pnlOntologyBrowser.setBorder(BorderFactory.createEmptyBorder(5, 3, 0, 3));
        this.pnlOntologyBrowser.setName("panel_ontologybrowser");
        this.pnlOntologyBrowser.setLayout(new BorderLayout(0, 2));
        this.pnlConcept.setLayout(new BorderLayout(0, 2));
        this.pnlFocusURI.setLayout(new BorderLayout());
        this.lblFocusOnURI.setFont(new Font("Tahoma", 1, 12));
        this.lblFocusOnURI.setForeground(new Color(53, 113, 163));
        this.lblFocusOnURI.setText("Subject IRI template:");
        this.pnlFocusURI.add((Component)this.lblFocusOnURI, "North");
        this.txtClassUriTemplate.setFont(new Font("Dialog", 0, 14));
        this.txtClassUriTemplate.setText(this.defaultUriTemplate());
        this.txtClassUriTemplate.setMinimumSize(new Dimension(240, 23));
        this.txtClassUriTemplate.setPreferredSize(new Dimension(240, 23));
        this.txtClassUriTemplate.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                MappingAssistantPanel.this.txtClassUriTemplateFocusGained(evt);
            }

            @Override
            public void focusLost(FocusEvent evt) {
                MappingAssistantPanel.this.txtClassUriTemplateFocusLost(evt);
            }
        });
        this.txtClassUriTemplate.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                MappingAssistantPanel.this.txtClassUriTemplateKeyPressed(evt);
            }
        });
        this.pnlFocusURI.add((Component)this.txtClassUriTemplate, "South");
        this.pnlConcept.add((Component)this.pnlFocusURI, "North");
        this.pnlClassMap.setBackground(new Color(240, 245, 240));
        this.pnlClassMap.setLayout(new BorderLayout());
        this.pnlClassSeachComboBox.setLayout(new BorderLayout());
        Vector<Object> v = new Vector<Object>();
        for (IRI c : this.obdaModel.getCurrentVocabulary().classes()) {
            v.addElement(new PredicateItem(c, PredicateItem.PredicateType.CLASS, this.prefixManager));
        }
        this.cboClassAutoSuggest = new AutoSuggestComboBox(v);
        this.cboClassAutoSuggest.setRenderer(new ClassListCellRenderer());
        this.cboClassAutoSuggest.setMinimumSize(new Dimension(195, 23));
        this.cboClassAutoSuggest.setPreferredSize(new Dimension(195, 23));
        this.cboClassAutoSuggest.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                MappingAssistantPanel.this.cboClassAutoSuggestItemStateChanged(evt);
            }
        });
        JTextField txtComboBoxEditor = (JTextField)this.cboClassAutoSuggest.getEditor().getEditorComponent();
        txtComboBoxEditor.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                MappingAssistantPanel.this.cboClassAutoSuggestKeyPressed(evt);
            }
        });
        this.pnlClassSeachComboBox.add((Component)this.cboClassAutoSuggest, "Center");
        this.pnlClassMap.add((Component)this.pnlClassSeachComboBox, "South");
        this.lblClass.setFont(new Font("Tahoma", 1, 12));
        this.lblClass.setForeground(new Color(53, 113, 163));
        this.lblClass.setText("rdf:type (optional):");
        this.lblClass.setOpaque(true);
        this.pnlClassMap.add((Component)this.lblClass, "North");
        this.pnlConcept.add((Component)this.pnlClassMap, "Center");
        this.pnlOntologyBrowser.add((Component)this.pnlConcept, "North");
        this.pnlProperties.setLayout(new BorderLayout(0, 3));
        this.pnlPropertiesLabel.setMinimumSize(new Dimension(63, 30));
        this.pnlPropertiesLabel.setLayout(new BorderLayout());
        this.lblProperties.setFont(new Font("Tahoma", 1, 12));
        this.lblProperties.setForeground(new Color(53, 113, 163));
        this.lblProperties.setText("Add new property mapping:");
        this.lblProperties.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        this.lblProperties.setOpaque(true);
        this.lblProperties.setVerticalTextPosition(3);
        this.pnlPropertiesLabel.add((Component)this.lblProperties, "Center");
        this.pnlProperties.add((Component)this.pnlPropertiesLabel, "North");
        this.pnlPropertyList.setLayout(new BorderLayout());
        this.pnlPropertyEditorList = new PropertyMappingPanel(this.obdaModel);
        this.pnlPropertyList.add(this.pnlPropertyEditorList);
        this.pnlProperties.add((Component)this.pnlPropertyList, "Center");
        this.pnlOntologyBrowser.add((Component)this.pnlProperties, "Center");
        this.pnlCommandButtons.setBorder(BorderFactory.createEmptyBorder(5, 0, 0, 0));
        this.pnlCommandButtons.setLayout(new FlowLayout(2));
        this.cmdClearAll.setText("Clear All");
        this.cmdClearAll.setBorder(BorderFactory.createEtchedBorder());
        this.cmdClearAll.setContentAreaFilled(false);
        this.cmdClearAll.setPreferredSize(new Dimension(70, 25));
        this.cmdClearAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MappingAssistantPanel.this.cmdClearAllActionPerformed(evt);
            }
        });
        this.pnlCommandButtons.add(this.cmdClearAll);
        this.cmdCreateMapping.setText("Create Mapping");
        this.cmdCreateMapping.setBorder(BorderFactory.createEtchedBorder());
        this.cmdCreateMapping.setContentAreaFilled(false);
        this.cmdCreateMapping.setPreferredSize(new Dimension(120, 25));
        this.cmdCreateMapping.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MappingAssistantPanel.this.cmdCreateMappingActionPerformed(evt);
            }
        });
        this.pnlCommandButtons.add(this.cmdCreateMapping);
        this.pnlOntologyBrowser.add((Component)this.pnlCommandButtons, "South");
        this.splMainSplitter.setRightComponent(this.pnlOntologyBrowser);
        this.add((Component)this.splMainSplitter, "Center");
    }

    private void cboDataSetActionPerformed(ActionEvent evt) {
        this.txtQueryEditor.setText(EMPTY_TEXT);
        JComboBox cb = (JComboBox)evt.getSource();
        if (cb.getSelectedIndex() != -1) {
            RelationDefinition dd = (RelationDefinition)cb.getSelectedItem();
            if (dd != null) {
                String sql = this.generateSQLString(dd);
                this.txtQueryEditor.setText(sql);
            }
            this.executeQuery();
            this.txtClassUriTemplate.requestFocus();
        }
    }

    private void txtQueryEditorKeyPressed(KeyEvent evt) {
        if (evt.getKeyCode() == 69 && (evt.getModifiers() & 2) != 0) {
            this.executeQuery();
            this.txtClassUriTemplate.requestFocus();
        }
    }

    private void txtRowCountFocusLost(FocusEvent evt) {
        if (this.selectedSource != null && !this.txtQueryEditor.getText().isEmpty()) {
            this.executeQuery();
            this.txtClassUriTemplate.requestFocus();
        }
    }

    private void txtRowCountKeyPressed(KeyEvent evt) {
        int code = evt.getKeyCode();
        if (code == 10) {
            this.txtRowCount.transferFocus();
        }
    }

    private void cmdExecuteActionPerformed(ActionEvent evt) {
        if (this.selectedSource == null) {
            DialogUtils.showQuickErrorDialog(this, new Exception("Data source has not been defined."));
        } else {
            String sqlString = this.txtQueryEditor.getText();
            if (sqlString.isEmpty()) {
                JOptionPane.showMessageDialog(this, "SQL query cannot be blank", "Warning", 2);
            } else {
                this.executeQuery();
                this.txtClassUriTemplate.requestFocus();
            }
        }
    }

    private void txtClassUriTemplateFocusGained(FocusEvent evt) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                String uriTemplate = MappingAssistantPanel.this.txtClassUriTemplate.getText();
                int pos = 0;
                pos = uriTemplate.contains(":") ? uriTemplate.indexOf(":") + 1 : uriTemplate.length();
                MappingAssistantPanel.this.txtClassUriTemplate.setCaretPosition(pos);
            }
        });
    }

    private void txtClassUriTemplateFocusLost(FocusEvent evt) {
        String uriTemplate = this.txtClassUriTemplate.getText();
        if (this.predicateSubjectMap == null) {
            this.predicateSubjectMap = this.createPredicateSubjectMap();
        }
        this.predicateSubjectMap.setTargetMapping(uriTemplate);
        this.validateClassUri();
    }

    private void txtClassUriTemplateKeyPressed(KeyEvent evt) {
        int code = evt.getKeyCode();
        if (code == 27) {
            this.txtClassUriTemplate.setText(this.defaultUriTemplate());
        } else if (code == 10) {
            this.cboClassAutoSuggest.requestFocus();
        }
    }

    private void cboClassAutoSuggestItemStateChanged(ItemEvent evt) {
        Object item = evt.getItem();
        if (item instanceof PredicateItem) {
            if (evt.getStateChange() == 2) {
                this.predicateSubjectMap = this.createPredicateSubjectMap();
                this.predicateSubjectMap.setTargetMapping(this.txtClassUriTemplate.getText());
                this.isSubjectClassValid = true;
            } else {
                PredicateItem selectedItem = (PredicateItem)item;
                this.predicateSubjectMap = new MapItem(selectedItem);
                this.predicateSubjectMap.setTargetMapping(this.txtClassUriTemplate.getText());
                this.isSubjectClassValid = true;
            }
        } else if (item instanceof String) {
            String className = item.toString();
            if (!className.isEmpty()) {
                this.isSubjectClassValid = false;
            }
            this.isSubjectClassValid = true;
        }
        this.validateSubjectClass();
    }

    private void cboClassAutoSuggestKeyPressed(KeyEvent evt) {
        int code = evt.getKeyCode();
        if (code == 27) {
            this.cboClassAutoSuggest.setSelectedIndex(-1);
        }
    }

    private void cmdClearAllActionPerformed(ActionEvent evt) {
        this.clearForm();
    }

    private void cmdCreateMappingActionPerformed(ActionEvent evt) {
        if (!this.pnlPropertyEditorList.isEmpty() && this.pnlPropertyEditorList.isEditing()) {
            this.pnlPropertyEditorList.stopCellEditing();
        }
        try {
            String source = this.txtQueryEditor.getText();
            if (source.isEmpty()) {
                JOptionPane.showMessageDialog(this, "ERROR: The SQL source cannot be empty", "Error", 0);
                return;
            }
            String subjectTargetString = this.predicateSubjectMap.getTargetMapping();
            if (subjectTargetString.equals(":")) {
                JOptionPane.showMessageDialog(this, "ERROR: Class IRI template cannot be empty", "Error", 0);
                return;
            }
            List<MapItem> predicateObjectMapsList = this.pnlPropertyEditorList.getPredicateObjectMapsList();
            ImmutableList<TargetAtom> target = this.prepareTargetQuery(this.predicateSubjectMap, predicateObjectMapsList);
            if (target.isEmpty()) {
                JOptionPane.showMessageDialog(this, "ERROR: The target cannot be empty. Add a class or a property", "Error", 0);
                return;
            }
            OntopNativeSQLPPTriplesMap mappingAxiom = new OntopNativeSQLPPTriplesMap(MAPPING_FACTORY.getSQLQuery(source), target);
            this.obdaModel.addTriplesMap((SQLPPTriplesMap)mappingAxiom, false);
            String targetString = TargetQueryRenderer.encode(target, (PrefixManager)this.prefixManager);
            JOptionPane.showMessageDialog(this, String.format("Mapping created and added to the Mapping Manager: \n target: %s\n source: %s", targetString, source), "Mapping created", 1);
            this.clearForm();
        }
        catch (DuplicateMappingException e) {
            DialogUtils.showQuickErrorDialog(null, (Exception)((Object)e), "Duplicate mapping identification.");
            return;
        }
        catch (NullPointerException e) {
            DialogUtils.showQuickErrorDialog(null, new Exception("Data source has not been defined."));
            return;
        }
        catch (RuntimeException e) {
            DialogUtils.showQuickErrorDialog(null, e, "Empty property mapping.");
            return;
        }
    }

    private ImmutableList<TargetAtom> prepareTargetQuery(MapItem predicateSubjectMap, List<MapItem> predicateObjectMapsList) {
        ImmutableList.Builder bodyBuilder = ImmutableList.builder();
        ImmutableFunctionalTerm subjectTerm = this.createSubjectTerm(predicateSubjectMap);
        if (!predicateSubjectMap.getPredicateIRI().equals((Object)OWL.THING)) {
            TargetAtom concept = this.targetAtomFactory.getTripleTargetAtom((ImmutableTerm)subjectTerm, predicateSubjectMap.getPredicateIRI());
            bodyBuilder.add((Object)concept);
        }
        for (MapItem predicateObjectMap : predicateObjectMapsList) {
            if (predicateObjectMap.isObjectMap()) {
                ImmutableTerm objectTerm = this.createObjectTerm(this.getColumnName(predicateObjectMap), predicateObjectMap.getDataType());
                TargetAtom attribute = this.targetAtomFactory.getTripleTargetAtom((ImmutableTerm)subjectTerm, predicateObjectMap.getPredicateIRI(), objectTerm);
                bodyBuilder.add((Object)attribute);
                continue;
            }
            if (!predicateObjectMap.isRefObjectMap()) continue;
            ImmutableFunctionalTerm objectRefTerm = this.createRefObjectTerm(predicateObjectMap);
            TargetAtom role = this.targetAtomFactory.getTripleTargetAtom((ImmutableTerm)subjectTerm, predicateObjectMap.getPredicateIRI(), (ImmutableTerm)objectRefTerm);
            bodyBuilder.add((Object)role);
        }
        return bodyBuilder.build();
    }

    private ImmutableFunctionalTerm createSubjectTerm(MapItem predicateSubjectMap) {
        String subjectTargetString = predicateSubjectMap.getTargetMapping();
        String subjectUriTemplate = EMPTY_TEXT;
        subjectUriTemplate = this.writtenInFullUri(subjectTargetString) ? subjectTargetString.substring(1, subjectTargetString.length() - 1) : this.prefixManager.getExpandForm(subjectTargetString, false);
        return this.getUriFunctionTerm(subjectUriTemplate);
    }

    private ImmutableTerm createObjectTerm(String column, FunctionSymbol datatype) {
        DBConstant object;
        if (column.matches("\"([\\w.]+)?\"")) {
            object = this.termFactory.getDBStringConstant(column.substring(1, column.length() - 1));
        } else {
            List<FormatString> columnStrings = this.parse(column);
            if (columnStrings.size() > 1) {
                throw new RuntimeException("Unsupported column mapping: " + column);
            }
            String columnName = columnStrings.get(0).toString();
            object = this.termFactory.getVariable(columnName);
        }
        if (datatype == null) {
            return object;
        }
        return this.termFactory.getImmutableFunctionalTerm(datatype, new ImmutableTerm[]{object});
    }

    private ImmutableFunctionalTerm createRefObjectTerm(MapItem predicateObjectMap) {
        String predicateTargetString = predicateObjectMap.getTargetMapping();
        String objectUriTemplate = EMPTY_TEXT;
        objectUriTemplate = this.writtenInFullUri(predicateTargetString) ? predicateTargetString.substring(1, predicateTargetString.length() - 1) : this.prefixManager.getExpandForm(predicateTargetString, false);
        return this.getUriFunctionTerm(objectUriTemplate);
    }

    private boolean writtenInFullUri(String input) {
        return input.startsWith("<") && input.endsWith(">");
    }

    private String getColumnName(MapItem predicateObjectMap) {
        String columnName = predicateObjectMap.getTargetMapping();
        if (columnName.isEmpty()) {
            throw new RuntimeException("Property mapping should not be empty: " + predicateObjectMap.getName());
        }
        return columnName;
    }

    private String getDefaultNamespace(boolean usePrefix) {
        String defaultNamespace = this.prefixManager.getDefaultPrefix();
        if (usePrefix) {
            defaultNamespace = this.prefixManager.getShortForm(defaultNamespace, false);
        }
        return defaultNamespace;
    }

    private String defaultUriTemplate() {
        return String.format("%s", this.getDefaultNamespace(true));
    }

    private MapItem createPredicateSubjectMap() {
        return new MapItem(new PredicateItem(OWL.THING, PredicateItem.PredicateType.CLASS, this.prefixManager));
    }

    private ImmutableFunctionalTerm getUriFunctionTerm(String text) {
        String PLACEHOLDER = "{}";
        LinkedList<Variable> terms = new LinkedList<Variable>();
        List<FormatString> tokens = this.parse(text);
        StringBuilder sb = new StringBuilder();
        for (FormatString token : tokens) {
            if (token instanceof FixedString) {
                sb.append(token.toString());
                continue;
            }
            if (!(token instanceof ColumnString)) continue;
            sb.append("{}");
            Variable column = this.termFactory.getVariable(token.toString());
            terms.add(column);
        }
        return this.termFactory.getIRIFunctionalTerm(sb.toString(), ImmutableList.copyOf(terms));
    }

    private List<FormatString> parse(String text) {
        ArrayList<FormatString> toReturn = new ArrayList<FormatString>();
        Matcher m = chPattern.matcher(text);
        int i = 0;
        while (i < text.length()) {
            if (m.find(i)) {
                if (m.start() != i) {
                    toReturn.add(new FixedString(text.substring(i, m.start())));
                }
                String value = m.group(1);
                toReturn.add(new ColumnString(value));
                i = m.end();
                continue;
            }
            toReturn.add(new FixedString(text.substring(i)));
            break;
        }
        return toReturn;
    }

    private void clearForm() {
        this.cboDataSet.setSelectedIndex(-1);
        this.txtQueryEditor.setText(EMPTY_TEXT);
        this.tblQueryResult = new SQLResultTable();
        this.tblQueryResult.setAutoResizeMode(0);
        this.scrQueryResult.setViewportView(this.tblQueryResult);
        this.cboClassAutoSuggest.setSelectedIndex(-1);
        this.txtClassUriTemplate.setText(this.defaultUriTemplate());
        this.pnlPropertyEditorList.clear();
        this.predicateSubjectMap = null;
    }

    private String generateSQLString(RelationDefinition table) {
        StringBuilder sb = new StringBuilder("select");
        boolean needComma = false;
        for (Attribute attr : table.getAttributes()) {
            if (needComma) {
                sb.append(",");
            }
            sb.append(" ");
            sb.append(attr.getID());
            needComma = true;
        }
        sb.append(" ");
        sb.append("from");
        sb.append(" ");
        sb.append(table.getID());
        return sb.toString();
    }

    private void executeQuery() {
        try {
            this.releaseResultset();
            OBDAProgressMonitor progMonitor = new OBDAProgressMonitor("Executing query...", this);
            CountDownLatch latch = new CountDownLatch(1);
            ExecuteSQLQueryAction action = new ExecuteSQLQueryAction(latch);
            progMonitor.addProgressListener(action);
            progMonitor.start();
            action.run();
            latch.await();
            progMonitor.stop();
            ResultSet rs = action.getResult();
            if (rs != null) {
                SQLResultSetTableModel model = new SQLResultSetTableModel(rs, this.fetchSize());
                this.tblQueryResult.setModel(model);
            }
        }
        catch (Exception e) {
            DialogUtils.showQuickErrorDialog(this, e);
        }
    }

    private int fetchSize() {
        return Integer.parseInt(this.txtRowCount.getText());
    }

    private void releaseResultset() {
        TableModel model = this.tblQueryResult.getModel();
        if (model == null) {
            return;
        }
        if (!(model instanceof IncrementalResultSetTableModel)) {
            return;
        }
        IncrementalResultSetTableModel imodel = (IncrementalResultSetTableModel)model;
        imodel.close();
    }

    @Override
    public void datasourceChanged(OBDADataSource oldSource, OBDADataSource newSource) {
        this.selectedSource = newSource;
        this.addDatabaseTableToDataSetComboBox();
        this.releaseResultset();
        this.clearForm();
    }

    private void addDatabaseTableToDataSetComboBox() {
        DefaultComboBoxModel<DatabaseRelationDefinition> relationList = new DefaultComboBoxModel<DatabaseRelationDefinition>();
        try {
            Connection conn = ConnectionTools.getConnection(this.selectedSource);
            RDBMetadata md = RDBMetadataExtractionTools.createMetadata((Connection)conn, (TypeFactory)this.obdaModel.getTypeFactory());
            RDBMetadataExtractionTools.loadMetadata((RDBMetadata)md, (Connection)conn, null);
            for (DatabaseRelationDefinition relation : md.getDatabaseRelations()) {
                relationList.addElement(relation);
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        this.cboDataSet.setModel(relationList);
        this.cboDataSet.setSelectedIndex(-1);
    }

    private void validateClassUri() {
        if (this.predicateSubjectMap.isValid()) {
            this.setNormalBackground(this.txtClassUriTemplate);
        } else {
            this.setErrorBackground(this.txtClassUriTemplate);
        }
    }

    private void validateSubjectClass() {
        if (this.isSubjectClassValid) {
            this.setNormalBackground(this.cboClassAutoSuggest);
        } else {
            this.setErrorBackground(this.cboClassAutoSuggest);
        }
    }

    private void setNormalBackground(JComboBox comboBox) {
        JTextField text = (JTextField)comboBox.getEditor().getEditorComponent();
        text.setBackground(DEFAULT_TEXTFIELD_BACKGROUND);
    }

    private void setErrorBackground(JComboBox comboBox) {
        JTextField text = (JTextField)comboBox.getEditor().getEditorComponent();
        text.setBackground(ERROR_TEXTFIELD_BACKGROUND);
        Component[] comp = comboBox.getComponents();
        for (int i = 0; i < comp.length; ++i) {
            if (!(comp[i] instanceof MetalComboBoxButton)) continue;
            MetalComboBoxButton coloredArrowsButton = (MetalComboBoxButton)comp[i];
            coloredArrowsButton.setBackground(null);
            break;
        }
        comboBox.requestFocus();
    }

    private void setNormalBackground(JTextField textField) {
        textField.setBackground(DEFAULT_TEXTFIELD_BACKGROUND);
    }

    private void setErrorBackground(JTextField textField) {
        textField.setBackground(ERROR_TEXTFIELD_BACKGROUND);
        textField.requestFocus();
    }

    private class ExecuteSQLQueryAction
    implements OBDAProgressListener {
        CountDownLatch latch = null;
        Thread thread = null;
        ResultSet result = null;
        Statement statement = null;
        private boolean isCancelled = false;
        private boolean errorShown = false;

        private ExecuteSQLQueryAction(CountDownLatch latch) {
            this.latch = latch;
        }

        @Override
        public void actionCanceled() throws SQLException {
            this.isCancelled = true;
            if (this.thread != null) {
                this.thread.interrupt();
            }
            if (this.statement != null && !this.statement.isClosed()) {
                this.statement.close();
            }
            this.result = null;
            this.latch.countDown();
        }

        public ResultSet getResult() {
            return this.result;
        }

        public void run() {
            this.thread = new Thread(){

                @Override
                public void run() {
                    try {
                        OWLOntology activeOntology = MappingAssistantPanel.this.owlModelManager.getActiveOntology();
                        OntopSQLOWLAPIConfiguration configuration = MappingAssistantPanel.this.configurationManager.buildOntopSQLOWLAPIConfiguration(activeOntology);
                        SQLDialectAdapter sqlDialect = (SQLDialectAdapter)configuration.getInjector().getInstance(SQLDialectAdapter.class);
                        String sqlString = MappingAssistantPanel.this.txtQueryEditor.getText();
                        int rowCount = MappingAssistantPanel.this.fetchSize();
                        if (rowCount >= 0) {
                            if (sqlDialect instanceof SQLServerSQLDialectAdapter) {
                                SQLServerSQLDialectAdapter sqlServerDialect = (SQLServerSQLDialectAdapter)sqlDialect;
                                sqlString = sqlServerDialect.sqlLimit(sqlString, (long)rowCount);
                            } else {
                                sqlString = String.format("%s %s", sqlString, sqlDialect.sqlSlice((long)rowCount, 0L));
                            }
                        } else {
                            throw new RuntimeException("Invalid limit number.");
                        }
                        Connection c = ConnectionTools.getConnection(MappingAssistantPanel.this.selectedSource);
                        Statement s = c.createStatement();
                        ExecuteSQLQueryAction.this.result = s.executeQuery(sqlString);
                        ExecuteSQLQueryAction.this.latch.countDown();
                    }
                    catch (Exception e) {
                        ExecuteSQLQueryAction.this.latch.countDown();
                        ExecuteSQLQueryAction.this.errorShown = true;
                        DialogUtils.showQuickErrorDialog(null, e);
                    }
                }
            };
            this.thread.start();
        }

        @Override
        public boolean isCancelled() {
            return this.isCancelled;
        }

        @Override
        public boolean isErrorShown() {
            return this.errorShown;
        }
    }

    private class ClassListCellRenderer
    extends DefaultListCellRenderer {
        private static final long serialVersionUID = 1L;

        private ClassListCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            JLabel label = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (value instanceof PredicateItem) {
                PredicateItem predicate = (PredicateItem)value;
                ImageIcon icon = IconLoader.getImageIcon("images/class_primitive.png");
                label.setIcon(icon);
                label.setText(predicate.getQualifiedName());
            }
            return label;
        }
    }

    private class DataSetItemRenderer
    extends DefaultListCellRenderer {
        private static final long serialVersionUID = 1L;

        private DataSetItemRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            JLabel label = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            int tableSize = list.getModel().getSize();
            if (tableSize == 0) {
                label.setText("<No table found>");
                return label;
            }
            if (index == -1) {
                label.setText("<Select database table>");
                return label;
            }
            if (value instanceof DatabaseRelationDefinition) {
                DatabaseRelationDefinition td = (DatabaseRelationDefinition)value;
                ImageIcon icon = IconLoader.getImageIcon("images/db_table.png");
                label.setIcon(icon);
                label.setText(td.getID().getSQLRendering());
            } else if (value instanceof ParserViewDefinition) {
                ParserViewDefinition vd = (ParserViewDefinition)value;
                ImageIcon icon = IconLoader.getImageIcon("images/db_view.png");
                label.setIcon(icon);
                label.setText(vd.getID().getSQLRendering());
            }
            return label;
        }
    }

    private class ColumnString
    implements FormatString {
        private final String s;

        ColumnString(String s) {
            this.s = s;
        }

        @Override
        public int index() {
            return 0;
        }

        @Override
        public String toString() {
            return this.s;
        }
    }

    private class FixedString
    implements FormatString {
        private final String s;

        FixedString(String s) {
            this.s = s;
        }

        @Override
        public int index() {
            return -1;
        }

        @Override
        public String toString() {
            return this.s;
        }
    }

    private static interface FormatString {
        public int index();

        public String toString();
    }
}

