/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.protege.gui.treemodels;

import it.unibz.inf.ontop.model.atom.TargetAtom;
import it.unibz.inf.ontop.model.term.ImmutableFunctionalTerm;
import it.unibz.inf.ontop.model.term.ImmutableTerm;
import it.unibz.inf.ontop.model.term.RDFConstant;

public class TreeModelTools {
    public static boolean match(String keyword, TargetAtom atom) {
        return atom.getSubstitutedTerms().stream().anyMatch(t -> TreeModelTools.match(keyword, t));
    }

    public static boolean match(String keyword, ImmutableTerm term) {
        if (term instanceof ImmutableFunctionalTerm) {
            ImmutableFunctionalTerm functionTerm = (ImmutableFunctionalTerm)term;
            if (functionTerm.getFunctionSymbol().toString().contains(keyword)) {
                return true;
            }
            return functionTerm.getTerms().stream().anyMatch(t -> TreeModelTools.match(keyword, t));
        }
        if (term instanceof RDFConstant) {
            return ((RDFConstant)term).getValue().contains(keyword);
        }
        return false;
    }
}

