/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.protege.gui.component;

import it.unibz.inf.ontop.model.term.functionsymbol.FunctionSymbol;
import it.unibz.inf.ontop.protege.core.OBDAModel;
import it.unibz.inf.ontop.protege.gui.IconLoader;
import it.unibz.inf.ontop.protege.gui.MapItem;
import it.unibz.inf.ontop.protege.gui.PredicateItem;
import it.unibz.inf.ontop.protege.gui.action.EditableCellFocusAction;
import it.unibz.inf.ontop.protege.gui.component.AutoSuggestComboBox;
import it.unibz.inf.ontop.protege.gui.component.DataTypeComboBox;
import it.unibz.inf.ontop.spec.mapping.PrefixManager;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.Vector;
import javax.swing.AbstractCellEditor;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.metal.MetalComboBoxButton;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import org.apache.commons.rdf.api.IRI;

public class PropertyMappingPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private final OBDAModel obdaModel;
    private PrefixManager prefixManager;
    private boolean isPredicatePropertyValid = false;
    private static final Color SELECTION_BACKGROUND = UIManager.getDefaults().getColor("Table.selectionBackground");
    private static final Color NORMAL_BACKGROUND = new Color(240, 245, 240);
    private static final Border EDIT_BORDER = BorderFactory.createCompoundBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(1, 3, 1, 3), BorderFactory.createLineBorder(new Color(0, 0, 0), 2)), BorderFactory.createEmptyBorder(4, 4, 4, 4));
    private static final Border NORMAL_BORDER = BorderFactory.createCompoundBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(1, 3, 1, 3), BorderFactory.createLineBorder(new Color(192, 192, 192), 1)), BorderFactory.createEmptyBorder(5, 5, 5, 5));
    private static final Font DEFAULT_FONT = new Font("Dialog", 0, 14);
    private static Color DEFAULT_TEXTFIELD_BACKGROUND = UIManager.getDefaults().getColor("TextField.background");
    private static Color ERROR_TEXTFIELD_BACKGROUND = new Color(255, 143, 143);
    private JButton cmdAdd;
    private JLabel lblCurrentPropertyMapping;
    private JTable lstProperties;
    private JMenuItem menuDelete;
    private JPanel pnlAddProperty;
    private AutoSuggestComboBox cboPropertyAutoSuggest;
    private JPanel pnlPropertyMapping;
    private JPopupMenu popMenu;
    private JScrollPane scrPropertyList;

    public PropertyMappingPanel(OBDAModel obdaModel) {
        this.obdaModel = obdaModel;
        this.prefixManager = obdaModel.getMutablePrefixManager();
        this.initComponents();
    }

    public List<MapItem> getPredicateObjectMapsList() {
        DefaultTableModel propertyListModel = (DefaultTableModel)this.lstProperties.getModel();
        int column = 0;
        int totalRow = propertyListModel.getRowCount();
        ArrayList<MapItem> predicateObjectMapList = new ArrayList<MapItem>();
        for (int row = 0; row < totalRow; ++row) {
            predicateObjectMapList.add((MapItem)propertyListModel.getValueAt(row, column));
        }
        return predicateObjectMapList;
    }

    public boolean isEmpty() {
        return this.getPredicateObjectMapsList().isEmpty();
    }

    public boolean isEditing() {
        return this.lstProperties.isEditing();
    }

    public boolean stopCellEditing() {
        return this.lstProperties.getCellEditor().stopCellEditing();
    }

    public void clear() {
        this.cboPropertyAutoSuggest.setSelectedIndex(-1);
        ((DefaultTableModel)this.lstProperties.getModel()).setRowCount(0);
    }

    private void initComponents() {
        this.popMenu = new JPopupMenu();
        this.menuDelete = new JMenuItem();
        this.pnlAddProperty = new JPanel();
        this.cmdAdd = new JButton();
        this.pnlPropertyMapping = new JPanel();
        this.scrPropertyList = new JScrollPane();
        this.lstProperties = new JTable();
        this.lblCurrentPropertyMapping = new JLabel();
        this.menuDelete.setText("Delete mapping");
        this.menuDelete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PropertyMappingPanel.this.menuDeleteActionPerformed(evt);
            }
        });
        this.popMenu.add(this.menuDelete);
        this.setAlignmentX(5.0f);
        this.setAlignmentY(5.0f);
        this.setFont(new Font("Arial", 0, 18));
        this.setMinimumSize(new Dimension(280, 500));
        this.setPreferredSize(new Dimension(280, 500));
        this.setLayout(new BorderLayout());
        this.pnlAddProperty.setBorder(BorderFactory.createEmptyBorder(0, 0, 3, 0));
        this.pnlAddProperty.setLayout(new BorderLayout(3, 0));
        Vector<Object> v = new Vector<Object>();
        for (IRI dp : this.obdaModel.getCurrentVocabulary().dataProperties()) {
            v.addElement(new PredicateItem(dp, PredicateItem.PredicateType.DATA_PROPERTY, this.prefixManager));
        }
        for (IRI op : this.obdaModel.getCurrentVocabulary().objectProperties()) {
            v.addElement(new PredicateItem(op, PredicateItem.PredicateType.OBJECT_PROPERTY, this.prefixManager));
        }
        this.cboPropertyAutoSuggest = new AutoSuggestComboBox(v);
        this.cboPropertyAutoSuggest.setRenderer(new PropertyListCellRenderer());
        this.cboPropertyAutoSuggest.setMinimumSize(new Dimension(195, 23));
        this.cboPropertyAutoSuggest.setPreferredSize(new Dimension(195, 23));
        JTextField txtComboBoxEditor = (JTextField)this.cboPropertyAutoSuggest.getEditor().getEditorComponent();
        txtComboBoxEditor.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                PropertyMappingPanel.this.cboPropertyAutoSuggestKeyPressed(evt);
            }
        });
        this.pnlAddProperty.add(this.cboPropertyAutoSuggest);
        this.cmdAdd.setBorder(BorderFactory.createEtchedBorder());
        this.cmdAdd.setContentAreaFilled(false);
        this.cmdAdd.setFocusable(false);
        this.cmdAdd.setMaximumSize(new Dimension(23, 23));
        this.cmdAdd.setMinimumSize(new Dimension(23, 23));
        this.cmdAdd.setPreferredSize(new Dimension(23, 23));
        this.cmdAdd.setIcon(IconLoader.getImageIcon("images/plus.png"));
        this.cmdAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PropertyMappingPanel.this.cmdAddActionPerformed(evt);
            }
        });
        this.pnlAddProperty.add((Component)this.cmdAdd, "East");
        this.add((Component)this.pnlAddProperty, "First");
        this.pnlPropertyMapping.setLayout(new BorderLayout());
        this.lstProperties.setModel(new DefaultTableModel(0, 1));
        this.lstProperties.setCellSelectionEnabled(true);
        this.lstProperties.setRowHeight(65);
        this.lstProperties.setSelectionMode(0);
        this.lstProperties.setTableHeader(null);
        this.lstProperties.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                PropertyMappingPanel.this.lstPropertiesMousePressed(evt);
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                PropertyMappingPanel.this.lstPropertiesMouseReleased(evt);
            }
        });
        this.lstProperties.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                PropertyMappingPanel.this.lstPropertiesKeyPressed(evt);
            }
        });
        new EditableCellFocusAction(this.lstProperties, KeyStroke.getKeyStroke(10, 0));
        new EditableCellFocusAction(this.lstProperties, KeyStroke.getKeyStroke(113, 0));
        this.scrPropertyList.setViewportView(this.lstProperties);
        this.pnlPropertyMapping.add((Component)this.scrPropertyList, "Center");
        this.lblCurrentPropertyMapping.setFont(new Font("Tahoma", 1, 12));
        this.lblCurrentPropertyMapping.setForeground(new Color(53, 113, 163));
        this.lblCurrentPropertyMapping.setText("Current property mappings:");
        this.lblCurrentPropertyMapping.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        this.pnlPropertyMapping.add((Component)this.lblCurrentPropertyMapping, "North");
        this.add((Component)this.pnlPropertyMapping, "Center");
    }

    private void menuDeleteActionPerformed(ActionEvent evt) {
        this.deleteMappingItem();
    }

    private void lstPropertiesMousePressed(MouseEvent evt) {
        this.showPopup(evt);
    }

    private void lstPropertiesMouseReleased(MouseEvent evt) {
        this.showPopup(evt);
    }

    private void lstPropertiesKeyPressed(KeyEvent evt) {
        int code = evt.getKeyCode();
        if (code == 127) {
            this.deleteMappingItem();
        }
    }

    private void cmdAddActionPerformed(ActionEvent evt) {
        Object item = this.cboPropertyAutoSuggest.getSelectedItem();
        this.addPredicateProperty(item);
        this.validatePredicateProperty();
    }

    private void showPopup(MouseEvent evt) {
        if (evt.isPopupTrigger()) {
            this.popMenu.show(evt.getComponent(), evt.getX(), evt.getY());
        }
    }

    private void deleteMappingItem() {
        int index;
        TableCellEditor editor = this.lstProperties.getCellEditor();
        if (editor != null) {
            editor.stopCellEditing();
        }
        if ((index = this.lstProperties.getSelectedRow()) != -1) {
            ((DefaultTableModel)this.lstProperties.getModel()).removeRow(index);
        }
    }

    private void cboPropertyAutoSuggestKeyPressed(KeyEvent evt) {
        int code = evt.getKeyCode();
        if (code == 27) {
            this.cboPropertyAutoSuggest.setSelectedIndex(-1);
        } else if (code == 10) {
            Object item = this.cboPropertyAutoSuggest.getSelectedItem();
            this.addPredicateProperty(item);
            this.validatePredicateProperty();
        }
    }

    private void addPredicateProperty(Object item) {
        if (item instanceof PredicateItem) {
            PredicateItem selectedItem = (PredicateItem)item;
            this.addRow(selectedItem);
            this.isPredicatePropertyValid = true;
        } else {
            this.isPredicatePropertyValid = false;
        }
    }

    private void addRow(PredicateItem selectedItem) {
        MapItem predicateObjectMap = new MapItem(selectedItem);
        if (selectedItem.isObjectPropertyPredicate()) {
            predicateObjectMap.setTargetMapping(this.defaultUriTemplate());
        }
        Object[] row = new MapItem[]{predicateObjectMap};
        ((DefaultTableModel)this.lstProperties.getModel()).addRow(row);
        TableColumn col = this.lstProperties.getColumnModel().getColumn(0);
        col.setCellRenderer(new PropertyItemRenderer());
        PropertyItemEditor editor = new PropertyItemEditor();
        editor.addCellEditorListener(this.lstProperties);
        col.setCellEditor(editor);
    }

    private String defaultUriTemplate() {
        return String.format("%s", this.getDefaultNamespace());
    }

    private String getDefaultNamespace() {
        String defaultNamespace = this.prefixManager.getDefaultPrefix();
        return this.prefixManager.getShortForm(defaultNamespace, false);
    }

    private void validatePredicateProperty() {
        if (this.isPredicatePropertyValid) {
            this.setNormalBackground(this.cboPropertyAutoSuggest);
        } else {
            this.setErrorBackground(this.cboPropertyAutoSuggest);
        }
    }

    private void setNormalBackground(JComboBox comboBox) {
        JTextField text = (JTextField)comboBox.getEditor().getEditorComponent();
        text.setBackground(DEFAULT_TEXTFIELD_BACKGROUND);
    }

    private void setErrorBackground(JComboBox comboBox) {
        JTextField text = (JTextField)comboBox.getEditor().getEditorComponent();
        text.setBackground(ERROR_TEXTFIELD_BACKGROUND);
        Component[] comp = comboBox.getComponents();
        for (int i = 0; i < comp.length; ++i) {
            if (!(comp[i] instanceof MetalComboBoxButton)) continue;
            MetalComboBoxButton coloredArrowsButton = (MetalComboBoxButton)comp[i];
            coloredArrowsButton.setBackground(null);
            break;
        }
        comboBox.requestFocus();
    }

    private class PropertyListCellRenderer
    extends DefaultListCellRenderer {
        private static final long serialVersionUID = 1L;

        private PropertyListCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            JLabel label = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (value instanceof PredicateItem) {
                PredicateItem property = (PredicateItem)value;
                if (property.isDataPropertyPredicate()) {
                    ImageIcon icon = IconLoader.getImageIcon("images/data_property.png");
                    label.setIcon(icon);
                    label.setText(property.getQualifiedName());
                } else if (property.isObjectPropertyPredicate()) {
                    ImageIcon icon = IconLoader.getImageIcon("images/object_property.png");
                    label.setIcon(icon);
                    label.setText(property.getQualifiedName());
                }
            }
            return label;
        }
    }

    public class PropertyItemEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        private static final long serialVersionUID = 1L;
        private JPanel pnlPropertyMapCell;
        private JPanel pnlPropertyName;
        private JPanel pnlPropertyUriTemplate;
        private JLabel lblPropertyName;
        private DataTypeComboBox cboDataTypes;
        private JLabel lblMapIcon;
        private JTextField txtPropertyTargetMap;
        private MapItem editedItem;

        public PropertyItemEditor() {
            this.initComponents();
        }

        private void setCaretToTextField() {
            this.txtPropertyTargetMap.requestFocusInWindow();
            this.txtPropertyTargetMap.setCaretPosition(this.txtPropertyTargetMap.getText().length());
        }

        private void initComponents() {
            this.pnlPropertyMapCell = new JPanel(){

                @Override
                public void addNotify() {
                    super.addNotify();
                    PropertyItemEditor.this.setCaretToTextField();
                }
            };
            this.pnlPropertyMapCell.setRequestFocusEnabled(true);
            this.pnlPropertyName = new JPanel();
            this.pnlPropertyUriTemplate = new JPanel();
            this.lblPropertyName = new JLabel();
            this.cboDataTypes = new DataTypeComboBox();
            this.lblMapIcon = new JLabel();
            this.txtPropertyTargetMap = new JTextField();
            this.pnlPropertyMapCell.setLayout(new BorderLayout(0, 2));
            this.pnlPropertyMapCell.setBorder(NORMAL_BORDER);
            this.pnlPropertyMapCell.setRequestFocusEnabled(true);
            this.lblPropertyName.setFont(DEFAULT_FONT);
            this.cboDataTypes.setBackground(Color.WHITE);
            this.cboDataTypes.setSelectedIndex(-1);
            this.pnlPropertyName.setLayout(new BorderLayout(5, 0));
            this.pnlPropertyName.setOpaque(false);
            this.pnlPropertyName.add((Component)this.lblPropertyName, "West");
            this.pnlPropertyName.add((Component)this.cboDataTypes, "East");
            this.lblMapIcon.setIcon(IconLoader.getImageIcon("images/link.png"));
            this.txtPropertyTargetMap.setFont(DEFAULT_FONT);
            this.pnlPropertyUriTemplate.setLayout(new BorderLayout(5, 0));
            this.pnlPropertyUriTemplate.setOpaque(false);
            this.pnlPropertyUriTemplate.add((Component)this.lblMapIcon, "West");
            this.pnlPropertyUriTemplate.add((Component)this.txtPropertyTargetMap, "Center");
            this.pnlPropertyMapCell.add((Component)this.pnlPropertyName, "North");
            this.pnlPropertyMapCell.add((Component)this.pnlPropertyUriTemplate, "South");
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            this.pnlPropertyMapCell.setBackground(SELECTION_BACKGROUND);
            if (!isSelected) {
                this.pnlPropertyMapCell.setBorder(EDIT_BORDER);
            }
            if (value instanceof MapItem) {
                MapItem entry = (MapItem)value;
                this.lblPropertyName.setText(entry.toString());
                this.editedItem = entry;
                if (entry.isObjectMap()) {
                    this.cboDataTypes.setVisible(true);
                    this.cboDataTypes.setSelectedItem(entry.getDataType());
                    this.lblPropertyName.setIcon(IconLoader.getImageIcon("images/data_property.png"));
                    this.txtPropertyTargetMap.setText(entry.getTargetMapping());
                } else if (entry.isRefObjectMap()) {
                    this.cboDataTypes.setVisible(false);
                    this.lblPropertyName.setIcon(IconLoader.getImageIcon("images/object_property.png"));
                    this.txtPropertyTargetMap.setText(entry.getTargetMapping());
                }
            }
            return this.pnlPropertyMapCell;
        }

        @Override
        public Object getCellEditorValue() {
            if (this.editedItem != null) {
                this.editedItem.setTargetMapping(this.txtPropertyTargetMap.getText());
                this.editedItem.setDataType((FunctionSymbol)this.cboDataTypes.getSelectedItem());
            }
            return this.editedItem;
        }

        @Override
        public boolean isCellEditable(EventObject anEvent) {
            MouseEvent mouseEvent;
            return anEvent instanceof MouseEvent ? (mouseEvent = (MouseEvent)anEvent).getClickCount() == 1 : anEvent instanceof ActionEvent;
        }

        @Override
        public boolean stopCellEditing() {
            try {
                this.editedItem.setTargetMapping(this.txtPropertyTargetMap.getText());
                this.editedItem.setDataType((FunctionSymbol)this.cboDataTypes.getSelectedItem());
                if (!this.editedItem.isValid()) {
                    this.setErrorBackground(this.txtPropertyTargetMap);
                    return false;
                }
                this.setNormalBackground(this.txtPropertyTargetMap);
                return super.stopCellEditing();
            }
            catch (Exception e) {
                return super.stopCellEditing();
            }
        }

        private void setNormalBackground(JTextField textField) {
            textField.setBackground(DEFAULT_TEXTFIELD_BACKGROUND);
        }

        private void setErrorBackground(JTextField textField) {
            textField.setBackground(ERROR_TEXTFIELD_BACKGROUND);
        }
    }

    class PropertyItemRenderer
    extends JPanel
    implements TableCellRenderer {
        private static final long serialVersionUID = 1L;
        private JPanel pnlPropertyName;
        private JPanel pnlPropertyUriTemplate;
        private JLabel lblPropertyName;
        private DataTypeComboBox cboDataTypes;
        private JLabel lblMapIcon;
        private JTextField txtPropertyTargetMap;

        public PropertyItemRenderer() {
            this.initComponents();
        }

        private void initComponents() {
            this.setBackground(NORMAL_BACKGROUND);
            this.setLayout(new BorderLayout(0, 2));
            this.setBorder(NORMAL_BORDER);
            this.setFocusable(false);
            this.pnlPropertyName = new JPanel();
            this.pnlPropertyUriTemplate = new JPanel();
            this.lblPropertyName = new JLabel();
            this.cboDataTypes = new DataTypeComboBox();
            this.lblMapIcon = new JLabel();
            this.txtPropertyTargetMap = new JTextField();
            this.lblPropertyName.setFont(DEFAULT_FONT);
            this.cboDataTypes.setBackground(Color.WHITE);
            this.cboDataTypes.setSelectedIndex(-1);
            this.pnlPropertyName.setLayout(new BorderLayout(5, 0));
            this.pnlPropertyName.setOpaque(false);
            this.pnlPropertyName.setFocusable(false);
            this.pnlPropertyName.add((Component)this.lblPropertyName, "West");
            this.pnlPropertyName.add((Component)this.cboDataTypes, "East");
            this.lblMapIcon.setIcon(IconLoader.getImageIcon("images/link.png"));
            this.txtPropertyTargetMap.setFont(DEFAULT_FONT);
            this.pnlPropertyUriTemplate.setLayout(new BorderLayout(5, 0));
            this.pnlPropertyUriTemplate.setOpaque(false);
            this.pnlPropertyUriTemplate.setFocusable(false);
            this.pnlPropertyUriTemplate.add((Component)this.lblMapIcon, "West");
            this.pnlPropertyUriTemplate.add((Component)this.txtPropertyTargetMap, "Center");
            this.add((Component)this.pnlPropertyName, "North");
            this.add((Component)this.pnlPropertyUriTemplate, "South");
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (isSelected) {
                this.setBackground(SELECTION_BACKGROUND);
                if (hasFocus) {
                    this.setBorder(NORMAL_BORDER);
                } else {
                    this.setBorder(EDIT_BORDER);
                }
            } else {
                if (hasFocus) {
                    this.setBackground(SELECTION_BACKGROUND);
                } else {
                    this.setBackground(NORMAL_BACKGROUND);
                }
                this.setBorder(NORMAL_BORDER);
            }
            if (value instanceof MapItem) {
                MapItem entry = (MapItem)value;
                this.lblPropertyName.setText(entry.toString());
                if (entry.isObjectMap()) {
                    this.cboDataTypes.setVisible(true);
                    this.cboDataTypes.setSelectedItem(entry.getDataType());
                    this.lblPropertyName.setIcon(IconLoader.getImageIcon("images/data_property.png"));
                    this.txtPropertyTargetMap.setText(entry.getTargetMapping());
                } else if (entry.isRefObjectMap()) {
                    this.cboDataTypes.setVisible(false);
                    this.lblPropertyName.setIcon(IconLoader.getImageIcon("images/object_property.png"));
                    this.txtPropertyTargetMap.setText(entry.getTargetMapping());
                }
            }
            return this;
        }
    }
}

