/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.protege.gui;

import it.unibz.inf.ontop.model.term.functionsymbol.FunctionSymbol;
import it.unibz.inf.ontop.protege.gui.PredicateItem;
import it.unibz.inf.ontop.spec.mapping.PrefixManager;
import org.apache.commons.rdf.api.IRI;

public class MapItem {
    private PredicateItem predicateItem;
    private String targetMapping = "";
    private FunctionSymbol dataType;

    public MapItem(PredicateItem predicate) {
        this.predicateItem = predicate;
    }

    public PrefixManager getPrefixManager() {
        return this.predicateItem.getPrefixManager();
    }

    public String getName() {
        if (this.predicateItem == null) {
            return "";
        }
        return this.predicateItem.getFullName();
    }

    public IRI getPredicateIRI() {
        return this.predicateItem.getSource();
    }

    public void setTargetMapping(String columnOrUriTemplate) {
        this.targetMapping = columnOrUriTemplate;
    }

    public String getTargetMapping() {
        return this.targetMapping;
    }

    public void setDataType(FunctionSymbol type) {
        this.dataType = type;
    }

    public FunctionSymbol getDataType() {
        return this.dataType;
    }

    public boolean isObjectMap() {
        return this.predicateItem.isDataPropertyPredicate();
    }

    public boolean isRefObjectMap() {
        return this.predicateItem.isObjectPropertyPredicate();
    }

    public boolean isValid() {
        if (this.predicateItem == null) {
            return false;
        }
        return !this.targetMapping.isEmpty();
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        MapItem other = (MapItem)obj;
        return this.getName() == other.getName();
    }

    public String toString() {
        if (this.predicateItem == null) {
            return "";
        }
        return this.predicateItem.getQualifiedName();
    }
}

