/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.protege.core;

import it.unibz.inf.ontop.injection.OntopSQLOWLAPIConfiguration;
import it.unibz.inf.ontop.protege.core.DisposableProperties;
import it.unibz.inf.ontop.protege.core.OBDADataSource;
import it.unibz.inf.ontop.protege.core.OBDAModel;
import it.unibz.inf.ontop.spec.mapping.parser.DataSource2PropertiesConvertor;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.semanticweb.owlapi.model.OWLOntology;

public class OntopConfigurationManager {
    private final OBDAModel obdaModel;
    private final DisposableProperties settings;
    private final DisposableProperties userSettings;
    @Nullable
    private File implicitDBConstraintFile;

    OntopConfigurationManager(@Nonnull OBDAModel obdaModel, @Nonnull DisposableProperties internalSettings) {
        this.obdaModel = obdaModel;
        this.settings = internalSettings;
        this.implicitDBConstraintFile = null;
        this.userSettings = new DisposableProperties();
    }

    Properties snapshotProperties() {
        DisposableProperties properties = this.settings.clone();
        properties.putAll((Map<?, ?>)this.userSettings.clone());
        properties.putAll((Map<?, ?>)DataSource2PropertiesConvertor.convert(this.obdaModel.getDatasource()));
        return properties;
    }

    Properties snapshotUserProperties() {
        DisposableProperties properties = this.userSettings.clone();
        properties.putAll((Map<?, ?>)DataSource2PropertiesConvertor.convert(this.obdaModel.getDatasource()));
        return properties;
    }

    public OntopSQLOWLAPIConfiguration buildOntopSQLOWLAPIConfiguration(OWLOntology currentOntology) {
        OntopSQLOWLAPIConfiguration.Builder builder = (OntopSQLOWLAPIConfiguration.Builder)((OntopSQLOWLAPIConfiguration.Builder)OntopSQLOWLAPIConfiguration.defaultBuilder().properties(this.snapshotProperties())).ppMapping(this.obdaModel.generatePPMapping());
        Optional.ofNullable(this.implicitDBConstraintFile).ifPresent(arg_0 -> ((OntopSQLOWLAPIConfiguration.Builder)builder).basicImplicitConstraintFile(arg_0));
        builder.ontology(currentOntology);
        return builder.build();
    }

    void setImplicitDBConstraintFile(File implicitDBConstraintFile) {
        this.implicitDBConstraintFile = implicitDBConstraintFile;
    }

    void clearImplicitDBConstraintFile() {
        this.implicitDBConstraintFile = null;
    }

    public void loadPropertyFile(File propertyFile) throws IOException {
        this.userSettings.load(new FileReader(propertyFile));
        OntopConfigurationManager.loadDataSource(this.obdaModel, this.userSettings);
    }

    void resetProperties(DisposableProperties settings) {
        this.settings.clear();
        this.settings.putAll((Map<?, ?>)settings);
        this.userSettings.clear();
        OBDADataSource dataSource = this.obdaModel.getDatasource();
        dataSource.setParameter("jdbc.url", "");
        dataSource.setParameter("jdbc.user", "");
        dataSource.setParameter("jdbc.password", "");
        dataSource.setParameter("jdbc.driver", "");
    }

    public void loadProperties(Properties properties) throws IOException {
        this.userSettings.putAll((Map<?, ?>)properties);
        OntopConfigurationManager.loadDataSource(this.obdaModel, this.userSettings);
    }

    private static void loadDataSource(OBDAModel obdaModel, DisposableProperties properties) {
        OBDADataSource dataSource = obdaModel.getDatasource();
        properties.getOptionalProperty("jdbc.url").ifPresent(v -> dataSource.setParameter("jdbc.url", (String)v));
        properties.getOptionalProperty("jdbc.user").ifPresent(v -> dataSource.setParameter("jdbc.user", (String)v));
        properties.getOptionalProperty("jdbc.password").ifPresent(v -> dataSource.setParameter("jdbc.password", (String)v));
        properties.getOptionalProperty("jdbc.driver").ifPresent(v -> dataSource.setParameter("jdbc.driver", (String)v));
    }
}

