/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.owlapi.validation;

import it.unibz.inf.ontop.owlapi.connection.OWLConnection;
import it.unibz.inf.ontop.spec.ontology.ClassifiedTBox;
import it.unibz.inf.ontop.spec.ontology.DataPropertyExpression;
import it.unibz.inf.ontop.spec.ontology.OClass;
import it.unibz.inf.ontop.spec.ontology.ObjectPropertyExpression;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.function.Function;
import java.util.function.Predicate;
import org.apache.commons.rdf.api.IRI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OntopOWLEmptyEntitiesChecker {
    private static final String CLASS_QUERY = "SELECT ?x WHERE {?x a <%s>.} LIMIT 1";
    private static final String PROPERTY_QUERY = "SELECT * WHERE {?x <%s> ?y.} LIMIT 1";
    private static final Logger LOG = LoggerFactory.getLogger(OntopOWLEmptyEntitiesChecker.class);
    private final ClassifiedTBox onto;
    private final OWLConnection conn;

    public OntopOWLEmptyEntitiesChecker(ClassifiedTBox tbox, OWLConnection conn) {
        this.onto = tbox;
        this.conn = conn;
    }

    public Iterable<IRI> emptyClasses() {
        return () -> new FunctionIterator<OClass, IRI>(new FilterIterator<OClass>(this.onto.classes().iterator(), this::isEmpty), OClass::getIRI);
    }

    public Iterable<IRI> emptyProperties() {
        return () -> new ChainIterator(new FunctionIterator<ObjectPropertyExpression, IRI>(new FilterIterator<ObjectPropertyExpression>(this.onto.objectProperties().iterator(), this::isEmpty), ObjectPropertyExpression::getIRI), new FunctionIterator<DataPropertyExpression, IRI>(new FilterIterator<DataPropertyExpression>(this.onto.dataProperties().iterator(), this::isEmpty), DataPropertyExpression::getIRI));
    }

    private boolean isEmpty(OClass c) {
        return !c.isTop() && !c.isBottom() && !OntopOWLEmptyEntitiesChecker.isResultNonEmpty(String.format(CLASS_QUERY, c.getIRI().getIRIString()), this.conn);
    }

    private boolean isEmpty(ObjectPropertyExpression c) {
        return !c.isTop() && !c.isBottom() && !OntopOWLEmptyEntitiesChecker.isResultNonEmpty(String.format(PROPERTY_QUERY, c.getIRI().getIRIString()), this.conn);
    }

    private boolean isEmpty(DataPropertyExpression c) {
        return !c.isTop() && !c.isBottom() && !OntopOWLEmptyEntitiesChecker.isResultNonEmpty(String.format(PROPERTY_QUERY, c.getIRI().getIRIString()), this.conn);
    }

    /*
     * Exception decompiling
     */
    private static boolean isResultNonEmpty(String query, OWLConnection conn) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static class FilterIterator<E>
    implements Iterator<E> {
        private final Iterator<E> iterator;
        private final Predicate<E> filter;
        private E next;
        private boolean atNext;

        FilterIterator(Iterator<E> iterator, Predicate<E> filter) {
            this.iterator = iterator;
            this.filter = filter;
        }

        @Override
        public boolean hasNext() {
            if (!this.atNext) {
                this.atNext = this.moveToNext();
            }
            return this.atNext;
        }

        @Override
        public E next() {
            if (!this.atNext) {
                boolean bl = this.atNext = !this.moveToNext();
                if (!this.atNext) {
                    throw new NoSuchElementException();
                }
            }
            this.atNext = false;
            return this.next;
        }

        private boolean moveToNext() {
            while (this.iterator.hasNext()) {
                this.next = this.iterator.next();
                if (!this.filter.test(this.next)) continue;
                return true;
            }
            return false;
        }
    }

    private static class FunctionIterator<E, F>
    implements Iterator<F> {
        private final Iterator<E> iterator;
        private final Function<E, F> function;

        FunctionIterator(Iterator<E> iterator, Function<E, F> function) {
            this.iterator = iterator;
            this.function = function;
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public F next() {
            return this.function.apply(this.iterator.next());
        }
    }

    private static class ChainIterator<E>
    implements Iterator<E> {
        private final Iterator<E> first;
        private final Iterator<E> second;

        ChainIterator(Iterator<E> first, Iterator<E> second) {
            this.first = first;
            this.second = second;
        }

        @Override
        public boolean hasNext() {
            return this.first.hasNext() || this.second.hasNext();
        }

        @Override
        public E next() {
            return this.first.hasNext() ? this.first.next() : this.second.next();
        }
    }
}

