/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.owlapi.resultset.impl;

import it.unibz.inf.ontop.answering.resultset.OntopBinding;
import it.unibz.inf.ontop.answering.resultset.OntopBindingSet;
import it.unibz.inf.ontop.com.google.common.collect.Iterators;
import it.unibz.inf.ontop.model.term.Constant;
import it.unibz.inf.ontop.model.term.ObjectConstant;
import it.unibz.inf.ontop.model.term.RDFLiteralConstant;
import it.unibz.inf.ontop.owlapi.exception.OntopOWLException;
import it.unibz.inf.ontop.owlapi.resultset.OWLBinding;
import it.unibz.inf.ontop.owlapi.resultset.OWLBindingSet;
import it.unibz.inf.ontop.owlapi.resultset.impl.OWLAPIIndividualTranslator;
import it.unibz.inf.ontop.owlapi.resultset.impl.OntopOWLBinding;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.semanticweb.owlapi.model.OWLAnonymousIndividual;
import org.semanticweb.owlapi.model.OWLException;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLPropertyAssertionObject;

public class OntopOWLBindingSet
implements OWLBindingSet {
    private final OntopBindingSet ontopBindingSet;
    private final OWLAPIIndividualTranslator translator;
    private final byte[] salt;

    public OntopOWLBindingSet(OntopBindingSet ontopBindingSet, byte[] salt) {
        this.ontopBindingSet = ontopBindingSet;
        this.salt = salt;
        this.translator = new OWLAPIIndividualTranslator();
    }

    @Override
    @Nonnull
    public Iterator<OWLBinding> iterator() {
        return Iterators.transform((Iterator)this.ontopBindingSet.iterator(), ontopBinding -> new OntopOWLBinding((OntopBinding)ontopBinding, this.translator, this.salt));
    }

    @Override
    public Set<String> getBindingNames() {
        return Arrays.stream(this.ontopBindingSet.getBindingNames()).collect(Collectors.toSet());
    }

    @Override
    public OWLBinding getBinding(String bindingName) {
        OntopBinding ontopBinding = this.ontopBindingSet.getBinding(bindingName);
        if (ontopBinding != null) {
            return new OntopOWLBinding(ontopBinding, this.translator, this.salt);
        }
        return null;
    }

    @Override
    public OWLPropertyAssertionObject getOWLPropertyAssertionObject(String bindingName) throws OWLException {
        try {
            return this.translate((Constant)this.ontopBindingSet.getConstant(bindingName));
        }
        catch (Exception e) {
            throw new OntopOWLException(e + " Column: " + bindingName);
        }
    }

    @Override
    public OWLIndividual getOWLIndividual(String bindingName) throws OWLException {
        try {
            return (OWLIndividual)this.translate((Constant)this.ontopBindingSet.getConstant(bindingName));
        }
        catch (Exception e) {
            throw new OntopOWLException(e);
        }
    }

    @Override
    public OWLNamedIndividual getOWLNamedIndividual(String bindingName) throws OWLException {
        try {
            return (OWLNamedIndividual)this.translate((Constant)this.ontopBindingSet.getConstant(bindingName));
        }
        catch (Exception e) {
            throw new OntopOWLException(e);
        }
    }

    @Override
    public OWLAnonymousIndividual getOWLAnonymousIndividual(String bindingName) throws OWLException {
        try {
            return (OWLAnonymousIndividual)this.translate((Constant)this.ontopBindingSet.getConstant(bindingName));
        }
        catch (Exception e) {
            throw new OntopOWLException(e);
        }
    }

    @Override
    public OWLLiteral getOWLLiteral(String bindingName) throws OWLException {
        try {
            return (OWLLiteral)this.translate((Constant)this.ontopBindingSet.getConstant(bindingName));
        }
        catch (Exception e) {
            throw new OntopOWLException(e);
        }
    }

    @Override
    public OWLObject getOWLObject(String column) throws OWLException {
        try {
            return this.translate((Constant)this.ontopBindingSet.getConstant(column));
        }
        catch (Exception e) {
            throw new OntopOWLException(e);
        }
    }

    public String toString() {
        return this.ontopBindingSet.toString();
    }

    private OWLPropertyAssertionObject translate(Constant c) {
        if (c instanceof ObjectConstant) {
            return this.translator.translate((ObjectConstant)c, this.salt);
        }
        return this.translator.translate((RDFLiteralConstant)c);
    }
}

