/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.owlapi.resultset.impl;

import it.unibz.inf.ontop.exception.MinorOntopInternalBugException;
import it.unibz.inf.ontop.model.term.BNode;
import it.unibz.inf.ontop.model.term.IRIConstant;
import it.unibz.inf.ontop.model.term.ObjectConstant;
import it.unibz.inf.ontop.model.term.RDFConstant;
import it.unibz.inf.ontop.model.term.RDFLiteralConstant;
import it.unibz.inf.ontop.model.type.LanguageTag;
import it.unibz.inf.ontop.model.type.RDFDatatype;
import it.unibz.inf.ontop.spec.ontology.RDFFact;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import uk.ac.manchester.cs.owl.owlapi.OWLDataFactoryImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLDatatypeImpl;

public class OWLAPIIndividualTranslator {
    private final OWLDataFactory dataFactory = new OWLDataFactoryImpl();

    public OWLAxiom translate(RDFFact assertion, byte[] salt) {
        IRIConstant factProperty = assertion.getProperty();
        ObjectConstant classOrProperty = assertion.getClassOrProperty();
        OWLIndividual subject = this.translate(assertion.getSubject(), salt);
        if (assertion.getGraph().isPresent()) {
            throw new MinorOntopInternalBugException("Quads are not supported by OWLAPI so that method should not used with them");
        }
        if (factProperty.equals(classOrProperty) || !(classOrProperty instanceof IRIConstant)) {
            RDFConstant assertionObject = assertion.getObject();
            if (assertionObject instanceof ObjectConstant) {
                OWLObjectProperty property = this.dataFactory.getOWLObjectProperty(IRI.create((String)factProperty.getIRI().getIRIString()));
                OWLIndividual object = this.translate((ObjectConstant)assertionObject, salt);
                return this.dataFactory.getOWLObjectPropertyAssertionAxiom((OWLObjectPropertyExpression)property, subject, object);
            }
            OWLDataProperty property = this.dataFactory.getOWLDataProperty(IRI.create((String)factProperty.getIRI().getIRIString()));
            OWLLiteral literal = this.translate((RDFLiteralConstant)assertionObject);
            return this.dataFactory.getOWLDataPropertyAssertionAxiom((OWLDataPropertyExpression)property, subject, literal);
        }
        IRI classIRI = IRI.create((String)((IRIConstant)classOrProperty).getIRI().getIRIString());
        OWLClass description = this.dataFactory.getOWLClass(classIRI);
        return this.dataFactory.getOWLClassAssertionAxiom((OWLClassExpression)description, subject);
    }

    public OWLIndividual translate(ObjectConstant constant, byte[] salt) {
        if (constant instanceof IRIConstant) {
            return this.dataFactory.getOWLNamedIndividual(IRI.create((String)((IRIConstant)constant).getIRI().getIRIString()));
        }
        return this.dataFactory.getOWLAnonymousIndividual(((BNode)constant).getAnonymizedLabel(salt));
    }

    public OWLLiteral translate(RDFLiteralConstant v) {
        if (v == null) {
            return null;
        }
        String value = v.getValue();
        if (value == null) {
            return null;
        }
        RDFDatatype type = v.getType();
        if (type.getLanguageTag().isPresent()) {
            return this.dataFactory.getOWLLiteral(value, ((LanguageTag)type.getLanguageTag().get()).getFullString());
        }
        OWLDatatypeImpl owlDatatype = new OWLDatatypeImpl(IRI.create((String)type.getIRI().getIRIString()));
        return this.dataFactory.getOWLLiteral(value, (OWLDatatype)owlDatatype);
    }
}

