/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.owlapi.impl;

import it.unibz.inf.ontop.com.google.common.base.Preconditions;
import it.unibz.inf.ontop.injection.OntopSystemOWLAPIConfiguration;
import it.unibz.inf.ontop.owlapi.OntopOWLFactory;
import it.unibz.inf.ontop.owlapi.OntopOWLReasoner;
import it.unibz.inf.ontop.owlapi.impl.QuestOWL;
import it.unibz.inf.ontop.owlapi.impl.QuestOWLConfiguration;
import javax.annotation.Nonnull;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyCreationException;
import org.semanticweb.owlapi.reasoner.IllegalConfigurationException;
import org.semanticweb.owlapi.reasoner.OWLReasoner;
import org.semanticweb.owlapi.reasoner.OWLReasonerConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QuestOWLFactory
implements OntopOWLFactory {
    private final Logger log = LoggerFactory.getLogger(QuestOWLFactory.class);

    @Nonnull
    public String getReasonerName() {
        return "Ontop/Quest";
    }

    @Nonnull
    public OntopOWLReasoner createNonBufferingReasoner(@Nonnull OWLOntology ontology) {
        throw new UnsupportedOperationException("Quest is a buffering reasoner");
    }

    public OWLReasoner createReasoner(@Nonnull OWLOntology ontology) {
        throw new UnsupportedOperationException("A configuration is required");
    }

    @Nonnull
    public OntopOWLReasoner createNonBufferingReasoner(@Nonnull OWLOntology ontology, @Nonnull OWLReasonerConfiguration config) throws IllegalConfigurationException {
        throw new UnsupportedOperationException("Quest is a buffering reasoner");
    }

    @Override
    @Nonnull
    public OntopOWLReasoner createReasoner(@Nonnull OWLOntology ontology, @Nonnull OWLReasonerConfiguration config) throws IllegalConfigurationException {
        Preconditions.checkArgument((boolean)(config instanceof QuestOWLConfiguration), (String)"config %s is not an instance of QuestOWLConfiguration", (Object)config);
        return new QuestOWL(ontology, (QuestOWLConfiguration)config);
    }

    @Override
    @Nonnull
    public OntopOWLReasoner createReasoner(@Nonnull OntopSystemOWLAPIConfiguration config) throws IllegalConfigurationException, OWLOntologyCreationException {
        QuestOWLConfiguration owlConfiguration = new QuestOWLConfiguration(config);
        OWLOntology ontology = (OWLOntology)config.loadInputOntology().orElseThrow(() -> new IllegalConfigurationException("QuestOWL requires an ontology", (OWLReasonerConfiguration)owlConfiguration));
        return this.createReasoner(ontology, (OWLReasonerConfiguration)owlConfiguration);
    }
}

