/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.owlapi.resultset.impl;

import it.unibz.inf.ontop.answering.resultset.GraphResultSet;
import it.unibz.inf.ontop.exception.OntopConnectionException;
import it.unibz.inf.ontop.exception.OntopInternalBugException;
import it.unibz.inf.ontop.exception.OntopQueryAnsweringException;
import it.unibz.inf.ontop.owlapi.exception.OntopOWLException;
import it.unibz.inf.ontop.owlapi.resultset.GraphOWLResultSet;
import it.unibz.inf.ontop.owlapi.resultset.impl.OWLAPIIndividualTranslator;
import it.unibz.inf.ontop.spec.ontology.AnnotationAssertion;
import it.unibz.inf.ontop.spec.ontology.Assertion;
import it.unibz.inf.ontop.spec.ontology.ClassAssertion;
import it.unibz.inf.ontop.spec.ontology.DataPropertyAssertion;
import it.unibz.inf.ontop.spec.ontology.ObjectPropertyAssertion;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLException;

public class OntopGraphOWLResultSet
implements GraphOWLResultSet {
    private final GraphResultSet graphResultSet;
    private final OWLAPIIndividualTranslator translator;

    public OntopGraphOWLResultSet(GraphResultSet graphResultSet) {
        this.graphResultSet = graphResultSet;
        this.translator = new OWLAPIIndividualTranslator();
    }

    @Override
    public boolean hasNext() throws OWLException {
        try {
            return this.graphResultSet.hasNext();
        }
        catch (OntopConnectionException | OntopQueryAnsweringException e) {
            throw new OntopOWLException(e);
        }
    }

    @Override
    public OWLAxiom next() throws OWLException {
        try {
            return this.convertAssertion(this.graphResultSet.next());
        }
        catch (OntopQueryAnsweringException e) {
            throw new OntopOWLException(e);
        }
    }

    @Override
    public void close() throws OWLException {
        try {
            this.graphResultSet.close();
        }
        catch (OntopConnectionException e) {
            throw new OntopOWLException(e);
        }
    }

    OWLAxiom convertAssertion(Assertion assertion) {
        if (assertion instanceof ClassAssertion) {
            return this.translator.translate((ClassAssertion)assertion);
        }
        if (assertion instanceof ObjectPropertyAssertion) {
            return this.translator.translate((ObjectPropertyAssertion)assertion);
        }
        if (assertion instanceof DataPropertyAssertion) {
            return this.translator.translate((DataPropertyAssertion)assertion);
        }
        if (assertion instanceof AnnotationAssertion) {
            return this.translator.translate((AnnotationAssertion)assertion);
        }
        throw new UnsupportedAssertionException(assertion);
    }

    private static class UnsupportedAssertionException
    extends OntopInternalBugException {
        UnsupportedAssertionException(Assertion assertion) {
            super("Unsupported assertion (cannot be converted to OWLAPI): " + assertion);
        }
    }
}

