/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.owlapi.resultset.impl;

import it.unibz.inf.ontop.exception.OntopInternalBugException;
import it.unibz.inf.ontop.model.term.BNode;
import it.unibz.inf.ontop.model.term.Constant;
import it.unibz.inf.ontop.model.term.IRIConstant;
import it.unibz.inf.ontop.model.term.ObjectConstant;
import it.unibz.inf.ontop.model.term.RDFLiteralConstant;
import it.unibz.inf.ontop.model.type.LanguageTag;
import it.unibz.inf.ontop.model.type.RDFDatatype;
import it.unibz.inf.ontop.spec.ontology.AnnotationAssertion;
import it.unibz.inf.ontop.spec.ontology.ClassAssertion;
import it.unibz.inf.ontop.spec.ontology.DataPropertyAssertion;
import it.unibz.inf.ontop.spec.ontology.ObjectPropertyAssertion;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotationAssertionAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAnnotationSubject;
import org.semanticweb.owlapi.model.OWLAnnotationValue;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLIndividualAxiom;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import uk.ac.manchester.cs.owl.owlapi.OWLDataFactoryImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLDatatypeImpl;

public class OWLAPIIndividualTranslator {
    private final OWLDataFactory dataFactory = new OWLDataFactoryImpl();

    public OWLIndividualAxiom translate(ClassAssertion ca) {
        IRI conceptIRI = IRI.create((String)ca.getConcept().getIRI().getIRIString());
        OWLClass description = this.dataFactory.getOWLClass(conceptIRI);
        OWLIndividual object = this.translate(ca.getIndividual());
        return this.dataFactory.getOWLClassAssertionAxiom((OWLClassExpression)description, object);
    }

    public OWLIndividualAxiom translate(ObjectPropertyAssertion opa) {
        IRI roleIRI = IRI.create((String)opa.getProperty().getIRI().getIRIString());
        OWLObjectProperty property = this.dataFactory.getOWLObjectProperty(roleIRI);
        OWLIndividual subject = this.translate(opa.getSubject());
        OWLIndividual object = this.translate(opa.getObject());
        return this.dataFactory.getOWLObjectPropertyAssertionAxiom((OWLObjectPropertyExpression)property, subject, object);
    }

    public OWLIndividualAxiom translate(DataPropertyAssertion opa) {
        IRI roleIRI = IRI.create((String)opa.getProperty().getIRI().getIRIString());
        OWLDataProperty property = this.dataFactory.getOWLDataProperty(roleIRI);
        OWLIndividual subject = this.translate(opa.getSubject());
        OWLLiteral object = this.translate(opa.getValue());
        return this.dataFactory.getOWLDataPropertyAssertionAxiom((OWLDataPropertyExpression)property, subject, object);
    }

    public OWLAnnotationAssertionAxiom translate(AnnotationAssertion opa) {
        IRI roleIRI = IRI.create((String)opa.getProperty().getIRI().getIRIString());
        OWLAnnotationProperty property = this.dataFactory.getOWLAnnotationProperty(roleIRI);
        OWLAnnotationSubject subject = this.translateAnnotationSubject(opa.getSubject());
        OWLAnnotationValue object = this.translateAnnotationValue(opa.getValue());
        return this.dataFactory.getOWLAnnotationAssertionAxiom(property, subject, object);
    }

    public OWLIndividual translate(ObjectConstant constant) {
        if (constant instanceof IRIConstant) {
            return this.dataFactory.getOWLNamedIndividual(IRI.create((String)((IRIConstant)constant).getIRI().getIRIString()));
        }
        return this.dataFactory.getOWLAnonymousIndividual(((BNode)constant).getName());
    }

    public OWLLiteral translate(RDFLiteralConstant v) {
        if (v == null) {
            return null;
        }
        String value = v.getValue();
        if (value == null) {
            return null;
        }
        RDFDatatype type = v.getType();
        if (!(type instanceof RDFDatatype)) {
            throw new IllegalStateException("A ValueConstant given to OWLAPI must have a RDF datatype");
        }
        RDFDatatype datatype = type;
        if (datatype.getLanguageTag().isPresent()) {
            return this.dataFactory.getOWLLiteral(value, ((LanguageTag)datatype.getLanguageTag().get()).getFullString());
        }
        OWLDatatypeImpl owlDatatype = new OWLDatatypeImpl(IRI.create((String)datatype.getIRI().getIRIString()));
        if (owlDatatype != null) {
            return this.dataFactory.getOWLLiteral(value, (OWLDatatype)owlDatatype);
        }
        throw new IllegalArgumentException(datatype.toString());
    }

    public OWLAnnotationSubject translateAnnotationSubject(ObjectConstant subject) {
        if (subject instanceof IRIConstant) {
            return IRI.create((String)((IRIConstant)subject).getIRI().getIRIString());
        }
        if (subject instanceof BNode) {
            return this.dataFactory.getOWLAnonymousIndividual(((BNode)subject).getName());
        }
        throw new UnexceptedAssertionTermException((Constant)subject);
    }

    public OWLAnnotationValue translateAnnotationValue(Constant constant) {
        if (constant instanceof RDFLiteralConstant) {
            return this.translate((RDFLiteralConstant)constant);
        }
        if (constant instanceof IRIConstant) {
            return IRI.create((String)((IRIConstant)constant).getIRI().getIRIString());
        }
        if (constant instanceof BNode) {
            return this.dataFactory.getOWLAnonymousIndividual(((BNode)constant).getName());
        }
        throw new UnexceptedAssertionTermException(constant);
    }

    private static class UnexceptedAssertionTermException
    extends OntopInternalBugException {
        UnexceptedAssertionTermException(Constant term) {
            super("Unexpected term in an assertion (cannot be converted to OWLAPI): " + term);
        }
    }
}

