/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.owlapi.validation;

import it.unibz.inf.ontop.owlapi.connection.OWLConnection;
import it.unibz.inf.ontop.spec.ontology.ClassifiedTBox;
import it.unibz.inf.ontop.spec.ontology.DataPropertyExpression;
import it.unibz.inf.ontop.spec.ontology.OClass;
import it.unibz.inf.ontop.spec.ontology.ObjectPropertyExpression;
import java.util.Iterator;
import org.apache.commons.rdf.api.IRI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QuestOWLEmptyEntitiesChecker {
    private final ClassifiedTBox onto;
    private final OWLConnection conn;
    private int nEmptyConcepts = 0;
    private int nEmptyRoles = 0;

    public QuestOWLEmptyEntitiesChecker(ClassifiedTBox tbox, OWLConnection conn) {
        this.onto = tbox;
        this.conn = conn;
    }

    public Iterator<IRI> iEmptyConcepts() {
        return new EmptyEntitiesIterator(this.onto.classes().iterator(), this.conn);
    }

    public Iterator<IRI> iEmptyRoles() {
        return new EmptyEntitiesIterator(this.onto.objectProperties().iterator(), this.onto.dataProperties().iterator(), this.conn);
    }

    public int getEConceptsSize() {
        return this.nEmptyConcepts;
    }

    public int getERolesSize() {
        return this.nEmptyRoles;
    }

    public String toString() {
        String str = new String();
        str = str + String.format("- %s Empty %s ", this.nEmptyConcepts, this.nEmptyConcepts == 1 ? "concept" : "concepts");
        str = str + String.format("- %s Empty %s\n", this.nEmptyRoles, this.nEmptyRoles == 1 ? "role" : "roles");
        return str;
    }

    private class EmptyEntitiesIterator
    implements Iterator<IRI> {
        private static final String queryConcepts = "SELECT ?x WHERE {?x a <%s>.} LIMIT 1";
        private static final String queryRoles = "SELECT * WHERE {?x <%s> ?y.} LIMIT 1";
        private final OWLConnection questConn;
        private boolean hasNext = false;
        private IRI nextConcept;
        private final Iterator<OClass> classIterator;
        private final Iterator<ObjectPropertyExpression> objectRoleIterator;
        private final Iterator<DataPropertyExpression> dataRoleIterator;
        private Logger log = LoggerFactory.getLogger(EmptyEntitiesIterator.class);

        public EmptyEntitiesIterator(Iterator<OClass> classIterator, OWLConnection questConn) {
            this.questConn = questConn;
            this.classIterator = classIterator;
            this.objectRoleIterator = new Iterator<ObjectPropertyExpression>(){

                @Override
                public boolean hasNext() {
                    return false;
                }

                @Override
                public ObjectPropertyExpression next() {
                    return null;
                }
            };
            this.dataRoleIterator = new Iterator<DataPropertyExpression>(){

                @Override
                public boolean hasNext() {
                    return false;
                }

                @Override
                public DataPropertyExpression next() {
                    return null;
                }
            };
        }

        public EmptyEntitiesIterator(Iterator<ObjectPropertyExpression> objectRoleIterator, Iterator<DataPropertyExpression> dataRoleIterator, OWLConnection questConn) {
            this.questConn = questConn;
            this.classIterator = new Iterator<OClass>(){

                @Override
                public boolean hasNext() {
                    return false;
                }

                @Override
                public OClass next() {
                    return null;
                }
            };
            this.objectRoleIterator = objectRoleIterator;
            this.dataRoleIterator = dataRoleIterator;
        }

        private String getPredicateQuery(IRI p) {
            return String.format(queryRoles, p.getIRIString());
        }

        private String getClassQuery(IRI p) {
            return String.format(queryConcepts, p.getIRIString());
        }

        private String getQuery(int arity, IRI iri) {
            switch (arity) {
                case 1: {
                    return this.getClassQuery(iri);
                }
                case 2: {
                    return this.getPredicateQuery(iri);
                }
            }
            return "";
        }

        @Override
        public boolean hasNext() {
            OClass next;
            while (this.classIterator.hasNext()) {
                next = this.classIterator.next();
                if (next.isTop() || next.isBottom() || !this.nextEmptyEntity(next.getIRI(), 1)) continue;
                QuestOWLEmptyEntitiesChecker.this.nEmptyConcepts++;
                return this.hasNext;
            }
            this.log.debug("No more empty concepts");
            while (this.objectRoleIterator.hasNext()) {
                next = this.objectRoleIterator.next();
                if (next.isTop() || next.isBottom() || !this.nextEmptyEntity(next.getIRI(), 2)) continue;
                QuestOWLEmptyEntitiesChecker.this.nEmptyRoles++;
                return this.hasNext;
            }
            this.log.debug("No more empty object roles");
            while (this.dataRoleIterator.hasNext()) {
                next = this.dataRoleIterator.next();
                if (next.isTop() || next.isBottom() || !this.nextEmptyEntity(next.getIRI(), 2)) continue;
                QuestOWLEmptyEntitiesChecker.this.nEmptyRoles++;
                return this.hasNext;
            }
            this.log.debug("No more empty data roles");
            this.hasNext = false;
            return this.hasNext;
        }

        /*
         * Exception decompiling
         */
        private boolean nextEmptyEntity(IRI entity, int arity) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        @Override
        public IRI next() {
            if (this.hasNext) {
                return this.nextConcept;
            }
            return null;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

