/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.owlapi.impl;

import com.google.common.collect.ImmutableList;
import it.unibz.inf.ontop.answering.OntopQueryEngine;
import it.unibz.inf.ontop.answering.connection.OntopConnection;
import it.unibz.inf.ontop.answering.reformulation.input.InputQueryFactory;
import it.unibz.inf.ontop.exception.InvalidOntopConfigurationException;
import it.unibz.inf.ontop.exception.OBDASpecificationException;
import it.unibz.inf.ontop.exception.OntopConnectionException;
import it.unibz.inf.ontop.injection.OntopSystemOWLAPIConfiguration;
import it.unibz.inf.ontop.owlapi.OntopOWLReasoner;
import it.unibz.inf.ontop.owlapi.connection.OntopOWLConnection;
import it.unibz.inf.ontop.owlapi.connection.impl.DefaultOntopOWLConnection;
import it.unibz.inf.ontop.owlapi.impl.QuestOWLConfiguration;
import it.unibz.inf.ontop.spec.ontology.ClassExpression;
import it.unibz.inf.ontop.spec.ontology.ClassifiedTBox;
import it.unibz.inf.ontop.spec.ontology.DataPropertyExpression;
import it.unibz.inf.ontop.spec.ontology.NaryAxiom;
import it.unibz.inf.ontop.spec.ontology.ObjectPropertyExpression;
import it.unibz.inf.ontop.spec.ontology.Ontology;
import it.unibz.inf.ontop.spec.ontology.owlapi.OWLAPITranslatorOWL2QL;
import it.unibz.inf.ontop.utils.VersionInfo;
import java.util.Iterator;
import java.util.Set;
import javax.annotation.Nonnull;
import org.semanticweb.owlapi.model.AxiomType;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLException;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.reasoner.AxiomNotInProfileException;
import org.semanticweb.owlapi.reasoner.BufferingMode;
import org.semanticweb.owlapi.reasoner.ClassExpressionNotInProfileException;
import org.semanticweb.owlapi.reasoner.FreshEntitiesException;
import org.semanticweb.owlapi.reasoner.FreshEntityPolicy;
import org.semanticweb.owlapi.reasoner.IllegalConfigurationException;
import org.semanticweb.owlapi.reasoner.InconsistentOntologyException;
import org.semanticweb.owlapi.reasoner.IndividualNodeSetPolicy;
import org.semanticweb.owlapi.reasoner.InferenceType;
import org.semanticweb.owlapi.reasoner.Node;
import org.semanticweb.owlapi.reasoner.NodeSet;
import org.semanticweb.owlapi.reasoner.OWLReasonerConfiguration;
import org.semanticweb.owlapi.reasoner.ReasonerInternalException;
import org.semanticweb.owlapi.reasoner.ReasonerInterruptedException;
import org.semanticweb.owlapi.reasoner.ReasonerProgressMonitor;
import org.semanticweb.owlapi.reasoner.TimeOutException;
import org.semanticweb.owlapi.reasoner.UnsupportedEntailmentTypeException;
import org.semanticweb.owlapi.reasoner.impl.OWLReasonerBase;
import org.semanticweb.owlapi.reasoner.structural.StructuralReasoner;
import org.semanticweb.owlapi.util.Version;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QuestOWL
extends OWLReasonerBase
implements OntopOWLReasoner {
    StructuralReasoner structuralReasoner;
    private final Version version;
    private final ReasonerProgressMonitor pm;
    private boolean prepared = false;
    private boolean isOntopConnectionInitialized = false;
    private boolean questready = false;
    private Object inconsistent = null;
    private Exception questException = null;
    private ClassifiedTBox translatedOntologyMerge;
    private static Logger log = LoggerFactory.getLogger(QuestOWL.class);
    private final OntopQueryEngine queryEngine;
    private final InputQueryFactory inputQueryFactory;
    private final OWLAPITranslatorOWL2QL owlapiTranslator;

    protected QuestOWL(OWLOntology rootOntology, QuestOWLConfiguration owlConfiguration) throws IllegalConfigurationException {
        super(rootOntology, (OWLReasonerConfiguration)owlConfiguration, BufferingMode.BUFFERING);
        OntopSystemOWLAPIConfiguration ontopConfiguration = owlConfiguration.getOntopConfiguration();
        try {
            ontopConfiguration.validate();
        }
        catch (InvalidOntopConfigurationException e) {
            throw new IllegalConfigurationException(e.getMessage(), (OWLReasonerConfiguration)owlConfiguration);
        }
        this.structuralReasoner = new StructuralReasoner(rootOntology, (OWLReasonerConfiguration)owlConfiguration, BufferingMode.BUFFERING);
        try {
            this.queryEngine = ontopConfiguration.loadQueryEngine();
        }
        catch (OBDASpecificationException e) {
            throw new IllegalConfigurationException((Throwable)e, (OWLReasonerConfiguration)owlConfiguration);
        }
        this.inputQueryFactory = ontopConfiguration.getInputQueryFactory();
        this.pm = owlConfiguration.getProgressMonitor();
        this.version = QuestOWL.extractVersion();
        this.owlapiTranslator = (OWLAPITranslatorOWL2QL)ontopConfiguration.getInjector().getInstance(OWLAPITranslatorOWL2QL.class);
        this.prepareReasoner();
    }

    private static Version extractVersion() {
        VersionInfo versionInfo = VersionInfo.getVersionInfo();
        String versionString = versionInfo.getVersion();
        String[] splits = versionString.split("\\.");
        int major = 0;
        int minor = 0;
        int patch = 0;
        int build = 0;
        try {
            major = Integer.parseInt(splits[0]);
            minor = Integer.parseInt(splits[1]);
            patch = Integer.parseInt(splits[2]);
            build = Integer.parseInt(splits[3]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new Version(major, minor, patch, build);
    }

    public void flush() {
        this.prepared = false;
        super.flush();
        this.prepareReasoner();
    }

    private void prepareConnector() throws OntopConnectionException {
        if (!this.isOntopConnectionInitialized) {
            log.info("Initializing a new Ontop instance...");
            this.queryEngine.connect();
            this.isOntopConnectionInitialized = true;
        }
        this.questready = true;
    }

    public void dispose() {
        super.dispose();
        try {
            this.queryEngine.close();
        }
        catch (Exception e) {
            log.debug(e.getMessage());
        }
    }

    private ClassifiedTBox loadOntologies(OWLOntology ontology) {
        log.debug("Load ontologies called. Translating ontologies.");
        Ontology mergeOntology = this.owlapiTranslator.translateAndClassify(ontology);
        return mergeOntology.tbox();
    }

    @Override
    public OntopOWLConnection getConnection() throws ReasonerInternalException {
        if (!this.questready) {
            ReasonerInternalException owlReasonerRuntimeException = new ReasonerInternalException("Ontop was not initialized properly. This is generally indicates, connection problems or error during ontology or mapping pre-processing. \n\nOriginal error message:\n" + this.questException.getMessage());
            owlReasonerRuntimeException.setStackTrace(this.questException.getStackTrace());
            throw owlReasonerRuntimeException;
        }
        try {
            OntopConnection conn = this.queryEngine.getConnection();
            return new DefaultOntopOWLConnection(conn, this.inputQueryFactory);
        }
        catch (OntopConnectionException e) {
            throw new ReasonerInternalException((Throwable)e);
        }
    }

    @Nonnull
    public String getReasonerName() {
        return "Quest";
    }

    @Nonnull
    public FreshEntityPolicy getFreshEntityPolicy() {
        return this.structuralReasoner.getFreshEntityPolicy();
    }

    @Nonnull
    public IndividualNodeSetPolicy getIndividualNodeSetPolicy() {
        return this.structuralReasoner.getIndividualNodeSetPolicy();
    }

    @Nonnull
    public Version getReasonerVersion() {
        return this.version;
    }

    protected void handleChanges(@Nonnull Set<OWLAxiom> addAxioms, @Nonnull Set<OWLAxiom> removeAxioms) {
        this.prepared = false;
        this.prepareReasoner();
    }

    public void interrupt() {
    }

    private void ensurePrepared() {
        if (!this.prepared) {
            this.prepareReasoner();
        }
    }

    private void prepareReasoner() throws ReasonerInterruptedException, TimeOutException {
        this.pm.reasonerTaskStarted("Classifying...");
        this.pm.reasonerTaskBusy();
        this.structuralReasoner.prepareReasoner();
        try {
            this.translatedOntologyMerge = this.loadOntologies(this.getRootOntology());
            this.questready = false;
            this.questException = null;
            try {
                this.prepareConnector();
                this.questready = true;
                this.questException = null;
            }
            catch (Exception e) {
                this.questready = false;
                this.questException = e;
                log.error("Could not initialize the Quest query answering engine. Answering queries will not be available.");
                log.error(e.getMessage(), (Throwable)e);
                throw e;
            }
        }
        catch (Exception e) {
            throw new ReasonerInternalException((Throwable)e);
        }
        finally {
            this.prepared = true;
            this.pm.reasonerTaskStopped();
        }
    }

    public void precomputeInferences(InferenceType ... inferenceTypes) throws ReasonerInterruptedException, TimeOutException, InconsistentOntologyException {
        this.ensurePrepared();
    }

    public boolean isPrecomputed(@Nonnull InferenceType inferenceType) {
        return this.prepared;
    }

    @Nonnull
    public Set<InferenceType> getPrecomputableInferenceTypes() {
        return this.structuralReasoner.getPrecomputableInferenceTypes();
    }

    public boolean isConsistent() throws ReasonerInterruptedException, TimeOutException {
        try {
            return this.isDisjointAxiomsConsistent() && this.isFunctionalPropertyAxiomsConsistent();
        }
        catch (OWLException e) {
            throw new ReasonerInterruptedException((Throwable)e);
        }
    }

    @Override
    public Object getInconsistentAxiom() {
        return this.inconsistent;
    }

    private boolean isDisjointAxiomsConsistent() throws ReasonerInterruptedException, TimeOutException, OWLException {
        ObjectPropertyExpression p2;
        ObjectPropertyExpression p1;
        Iterator iterator;
        ImmutableList props;
        boolean isConsistent;
        String strQuery;
        String strQueryClass = "ASK {?x a <%s>; a <%s> }";
        for (NaryAxiom dda : this.translatedOntologyMerge.disjointClasses()) {
            ImmutableList disj = dda.getComponents();
            Iterator classIterator = disj.iterator();
            ClassExpression s1 = (ClassExpression)classIterator.next();
            ClassExpression s2 = (ClassExpression)classIterator.next();
            strQuery = String.format("ASK {?x a <%s>; a <%s> }", s1, s2);
            isConsistent = this.executeConsistencyQuery(strQuery);
            if (isConsistent) continue;
            this.inconsistent = dda;
            return false;
        }
        String strQueryProp = "ASK {?x <%s> ?y; <%s> ?y }";
        for (NaryAxiom dda : this.translatedOntologyMerge.disjointObjectProperties()) {
            props = dda.getComponents();
            iterator = props.iterator();
            p1 = (ObjectPropertyExpression)iterator.next();
            p2 = (ObjectPropertyExpression)iterator.next();
            strQuery = String.format("ASK {?x <%s> ?y; <%s> ?y }", p1, p2);
            isConsistent = this.executeConsistencyQuery(strQuery);
            if (isConsistent) continue;
            this.inconsistent = dda;
            return false;
        }
        strQueryProp = "ASK {?x <%s> ?y; <%s> ?y }";
        for (NaryAxiom dda : this.translatedOntologyMerge.disjointDataProperties()) {
            props = dda.getComponents();
            iterator = props.iterator();
            p1 = (DataPropertyExpression)iterator.next();
            p2 = (DataPropertyExpression)iterator.next();
            strQuery = String.format("ASK {?x <%s> ?y; <%s> ?y }", p1, p2);
            isConsistent = this.executeConsistencyQuery(strQuery);
            if (isConsistent) continue;
            this.inconsistent = dda;
            return false;
        }
        return true;
    }

    private boolean isFunctionalPropertyAxiomsConsistent() throws ReasonerInterruptedException, TimeOutException, OWLException {
        boolean isConsistent;
        String strQuery;
        String propFunc;
        String strQueryFunc = "ASK { ?x <%s> ?y; <%s> ?z. FILTER (?z != ?y) }";
        for (ObjectPropertyExpression pfa : this.translatedOntologyMerge.functionalObjectProperties()) {
            propFunc = pfa.getIRI().getIRIString();
            strQuery = String.format("ASK { ?x <%s> ?y; <%s> ?z. FILTER (?z != ?y) }", propFunc, propFunc);
            isConsistent = this.executeConsistencyQuery(strQuery);
            if (isConsistent) continue;
            this.inconsistent = pfa;
            return false;
        }
        for (ObjectPropertyExpression pfa : this.translatedOntologyMerge.functionalDataProperties()) {
            propFunc = pfa.getIRI().getIRIString();
            strQuery = String.format("ASK { ?x <%s> ?y; <%s> ?z. FILTER (?z != ?y) }", propFunc, propFunc);
            isConsistent = this.executeConsistencyQuery(strQuery);
            if (isConsistent) continue;
            this.inconsistent = pfa;
            return false;
        }
        return true;
    }

    /*
     * Exception decompiling
     */
    private boolean executeConsistencyQuery(String strQuery) throws OWLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public boolean isSatisfiable(@Nonnull OWLClassExpression classExpression) throws ReasonerInterruptedException, TimeOutException, ClassExpressionNotInProfileException, FreshEntitiesException, InconsistentOntologyException {
        return this.structuralReasoner.isSatisfiable(classExpression);
    }

    @Nonnull
    public Node<OWLClass> getUnsatisfiableClasses() throws ReasonerInterruptedException, TimeOutException {
        return this.structuralReasoner.getUnsatisfiableClasses();
    }

    public boolean isEntailed(@Nonnull OWLAxiom axiom) throws ReasonerInterruptedException, UnsupportedEntailmentTypeException, TimeOutException, AxiomNotInProfileException, FreshEntitiesException, InconsistentOntologyException {
        return this.structuralReasoner.isEntailed(axiom);
    }

    public boolean isEntailed(@Nonnull Set<? extends OWLAxiom> axioms) throws ReasonerInterruptedException, UnsupportedEntailmentTypeException, TimeOutException, AxiomNotInProfileException, FreshEntitiesException, InconsistentOntologyException {
        return this.structuralReasoner.isEntailed(axioms);
    }

    public boolean isEntailmentCheckingSupported(@Nonnull AxiomType<?> axiomType) {
        return this.structuralReasoner.isEntailmentCheckingSupported(axiomType);
    }

    @Nonnull
    public Node<OWLClass> getTopClassNode() {
        return this.structuralReasoner.getTopClassNode();
    }

    @Nonnull
    public Node<OWLClass> getBottomClassNode() {
        return this.structuralReasoner.getBottomClassNode();
    }

    @Nonnull
    public NodeSet<OWLClass> getSubClasses(@Nonnull OWLClassExpression ce, boolean direct) throws InconsistentOntologyException, ClassExpressionNotInProfileException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        return this.structuralReasoner.getSubClasses(ce, direct);
    }

    @Nonnull
    public NodeSet<OWLClass> getSuperClasses(@Nonnull OWLClassExpression ce, boolean direct) throws InconsistentOntologyException, ClassExpressionNotInProfileException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        return this.structuralReasoner.getSuperClasses(ce, direct);
    }

    @Nonnull
    public Node<OWLClass> getEquivalentClasses(@Nonnull OWLClassExpression ce) throws InconsistentOntologyException, ClassExpressionNotInProfileException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        return this.structuralReasoner.getEquivalentClasses(ce);
    }

    @Nonnull
    public NodeSet<OWLClass> getDisjointClasses(@Nonnull OWLClassExpression ce) {
        return this.structuralReasoner.getDisjointClasses(ce);
    }

    @Nonnull
    public Node<OWLObjectPropertyExpression> getTopObjectPropertyNode() {
        return this.structuralReasoner.getTopObjectPropertyNode();
    }

    @Nonnull
    public Node<OWLObjectPropertyExpression> getBottomObjectPropertyNode() {
        return this.structuralReasoner.getBottomObjectPropertyNode();
    }

    @Nonnull
    public NodeSet<OWLObjectPropertyExpression> getSubObjectProperties(@Nonnull OWLObjectPropertyExpression pe, boolean direct) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        return this.structuralReasoner.getSubObjectProperties(pe, direct);
    }

    @Nonnull
    public NodeSet<OWLObjectPropertyExpression> getSuperObjectProperties(@Nonnull OWLObjectPropertyExpression pe, boolean direct) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        return this.structuralReasoner.getSuperObjectProperties(pe, direct);
    }

    @Nonnull
    public Node<OWLObjectPropertyExpression> getEquivalentObjectProperties(@Nonnull OWLObjectPropertyExpression pe) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        return this.structuralReasoner.getEquivalentObjectProperties(pe);
    }

    @Nonnull
    public NodeSet<OWLObjectPropertyExpression> getDisjointObjectProperties(@Nonnull OWLObjectPropertyExpression pe) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        return this.structuralReasoner.getDisjointObjectProperties(pe);
    }

    @Nonnull
    public Node<OWLObjectPropertyExpression> getInverseObjectProperties(@Nonnull OWLObjectPropertyExpression pe) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        return this.structuralReasoner.getInverseObjectProperties(pe);
    }

    @Nonnull
    public NodeSet<OWLClass> getObjectPropertyDomains(@Nonnull OWLObjectPropertyExpression pe, boolean direct) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        return this.structuralReasoner.getObjectPropertyDomains(pe, direct);
    }

    @Nonnull
    public NodeSet<OWLClass> getObjectPropertyRanges(@Nonnull OWLObjectPropertyExpression pe, boolean direct) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        return this.structuralReasoner.getObjectPropertyRanges(pe, direct);
    }

    @Nonnull
    public Node<OWLDataProperty> getTopDataPropertyNode() {
        return this.structuralReasoner.getTopDataPropertyNode();
    }

    @Nonnull
    public Node<OWLDataProperty> getBottomDataPropertyNode() {
        return this.structuralReasoner.getBottomDataPropertyNode();
    }

    @Nonnull
    public NodeSet<OWLDataProperty> getSubDataProperties(@Nonnull OWLDataProperty pe, boolean direct) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        return this.structuralReasoner.getSubDataProperties(pe, direct);
    }

    @Nonnull
    public NodeSet<OWLDataProperty> getSuperDataProperties(@Nonnull OWLDataProperty pe, boolean direct) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        return this.structuralReasoner.getSuperDataProperties(pe, direct);
    }

    @Nonnull
    public Node<OWLDataProperty> getEquivalentDataProperties(@Nonnull OWLDataProperty pe) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        return this.structuralReasoner.getEquivalentDataProperties(pe);
    }

    @Nonnull
    public NodeSet<OWLDataProperty> getDisjointDataProperties(@Nonnull OWLDataPropertyExpression pe) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        return this.structuralReasoner.getDisjointDataProperties(pe);
    }

    @Nonnull
    public NodeSet<OWLClass> getDataPropertyDomains(@Nonnull OWLDataProperty pe, boolean direct) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        return this.structuralReasoner.getDataPropertyDomains(pe, direct);
    }

    @Nonnull
    public NodeSet<OWLClass> getTypes(@Nonnull OWLNamedIndividual ind, boolean direct) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        return this.structuralReasoner.getTypes(ind, direct);
    }

    @Nonnull
    public NodeSet<OWLNamedIndividual> getInstances(@Nonnull OWLClassExpression ce, boolean direct) throws InconsistentOntologyException, ClassExpressionNotInProfileException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        return this.structuralReasoner.getInstances(ce, direct);
    }

    @Nonnull
    public NodeSet<OWLNamedIndividual> getObjectPropertyValues(@Nonnull OWLNamedIndividual ind, @Nonnull OWLObjectPropertyExpression pe) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        return this.structuralReasoner.getObjectPropertyValues(ind, pe);
    }

    @Nonnull
    public Set<OWLLiteral> getDataPropertyValues(@Nonnull OWLNamedIndividual ind, @Nonnull OWLDataProperty pe) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        return this.structuralReasoner.getDataPropertyValues(ind, pe);
    }

    @Nonnull
    public Node<OWLNamedIndividual> getSameIndividuals(@Nonnull OWLNamedIndividual ind) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        return this.structuralReasoner.getSameIndividuals(ind);
    }

    @Nonnull
    public NodeSet<OWLNamedIndividual> getDifferentIndividuals(@Nonnull OWLNamedIndividual ind) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        return this.structuralReasoner.getDifferentIndividuals(ind);
    }

    @Override
    public void close() {
        this.dispose();
    }
}

