/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.owlapi.impl;

import com.google.common.collect.ImmutableSet;
import it.unibz.inf.ontop.answering.resultset.MaterializedGraphResultSet;
import it.unibz.inf.ontop.exception.OBDASpecificationException;
import it.unibz.inf.ontop.injection.OntopSystemConfiguration;
import it.unibz.inf.ontop.materialization.MaterializationParams;
import it.unibz.inf.ontop.materialization.OntopRDFMaterializer;
import it.unibz.inf.ontop.materialization.impl.DefaultOntopRDFMaterializer;
import it.unibz.inf.ontop.owlapi.OntopOWLAPIMaterializer;
import it.unibz.inf.ontop.owlapi.exception.OntopOWLException;
import it.unibz.inf.ontop.owlapi.resultset.MaterializedGraphOWLResultSet;
import it.unibz.inf.ontop.owlapi.resultset.impl.OntopMaterializedGraphOWLResultSet;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import javax.annotation.Nonnull;
import org.apache.commons.rdf.api.RDF;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLException;

public class DefaultOntopOWLAPIMaterializer
implements OntopOWLAPIMaterializer {
    private final OntopRDFMaterializer materializer;
    private RDF rdfFactory;

    public DefaultOntopOWLAPIMaterializer(OntopSystemConfiguration configuration, MaterializationParams materializationParams) throws OBDASpecificationException {
        this.materializer = new DefaultOntopRDFMaterializer(configuration, materializationParams);
        this.rdfFactory = (RDF)configuration.getInjector().getInstance(RDF.class);
    }

    public DefaultOntopOWLAPIMaterializer(OntopSystemConfiguration configuration) throws OBDASpecificationException {
        this(configuration, MaterializationParams.defaultBuilder().build());
    }

    @Override
    public MaterializedGraphOWLResultSet materialize() throws OWLException {
        try {
            return this.wrap(this.materializer.materialize());
        }
        catch (OBDASpecificationException e) {
            throw new OntopOWLException(e);
        }
    }

    @Override
    public MaterializedGraphOWLResultSet materialize(@Nonnull ImmutableSet<IRI> selectedVocabulary) throws OWLException {
        try {
            return this.wrap(this.materializer.materialize((ImmutableSet)selectedVocabulary.stream().map(i -> this.rdfFactory.createIRI(i.toString())).collect(ImmutableCollectors.toSet())));
        }
        catch (OBDASpecificationException e) {
            throw new OntopOWLException(e);
        }
    }

    @Override
    public ImmutableSet<IRI> getClasses() {
        return (ImmutableSet)this.materializer.getClasses().stream().map(i -> IRI.create((String)i.getIRIString())).collect(ImmutableCollectors.toSet());
    }

    @Override
    public ImmutableSet<IRI> getProperties() {
        return (ImmutableSet)this.materializer.getProperties().stream().map(i -> IRI.create((String)i.getIRIString())).collect(ImmutableCollectors.toSet());
    }

    private MaterializedGraphOWLResultSet wrap(MaterializedGraphResultSet graphResultSet) {
        return new OntopMaterializedGraphOWLResultSet(graphResultSet);
    }
}

