/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.owlapi.connection.impl;

import it.unibz.inf.ontop.answering.connection.OntopStatement;
import it.unibz.inf.ontop.answering.reformulation.input.AskQuery;
import it.unibz.inf.ontop.answering.reformulation.input.ConstructQuery;
import it.unibz.inf.ontop.answering.reformulation.input.DescribeQuery;
import it.unibz.inf.ontop.answering.reformulation.input.GraphSPARQLQuery;
import it.unibz.inf.ontop.answering.reformulation.input.InputQuery;
import it.unibz.inf.ontop.answering.reformulation.input.InputQueryFactory;
import it.unibz.inf.ontop.answering.reformulation.input.SelectQuery;
import it.unibz.inf.ontop.answering.resultset.BooleanResultSet;
import it.unibz.inf.ontop.answering.resultset.GraphResultSet;
import it.unibz.inf.ontop.answering.resultset.SimpleGraphResultSet;
import it.unibz.inf.ontop.answering.resultset.TupleResultSet;
import it.unibz.inf.ontop.exception.OntopConnectionException;
import it.unibz.inf.ontop.exception.OntopInvalidInputQueryException;
import it.unibz.inf.ontop.exception.OntopQueryEngineException;
import it.unibz.inf.ontop.exception.OntopQueryEvaluationException;
import it.unibz.inf.ontop.exception.OntopReformulationException;
import it.unibz.inf.ontop.exception.OntopResultConversionException;
import it.unibz.inf.ontop.exception.OntopUnsupportedInputQueryException;
import it.unibz.inf.ontop.iq.IQ;
import it.unibz.inf.ontop.owlapi.connection.OntopOWLStatement;
import it.unibz.inf.ontop.owlapi.exception.OntopOWLException;
import it.unibz.inf.ontop.owlapi.resultset.BooleanOWLResultSet;
import it.unibz.inf.ontop.owlapi.resultset.GraphOWLResultSet;
import it.unibz.inf.ontop.owlapi.resultset.TupleOWLResultSet;
import it.unibz.inf.ontop.owlapi.resultset.impl.OntopBooleanOWLResultSet;
import it.unibz.inf.ontop.owlapi.resultset.impl.OntopGraphOWLResultSet;
import it.unibz.inf.ontop.owlapi.resultset.impl.OntopTupleOWLResultSet;

public class DefaultOntopOWLStatement
implements OntopOWLStatement {
    private OntopStatement st;
    private final InputQueryFactory inputQueryFactory;

    public DefaultOntopOWLStatement(OntopStatement st, InputQueryFactory inputQueryFactory) {
        this.st = st;
        this.inputQueryFactory = inputQueryFactory;
    }

    @Override
    public void cancel() throws OntopOWLException {
        try {
            this.st.cancel();
        }
        catch (OntopConnectionException e) {
            throw new OntopOWLException(e);
        }
    }

    @Override
    public void close() throws OntopOWLException {
        try {
            this.st.close();
        }
        catch (OntopConnectionException e) {
            throw new OntopOWLException(e);
        }
    }

    @Override
    public TupleOWLResultSet executeSelectQuery(String inputQuery) throws OntopOWLException {
        try {
            SelectQuery query = this.inputQueryFactory.createSelectQuery(inputQuery);
            TupleResultSet resultSet = (TupleResultSet)this.st.execute((InputQuery)query);
            return new OntopTupleOWLResultSet(resultSet);
        }
        catch (OntopQueryEngineException e) {
            throw new OntopOWLException(e);
        }
    }

    @Override
    public BooleanOWLResultSet executeAskQuery(String inputQuery) throws OntopOWLException {
        try {
            AskQuery query = this.inputQueryFactory.createAskQuery(inputQuery);
            BooleanResultSet resultSet = (BooleanResultSet)this.st.execute((InputQuery)query);
            return new OntopBooleanOWLResultSet(resultSet);
        }
        catch (OntopQueryEngineException e) {
            throw new OntopOWLException(e);
        }
    }

    @Override
    public GraphOWLResultSet executeConstructQuery(String inputQuery) throws OntopOWLException {
        try {
            ConstructQuery query = this.inputQueryFactory.createConstructQuery(inputQuery);
            return this.executeGraph((GraphSPARQLQuery)query);
        }
        catch (OntopQueryEngineException e) {
            throw new OntopOWLException(e);
        }
    }

    @Override
    public GraphOWLResultSet executeDescribeQuery(String inputQuery) throws OntopOWLException {
        try {
            DescribeQuery query = this.inputQueryFactory.createDescribeQuery(inputQuery);
            return this.executeGraph((GraphSPARQLQuery)query);
        }
        catch (OntopQueryEngineException e) {
            throw new OntopOWLException(e);
        }
    }

    @Override
    public GraphOWLResultSet executeGraphQuery(String inputQuery) throws OntopOWLException {
        try {
            GraphSPARQLQuery query = this.inputQueryFactory.createGraphQuery(inputQuery);
            return this.executeGraph(query);
        }
        catch (OntopQueryEngineException e) {
            throw new OntopOWLException(e);
        }
    }

    private GraphOWLResultSet executeGraph(GraphSPARQLQuery query) throws OntopQueryEvaluationException, OntopConnectionException, OntopReformulationException, OntopResultConversionException {
        SimpleGraphResultSet resultSet = (SimpleGraphResultSet)this.st.execute((InputQuery)query);
        return new OntopGraphOWLResultSet((GraphResultSet)resultSet);
    }

    public int getFetchSize() throws OntopOWLException {
        try {
            return this.st.getFetchSize();
        }
        catch (OntopConnectionException e) {
            throw new OntopOWLException(e);
        }
    }

    public int getMaxRows() throws OntopOWLException {
        try {
            return this.st.getMaxRows();
        }
        catch (OntopConnectionException e) {
            throw new OntopOWLException(e);
        }
    }

    public void getMoreResults() throws OntopOWLException {
        try {
            this.st.getMoreResults();
        }
        catch (OntopConnectionException e) {
            throw new OntopOWLException(e);
        }
    }

    public int getQueryTimeout() throws OntopOWLException {
        try {
            return this.st.getQueryTimeout();
        }
        catch (OntopConnectionException e) {
            throw new OntopOWLException(e);
        }
    }

    public void setFetchSize(int rows) throws OntopOWLException {
        try {
            this.st.setFetchSize(rows);
        }
        catch (OntopConnectionException e) {
            throw new OntopOWLException(e);
        }
    }

    public void setMaxRows(int max) throws OntopOWLException {
        try {
            this.st.setMaxRows(max);
        }
        catch (OntopConnectionException e) {
            throw new OntopOWLException(e);
        }
    }

    @Override
    public boolean isClosed() throws OntopOWLException {
        try {
            return this.st.isClosed();
        }
        catch (OntopConnectionException e) {
            throw new OntopOWLException(e);
        }
    }

    @Override
    public void setQueryTimeout(int seconds) throws OntopOWLException {
        try {
            this.st.setQueryTimeout(seconds);
        }
        catch (OntopConnectionException e) {
            throw new OntopOWLException(e);
        }
    }

    @Override
    public long getTupleCount(String query) throws OntopOWLException {
        try {
            return this.st.getTupleCount(this.parseQueryString(query));
        }
        catch (Exception e) {
            throw new OntopOWLException(e);
        }
    }

    @Override
    public String getRewritingRendering(String query) throws OntopOWLException {
        try {
            return this.st.getRewritingRendering(this.parseQueryString(query));
        }
        catch (Exception e) {
            throw new OntopOWLException(e);
        }
    }

    @Override
    public IQ getExecutableQuery(String query) throws OntopOWLException {
        try {
            return this.st.getExecutableQuery(this.parseQueryString(query));
        }
        catch (OntopReformulationException e) {
            throw new OntopOWLException(e);
        }
    }

    private InputQuery parseQueryString(String queryString) throws OntopOWLException {
        try {
            return this.inputQueryFactory.createSPARQLQuery(queryString);
        }
        catch (OntopInvalidInputQueryException | OntopUnsupportedInputQueryException e) {
            throw new OntopOWLException(e);
        }
    }
}

