package it.unibz.inf.ontop.owlapi.resultset.utils;

/*
 * #%L
 * ontop-obdalib-owlapi
 * %%
 * Copyright (C) 2009 - 2014 Free University of Bozen-Bolzano
 * %%
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * #L%
 */

import java.io.IOException;
import java.io.Writer;
import java.util.List;

public class OWLResultSetWriter {

	public static void writeCSV(List<String[]> tabularData, Writer writer) throws IOException {

		// Print the CSV content
		for (String[] rows : tabularData) {
			StringBuilder line = new StringBuilder();
			boolean needComma = false;
			for (int i = 0; i < rows.length; i++) {
				if (needComma) {
					line.append(",");
				}
				line.append(rows[i]);
				needComma = true;
			}			
			writer.write(line + "\n");
			writer.flush();
		}
		writer.close();
	}
}
