/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.iq.view.impl;

import com.google.inject.Inject;
import it.unibz.inf.ontop.com.google.common.collect.ImmutableMap;
import it.unibz.inf.ontop.dbschema.OntopViewDefinition;
import it.unibz.inf.ontop.dbschema.RelationDefinition;
import it.unibz.inf.ontop.injection.CoreSingletons;
import it.unibz.inf.ontop.injection.IntermediateQueryFactory;
import it.unibz.inf.ontop.injection.QueryTransformerFactory;
import it.unibz.inf.ontop.iq.IQ;
import it.unibz.inf.ontop.iq.IQTree;
import it.unibz.inf.ontop.iq.node.ExtensionalDataNode;
import it.unibz.inf.ontop.iq.transform.impl.DefaultRecursiveIQTreeVisitingTransformer;
import it.unibz.inf.ontop.iq.view.OntopViewUnfolder;
import it.unibz.inf.ontop.model.atom.DistinctVariableOnlyDataAtom;
import it.unibz.inf.ontop.model.term.VariableOrGroundTerm;
import it.unibz.inf.ontop.substitution.ImmutableSubstitution;
import it.unibz.inf.ontop.substitution.InjectiveVar2VarSubstitution;
import it.unibz.inf.ontop.substitution.SubstitutionFactory;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import it.unibz.inf.ontop.utils.VariableGenerator;
import java.util.Map;
import java.util.Optional;

public class OntopViewUnfolderImpl
implements OntopViewUnfolder {
    protected final CoreSingletons coreSingletons;
    protected final IntermediateQueryFactory iqFactory;

    @Inject
    protected OntopViewUnfolderImpl(CoreSingletons coreSingletons) {
        this.coreSingletons = coreSingletons;
        this.iqFactory = coreSingletons.getIQFactory();
    }

    @Override
    public IQ optimize(IQ query) {
        IQTree initialTree = query.getTree();
        int maxLevel = this.extractMaxLevel(initialTree);
        if (maxLevel < 1) {
            return query;
        }
        IQTree newTree = this.transformTree(initialTree, query.getVariableGenerator(), maxLevel);
        return newTree.equals(initialTree) ? query : this.iqFactory.createIQ(query.getProjectionAtom(), newTree).normalizeForOptimization();
    }

    protected IQTree transformTree(IQTree tree, VariableGenerator variableGenerator, int maxLevel) {
        return new MaxLevelViewUnfoldingTransformer(maxLevel, variableGenerator, this.coreSingletons).transform(tree);
    }

    private int extractMaxLevel(IQTree tree) {
        if (tree.getRootNode() instanceof ExtensionalDataNode) {
            RelationDefinition relationDefinition = ((ExtensionalDataNode)tree.getRootNode()).getRelationDefinition();
            return relationDefinition instanceof OntopViewDefinition ? ((OntopViewDefinition)relationDefinition).getLevel() : 0;
        }
        return tree.getChildren().stream().reduce(0, (l, c) -> Math.max(l, this.extractMaxLevel((IQTree)c)), Math::max);
    }

    protected static class MaxLevelViewUnfoldingTransformer
    extends DefaultRecursiveIQTreeVisitingTransformer {
        protected final int maxLevel;
        protected final VariableGenerator variableGenerator;
        protected final SubstitutionFactory substitutionFactory;
        protected final QueryTransformerFactory transformerFactory;

        protected MaxLevelViewUnfoldingTransformer(int maxLevel, VariableGenerator variableGenerator, CoreSingletons coreSingletons) {
            super(coreSingletons);
            this.maxLevel = maxLevel;
            this.variableGenerator = variableGenerator;
            this.substitutionFactory = coreSingletons.getSubstitutionFactory();
            this.transformerFactory = coreSingletons.getQueryTransformerFactory();
        }

        public IQTree transformExtensionalData(ExtensionalDataNode dataNode) {
            RelationDefinition relationDefinition = dataNode.getRelationDefinition();
            if (relationDefinition instanceof OntopViewDefinition) {
                OntopViewDefinition viewDefinition = (OntopViewDefinition)relationDefinition;
                return viewDefinition.getLevel() < this.maxLevel ? dataNode : this.merge(dataNode, viewDefinition.getIQ());
            }
            return dataNode;
        }

        protected IQTree merge(ExtensionalDataNode dataNode, IQ definition) {
            InjectiveVar2VarSubstitution renamingSubstitution = this.substitutionFactory.generateNotConflictingRenaming(this.variableGenerator, definition.getTree().getKnownVariables());
            IQ renamedDefinition = renamingSubstitution.isEmpty() ? definition : this.transformerFactory.createRenamer(renamingSubstitution).transform(definition);
            ImmutableSubstitution<VariableOrGroundTerm> descendingSubstitution = this.extractSubstitution(renamingSubstitution.applyToDistinctVariableOnlyDataAtom(renamedDefinition.getProjectionAtom()), (ImmutableMap<Integer, ? extends VariableOrGroundTerm>)dataNode.getArgumentMap());
            return renamedDefinition.getTree().applyDescendingSubstitution(descendingSubstitution, Optional.empty()).normalizeForOptimization(this.variableGenerator);
        }

        protected ImmutableSubstitution<VariableOrGroundTerm> extractSubstitution(DistinctVariableOnlyDataAtom sourceAtom, ImmutableMap<Integer, ? extends VariableOrGroundTerm> targetArgumentMap) {
            ImmutableMap newMap = (ImmutableMap)targetArgumentMap.entrySet().stream().collect(ImmutableCollectors.toMap(e -> sourceAtom.getTerm(((Integer)e.getKey()).intValue()), Map.Entry::getValue));
            return this.substitutionFactory.getSubstitution(newMap);
        }
    }
}

