/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.iq.transformer.impl;

import com.google.inject.Inject;
import com.google.inject.assistedinject.Assisted;
import it.unibz.inf.ontop.com.google.common.collect.ImmutableList;
import it.unibz.inf.ontop.com.google.common.collect.ImmutableMap;
import it.unibz.inf.ontop.com.google.common.collect.ImmutableMultimap;
import it.unibz.inf.ontop.com.google.common.collect.ImmutableSet;
import it.unibz.inf.ontop.com.google.common.collect.Maps;
import it.unibz.inf.ontop.exception.MinorOntopInternalBugException;
import it.unibz.inf.ontop.exception.OntopInternalBugException;
import it.unibz.inf.ontop.injection.IntermediateQueryFactory;
import it.unibz.inf.ontop.iq.IQTree;
import it.unibz.inf.ontop.iq.LeafIQTree;
import it.unibz.inf.ontop.iq.UnaryIQTree;
import it.unibz.inf.ontop.iq.node.AggregationNode;
import it.unibz.inf.ontop.iq.node.BinaryNonCommutativeOperatorNode;
import it.unibz.inf.ontop.iq.node.ConstructionNode;
import it.unibz.inf.ontop.iq.node.DistinctNode;
import it.unibz.inf.ontop.iq.node.NaryOperatorNode;
import it.unibz.inf.ontop.iq.node.UnaryOperatorNode;
import it.unibz.inf.ontop.iq.node.UnionNode;
import it.unibz.inf.ontop.iq.tools.TypeConstantDictionary;
import it.unibz.inf.ontop.iq.transform.IQTreeVisitingTransformer;
import it.unibz.inf.ontop.iq.transform.impl.DefaultRecursiveIQTreeVisitingTransformer;
import it.unibz.inf.ontop.iq.transformer.TermTypeTermLiftTransformer;
import it.unibz.inf.ontop.model.term.Constant;
import it.unibz.inf.ontop.model.term.DBConstant;
import it.unibz.inf.ontop.model.term.ImmutableFunctionalTerm;
import it.unibz.inf.ontop.model.term.ImmutableTerm;
import it.unibz.inf.ontop.model.term.RDFTermTypeConstant;
import it.unibz.inf.ontop.model.term.TermFactory;
import it.unibz.inf.ontop.model.term.Variable;
import it.unibz.inf.ontop.model.term.functionsymbol.FunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.FunctionSymbolFactory;
import it.unibz.inf.ontop.model.term.functionsymbol.RDFTermTypeFunctionSymbol;
import it.unibz.inf.ontop.substitution.ImmutableSubstitution;
import it.unibz.inf.ontop.substitution.SubstitutionFactory;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import it.unibz.inf.ontop.utils.VariableGenerator;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;

public class DefaultTermTypeTermVisitingTreeTransformer
extends DefaultRecursiveIQTreeVisitingTransformer
implements TermTypeTermLiftTransformer {
    private final VariableGenerator variableGenerator;
    private final TypeConstantDictionary dictionary;
    private final TermFactory termFactory;
    private final Constant nullValue;
    private final SubstitutionFactory substitutionFactory;
    private final FunctionSymbolFactory functionSymbolFactory;

    @Inject
    protected DefaultTermTypeTermVisitingTreeTransformer(@Assisted VariableGenerator variableGenerator, TermFactory termFactory, IntermediateQueryFactory iqFactory, TypeConstantDictionary typeConstantDictionary, SubstitutionFactory substitutionFactory, FunctionSymbolFactory functionSymbolFactory) {
        super(iqFactory);
        this.variableGenerator = variableGenerator;
        this.dictionary = typeConstantDictionary;
        this.termFactory = termFactory;
        this.nullValue = termFactory.getNullConstant();
        this.substitutionFactory = substitutionFactory;
        this.functionSymbolFactory = functionSymbolFactory;
    }

    public IQTree transform(IQTree tree) {
        return tree.normalizeForOptimization(this.variableGenerator).acceptTransformer((IQTreeVisitingTransformer)this);
    }

    public IQTree transformUnion(IQTree tree, UnionNode rootNode, ImmutableList<IQTree> children) {
        ImmutableList normalizedChildren = (ImmutableList)children.stream().map(c -> c.acceptTransformer((IQTreeVisitingTransformer)this)).map(this::replaceTypeTermConstants).collect(ImmutableCollectors.toList());
        ImmutableSet metaTermTypeVariables = (ImmutableSet)rootNode.getVariables().stream().filter(v -> normalizedChildren.stream().anyMatch(c -> this.extractDefinition((Variable)v, (IQTree)c).filter(d -> d instanceof ImmutableFunctionalTerm).map(d -> (ImmutableFunctionalTerm)d).filter(d -> d.getFunctionSymbol() instanceof RDFTermTypeFunctionSymbol).isPresent())).collect(ImmutableCollectors.toSet());
        if (metaTermTypeVariables.isEmpty()) {
            return this.iqFactory.createNaryIQTree((NaryOperatorNode)rootNode, normalizedChildren).normalizeForOptimization(this.variableGenerator);
        }
        ImmutableMultimap possibleConstantMultimap = (ImmutableMultimap)metaTermTypeVariables.stream().flatMap(v -> normalizedChildren.stream().flatMap(child -> this.extractPossibleTermTypeConstants((Variable)v, (IQTree)child)).map(c -> Maps.immutableEntry((Object)v, (Object)c))).distinct().collect(ImmutableCollectors.toMultimap());
        ImmutableMap typeFunctionSymbolMap = (ImmutableMap)possibleConstantMultimap.asMap().entrySet().stream().collect(ImmutableCollectors.toMap(Map.Entry::getKey, e -> this.functionSymbolFactory.getRDFTermTypeFunctionSymbol(this.dictionary, ImmutableSet.copyOf((Collection)((Collection)e.getValue())), false)));
        ImmutableList newChildren = (ImmutableList)normalizedChildren.stream().map(c -> this.enforceUsageOfCommonTypeFunctionSymbol((IQTree)c, (ImmutableMap<Variable, RDFTermTypeFunctionSymbol>)typeFunctionSymbolMap)).collect(ImmutableCollectors.toList());
        return this.iqFactory.createNaryIQTree((NaryOperatorNode)rootNode, newChildren).normalizeForOptimization(this.variableGenerator);
    }

    private IQTree replaceTypeTermConstants(IQTree child) {
        return Optional.of(child.getRootNode()).filter(n -> n instanceof ConstructionNode).map(n -> (ConstructionNode)n).map(ConstructionNode::getSubstitution).filter(s -> !s.isEmpty()).map(this::replaceTypeTermConstants).map(s -> this.iqFactory.createConstructionNode(child.getVariables(), s)).filter(n -> !n.equals(child.getRootNode())).map(n -> this.iqFactory.createUnaryIQTree((UnaryOperatorNode)n, ((UnaryIQTree)child).getChild())).orElse(child);
    }

    private ImmutableSubstitution<ImmutableTerm> replaceTypeTermConstants(ImmutableSubstitution<ImmutableTerm> substitution) {
        return this.substitutionFactory.getSubstitution((ImmutableMap)substitution.getImmutableMap().entrySet().stream().collect(ImmutableCollectors.toMap(Map.Entry::getKey, e -> this.replaceTypeTermConstants((ImmutableTerm)e.getValue()))));
    }

    private ImmutableTerm replaceTypeTermConstants(ImmutableTerm term) {
        if (term instanceof RDFTermTypeConstant) {
            RDFTermTypeConstant typeConstant = (RDFTermTypeConstant)term;
            DBConstant intConstant = this.dictionary.convert(typeConstant);
            return this.termFactory.getRDFTermTypeFunctionalTerm((ImmutableTerm)intConstant, this.dictionary, ImmutableSet.of((Object)typeConstant), false);
        }
        if (term instanceof ImmutableFunctionalTerm) {
            ImmutableList subTerms = (ImmutableList)((ImmutableFunctionalTerm)term).getTerms().stream().map(this::replaceTypeTermConstants).collect(ImmutableCollectors.toList());
            return this.termFactory.getImmutableFunctionalTerm(((ImmutableFunctionalTerm)term).getFunctionSymbol(), subTerms).simplify();
        }
        return term;
    }

    private Optional<ImmutableTerm> extractDefinition(Variable variable, IQTree unionChild) {
        return Optional.of(unionChild.getRootNode()).filter(n -> n instanceof ConstructionNode).map(n -> (ConstructionNode)n).flatMap(c -> Optional.ofNullable(c.getSubstitution().get(variable)));
    }

    private Stream<RDFTermTypeConstant> extractPossibleTermTypeConstants(Variable variable, IQTree child) {
        ImmutableTerm definition = this.extractDefinition(variable, child).orElseThrow(() -> new UnexpectedlyFormattedIQTreeException("Was expecting the child to define the blocked definition of the RDF term type variable"));
        if (definition.equals(this.nullValue)) {
            return Stream.of(new RDFTermTypeConstant[0]);
        }
        if (definition instanceof ImmutableFunctionalTerm) {
            return this.extractPossibleTermTypeConstants((ImmutableFunctionalTerm)definition);
        }
        throw new UnexpectedlyFormattedIQTreeException("Was not expecting a Variable or a different kind of Constant");
    }

    private Stream<RDFTermTypeConstant> extractPossibleTermTypeConstants(ImmutableFunctionalTerm definition) {
        RDFTermTypeFunctionSymbol functionSymbol = Optional.of(definition.getFunctionSymbol()).filter(f -> f instanceof RDFTermTypeFunctionSymbol).map(f -> (RDFTermTypeFunctionSymbol)f).orElseThrow(() -> new UnexpectedlyFormattedIQTreeException("Was expecting the definition to be a RDFTermTypeFunctionSymbol"));
        return functionSymbol.getConversionMap().values().stream();
    }

    private IQTree enforceUsageOfCommonTypeFunctionSymbol(IQTree tree, ImmutableMap<Variable, RDFTermTypeFunctionSymbol> typeFunctionSymbolMap) {
        ConstructionNode initialConstructionNode = Optional.of(tree.getRootNode()).filter(n -> n instanceof ConstructionNode).map(n -> (ConstructionNode)n).orElseThrow(() -> new UnexpectedlyFormattedIQTreeException("Was expecting the child to start with a ConstructionNode"));
        ImmutableMap newSubstitutionMap = (ImmutableMap)initialConstructionNode.getSubstitution().getImmutableMap().entrySet().stream().collect(ImmutableCollectors.toMap(Map.Entry::getKey, e -> Optional.ofNullable(typeFunctionSymbolMap.get(e.getKey())).map(functionSymbol -> this.enforceUsageOfCommonTypeFunctionSymbol((ImmutableTerm)e.getValue(), (RDFTermTypeFunctionSymbol)functionSymbol)).orElse((ImmutableTerm)e.getValue())));
        ConstructionNode newConstructionNode = this.iqFactory.createConstructionNode(tree.getVariables(), this.substitutionFactory.getSubstitution(newSubstitutionMap));
        return this.iqFactory.createUnaryIQTree((UnaryOperatorNode)newConstructionNode, ((UnaryIQTree)tree).getChild());
    }

    private ImmutableTerm enforceUsageOfCommonTypeFunctionSymbol(ImmutableTerm definition, RDFTermTypeFunctionSymbol functionSymbol) {
        if (definition.isNull()) {
            return this.termFactory.getImmutableFunctionalTerm((FunctionSymbol)functionSymbol, new ImmutableTerm[]{definition});
        }
        if (definition instanceof ImmutableFunctionalTerm && ((ImmutableFunctionalTerm)definition).getFunctionSymbol() instanceof RDFTermTypeFunctionSymbol) {
            return this.termFactory.getImmutableFunctionalTerm((FunctionSymbol)functionSymbol, ((ImmutableFunctionalTerm)definition).getTerms());
        }
        throw new MinorOntopInternalBugException(String.format("Was expecting a functional term with a RDFTermTypeFunctionSymbol, not %s.\nSome simplifications might be missing", definition));
    }

    public IQTree transformDistinct(IQTree tree, DistinctNode rootNode, IQTree child) {
        return this.transformNodeBlockingNonInjectiveBindings((UnaryOperatorNode)rootNode, child);
    }

    public IQTree transformAggregation(IQTree tree, AggregationNode rootNode, IQTree child) {
        return this.transformNodeBlockingNonInjectiveBindings((UnaryOperatorNode)rootNode, child);
    }

    private IQTree transformNodeBlockingNonInjectiveBindings(UnaryOperatorNode rootNode, IQTree child) {
        IQTree normalizedChild = this.replaceTypeTermConstants(child.acceptTransformer((IQTreeVisitingTransformer)this));
        return this.iqFactory.createUnaryIQTree(rootNode, normalizedChild).normalizeForOptimization(this.variableGenerator);
    }

    protected IQTree transformLeaf(LeafIQTree leaf) {
        return leaf.normalizeForOptimization(this.variableGenerator);
    }

    protected IQTree transformUnaryNode(IQTree tree, UnaryOperatorNode rootNode, IQTree child) {
        return super.transformUnaryNode(tree, rootNode, child).normalizeForOptimization(this.variableGenerator);
    }

    protected IQTree transformNaryCommutativeNode(IQTree tree, NaryOperatorNode rootNode, ImmutableList<IQTree> children) {
        return super.transformNaryCommutativeNode(tree, rootNode, children).normalizeForOptimization(this.variableGenerator);
    }

    protected IQTree transformBinaryNonCommutativeNode(IQTree tree, BinaryNonCommutativeOperatorNode rootNode, IQTree leftChild, IQTree rightChild) {
        return super.transformBinaryNonCommutativeNode(tree, rootNode, leftChild, rightChild).normalizeForOptimization(this.variableGenerator);
    }

    private static class UnexpectedlyFormattedIQTreeException
    extends OntopInternalBugException {
        protected UnexpectedlyFormattedIQTreeException(String message) {
            super(message);
        }
    }
}

