/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.iq.proposal.impl;

import it.unibz.inf.ontop.iq.IntermediateQuery;
import it.unibz.inf.ontop.iq.node.QueryNode;
import it.unibz.inf.ontop.iq.proposal.NodeCentricOptimizationResults;
import it.unibz.inf.ontop.iq.proposal.impl.ProposalResultsImpl;
import java.util.Optional;

public class NodeCentricOptimizationResultsImpl<N extends QueryNode>
extends ProposalResultsImpl
implements NodeCentricOptimizationResults<N> {
    private final Optional<QueryNode> optionalNextSibling;
    private final Optional<N> optionalNewNode;
    private final Optional<QueryNode> optionalClosestAncestor;
    private final Optional<QueryNode> optionalReplacingChild;

    public NodeCentricOptimizationResultsImpl(IntermediateQuery query, N newNode) {
        this.optionalNextSibling = query.getNextSibling(newNode);
        this.optionalNewNode = Optional.of(newNode);
        this.optionalClosestAncestor = query.getParent(newNode);
        this.optionalReplacingChild = Optional.empty();
    }

    public NodeCentricOptimizationResultsImpl(IntermediateQuery query, Optional<QueryNode> optionalNextSibling, Optional<QueryNode> optionalClosestAncestor) {
        Optional optionalSiblingParent;
        this.optionalNextSibling = optionalNextSibling;
        this.optionalNewNode = Optional.empty();
        this.optionalClosestAncestor = optionalClosestAncestor;
        this.optionalReplacingChild = Optional.empty();
        if (optionalNextSibling.isPresent() && optionalClosestAncestor.isPresent() && (!(optionalSiblingParent = query.getParent(optionalNextSibling.get())).isPresent() || optionalSiblingParent.get() != optionalClosestAncestor.get())) {
            throw new IllegalArgumentException("The closest ancestor is not the parent of the next sibling");
        }
    }

    public NodeCentricOptimizationResultsImpl(IntermediateQuery query, Optional<QueryNode> optionalReplacingChild) {
        if (!optionalReplacingChild.isPresent()) {
            throw new IllegalArgumentException("A replacing child must be given (not optional in practice)");
        }
        this.optionalReplacingChild = optionalReplacingChild;
        this.optionalNextSibling = query.getNextSibling(optionalReplacingChild.get());
        this.optionalNewNode = Optional.empty();
        this.optionalClosestAncestor = query.getParent(optionalReplacingChild.get());
    }

    @Override
    public Optional<N> getOptionalNewNode() {
        return this.optionalNewNode;
    }

    @Override
    public Optional<QueryNode> getOptionalNextSibling() {
        return this.optionalNextSibling;
    }

    @Override
    public Optional<QueryNode> getOptionalClosestAncestor() {
        return this.optionalClosestAncestor;
    }

    @Override
    public Optional<QueryNode> getOptionalReplacingChild() {
        return this.optionalReplacingChild;
    }

    @Override
    public Optional<QueryNode> getNewNodeOrReplacingChild() {
        return this.optionalNewNode.map(Optional::of).orElse(this.optionalReplacingChild);
    }
}

