/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.iq.executor.projection;

import com.google.inject.Inject;
import it.unibz.inf.ontop.com.google.common.collect.ImmutableMap;
import it.unibz.inf.ontop.com.google.common.collect.ImmutableSet;
import it.unibz.inf.ontop.injection.IntermediateQueryFactory;
import it.unibz.inf.ontop.iq.IntermediateQuery;
import it.unibz.inf.ontop.iq.exception.InvalidQueryOptimizationProposalException;
import it.unibz.inf.ontop.iq.executor.projection.ProjectionShrinkingExecutor;
import it.unibz.inf.ontop.iq.impl.QueryTreeComponent;
import it.unibz.inf.ontop.iq.node.ConstructionNode;
import it.unibz.inf.ontop.iq.node.ExplicitVariableProjectionNode;
import it.unibz.inf.ontop.iq.node.QueryNode;
import it.unibz.inf.ontop.iq.node.TrueNode;
import it.unibz.inf.ontop.iq.node.UnionNode;
import it.unibz.inf.ontop.iq.proposal.NodeCentricOptimizationResults;
import it.unibz.inf.ontop.iq.proposal.ProjectionShrinkingProposal;
import it.unibz.inf.ontop.iq.proposal.impl.NodeCentricOptimizationResultsImpl;
import it.unibz.inf.ontop.model.term.Variable;
import it.unibz.inf.ontop.substitution.SubstitutionFactory;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import java.util.Optional;

public class ProjectionShrinkingExecutorImpl
implements ProjectionShrinkingExecutor {
    private final IntermediateQueryFactory iqFactory;
    private final SubstitutionFactory substitutionFactory;

    @Inject
    private ProjectionShrinkingExecutorImpl(IntermediateQueryFactory iqFactory, SubstitutionFactory substitutionFactory) {
        this.iqFactory = iqFactory;
        this.substitutionFactory = substitutionFactory;
    }

    public NodeCentricOptimizationResults<ExplicitVariableProjectionNode> apply(ProjectionShrinkingProposal proposal, IntermediateQuery query, QueryTreeComponent treeComponent) throws InvalidQueryOptimizationProposalException {
        ExplicitVariableProjectionNode focusNode = (ExplicitVariableProjectionNode)proposal.getFocusNode();
        ImmutableSet<Variable> retainedVariables = proposal.getRetainedVariables();
        if (focusNode instanceof UnionNode) {
            UnionNode replacingNode = this.iqFactory.createUnionNode(retainedVariables);
            treeComponent.replaceNode((QueryNode)focusNode, (QueryNode)replacingNode);
            return new NodeCentricOptimizationResultsImpl<UnionNode>(query, replacingNode);
        }
        if (focusNode instanceof ConstructionNode) {
            if (retainedVariables.size() > 0) {
                ImmutableMap shrinkedMap = (ImmutableMap)((ConstructionNode)focusNode).getSubstitution().getImmutableMap().entrySet().stream().filter(e -> retainedVariables.contains(e.getKey())).collect(ImmutableCollectors.toMap());
                ConstructionNode replacingNode = this.iqFactory.createConstructionNode(retainedVariables, this.substitutionFactory.getSubstitution(shrinkedMap));
                treeComponent.replaceNode((QueryNode)focusNode, (QueryNode)replacingNode);
                return new NodeCentricOptimizationResultsImpl<ConstructionNode>(query, replacingNode);
            }
            if (query.getFirstChild((QueryNode)focusNode).isPresent()) {
                QueryNode replacingNode = treeComponent.removeOrReplaceNodeByUniqueChild((QueryNode)focusNode);
                return new NodeCentricOptimizationResultsImpl<ExplicitVariableProjectionNode>(query, Optional.of(replacingNode));
            }
            TrueNode replacingNode = this.iqFactory.createTrueNode();
            treeComponent.replaceNode((QueryNode)focusNode, (QueryNode)replacingNode);
            return new NodeCentricOptimizationResultsImpl<ExplicitVariableProjectionNode>(query, Optional.of(replacingNode));
        }
        throw new IllegalStateException("a projection shrinking proposal can only be made for a Union or Construction node");
    }
}

