/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.iq.executor.leftjoin;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import it.unibz.inf.ontop.com.google.common.collect.ImmutableCollection;
import it.unibz.inf.ontop.com.google.common.collect.ImmutableList;
import it.unibz.inf.ontop.com.google.common.collect.ImmutableMap;
import it.unibz.inf.ontop.com.google.common.collect.ImmutableMultimap;
import it.unibz.inf.ontop.com.google.common.collect.ImmutableSet;
import it.unibz.inf.ontop.dbschema.ForeignKeyConstraint;
import it.unibz.inf.ontop.dbschema.RelationDefinition;
import it.unibz.inf.ontop.dbschema.UniqueConstraint;
import it.unibz.inf.ontop.exception.MinorOntopInternalBugException;
import it.unibz.inf.ontop.injection.IntermediateQueryFactory;
import it.unibz.inf.ontop.iq.executor.leftjoin.LeftJoinRightChildNormalizationAnalyzer;
import it.unibz.inf.ontop.iq.node.ExtensionalDataNode;
import it.unibz.inf.ontop.iq.node.VariableNullability;
import it.unibz.inf.ontop.model.term.GroundTerm;
import it.unibz.inf.ontop.model.term.ImmutableExpression;
import it.unibz.inf.ontop.model.term.ImmutableTerm;
import it.unibz.inf.ontop.model.term.TermFactory;
import it.unibz.inf.ontop.model.term.Variable;
import it.unibz.inf.ontop.model.term.VariableOrGroundTerm;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import it.unibz.inf.ontop.utils.VariableGenerator;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.annotation.Nullable;

@Singleton
public class LeftJoinRightChildNormalizationAnalyzerImpl
implements LeftJoinRightChildNormalizationAnalyzer {
    private final TermFactory termFactory;
    private final IntermediateQueryFactory iqFactory;

    @Inject
    private LeftJoinRightChildNormalizationAnalyzerImpl(TermFactory termFactory, IntermediateQueryFactory iqFactory) {
        this.termFactory = termFactory;
        this.iqFactory = iqFactory;
    }

    @Override
    public LeftJoinRightChildNormalizationAnalyzer.LeftJoinRightChildNormalizationAnalysis analyze(ImmutableSet<Variable> leftVariables, ImmutableList<ExtensionalDataNode> leftDataNodes, ExtensionalDataNode rightDataNode, VariableGenerator variableGenerator, VariableNullability variableNullability) {
        ImmutableMultimap leftRelationArgumentMultimap = (ImmutableMultimap)leftDataNodes.stream().collect(ImmutableCollectors.toMultimap(ExtensionalDataNode::getRelationDefinition, ExtensionalDataNode::getArgumentMap));
        ImmutableMap rightArgumentMap = rightDataNode.getArgumentMap();
        if (leftRelationArgumentMultimap.isEmpty()) {
            return new LeftJoinRightChildNormalizationAnalysisImpl(false);
        }
        RelationDefinition rightRelation = rightDataNode.getRelationDefinition();
        ImmutableSet<UniqueConstraint> matchedUCs = this.extractMatchedUCs((ImmutableMultimap<RelationDefinition, ImmutableMap<Integer, ? extends VariableOrGroundTerm>>)leftRelationArgumentMultimap, (ImmutableMap<Integer, ? extends VariableOrGroundTerm>)rightArgumentMap, rightRelation, variableNullability);
        ImmutableSet<ForeignKeyConstraint> matchedFKs = this.extractMatchedFKs((ImmutableMultimap<RelationDefinition, ImmutableMap<Integer, ? extends VariableOrGroundTerm>>)leftRelationArgumentMultimap, (ImmutableMap<Integer, ? extends VariableOrGroundTerm>)rightArgumentMap, rightRelation, variableNullability);
        if (matchedUCs.isEmpty() && matchedFKs.isEmpty()) {
            return new LeftJoinRightChildNormalizationAnalysisImpl(false);
        }
        int rightArity = rightDataNode.getRelationDefinition().getAttributes().size();
        ImmutableSet<Integer> nonMatchedRightAttributeIndexes = this.extractNonMatchedRightAttributeIndexes((ImmutableCollection<UniqueConstraint>)matchedUCs, (ImmutableCollection<ForeignKeyConstraint>)matchedFKs, rightArity);
        ImmutableList conflictingRightArgumentIndexes = (ImmutableList)nonMatchedRightAttributeIndexes.stream().filter(i -> this.isRightArgumentConflicting((int)i, (ImmutableCollection<Variable>)leftVariables, (ImmutableMap<Integer, ? extends VariableOrGroundTerm>)rightArgumentMap, nonMatchedRightAttributeIndexes)).collect(ImmutableCollectors.toList());
        if (!conflictingRightArgumentIndexes.isEmpty()) {
            ExtensionalDataNode newRightDataNode = this.iqFactory.createExtensionalDataNode(rightRelation, this.computeNewRightArgumentMap((ImmutableMap<Integer, ? extends VariableOrGroundTerm>)rightArgumentMap, (ImmutableList<Integer>)conflictingRightArgumentIndexes, variableGenerator));
            ImmutableExpression newExpression = this.computeExpression((ImmutableMap<Integer, ? extends VariableOrGroundTerm>)rightArgumentMap, (ImmutableMap<Integer, ? extends VariableOrGroundTerm>)newRightDataNode.getArgumentMap());
            return new LeftJoinRightChildNormalizationAnalysisImpl(newRightDataNode, newExpression);
        }
        return new LeftJoinRightChildNormalizationAnalysisImpl(true);
    }

    private ImmutableSet<UniqueConstraint> extractMatchedUCs(ImmutableMultimap<RelationDefinition, ImmutableMap<Integer, ? extends VariableOrGroundTerm>> leftRelationArgumentMultimap, ImmutableMap<Integer, ? extends VariableOrGroundTerm> rightArgumentMap, RelationDefinition rightRelation, VariableNullability variableNullability) {
        return (ImmutableSet)leftRelationArgumentMultimap.get((Object)rightRelation).stream().flatMap(leftArgumentMap -> rightRelation.getUniqueConstraints().stream().filter(uc -> this.isUcMatching((UniqueConstraint)uc, (ImmutableMap<Integer, ? extends VariableOrGroundTerm>)leftArgumentMap, rightArgumentMap, variableNullability))).collect(ImmutableCollectors.toSet());
    }

    private boolean isUcMatching(UniqueConstraint uniqueConstraint, ImmutableMap<Integer, ? extends VariableOrGroundTerm> leftArgumentMap, ImmutableMap<Integer, ? extends VariableOrGroundTerm> rightArgumentMap, VariableNullability variableNullability) {
        return uniqueConstraint.getAttributes().stream().allMatch(a -> {
            Optional<Object> leftArg = Optional.ofNullable(leftArgumentMap.get((Object)(a.getIndex() - 1)));
            return leftArg.isPresent() && leftArg.equals(Optional.ofNullable(rightArgumentMap.get((Object)(a.getIndex() - 1)))) && !((VariableOrGroundTerm)leftArg.get()).isNullable(variableNullability.getNullableVariables());
        });
    }

    private ImmutableSet<ForeignKeyConstraint> extractMatchedFKs(ImmutableMultimap<RelationDefinition, ImmutableMap<Integer, ? extends VariableOrGroundTerm>> leftRelationArgumentMultimap, ImmutableMap<Integer, ? extends VariableOrGroundTerm> rightArgumentMap, RelationDefinition rightRelation, VariableNullability variableNullability) {
        return (ImmutableSet)leftRelationArgumentMultimap.asMap().entrySet().stream().flatMap(e -> this.extractMatchedFKsForARelation((RelationDefinition)e.getKey(), (Collection)e.getValue(), rightArgumentMap, rightRelation, variableNullability)).collect(ImmutableCollectors.toSet());
    }

    private Stream<ForeignKeyConstraint> extractMatchedFKsForARelation(RelationDefinition leftRelation, Collection<ImmutableMap<Integer, ? extends VariableOrGroundTerm>> leftArgumentLists, ImmutableMap<Integer, ? extends VariableOrGroundTerm> rightArgumentMap, RelationDefinition rightRelation, VariableNullability variableNullability) {
        return leftRelation.getForeignKeys().stream().filter(fk -> fk.getReferencedRelation().equals(rightRelation)).filter(fk -> leftArgumentLists.stream().anyMatch(leftArgumentMap -> this.isFkMatching((ForeignKeyConstraint)fk, (ImmutableMap<Integer, ? extends VariableOrGroundTerm>)leftArgumentMap, rightArgumentMap, variableNullability)));
    }

    private boolean isFkMatching(ForeignKeyConstraint foreignKey, ImmutableMap<Integer, ? extends VariableOrGroundTerm> leftArgumentMap, ImmutableMap<Integer, ? extends VariableOrGroundTerm> rightArgumentMap, VariableNullability variableNullability) {
        return foreignKey.getComponents().stream().allMatch(c -> {
            Optional<Object> leftArg = Optional.ofNullable(leftArgumentMap.get((Object)(c.getAttribute().getIndex() - 1)));
            return leftArg.isPresent() && leftArg.equals(Optional.ofNullable(rightArgumentMap.get((Object)(c.getReferencedAttribute().getIndex() - 1)))) && !((VariableOrGroundTerm)leftArg.get()).isNullable(variableNullability.getNullableVariables());
        });
    }

    private ImmutableSet<Integer> extractNonMatchedRightAttributeIndexes(ImmutableCollection<UniqueConstraint> matchedUCs, ImmutableCollection<ForeignKeyConstraint> matchedFKs, int arity) {
        return (ImmutableSet)IntStream.range(0, arity).filter(i -> matchedUCs.stream().noneMatch(uc -> uc.getAttributes().stream().anyMatch(a -> a.getIndex() == i + 1))).filter(i -> matchedFKs.stream().noneMatch(fk -> fk.getComponents().stream().anyMatch(c -> c.getReferencedAttribute().getIndex() == i + 1))).boxed().collect(ImmutableCollectors.toSet());
    }

    private boolean isRightArgumentConflicting(int rightArgumentIndex, ImmutableCollection<Variable> leftVariables, ImmutableMap<Integer, ? extends VariableOrGroundTerm> rightArgumentMap, ImmutableSet<Integer> nonMatchedRightAttributeIndexes) {
        VariableOrGroundTerm rightArgument = (VariableOrGroundTerm)rightArgumentMap.get((Object)rightArgumentIndex);
        if (rightArgument instanceof GroundTerm) {
            return true;
        }
        Variable rightVariable = (Variable)rightArgument;
        if (leftVariables.contains((Object)rightVariable)) {
            return true;
        }
        return rightArgumentMap.keySet().stream().filter(i -> i < rightArgumentIndex || !nonMatchedRightAttributeIndexes.contains(i)).anyMatch(i -> ((VariableOrGroundTerm)rightArgumentMap.get(i)).equals(rightVariable));
    }

    private ImmutableMap<Integer, VariableOrGroundTerm> computeNewRightArgumentMap(ImmutableMap<Integer, ? extends VariableOrGroundTerm> rightArgumentMap, ImmutableList<Integer> conflictingRightArgumentIndexes, VariableGenerator variableGenerator) {
        return (ImmutableMap)rightArgumentMap.entrySet().stream().collect(ImmutableCollectors.toMap(Map.Entry::getKey, e -> conflictingRightArgumentIndexes.contains(e.getKey()) ? variableGenerator.generateNewVariable() : (VariableOrGroundTerm)e.getValue()));
    }

    private ImmutableExpression computeExpression(ImmutableMap<Integer, ? extends VariableOrGroundTerm> formerRightArgumentMap, ImmutableMap<Integer, ? extends VariableOrGroundTerm> newRightArgumentMap) {
        Stream<ImmutableExpression> expressions = formerRightArgumentMap.entrySet().stream().filter(e -> !((VariableOrGroundTerm)e.getValue()).equals(newRightArgumentMap.get(e.getKey()))).map(e -> this.termFactory.getStrictEquality((ImmutableTerm)newRightArgumentMap.get(e.getKey()), (ImmutableTerm)e.getValue(), new ImmutableTerm[0]));
        return (ImmutableExpression)this.termFactory.getConjunction(expressions).orElseThrow(() -> new MinorOntopInternalBugException("A boolean expression was expected"));
    }

    public static class LeftJoinRightChildNormalizationAnalysisImpl
    implements LeftJoinRightChildNormalizationAnalyzer.LeftJoinRightChildNormalizationAnalysis {
        @Nullable
        private final ExtensionalDataNode newRightDataNode;
        @Nullable
        private final ImmutableExpression expression;
        private final boolean isMatchingAConstraint;

        private LeftJoinRightChildNormalizationAnalysisImpl(ExtensionalDataNode newRightDataNode, ImmutableExpression expression) {
            this.newRightDataNode = newRightDataNode;
            this.expression = expression;
            this.isMatchingAConstraint = true;
        }

        private LeftJoinRightChildNormalizationAnalysisImpl(boolean isMatchingAConstraint) {
            this.newRightDataNode = null;
            this.expression = null;
            this.isMatchingAConstraint = isMatchingAConstraint;
        }

        @Override
        public boolean isMatchingAConstraint() {
            return this.isMatchingAConstraint;
        }

        @Override
        public Optional<ExtensionalDataNode> getProposedRightDataNode() {
            return Optional.ofNullable(this.newRightDataNode);
        }

        @Override
        public Optional<ImmutableExpression> getAdditionalExpression() {
            return Optional.ofNullable(this.expression);
        }
    }
}

