/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.iq.executor.join;

import com.google.inject.Inject;
import it.unibz.inf.ontop.com.google.common.collect.ImmutableList;
import it.unibz.inf.ontop.com.google.common.collect.UnmodifiableIterator;
import it.unibz.inf.ontop.iq.IntermediateQuery;
import it.unibz.inf.ontop.iq.node.FilterNode;
import it.unibz.inf.ontop.iq.node.InnerJoinNode;
import it.unibz.inf.ontop.iq.node.JoinOrFilterNode;
import it.unibz.inf.ontop.iq.node.QueryNode;
import it.unibz.inf.ontop.model.term.ImmutableExpression;
import it.unibz.inf.ontop.model.term.ImmutableFunctionalTerm;
import it.unibz.inf.ontop.model.term.TermFactory;
import it.unibz.inf.ontop.utils.CoreUtilsFactory;
import java.util.LinkedList;
import java.util.Optional;

public class JoinExtractionUtils {
    private final TermFactory termFactory;
    private final CoreUtilsFactory coreUtilsFactory;

    @Inject
    private JoinExtractionUtils(TermFactory termFactory, CoreUtilsFactory coreUtilsFactory) {
        this.termFactory = termFactory;
        this.coreUtilsFactory = coreUtilsFactory;
    }

    public Optional<ImmutableExpression> extractFoldAndOptimizeBooleanExpressions(ImmutableList<JoinOrFilterNode> filterAndJoinNodes) throws UnsatisfiableExpressionException {
        ImmutableList<ImmutableExpression> booleanExpressions = JoinExtractionUtils.extractBooleanExpressions(filterAndJoinNodes);
        Optional<ImmutableExpression> foldedExpression = this.foldBooleanExpressions(booleanExpressions);
        if (foldedExpression.isPresent()) {
            ImmutableExpression expression = foldedExpression.get();
            ImmutableExpression.Evaluation evaluationResult = expression.evaluate(this.coreUtilsFactory.createSimplifiedVariableNullability((ImmutableFunctionalTerm)expression));
            if (evaluationResult.isEffectiveFalse()) {
                throw new UnsatisfiableExpressionException();
            }
            return evaluationResult.getExpression();
        }
        return Optional.empty();
    }

    public static ImmutableList<JoinOrFilterNode> extractFilterAndInnerJoinNodes(InnerJoinNode topJoinNode, IntermediateQuery query) {
        ImmutableList.Builder joinAndFilterNodeBuilder = ImmutableList.builder();
        LinkedList<Object> nodesToExplore = new LinkedList<Object>();
        nodesToExplore.add(topJoinNode);
        joinAndFilterNodeBuilder.add((Object)topJoinNode);
        while (!nodesToExplore.isEmpty()) {
            JoinOrFilterNode joinNode = (JoinOrFilterNode)nodesToExplore.poll();
            for (QueryNode child : query.getChildren((QueryNode)joinNode)) {
                if (!(child instanceof InnerJoinNode) && !(child instanceof FilterNode)) continue;
                JoinOrFilterNode joinOrFilterChild = (JoinOrFilterNode)child;
                nodesToExplore.add(joinOrFilterChild);
                joinAndFilterNodeBuilder.add((Object)joinOrFilterChild);
            }
        }
        return joinAndFilterNodeBuilder.build();
    }

    public Optional<ImmutableExpression> foldBooleanExpressions(ImmutableList<ImmutableExpression> booleanExpressions) {
        switch (booleanExpressions.size()) {
            case 0: {
                return Optional.empty();
            }
            case 1: {
                return Optional.of(booleanExpressions.get(0));
            }
        }
        UnmodifiableIterator it = booleanExpressions.iterator();
        ImmutableExpression currentExpression = this.termFactory.getConjunction((ImmutableExpression)it.next(), new ImmutableExpression[]{(ImmutableExpression)it.next()});
        while (it.hasNext()) {
            currentExpression = this.termFactory.getConjunction(currentExpression, new ImmutableExpression[]{(ImmutableExpression)it.next()});
        }
        return Optional.of(currentExpression);
    }

    @Deprecated
    public static ImmutableList<ImmutableExpression> extractBooleanExpressionsFromJoins(InnerJoinNode topJoinNode, IntermediateQuery query) {
        LinkedList<InnerJoinNode> joinNodesToExplore = new LinkedList<InnerJoinNode>();
        joinNodesToExplore.add(topJoinNode);
        ImmutableList.Builder exprListBuilder = ImmutableList.builder();
        while (!joinNodesToExplore.isEmpty()) {
            InnerJoinNode joinNode = (InnerJoinNode)joinNodesToExplore.poll();
            Optional optionalFilterCondition = joinNode.getOptionalFilterCondition();
            if (optionalFilterCondition.isPresent()) {
                exprListBuilder.add(optionalFilterCondition.get());
            }
            for (QueryNode child : query.getChildren((QueryNode)joinNode)) {
                if (child instanceof InnerJoinNode) {
                    joinNodesToExplore.add((InnerJoinNode)child);
                    continue;
                }
                if (!(child instanceof FilterNode)) continue;
                exprListBuilder.add((Object)((FilterNode)child).getFilterCondition());
            }
        }
        return exprListBuilder.build();
    }

    @Deprecated
    public static ImmutableList<QueryNode> extractNonInnerJoinOrFilterNodesFromJoins(InnerJoinNode topJoinNode, IntermediateQuery query) {
        LinkedList<Object> filterOrJoinNodesToExplore = new LinkedList<Object>();
        filterOrJoinNodesToExplore.add(topJoinNode);
        ImmutableList.Builder otherNodeListBuilder = ImmutableList.builder();
        while (!filterOrJoinNodesToExplore.isEmpty()) {
            JoinOrFilterNode node = (JoinOrFilterNode)filterOrJoinNodesToExplore.poll();
            for (QueryNode child : query.getChildren((QueryNode)node)) {
                if (child instanceof InnerJoinNode || child instanceof FilterNode) {
                    filterOrJoinNodesToExplore.add((JoinOrFilterNode)child);
                    continue;
                }
                otherNodeListBuilder.add((Object)child);
            }
        }
        return otherNodeListBuilder.build();
    }

    private static ImmutableList<ImmutableExpression> extractBooleanExpressions(ImmutableList<JoinOrFilterNode> filterAndJoinNodes) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (JoinOrFilterNode node : filterAndJoinNodes) {
            Optional optionalFilterCondition = node.getOptionalFilterCondition();
            if (!optionalFilterCondition.isPresent()) continue;
            builder.add(optionalFilterCondition.get());
        }
        return builder.build();
    }

    public static class UnsatisfiableExpressionException
    extends Exception {
    }
}

