/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.iq.executor.join;

import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import it.unibz.inf.ontop.dbschema.RelationDefinition;
import it.unibz.inf.ontop.exception.MinorOntopInternalBugException;
import it.unibz.inf.ontop.iq.IntermediateQuery;
import it.unibz.inf.ontop.iq.exception.EmptyQueryException;
import it.unibz.inf.ontop.iq.impl.QueryTreeComponent;
import it.unibz.inf.ontop.iq.node.BinaryOrderedOperatorNode;
import it.unibz.inf.ontop.iq.node.ExplicitVariableProjectionNode;
import it.unibz.inf.ontop.iq.node.ExtensionalDataNode;
import it.unibz.inf.ontop.iq.node.FilterNode;
import it.unibz.inf.ontop.iq.node.JoinLikeNode;
import it.unibz.inf.ontop.iq.node.JoinOrFilterNode;
import it.unibz.inf.ontop.iq.node.LeftJoinNode;
import it.unibz.inf.ontop.iq.node.QueryNode;
import it.unibz.inf.ontop.iq.proposal.NodeCentricOptimizationResults;
import it.unibz.inf.ontop.iq.proposal.impl.NodeCentricOptimizationResultsImpl;
import it.unibz.inf.ontop.iq.proposal.impl.SubstitutionPropagationProposalImpl;
import it.unibz.inf.ontop.model.term.ImmutableExpression;
import it.unibz.inf.ontop.model.term.TermFactory;
import it.unibz.inf.ontop.model.term.Variable;
import it.unibz.inf.ontop.model.term.VariableOrGroundTerm;
import it.unibz.inf.ontop.substitution.ImmutableSubstitution;
import it.unibz.inf.ontop.substitution.impl.ImmutableUnificationTools;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SelfJoinLikeExecutor {
    private static final Logger LOGGER = LoggerFactory.getLogger(SelfJoinLikeExecutor.class);
    private final ImmutableUnificationTools unificationTools;
    private final TermFactory termFactory;

    protected SelfJoinLikeExecutor(ImmutableUnificationTools unificationTools, TermFactory termFactory) {
        this.unificationTools = unificationTools;
        this.termFactory = termFactory;
    }

    protected static ImmutableMultimap<RelationDefinition, ExtensionalDataNode> extractDataNodes(ImmutableList<QueryNode> siblings) {
        ImmutableMultimap.Builder mapBuilder = ImmutableMultimap.builder();
        for (QueryNode node : siblings) {
            if (!(node instanceof ExtensionalDataNode)) continue;
            ExtensionalDataNode dataNode = (ExtensionalDataNode)node;
            mapBuilder.put((Object)dataNode.getRelationDefinition(), (Object)dataNode);
        }
        return mapBuilder.build();
    }

    protected Optional<ImmutableSubstitution<VariableOrGroundTerm>> mergeSubstitutions(ImmutableList<ImmutableSubstitution<VariableOrGroundTerm>> substitutions, ImmutableMultimap<RelationDefinition, ExtensionalDataNode> initialDataNodeMap, ImmutableList<Variable> priorityVariables) throws AtomUnificationException {
        ImmutableMap occurrenceVariableMap = ((ImmutableMultimap)initialDataNodeMap.asMap().entrySet().stream().flatMap(e -> ((Collection)e.getValue()).stream().flatMap(n -> n.getVariables().stream()).map(v -> Maps.immutableEntry((Object)v, e.getKey()))).collect(ImmutableCollectors.toMultimap())).asMap();
        ImmutableSet sharedVariables = (ImmutableSet)occurrenceVariableMap.entrySet().stream().filter(e -> ImmutableSet.copyOf((Collection)((Collection)e.getValue())).size() > 1).map(Map.Entry::getKey).collect(ImmutableCollectors.toSet());
        ImmutableSet nonSharedVariables = Sets.difference((Set)occurrenceVariableMap.keySet(), (Set)sharedVariables).immutableCopy();
        ImmutableList.Builder nonSharedSubstitutionListBuilder = ImmutableList.builder();
        Optional optionalAccumulatedSubstitution = Optional.empty();
        for (ImmutableSubstitution substitution : substitutions) {
            if (substitution.isEmpty()) continue;
            if (optionalAccumulatedSubstitution.isPresent()) {
                ImmutableSubstitution substitutionToUnify;
                Optional optionalMGUS;
                ImmutableSubstitution accumulatedSubstitution = (ImmutableSubstitution)optionalAccumulatedSubstitution.get();
                ImmutableSubstitution nonSharedSubstitution = accumulatedSubstitution.reduceDomainToIntersectionWith(nonSharedVariables);
                if (!nonSharedSubstitution.isEmpty()) {
                    nonSharedSubstitutionListBuilder.add((Object)nonSharedSubstitution);
                }
                if ((optionalMGUS = this.unificationTools.computeAtomMGUS(substitutionToUnify = nonSharedSubstitution.isEmpty() ? accumulatedSubstitution : accumulatedSubstitution.reduceDomainToIntersectionWith(sharedVariables), substitution)).isPresent()) {
                    optionalAccumulatedSubstitution = optionalMGUS;
                    continue;
                }
                throw new AtomUnificationException();
            }
            optionalAccumulatedSubstitution = Optional.of(substitution);
        }
        return optionalAccumulatedSubstitution.map(s -> Stream.concat(nonSharedSubstitutionListBuilder.build().stream(), Stream.of(s)).reduce((v1, v2) -> v2.composeWith2(v1)).orElseThrow(() -> new MinorOntopInternalBugException("At least one substitution was expected"))).map(s -> s.orientate(priorityVariables));
    }

    protected ImmutableList<ImmutableSubstitution<VariableOrGroundTerm>> extractSubstitutions(ImmutableCollection<PredicateLevelProposal> predicateProposals) {
        ImmutableList.Builder substitutionListBuilder = ImmutableList.builder();
        for (PredicateLevelProposal proposal : predicateProposals) {
            substitutionListBuilder.addAll(proposal.getSubstitutions());
        }
        return substitutionListBuilder.build();
    }

    protected <N extends JoinOrFilterNode> NodeCentricOptimizationResults<N> updateJoinNodeAndPropagateSubstitution(IntermediateQuery query, QueryTreeComponent treeComponent, N joinNode, ConcreteProposal proposal) throws EmptyQueryException {
        Optional optionalFilter = joinNode.getOptionalFilterCondition().map(f -> proposal.getOptionalIsNotNullExpression().map(f2 -> this.termFactory.getConjunction(f, new ImmutableExpression[]{f2})).orElse((ImmutableExpression)f)).map(Optional::of).orElseGet(proposal::getOptionalIsNotNullExpression);
        switch (treeComponent.getChildren(joinNode).size()) {
            case 0: {
                throw new IllegalStateException("Self-join elimination MUST not eliminate ALL the nodes");
            }
            case 1: {
                QueryNode uniqueChild = (QueryNode)treeComponent.getFirstChild(joinNode).get();
                if (optionalFilter.isPresent()) {
                    FilterNode filterNode = query.getFactory().createFilterNode((ImmutableExpression)optionalFilter.get());
                    treeComponent.replaceNode(joinNode, (QueryNode)filterNode);
                } else {
                    treeComponent.removeOrReplaceNodeByUniqueChild(joinNode);
                }
                NodeCentricOptimizationResults<QueryNode> propagationResults = SelfJoinLikeExecutor.propagateSubstitution(query, proposal.getOptionalSubstitution(), uniqueChild);
                return propagationResults.getNewNodeOrReplacingChild().map(child -> new NodeCentricOptimizationResultsImpl(query, Optional.of(child))).orElseGet(() -> new NodeCentricOptimizationResultsImpl(query, propagationResults.getOptionalNextSibling(), propagationResults.getOptionalClosestAncestor()));
            }
        }
        JoinOrFilterNode newJoinNode = optionalFilter.map(cond -> {
            FilterNode parentFilter = query.getFactory().createFilterNode(cond);
            treeComponent.insertParent((QueryNode)joinNode, (QueryNode)parentFilter);
            JoinLikeNode conditionLessJoinNode = ((JoinLikeNode)joinNode).changeOptionalFilterCondition(Optional.empty());
            treeComponent.replaceNode((QueryNode)joinNode, (QueryNode)conditionLessJoinNode);
            return conditionLessJoinNode;
        }).orElse(joinNode);
        return SelfJoinLikeExecutor.propagateSubstitution(query, proposal.getOptionalSubstitution(), newJoinNode);
    }

    private static <T extends QueryNode> NodeCentricOptimizationResults<T> propagateSubstitution(IntermediateQuery query, Optional<ImmutableSubstitution<VariableOrGroundTerm>> optionalSubstitution, T topNode) throws EmptyQueryException {
        if (optionalSubstitution.isPresent()) {
            SubstitutionPropagationProposalImpl<T> propagationProposal = new SubstitutionPropagationProposalImpl<T>(topNode, optionalSubstitution.get(), false);
            return (NodeCentricOptimizationResults)query.applyProposal(propagationProposal, true);
        }
        return new NodeCentricOptimizationResultsImpl<T>(query, topNode);
    }

    protected ImmutableList<Variable> prioritizeVariables(IntermediateQuery query, JoinLikeNode joinLikeNode) {
        return (ImmutableList)((Stream)this.extractAncestors(query, (QueryNode)joinLikeNode).stream().sequential()).flatMap(p -> this.extractPriorityVariables(query, p.parent, p.position)).distinct().collect(ImmutableCollectors.toList());
    }

    private ImmutableList<ParentAndChildPosition> extractAncestors(IntermediateQuery query, QueryNode node) {
        Optional optionalAncestor = query.getParent(node);
        QueryNode ancestorChild = node;
        ImmutableList.Builder listBuilder = ImmutableList.builder();
        while (optionalAncestor.isPresent()) {
            QueryNode ancestor = (QueryNode)optionalAncestor.get();
            listBuilder.add((Object)new ParentAndChildPosition(ancestor, query.getOptionalPosition(ancestor, ancestorChild)));
            optionalAncestor = query.getParent(ancestor);
            ancestorChild = ancestor;
        }
        return listBuilder.build();
    }

    private Stream<Variable> extractPriorityVariables(IntermediateQuery query, QueryNode node, Optional<BinaryOrderedOperatorNode.ArgumentPosition> childPosition) {
        if (node instanceof ExplicitVariableProjectionNode) {
            return ((ExplicitVariableProjectionNode)node).getVariables().stream();
        }
        if (node instanceof LeftJoinNode) {
            switch (childPosition.get()) {
                case RIGHT: {
                    return query.getChild(node, BinaryOrderedOperatorNode.ArgumentPosition.LEFT).map(c -> query.getVariables(c).stream()).orElseThrow(() -> new IllegalStateException("A LJ must have a left child"));
                }
            }
            return Stream.empty();
        }
        return Stream.empty();
    }

    private static class ParentAndChildPosition {
        public final QueryNode parent;
        public final Optional<BinaryOrderedOperatorNode.ArgumentPosition> position;

        private ParentAndChildPosition(QueryNode parent, Optional<BinaryOrderedOperatorNode.ArgumentPosition> position) {
            this.parent = parent;
            this.position = position;
        }
    }

    protected static class ConcreteProposal {
        private final Optional<ImmutableSubstitution<VariableOrGroundTerm>> optionalSubstitution;
        private final Optional<ImmutableExpression> optionalIsNotNullExpression;

        public ConcreteProposal(Optional<ImmutableSubstitution<VariableOrGroundTerm>> optionalSubstitution, Optional<ImmutableExpression> optionalIsNotNullExpression) {
            this.optionalSubstitution = optionalSubstitution;
            this.optionalIsNotNullExpression = optionalIsNotNullExpression;
        }

        public Optional<ImmutableSubstitution<VariableOrGroundTerm>> getOptionalSubstitution() {
            return this.optionalSubstitution;
        }

        public Optional<ImmutableExpression> getOptionalIsNotNullExpression() {
            return this.optionalIsNotNullExpression;
        }
    }

    protected static class PredicateLevelProposal {
        private final ImmutableCollection<ImmutableSubstitution<VariableOrGroundTerm>> substitutions;
        private final Optional<ImmutableExpression> isNotNullConjunction;

        public PredicateLevelProposal(ImmutableCollection<ImmutableSubstitution<VariableOrGroundTerm>> substitutions, Optional<ImmutableExpression> isNotNullConjunction) {
            this.substitutions = substitutions;
            this.isNotNullConjunction = isNotNullConjunction;
        }

        public ImmutableCollection<ImmutableSubstitution<VariableOrGroundTerm>> getSubstitutions() {
            return this.substitutions;
        }

        public Optional<ImmutableExpression> getIsNotNullConjunction() {
            return this.isNotNullConjunction;
        }
    }

    protected static final class AtomUnificationException
    extends Exception {
        protected AtomUnificationException() {
        }
    }
}

