/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.iq.transformer.impl;

import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import it.unibz.inf.ontop.com.google.common.collect.ImmutableList;
import it.unibz.inf.ontop.com.google.common.collect.ImmutableMap;
import it.unibz.inf.ontop.com.google.common.collect.ImmutableMultiset;
import it.unibz.inf.ontop.com.google.common.collect.ImmutableSet;
import it.unibz.inf.ontop.com.google.common.collect.Multiset;
import it.unibz.inf.ontop.com.google.common.collect.UnmodifiableIterator;
import it.unibz.inf.ontop.exception.OntopInternalBugException;
import it.unibz.inf.ontop.injection.IntermediateQueryFactory;
import it.unibz.inf.ontop.iq.BinaryNonCommutativeIQTree;
import it.unibz.inf.ontop.iq.IQTree;
import it.unibz.inf.ontop.iq.UnaryIQTree;
import it.unibz.inf.ontop.iq.node.BinaryNonCommutativeOperatorNode;
import it.unibz.inf.ontop.iq.node.ConstructionNode;
import it.unibz.inf.ontop.iq.node.DistinctNode;
import it.unibz.inf.ontop.iq.node.ExtensionalDataNode;
import it.unibz.inf.ontop.iq.node.FilterNode;
import it.unibz.inf.ontop.iq.node.InnerJoinNode;
import it.unibz.inf.ontop.iq.node.IntensionalDataNode;
import it.unibz.inf.ontop.iq.node.LeftJoinNode;
import it.unibz.inf.ontop.iq.node.NaryOperatorNode;
import it.unibz.inf.ontop.iq.node.QueryNode;
import it.unibz.inf.ontop.iq.node.SliceNode;
import it.unibz.inf.ontop.iq.node.UnaryOperatorNode;
import it.unibz.inf.ontop.iq.transform.IQTreeTransformer;
import it.unibz.inf.ontop.iq.transform.impl.ChildTransformer;
import it.unibz.inf.ontop.iq.transform.impl.CompositeIQTreeTransformer;
import it.unibz.inf.ontop.iq.transform.impl.DefaultNonRecursiveIQTreeTransformer;
import it.unibz.inf.ontop.iq.transformer.ExplicitEqualityTransformer;
import it.unibz.inf.ontop.model.atom.AtomFactory;
import it.unibz.inf.ontop.model.atom.AtomPredicate;
import it.unibz.inf.ontop.model.atom.DataAtom;
import it.unibz.inf.ontop.model.term.GroundTerm;
import it.unibz.inf.ontop.model.term.ImmutableExpression;
import it.unibz.inf.ontop.model.term.ImmutableTerm;
import it.unibz.inf.ontop.model.term.TermFactory;
import it.unibz.inf.ontop.model.term.Variable;
import it.unibz.inf.ontop.model.term.VariableOrGroundTerm;
import it.unibz.inf.ontop.substitution.ImmutableSubstitution;
import it.unibz.inf.ontop.substitution.InjectiveVar2VarSubstitution;
import it.unibz.inf.ontop.substitution.ProtoSubstitution;
import it.unibz.inf.ontop.substitution.SubstitutionFactory;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import it.unibz.inf.ontop.utils.VariableGenerator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;

public class ExplicitEqualityTransformerImpl
implements ExplicitEqualityTransformer {
    private final IntermediateQueryFactory iqFactory;
    private final AtomFactory atomFactory;
    private final TermFactory termFactory;
    private final VariableGenerator variableGenerator;
    private final SubstitutionFactory substitutionFactory;
    private final CompositeIQTreeTransformer compositeTransformer;

    @AssistedInject
    public ExplicitEqualityTransformerImpl(@Assisted VariableGenerator variableGenerator, IntermediateQueryFactory iqFactory, AtomFactory atomFactory, TermFactory termFactory, SubstitutionFactory substitutionFactory) {
        this.iqFactory = iqFactory;
        this.atomFactory = atomFactory;
        this.termFactory = termFactory;
        this.variableGenerator = variableGenerator;
        this.substitutionFactory = substitutionFactory;
        ImmutableList preTransformers = ImmutableList.of((Object)((Object)new LocalExplicitEqualityEnforcer()));
        ImmutableList postTransformers = ImmutableList.of((Object)((Object)new CnLifter()), (Object)((Object)new FilterChildNormalizer(iqFactory)));
        this.compositeTransformer = new CompositeIQTreeTransformer(preTransformers, postTransformers, iqFactory);
    }

    public IQTree transform(IQTree tree) {
        return this.compositeTransformer.transform(tree);
    }

    private ImmutableExpression getConjunction(Stream<ImmutableExpression> expressions) {
        return this.termFactory.getConjunction((ImmutableList)expressions.flatMap(ImmutableExpression::flattenAND).collect(ImmutableCollectors.toList()));
    }

    private ImmutableExpression getConjunction(Optional<ImmutableExpression> optExpression, Stream<ImmutableExpression> expressions) {
        return this.getConjunction(optExpression.isPresent() ? Stream.concat(Stream.of(optExpression.get()), expressions) : expressions);
    }

    private class ExplicitEqualityTransformerInternalException
    extends OntopInternalBugException {
        ExplicitEqualityTransformerInternalException(String message) {
            super(message);
        }
    }

    class CnLifter
    extends DefaultNonRecursiveIQTreeTransformer {
        CnLifter() {
        }

        public IQTree transformDistinct(IQTree tree, DistinctNode rootNode, IQTree child) {
            return tree;
        }

        public IQTree transformSlice(IQTree tree, SliceNode rootNode, IQTree child) {
            return tree;
        }

        public IQTree transformUnaryNode(IQTree tree, UnaryOperatorNode rootNode, IQTree child) {
            ImmutableList<ConstructionNode> idleCns = this.getIdleCns(Stream.of(child));
            return idleCns.isEmpty() ? tree : this.getProjection((ImmutableSet<Variable>)tree.getVariables(), (IQTree)ExplicitEqualityTransformerImpl.this.iqFactory.createUnaryIQTree(rootNode, this.trimIdleCn(child)));
        }

        protected IQTree transformNaryCommutativeNode(IQTree tree, NaryOperatorNode rootNode, ImmutableList<IQTree> children) {
            ImmutableList<ConstructionNode> idleCns = this.getIdleCns(children.stream());
            return idleCns.isEmpty() ? tree : this.getProjection((ImmutableSet<Variable>)tree.getVariables(), (IQTree)ExplicitEqualityTransformerImpl.this.iqFactory.createNaryIQTree(rootNode, (ImmutableList)children.stream().map(this::trimIdleCn).collect(ImmutableCollectors.toList())));
        }

        protected IQTree transformBinaryNonCommutativeNode(IQTree tree, BinaryNonCommutativeOperatorNode rootNode, IQTree leftChild, IQTree rightChild) {
            ImmutableList<ConstructionNode> idleCns = this.getIdleCns(Stream.of(leftChild, rightChild));
            return idleCns.isEmpty() ? tree : this.getProjection((ImmutableSet<Variable>)tree.getVariables(), (IQTree)ExplicitEqualityTransformerImpl.this.iqFactory.createBinaryNonCommutativeIQTree(rootNode, this.trimIdleCn(leftChild), this.trimIdleCn(rightChild)));
        }

        private ImmutableList<ConstructionNode> getIdleCns(Stream<IQTree> trees) {
            return (ImmutableList)trees.map(this::getIdleCn).filter(Optional::isPresent).map(Optional::get).collect(ImmutableCollectors.toList());
        }

        private Optional<ConstructionNode> getIdleCn(IQTree tree) {
            ConstructionNode cn;
            QueryNode root = tree.getRootNode();
            if (root instanceof ConstructionNode && (cn = (ConstructionNode)root).getSubstitution().isEmpty()) {
                return Optional.of(cn);
            }
            return Optional.empty();
        }

        private IQTree trimIdleCn(IQTree tree) {
            return this.getIdleCn(tree).isPresent() ? ((UnaryIQTree)tree).getChild() : tree;
        }

        private IQTree getProjection(ImmutableSet<Variable> signature, IQTree tree) {
            QueryNode root = tree.getRootNode();
            if (root instanceof ConstructionNode) {
                return ExplicitEqualityTransformerImpl.this.iqFactory.createUnaryIQTree((UnaryOperatorNode)ExplicitEqualityTransformerImpl.this.iqFactory.createConstructionNode(signature, ((ConstructionNode)root).getSubstitution()), ((UnaryIQTree)tree).getChild());
            }
            return ExplicitEqualityTransformerImpl.this.iqFactory.createUnaryIQTree((UnaryOperatorNode)ExplicitEqualityTransformerImpl.this.iqFactory.createConstructionNode(signature), tree);
        }
    }

    class FilterChildNormalizer
    extends DefaultNonRecursiveIQTreeTransformer {
        private final ChildTransformer childTransformer;

        public FilterChildNormalizer(IntermediateQueryFactory iqFactory) {
            this.childTransformer = new ChildTransformer(iqFactory, (IQTreeTransformer)this);
        }

        public IQTree transformLeftJoin(IQTree tree, LeftJoinNode rootNode, IQTree leftChild, IQTree rightChild) {
            Optional<ImmutableExpression> leftChildChildExpression = this.getOptionalChildExpression(leftChild);
            Optional<ImmutableExpression> rightChildExpression = this.getOptionalChildExpression(rightChild);
            if (leftChildChildExpression.isPresent() || rightChildExpression.isPresent()) {
                BinaryNonCommutativeIQTree leftJoinTree = ExplicitEqualityTransformerImpl.this.iqFactory.createBinaryNonCommutativeIQTree((BinaryNonCommutativeOperatorNode)(rightChildExpression.isPresent() ? ExplicitEqualityTransformerImpl.this.iqFactory.createLeftJoinNode(Optional.of(this.updateJoinCondition(rootNode.getOptionalFilterCondition(), (ImmutableList<ImmutableExpression>)ImmutableList.of((Object)rightChildExpression.get())))) : rootNode), this.trimRootFilter(leftChild), this.trimRootFilter(rightChild));
                return leftChildChildExpression.isPresent() ? ExplicitEqualityTransformerImpl.this.iqFactory.createUnaryIQTree((UnaryOperatorNode)ExplicitEqualityTransformerImpl.this.iqFactory.createFilterNode(leftChildChildExpression.get()), (IQTree)leftJoinTree) : leftJoinTree;
            }
            return tree;
        }

        public IQTree transformInnerJoin(IQTree tree, InnerJoinNode rootNode, ImmutableList<IQTree> children) {
            ImmutableList<ImmutableExpression> filterChildExpressions = this.getChildExpressions(children);
            if (filterChildExpressions.isEmpty()) {
                return tree;
            }
            return ExplicitEqualityTransformerImpl.this.iqFactory.createNaryIQTree((NaryOperatorNode)ExplicitEqualityTransformerImpl.this.iqFactory.createInnerJoinNode(Optional.of(this.updateJoinCondition(rootNode.getOptionalFilterCondition(), filterChildExpressions))), (ImmutableList)children.stream().map(this::trimRootFilter).collect(ImmutableCollectors.toList()));
        }

        public IQTree transformFilter(IQTree tree, FilterNode rootNode, IQTree child) {
            ImmutableList<ImmutableExpression> filterChildExpressions = this.getChildExpressions((ImmutableList<IQTree>)ImmutableList.of((Object)child));
            if (filterChildExpressions.isEmpty()) {
                return tree;
            }
            return ExplicitEqualityTransformerImpl.this.iqFactory.createUnaryIQTree((UnaryOperatorNode)ExplicitEqualityTransformerImpl.this.iqFactory.createFilterNode(this.updateJoinCondition(Optional.of(rootNode.getFilterCondition()), filterChildExpressions)), this.trimRootFilter(child));
        }

        private ImmutableList<ImmutableExpression> getChildExpressions(ImmutableList<IQTree> children) {
            return (ImmutableList)children.stream().filter(t -> t.getRootNode() instanceof FilterNode).map(t -> ((FilterNode)t.getRootNode()).getFilterCondition()).collect(ImmutableCollectors.toList());
        }

        private Optional<ImmutableExpression> getOptionalChildExpression(IQTree child) {
            QueryNode root = child.getRootNode();
            return root instanceof FilterNode ? Optional.of(((FilterNode)root).getFilterCondition()) : Optional.empty();
        }

        private IQTree trimRootFilter(IQTree tree) {
            return tree.getRootNode() instanceof FilterNode ? ((UnaryIQTree)tree).getChild() : tree;
        }

        private ImmutableExpression updateJoinCondition(Optional<ImmutableExpression> joinCondition, ImmutableList<ImmutableExpression> additionalConditions) {
            if (additionalConditions.isEmpty()) {
                throw new ExplicitEqualityTransformerInternalException("Nonempty list of filters expected");
            }
            return ExplicitEqualityTransformerImpl.this.getConjunction(joinCondition, additionalConditions.stream());
        }

        protected IQTree transformUnaryNode(IQTree tree, UnaryOperatorNode rootNode, IQTree child) {
            return this.childTransformer.transform(tree);
        }

        protected IQTree transformNaryCommutativeNode(IQTree tree, NaryOperatorNode rootNode, ImmutableList<IQTree> children) {
            return this.childTransformer.transform(tree);
        }

        protected IQTree transformBinaryNonCommutativeNode(IQTree tree, BinaryNonCommutativeOperatorNode rootNode, IQTree leftChild, IQTree rightChild) {
            return this.childTransformer.transform(tree);
        }
    }

    class LocalExplicitEqualityEnforcer
    extends DefaultNonRecursiveIQTreeTransformer {
        LocalExplicitEqualityEnforcer() {
        }

        public IQTree transformIntensionalData(IntensionalDataNode dn) {
            return this.transformIntensionalDataNode(dn);
        }

        public IQTree transformExtensionalData(ExtensionalDataNode dn) {
            return this.transformExtensionalDataNode(dn);
        }

        public IQTree transformInnerJoin(IQTree tree, InnerJoinNode rootNode, ImmutableList<IQTree> children) {
            ImmutableList<InjectiveVar2VarSubstitution> substitutions = this.computeSubstitutions(children);
            if (substitutions.stream().allMatch(ProtoSubstitution::isEmpty)) {
                return tree;
            }
            ImmutableList<IQTree> updatedChildren = this.updateJoinChildren(substitutions, children);
            return ExplicitEqualityTransformerImpl.this.iqFactory.createUnaryIQTree((UnaryOperatorNode)ExplicitEqualityTransformerImpl.this.iqFactory.createConstructionNode(tree.getVariables()), (IQTree)ExplicitEqualityTransformerImpl.this.iqFactory.createNaryIQTree((NaryOperatorNode)ExplicitEqualityTransformerImpl.this.iqFactory.createInnerJoinNode(Optional.of(this.updateJoinCondition(rootNode.getOptionalFilterCondition(), substitutions))), updatedChildren));
        }

        public IQTree transformLeftJoin(IQTree tree, LeftJoinNode rootNode, IQTree leftChild, IQTree rightChild) {
            ImmutableList children = ImmutableList.of((Object)leftChild, (Object)rightChild);
            ImmutableList<InjectiveVar2VarSubstitution> substitutions = this.computeSubstitutions((ImmutableList<IQTree>)children);
            if (substitutions.stream().allMatch(ProtoSubstitution::isEmpty)) {
                return tree;
            }
            ImmutableList<IQTree> updatedChildren = this.updateJoinChildren(substitutions, (ImmutableList<IQTree>)children);
            return ExplicitEqualityTransformerImpl.this.iqFactory.createUnaryIQTree((UnaryOperatorNode)ExplicitEqualityTransformerImpl.this.iqFactory.createConstructionNode(tree.getVariables()), (IQTree)ExplicitEqualityTransformerImpl.this.iqFactory.createBinaryNonCommutativeIQTree((BinaryNonCommutativeOperatorNode)ExplicitEqualityTransformerImpl.this.iqFactory.createLeftJoinNode(Optional.of(this.updateJoinCondition(rootNode.getOptionalFilterCondition(), substitutions))), (IQTree)updatedChildren.get(0), (IQTree)updatedChildren.get(1)));
        }

        private ImmutableList<InjectiveVar2VarSubstitution> computeSubstitutions(ImmutableList<IQTree> children) {
            if (children.size() < 2) {
                throw new ExplicitEqualityTransformerInternalException("At least 2 children are expected");
            }
            ImmutableSet repeatedVariables = (ImmutableSet)((ImmutableMultiset)children.stream().flatMap(t -> t.getVariables().stream()).collect(ImmutableCollectors.toMultiset())).entrySet().stream().filter(e -> e.getCount() > 1).map(Multiset.Entry::getElement).collect(ImmutableCollectors.toSet());
            return (ImmutableList)((Stream)children.stream().sequential()).map(t -> this.computeSubstitution((ImmutableSet<Variable>)repeatedVariables, children, (IQTree)t)).collect(ImmutableCollectors.toList());
        }

        private ImmutableList<IQTree> updateJoinChildren(ImmutableList<InjectiveVar2VarSubstitution> substitutions, ImmutableList<IQTree> children) {
            UnmodifiableIterator it = children.iterator();
            return (ImmutableList)((Stream)substitutions.stream().sequential()).map(arg_0 -> LocalExplicitEqualityEnforcer.lambda$updateJoinChildren$3((Iterator)it, arg_0)).collect(ImmutableCollectors.toList());
        }

        private InjectiveVar2VarSubstitution computeSubstitution(ImmutableSet<Variable> repeatedVars, ImmutableList<IQTree> children, IQTree tree) {
            return ExplicitEqualityTransformerImpl.this.substitutionFactory.getInjectiveVar2VarSubstitution((Map)tree.getVariables().stream().filter(arg_0 -> repeatedVars.contains(arg_0)).filter(v -> !this.isFirstOcc((Variable)v, children, tree)).collect(ImmutableCollectors.toMap(v -> v, arg_0 -> ((VariableGenerator)ExplicitEqualityTransformerImpl.this.variableGenerator).generateNewVariableFromVar(arg_0))));
        }

        private boolean isFirstOcc(Variable variable, ImmutableList<IQTree> children, IQTree tree) {
            return ((Stream)children.stream().sequential()).filter(t -> t.getVariables().contains((Object)variable)).findFirst().get().equals(tree);
        }

        private ImmutableExpression updateJoinCondition(Optional<ImmutableExpression> optionalFilterCondition, ImmutableList<InjectiveVar2VarSubstitution> substitutions) {
            Stream<ImmutableExpression> varEqualities = this.extractEqualities(substitutions);
            return ExplicitEqualityTransformerImpl.this.getConjunction(optionalFilterCondition, varEqualities);
        }

        private Stream<ImmutableExpression> extractEqualities(ImmutableList<InjectiveVar2VarSubstitution> substitutions) {
            return substitutions.stream().flatMap(s -> s.getImmutableMap().entrySet().stream()).map(e -> ExplicitEqualityTransformerImpl.this.termFactory.getStrictEquality((ImmutableTerm)e.getKey(), (ImmutableTerm)e.getValue(), new ImmutableTerm[0]));
        }

        private IQTree transformIntensionalDataNode(IntensionalDataNode dn) {
            ImmutableList<Optional<Variable>> replacementVars = this.getArgumentReplacement(dn.getProjectionAtom());
            if (this.empt(replacementVars)) {
                return dn;
            }
            FilterNode filter = this.createFilter(dn.getProjectionAtom(), replacementVars);
            DataAtom atom = this.replaceVars(dn.getProjectionAtom(), replacementVars);
            return ExplicitEqualityTransformerImpl.this.iqFactory.createUnaryIQTree((UnaryOperatorNode)ExplicitEqualityTransformerImpl.this.iqFactory.createConstructionNode(dn.getVariables()), (IQTree)ExplicitEqualityTransformerImpl.this.iqFactory.createUnaryIQTree((UnaryOperatorNode)filter, (IQTree)dn.newAtom(atom)));
        }

        private IQTree transformExtensionalDataNode(ExtensionalDataNode dn) {
            ImmutableMap initialArgumentMap = dn.getArgumentMap();
            ImmutableMap<Integer, Variable> replacementVars = this.getArgumentReplacement((ImmutableMap<Integer, ? extends VariableOrGroundTerm>)initialArgumentMap);
            if (replacementVars.isEmpty()) {
                return dn;
            }
            FilterNode filter = this.createFilter((ImmutableMap<Integer, ? extends VariableOrGroundTerm>)initialArgumentMap, replacementVars);
            ImmutableMap<Integer, ? extends VariableOrGroundTerm> newArgumentMap = this.replaceVars((ImmutableMap<Integer, ? extends VariableOrGroundTerm>)initialArgumentMap, replacementVars);
            return ExplicitEqualityTransformerImpl.this.iqFactory.createUnaryIQTree((UnaryOperatorNode)ExplicitEqualityTransformerImpl.this.iqFactory.createConstructionNode(dn.getVariables()), (IQTree)ExplicitEqualityTransformerImpl.this.iqFactory.createUnaryIQTree((UnaryOperatorNode)filter, (IQTree)ExplicitEqualityTransformerImpl.this.iqFactory.createExtensionalDataNode(dn.getRelationDefinition(), newArgumentMap)));
        }

        private boolean empt(ImmutableList<Optional<Variable>> replacementVars) {
            return replacementVars.stream().noneMatch(Optional::isPresent);
        }

        private <P extends AtomPredicate> DataAtom<P> replaceVars(DataAtom<P> projectionAtom, ImmutableList<Optional<Variable>> replacements) {
            UnmodifiableIterator it = replacements.iterator();
            return ExplicitEqualityTransformerImpl.this.atomFactory.getDataAtom(projectionAtom.getPredicate(), (ImmutableList)projectionAtom.getArguments().stream().map(arg_0 -> LocalExplicitEqualityEnforcer.lambda$replaceVars$9((Iterator)it, arg_0)).collect(ImmutableCollectors.toList()));
        }

        private ImmutableMap<Integer, ? extends VariableOrGroundTerm> replaceVars(ImmutableMap<Integer, ? extends VariableOrGroundTerm> argumentMap, ImmutableMap<Integer, Variable> replacements) {
            return (ImmutableMap)argumentMap.entrySet().stream().collect(ImmutableCollectors.toMap(Map.Entry::getKey, e -> Optional.ofNullable((VariableOrGroundTerm)replacements.get(e.getKey())).orElseGet(e::getValue)));
        }

        private ImmutableList<Optional<Variable>> getArgumentReplacement(DataAtom dataAtom) {
            HashSet<Variable> vars = new HashSet<Variable>();
            ArrayList replacements = new ArrayList();
            for (VariableOrGroundTerm term : dataAtom.getArguments()) {
                if (term instanceof GroundTerm) {
                    replacements.add(Optional.of(ExplicitEqualityTransformerImpl.this.variableGenerator.generateNewVariable()));
                    continue;
                }
                if (!(term instanceof Variable)) continue;
                Variable var = (Variable)term;
                if (vars.contains(var)) {
                    replacements.add(Optional.of(ExplicitEqualityTransformerImpl.this.variableGenerator.generateNewVariableFromVar(var)));
                    continue;
                }
                replacements.add(Optional.empty());
                vars.add(var);
            }
            return ImmutableList.copyOf(replacements);
        }

        private ImmutableMap<Integer, Variable> getArgumentReplacement(ImmutableMap<Integer, ? extends VariableOrGroundTerm> argumentMap) {
            HashSet<Variable> vars = new HashSet<Variable>();
            HashMap replacementMap = new HashMap();
            for (Map.Entry entry : argumentMap.entrySet()) {
                VariableOrGroundTerm term = (VariableOrGroundTerm)entry.getValue();
                if (term instanceof GroundTerm) {
                    replacementMap.put(entry.getKey(), ExplicitEqualityTransformerImpl.this.variableGenerator.generateNewVariable());
                    continue;
                }
                if (!(term instanceof Variable)) continue;
                Variable var = (Variable)term;
                if (vars.contains(var)) {
                    replacementMap.put(entry.getKey(), ExplicitEqualityTransformerImpl.this.variableGenerator.generateNewVariableFromVar(var));
                    continue;
                }
                vars.add(var);
            }
            return ImmutableMap.copyOf(replacementMap);
        }

        private FilterNode createFilter(DataAtom da, ImmutableList<Optional<Variable>> replacementVars) {
            UnmodifiableIterator it = replacementVars.iterator();
            return ExplicitEqualityTransformerImpl.this.iqFactory.createFilterNode(ExplicitEqualityTransformerImpl.this.getConjunction(da.getArguments().stream().map(arg_0 -> this.lambda$createFilter$11((Iterator)it, arg_0)).filter(e -> ((Optional)e).isPresent()).map(e -> ((Optional)e).get())));
        }

        private FilterNode createFilter(ImmutableMap<Integer, ? extends VariableOrGroundTerm> initialArgumentMap, ImmutableMap<Integer, Variable> replacementVars) {
            return ExplicitEqualityTransformerImpl.this.iqFactory.createFilterNode(ExplicitEqualityTransformerImpl.this.getConjunction(replacementVars.entrySet().stream().map(e -> ExplicitEqualityTransformerImpl.this.termFactory.getStrictEquality((ImmutableTerm)initialArgumentMap.get(e.getKey()), (ImmutableTerm)e.getValue(), new ImmutableTerm[0]))));
        }

        private Optional<ImmutableExpression> getEquality(VariableOrGroundTerm t, Optional<Variable> replacement) {
            return replacement.map(variable -> ExplicitEqualityTransformerImpl.this.termFactory.getStrictEquality((ImmutableTerm)t, (ImmutableTerm)variable, new ImmutableTerm[0]));
        }

        private /* synthetic */ Object lambda$createFilter$11(Iterator it, Object a) {
            return this.getEquality((VariableOrGroundTerm)a, (Optional)it.next());
        }

        private static /* synthetic */ VariableOrGroundTerm lambda$replaceVars$9(Iterator it, VariableOrGroundTerm a) {
            Optional r = (Optional)it.next();
            return r.isPresent() ? (VariableOrGroundTerm)r.get() : a;
        }

        private static /* synthetic */ IQTree lambda$updateJoinChildren$3(Iterator it, InjectiveVar2VarSubstitution s) {
            return ((IQTree)it.next()).applyDescendingSubstitutionWithoutOptimizing((ImmutableSubstitution)s);
        }
    }
}

