/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.iq.optimizer.impl;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import it.unibz.inf.ontop.com.google.common.collect.ImmutableList;
import it.unibz.inf.ontop.com.google.common.collect.ImmutableMultiset;
import it.unibz.inf.ontop.com.google.common.collect.ImmutableSet;
import it.unibz.inf.ontop.com.google.common.collect.Multiset;
import it.unibz.inf.ontop.dbschema.RelationDefinition;
import it.unibz.inf.ontop.dbschema.UniqueConstraint;
import it.unibz.inf.ontop.injection.CoreSingletons;
import it.unibz.inf.ontop.injection.IntermediateQueryFactory;
import it.unibz.inf.ontop.iq.IQ;
import it.unibz.inf.ontop.iq.IQTree;
import it.unibz.inf.ontop.iq.node.ExtensionalDataNode;
import it.unibz.inf.ontop.iq.node.InnerJoinNode;
import it.unibz.inf.ontop.iq.optimizer.SelfJoinUCIQOptimizer;
import it.unibz.inf.ontop.iq.optimizer.impl.AbstractSelfJoinSimplifier;
import it.unibz.inf.ontop.iq.transform.IQTreeVisitingTransformer;
import it.unibz.inf.ontop.iq.transform.impl.DefaultRecursiveIQTreeVisitingTransformer;
import it.unibz.inf.ontop.model.term.ImmutableExpression;
import it.unibz.inf.ontop.model.term.TermFactory;
import it.unibz.inf.ontop.model.term.Variable;
import it.unibz.inf.ontop.model.term.VariableOrGroundTerm;
import it.unibz.inf.ontop.substitution.ImmutableSubstitution;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import java.util.Collection;
import java.util.Optional;
import java.util.stream.Stream;

@Singleton
public class SelfJoinUCIQOptimizerImpl
implements SelfJoinUCIQOptimizer {
    private final SelfJoinUCTransformer selfJoinUCTransformer;
    private final IntermediateQueryFactory iqFactory;

    @Inject
    public SelfJoinUCIQOptimizerImpl(IntermediateQueryFactory iqFactory, SelfJoinUCTransformer selfJoinUCTransformer) {
        this.iqFactory = iqFactory;
        this.selfJoinUCTransformer = selfJoinUCTransformer;
    }

    @Override
    public IQ optimize(IQ query) {
        IQTree initialTree = query.getTree();
        IQTree newTree = this.selfJoinUCTransformer.transform(initialTree);
        return newTree.equals(initialTree) ? query : this.iqFactory.createIQ(query.getProjectionAtom(), newTree).normalizeForOptimization();
    }

    protected static class SelfJoinUCSimplifier
    extends AbstractSelfJoinSimplifier<UniqueConstraint> {
        @Inject
        protected SelfJoinUCSimplifier(CoreSingletons coreSingletons) {
            super(coreSingletons);
        }

        @Override
        protected Stream<UniqueConstraint> extractConstraints(RelationDefinition relationDefinition) {
            return relationDefinition.getUniqueConstraints().stream();
        }

        @Override
        protected Optional<AbstractSelfJoinSimplifier.DeterminantGroupEvaluation> evaluateDeterminantGroup(ImmutableList<VariableOrGroundTerm> determinants, Collection<ExtensionalDataNode> dataNodes, UniqueConstraint constraint) {
            if (dataNodes.size() < 2) {
                throw new IllegalArgumentException("At least two nodes");
            }
            AbstractSelfJoinSimplifier.NormalizationBeforeUnification normalization = this.normalizeDataNodes(dataNodes, constraint);
            ImmutableMultiset variableOccurences = (ImmutableMultiset)dataNodes.stream().flatMap(n -> n.getArgumentMap().values().stream()).collect(ImmutableCollectors.toMultiset());
            ImmutableSet expressions = (ImmutableSet)Stream.concat(variableOccurences.entrySet().stream().filter(e -> e.getCount() > 1).map(Multiset.Entry::getElement).filter(d -> d instanceof Variable).map(d -> (Variable)d).map(arg_0 -> ((TermFactory)this.termFactory).getDBIsNotNull(arg_0)), normalization.equalities.stream()).collect(ImmutableCollectors.toSet());
            return this.unifyDataNodes(normalization.dataNodes.stream()).map(u -> new AbstractSelfJoinSimplifier.DeterminantGroupEvaluation((ImmutableSet<ImmutableExpression>)expressions, (ImmutableList<ExtensionalDataNode>)ImmutableList.of((Object)this.iqFactory.createExtensionalDataNode(((ExtensionalDataNode)dataNodes.iterator().next()).getRelationDefinition(), u.argumentMap)), (ImmutableSubstitution<VariableOrGroundTerm>)u.substitution));
        }
    }

    private static class SelfJoinUCTransformer
    extends DefaultRecursiveIQTreeVisitingTransformer {
        private final SelfJoinUCSimplifier simplifier;

        @Inject
        protected SelfJoinUCTransformer(CoreSingletons coreSingletons, SelfJoinUCSimplifier simplifier) {
            super(coreSingletons);
            this.simplifier = simplifier;
        }

        public IQTree transformInnerJoin(IQTree tree, InnerJoinNode rootNode, ImmutableList<IQTree> children) {
            ImmutableList liftedChildren = (ImmutableList)children.stream().map(t -> t.acceptTransformer((IQTreeVisitingTransformer)this)).collect(ImmutableCollectors.toList());
            return this.simplifier.transformInnerJoin(rootNode, (ImmutableList<IQTree>)liftedChildren, (ImmutableSet<Variable>)tree.getVariables());
        }
    }
}

