/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.iq.optimizer.impl;

import it.unibz.inf.ontop.com.google.common.collect.ImmutableList;
import it.unibz.inf.ontop.com.google.common.collect.ImmutableMap;
import it.unibz.inf.ontop.com.google.common.collect.Maps;
import it.unibz.inf.ontop.injection.CoreSingletons;
import it.unibz.inf.ontop.injection.IntermediateQueryFactory;
import it.unibz.inf.ontop.injection.OptimizationSingletons;
import it.unibz.inf.ontop.iq.IQ;
import it.unibz.inf.ontop.iq.IQTree;
import it.unibz.inf.ontop.iq.UnaryIQTree;
import it.unibz.inf.ontop.iq.node.AggregationNode;
import it.unibz.inf.ontop.iq.node.ConstructionNode;
import it.unibz.inf.ontop.iq.node.QueryNode;
import it.unibz.inf.ontop.iq.node.UnaryOperatorNode;
import it.unibz.inf.ontop.iq.optimizer.AggregationSimplifier;
import it.unibz.inf.ontop.iq.request.DefinitionPushDownRequest;
import it.unibz.inf.ontop.iq.transform.IQTreeTransformer;
import it.unibz.inf.ontop.iq.transform.IQTreeVisitingTransformer;
import it.unibz.inf.ontop.iq.transformer.impl.RDFTypeDependentSimplifyingTransformer;
import it.unibz.inf.ontop.model.term.Constant;
import it.unibz.inf.ontop.model.term.ImmutableFunctionalTerm;
import it.unibz.inf.ontop.model.term.ImmutableTerm;
import it.unibz.inf.ontop.model.term.RDFConstant;
import it.unibz.inf.ontop.model.term.TermFactory;
import it.unibz.inf.ontop.model.term.Variable;
import it.unibz.inf.ontop.model.term.functionsymbol.FunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.RDFTermFunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.SPARQLAggregationFunctionSymbol;
import it.unibz.inf.ontop.substitution.ImmutableSubstitution;
import it.unibz.inf.ontop.substitution.SubstitutionFactory;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import it.unibz.inf.ontop.utils.VariableGenerator;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import javax.inject.Inject;

public class AggregationSimplifierImpl
implements AggregationSimplifier {
    private final IntermediateQueryFactory iqFactory;
    private final OptimizationSingletons optimizationSingletons;

    @Inject
    private AggregationSimplifierImpl(IntermediateQueryFactory iqFactory, OptimizationSingletons optimizationSingletons) {
        this.iqFactory = iqFactory;
        this.optimizationSingletons = optimizationSingletons;
    }

    @Override
    public IQ optimize(IQ query) {
        VariableGenerator variableGenerator = query.getVariableGenerator();
        IQTreeTransformer transformer = this.createTransformer(variableGenerator);
        IQTree newTree = transformer.transform(query.getTree()).normalizeForOptimization(variableGenerator);
        return this.iqFactory.createIQ(query.getProjectionAtom(), newTree);
    }

    protected IQTreeTransformer createTransformer(VariableGenerator variableGenerator) {
        return new AggregationSimplifyingTransformer(variableGenerator, this.optimizationSingletons);
    }

    protected static class AggregationSimplifyingTransformer
    extends RDFTypeDependentSimplifyingTransformer {
        private final VariableGenerator variableGenerator;
        private final SubstitutionFactory substitutionFactory;
        private final TermFactory termFactory;

        protected AggregationSimplifyingTransformer(VariableGenerator variableGenerator, OptimizationSingletons optimizationSingletons) {
            super(optimizationSingletons);
            this.variableGenerator = variableGenerator;
            CoreSingletons coreSingletons = optimizationSingletons.getCoreSingletons();
            this.substitutionFactory = coreSingletons.getSubstitutionFactory();
            this.termFactory = coreSingletons.getTermFactory();
        }

        public IQTree transformAggregation(IQTree tree, AggregationNode rootNode, IQTree child) {
            IQTree normalizedChild = child.acceptTransformer((IQTreeVisitingTransformer)this).normalizeForOptimization(this.variableGenerator);
            QueryNode newChildRoot = normalizedChild.getRootNode();
            if (newChildRoot instanceof ConstructionNode && !child.getRootNode().equals(newChildRoot)) {
                return this.transform(this.iqFactory.createUnaryIQTree((UnaryOperatorNode)rootNode, normalizedChild).normalizeForOptimization(this.variableGenerator));
            }
            ImmutableSubstitution initialSubstitution = rootNode.getSubstitution();
            boolean hasGroupBy = !rootNode.getGroupingVariables().isEmpty();
            ImmutableMap simplificationMap = (ImmutableMap)initialSubstitution.getImmutableMap().entrySet().stream().collect(ImmutableCollectors.toMap(Map.Entry::getKey, e -> this.simplifyAggregationFunctionalTerm((ImmutableFunctionalTerm)e.getValue(), normalizedChild, hasGroupBy)));
            ImmutableSubstitution newAggregationSubstitution = this.substitutionFactory.getSubstitution((ImmutableMap)simplificationMap.entrySet().stream().flatMap(e -> ((Optional)e.getValue()).map(s -> s.getDecomposition().getSubTermSubstitutionMap().map(sub -> sub.entrySet().stream()).orElseGet(() -> Stream.of(new Map.Entry[0]))).orElseGet(() -> Stream.of(Maps.immutableEntry(e.getKey(), (Object)initialSubstitution.get((Variable)e.getKey()))))).collect(ImmutableCollectors.toMap()));
            AggregationNode newNode = this.iqFactory.createAggregationNode(rootNode.getGroupingVariables(), newAggregationSubstitution);
            Stream<DefinitionPushDownRequest> definitionsToPushDown = simplificationMap.values().stream().filter(Optional::isPresent).map(Optional::get).flatMap(s -> s.getPushDownRequests().stream());
            IQTree pushDownChildTree = this.pushDownDefinitions(normalizedChild, definitionsToPushDown);
            UnaryIQTree newAggregationTree = this.iqFactory.createUnaryIQTree((UnaryOperatorNode)newNode, pushDownChildTree);
            ImmutableMap parentSubstitutionMap = (ImmutableMap)simplificationMap.entrySet().stream().filter(e -> ((Optional)e.getValue()).isPresent()).collect(ImmutableCollectors.toMap(Map.Entry::getKey, e -> ((SPARQLAggregationFunctionSymbol.AggregationSimplification)((Optional)e.getValue()).get()).getDecomposition().getLiftableTerm()));
            return parentSubstitutionMap.isEmpty() ? newAggregationTree : this.iqFactory.createUnaryIQTree((UnaryOperatorNode)this.iqFactory.createConstructionNode(rootNode.getVariables(), this.substitutionFactory.getSubstitution(parentSubstitutionMap)), (IQTree)newAggregationTree);
        }

        protected Optional<SPARQLAggregationFunctionSymbol.AggregationSimplification> simplifyAggregationFunctionalTerm(ImmutableFunctionalTerm aggregationFunctionalTerm, IQTree child, boolean hasGroupBy) {
            FunctionSymbol functionSymbol = aggregationFunctionalTerm.getFunctionSymbol();
            if (functionSymbol instanceof SPARQLAggregationFunctionSymbol) {
                SPARQLAggregationFunctionSymbol aggregationFunctionSymbol = (SPARQLAggregationFunctionSymbol)functionSymbol;
                ImmutableList subTerms = aggregationFunctionalTerm.getTerms();
                if (subTerms.stream().allMatch(t -> this.isRDFFunctionalTerm((ImmutableTerm)t) || t instanceof RDFConstant)) {
                    ImmutableList extractedRDFTypes = (ImmutableList)aggregationFunctionalTerm.getTerms().stream().map(this::extractRDFTermTypeTerm).map(this::unwrapIfElseNull).map(t -> this.extractPossibleTypes((ImmutableTerm)t, child)).collect(ImmutableCollectors.toList());
                    if (extractedRDFTypes.stream().anyMatch(t -> !t.isPresent())) {
                        return Optional.empty();
                    }
                    ImmutableList possibleRDFTypes = (ImmutableList)extractedRDFTypes.stream().map(Optional::get).collect(ImmutableCollectors.toList());
                    return aggregationFunctionSymbol.decomposeIntoDBAggregation(subTerms, possibleRDFTypes, hasGroupBy, child.getVariableNullability(), this.variableGenerator, this.termFactory);
                }
            }
            return Optional.empty();
        }

        protected boolean isRDFFunctionalTerm(ImmutableTerm term) {
            return term instanceof ImmutableFunctionalTerm && ((ImmutableFunctionalTerm)term).getFunctionSymbol() instanceof RDFTermFunctionSymbol;
        }

        protected ImmutableTerm extractRDFTermTypeTerm(ImmutableTerm rdfTerm) {
            if (this.isRDFFunctionalTerm(rdfTerm)) {
                return ((ImmutableFunctionalTerm)rdfTerm).getTerm(1);
            }
            if (rdfTerm instanceof RDFConstant) {
                return this.termFactory.getRDFTermTypeConstant(((RDFConstant)rdfTerm).getType());
            }
            if (rdfTerm instanceof Constant && rdfTerm.isNull()) {
                return this.termFactory.getNullConstant();
            }
            throw new IllegalArgumentException("Was expecting a isRDFFunctionalTerm or an RDFConstant or NULL");
        }
    }
}

