/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.injection.impl;

import com.google.inject.Module;
import it.unibz.inf.ontop.com.google.common.collect.ImmutableMap;
import it.unibz.inf.ontop.injection.OntopModelConfiguration;
import it.unibz.inf.ontop.injection.OntopModelSettings;
import it.unibz.inf.ontop.injection.OntopOptimizationConfiguration;
import it.unibz.inf.ontop.injection.OntopOptimizationSettings;
import it.unibz.inf.ontop.injection.impl.OntopModelConfigurationImpl;
import it.unibz.inf.ontop.injection.impl.OntopOptimizationModule;
import it.unibz.inf.ontop.injection.impl.OntopOptimizationSettingsImpl;
import it.unibz.inf.ontop.iq.executor.ProposalExecutor;
import it.unibz.inf.ontop.iq.executor.construction.ConstructionNodeCleaningExecutor;
import it.unibz.inf.ontop.iq.executor.join.InnerJoinExecutor;
import it.unibz.inf.ontop.iq.executor.leftjoin.LeftJoinExecutor;
import it.unibz.inf.ontop.iq.executor.projection.ProjectionShrinkingExecutor;
import it.unibz.inf.ontop.iq.executor.substitution.SubstitutionPropagationExecutor;
import it.unibz.inf.ontop.iq.executor.union.FlattenUnionExecutor;
import it.unibz.inf.ontop.iq.executor.union.UnionLiftExecutor;
import it.unibz.inf.ontop.iq.proposal.ConstructionNodeCleaningProposal;
import it.unibz.inf.ontop.iq.proposal.FlattenUnionProposal;
import it.unibz.inf.ontop.iq.proposal.InnerJoinOptimizationProposal;
import it.unibz.inf.ontop.iq.proposal.LeftJoinOptimizationProposal;
import it.unibz.inf.ontop.iq.proposal.ProjectionShrinkingProposal;
import it.unibz.inf.ontop.iq.proposal.QueryOptimizationProposal;
import it.unibz.inf.ontop.iq.proposal.SubstitutionPropagationProposal;
import it.unibz.inf.ontop.iq.proposal.UnionLiftProposal;
import java.io.File;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Stream;
import javax.annotation.Nonnull;

public class OntopOptimizationConfigurationImpl
extends OntopModelConfigurationImpl
implements OntopOptimizationConfiguration {
    protected OntopOptimizationConfigurationImpl(OntopOptimizationSettings settings, OntopOptimizationOptions options) {
        super((OntopModelSettings)settings, options.getModelOptions());
    }

    @Override
    public OntopOptimizationSettings getSettings() {
        return (OntopOptimizationSettings)super.getSettings();
    }

    protected Stream<Module> buildGuiceModules() {
        return Stream.concat(super.buildGuiceModules(), Stream.of(new OntopOptimizationModule(this)));
    }

    protected ImmutableMap<Class<? extends QueryOptimizationProposal>, Class<? extends ProposalExecutor>> generateOptimizationConfigurationMap() {
        ImmutableMap.Builder internalExecutorMapBuilder = ImmutableMap.builder();
        internalExecutorMapBuilder.putAll((Map)super.generateOptimizationConfigurationMap());
        internalExecutorMapBuilder.put(InnerJoinOptimizationProposal.class, InnerJoinExecutor.class);
        internalExecutorMapBuilder.put(SubstitutionPropagationProposal.class, SubstitutionPropagationExecutor.class);
        internalExecutorMapBuilder.put(UnionLiftProposal.class, UnionLiftExecutor.class);
        internalExecutorMapBuilder.put(LeftJoinOptimizationProposal.class, LeftJoinExecutor.class);
        internalExecutorMapBuilder.put(ProjectionShrinkingProposal.class, ProjectionShrinkingExecutor.class);
        internalExecutorMapBuilder.put(FlattenUnionProposal.class, FlattenUnionExecutor.class);
        internalExecutorMapBuilder.put(ConstructionNodeCleaningProposal.class, ConstructionNodeCleaningExecutor.class);
        return internalExecutorMapBuilder.build();
    }

    public static final class BuilderImpl<B extends OntopOptimizationConfiguration.Builder<B>>
    extends AbstractOntopOptimizationBuilderMixin<B> {
        @Override
        public OntopOptimizationConfiguration build() {
            Properties properties = this.generateProperties();
            OntopOptimizationOptions options = this.generateOntopOptimizationConfigurationOptions();
            OntopOptimizationSettingsImpl settings = new OntopOptimizationSettingsImpl(properties);
            return new OntopOptimizationConfigurationImpl(settings, options);
        }
    }

    protected static abstract class AbstractOntopOptimizationBuilderMixin<B extends OntopOptimizationConfiguration.Builder<B>>
    implements OntopOptimizationConfiguration.Builder<B> {
        private final DefaultOntopOptimizationBuilderFragment<B> optimizationBuilderFragment = new DefaultOntopOptimizationBuilderFragment<AbstractOntopOptimizationBuilderMixin>(this);
        private final OntopModelConfigurationImpl.DefaultOntopModelBuilderFragment<B> modelBuilderFragment = new OntopModelConfigurationImpl.DefaultOntopModelBuilderFragment((OntopModelConfiguration.Builder)this);

        protected AbstractOntopOptimizationBuilderMixin() {
        }

        protected Properties generateProperties() {
            Properties properties = this.modelBuilderFragment.generateProperties();
            properties.putAll((Map<?, ?>)this.optimizationBuilderFragment.generateProperties());
            return properties;
        }

        protected OntopOptimizationOptions generateOntopOptimizationConfigurationOptions() {
            OntopModelConfigurationImpl.OntopModelConfigurationOptions modelOptions = this.modelBuilderFragment.generateModelOptions();
            return this.optimizationBuilderFragment.generateOptimizationOptions(modelOptions);
        }

        public B properties(@Nonnull Properties properties) {
            return (B)((OntopOptimizationConfiguration.Builder)this.modelBuilderFragment.properties(properties));
        }

        public B propertyFile(File propertyFile) {
            return (B)((OntopOptimizationConfiguration.Builder)this.modelBuilderFragment.propertyFile(propertyFile));
        }

        public B propertyFile(String propertyFilePath) {
            return (B)((OntopOptimizationConfiguration.Builder)this.modelBuilderFragment.propertyFile(propertyFilePath));
        }

        public B enableTestMode() {
            return (B)((OntopOptimizationConfiguration.Builder)this.modelBuilderFragment.enableTestMode());
        }
    }

    protected static class DefaultOntopOptimizationBuilderFragment<B extends OntopOptimizationConfiguration.Builder<B>>
    implements OntopOptimizationConfiguration.OntopOptimizationBuilderFragment<B> {
        private final B builder;

        protected DefaultOntopOptimizationBuilderFragment() {
            this.builder = (OntopOptimizationConfiguration.Builder)((Object)this);
        }

        protected DefaultOntopOptimizationBuilderFragment(B builder) {
            this.builder = builder;
        }

        protected Properties generateProperties() {
            return new Properties();
        }

        protected final OntopOptimizationOptions generateOptimizationOptions(OntopModelConfigurationImpl.OntopModelConfigurationOptions modelOptions) {
            return new OntopOptimizationOptions(modelOptions);
        }
    }

    public static class OntopOptimizationOptions {
        private final OntopModelConfigurationImpl.OntopModelConfigurationOptions modelOptions;

        OntopOptimizationOptions(OntopModelConfigurationImpl.OntopModelConfigurationOptions modelOptions) {
            this.modelOptions = modelOptions;
        }

        public OntopModelConfigurationImpl.OntopModelConfigurationOptions getModelOptions() {
            return this.modelOptions;
        }
    }
}

