/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.iq.optimizer.impl;

import it.unibz.inf.ontop.com.google.common.collect.ImmutableList;
import it.unibz.inf.ontop.com.google.common.collect.ImmutableMap;
import it.unibz.inf.ontop.com.google.common.collect.ImmutableSet;
import it.unibz.inf.ontop.com.google.common.collect.Lists;
import it.unibz.inf.ontop.com.google.common.collect.Sets;
import it.unibz.inf.ontop.injection.CoreSingletons;
import it.unibz.inf.ontop.injection.IntermediateQueryFactory;
import it.unibz.inf.ontop.injection.OptimizationSingletons;
import it.unibz.inf.ontop.iq.IQ;
import it.unibz.inf.ontop.iq.IQTree;
import it.unibz.inf.ontop.iq.node.ExtensionalDataNode;
import it.unibz.inf.ontop.iq.node.NaryOperatorNode;
import it.unibz.inf.ontop.iq.node.TrueNode;
import it.unibz.inf.ontop.iq.optimizer.SelfJoinSameTermIQOptimizer;
import it.unibz.inf.ontop.iq.optimizer.impl.AbstractDiscardedVariablesTransformer;
import it.unibz.inf.ontop.iq.optimizer.impl.LookForDistinctTransformerImpl;
import it.unibz.inf.ontop.iq.transform.IQTreeTransformer;
import it.unibz.inf.ontop.iq.visit.IQVisitor;
import it.unibz.inf.ontop.iq.visitor.RequiredExtensionalDataNodeExtractor;
import it.unibz.inf.ontop.model.term.ImmutableExpression;
import it.unibz.inf.ontop.model.term.TermFactory;
import it.unibz.inf.ontop.model.term.Variable;
import it.unibz.inf.ontop.model.term.VariableOrGroundTerm;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;
import java.util.Set;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class SelfJoinSameTermIQOptimizerImpl
implements SelfJoinSameTermIQOptimizer {
    private final IQTreeTransformer lookForDistinctTransformer;
    private final IntermediateQueryFactory iqFactory;

    @Inject
    protected SelfJoinSameTermIQOptimizerImpl(OptimizationSingletons optimizationSingletons, IntermediateQueryFactory iqFactory) {
        this.iqFactory = iqFactory;
        this.lookForDistinctTransformer = new LookForDistinctTransformerImpl(SameTermSelfJoinTransformer::new, optimizationSingletons);
    }

    @Override
    public IQ optimize(IQ query) {
        IQTree initialTree = query.getTree();
        IQTree newTree = this.lookForDistinctTransformer.transform(initialTree);
        return newTree.equals(initialTree) ? query : this.iqFactory.createIQ(query.getProjectionAtom(), newTree).normalizeForOptimization();
    }

    protected static class SameTermSelfJoinTransformer
    extends AbstractDiscardedVariablesTransformer {
        private final IQTreeTransformer lookForDistinctTransformer;
        private final OptimizationSingletons optimizationSingletons;
        private final IntermediateQueryFactory iqFactory;
        private final TermFactory termFactory;
        private final RequiredExtensionalDataNodeExtractor requiredExtensionalDataNodeExtractor;

        protected SameTermSelfJoinTransformer(ImmutableSet<Variable> discardedVariables, IQTreeTransformer lookForDistinctTransformer, OptimizationSingletons optimizationSingletons) {
            super(discardedVariables, lookForDistinctTransformer, optimizationSingletons.getCoreSingletons());
            this.lookForDistinctTransformer = lookForDistinctTransformer;
            this.optimizationSingletons = optimizationSingletons;
            CoreSingletons coreSingletons = optimizationSingletons.getCoreSingletons();
            this.iqFactory = coreSingletons.getIQFactory();
            this.termFactory = coreSingletons.getTermFactory();
            this.requiredExtensionalDataNodeExtractor = optimizationSingletons.getRequiredExtensionalDataNodeExtractor();
        }

        @Override
        protected AbstractDiscardedVariablesTransformer update(ImmutableSet<Variable> newDiscardedVariables) {
            return new SameTermSelfJoinTransformer(newDiscardedVariables, this.lookForDistinctTransformer, this.optimizationSingletons);
        }

        @Override
        protected Optional<IQTree> furtherSimplifyInnerJoinChildren(ImmutableList<ImmutableSet<Variable>> discardedVariablesPerChild, Optional<ImmutableExpression> optionalFilterCondition, ImmutableList<IQTree> partiallySimplifiedChildren) {
            ArrayList currentChildren = Lists.newArrayList(partiallySimplifiedChildren);
            IntStream.range(0, partiallySimplifiedChildren.size()).boxed().filter(i -> this.isDetectedAsRedundant((IQTree)currentChildren.get((int)i), (ImmutableSet<Variable>)((ImmutableSet)discardedVariablesPerChild.get(i.intValue())), IntStream.range(0, partiallySimplifiedChildren.size()).filter(j -> j != i).boxed().map(currentChildren::get))).forEach(i -> {
                IQTree cfr_ignored_0 = (IQTree)currentChildren.set((int)i, this.iqFactory.createTrueNode());
            });
            ImmutableSet variablesToFilterNulls = (ImmutableSet)IntStream.range(0, partiallySimplifiedChildren.size()).filter(i -> ((IQTree)currentChildren.get(i)).getRootNode() instanceof TrueNode).boxed().map(i -> Sets.difference((Set)((IQTree)partiallySimplifiedChildren.get(i.intValue())).getVariables(), (Set)((Set)discardedVariablesPerChild.get(i.intValue())))).flatMap(Collection::stream).collect(ImmutableCollectors.toSet());
            return Optional.of(variablesToFilterNulls).filter(vs -> !vs.isEmpty()).map(vs -> vs.stream().map(arg_0 -> ((TermFactory)this.termFactory).getDBIsNotNull(arg_0))).map(s -> optionalFilterCondition.map(f -> Stream.concat(Stream.of(f), s)).orElse((Stream)s)).flatMap(arg_0 -> ((TermFactory)this.termFactory).getConjunction(arg_0)).map(arg_0 -> ((IntermediateQueryFactory)this.iqFactory).createInnerJoinNode(arg_0)).map(n -> this.iqFactory.createNaryIQTree((NaryOperatorNode)n, ImmutableList.copyOf((Collection)currentChildren)));
        }

        boolean isDetectedAsRedundant(IQTree child, ImmutableSet<Variable> discardedVariables, Stream<IQTree> otherChildren) {
            return Optional.of(child).filter(c -> c instanceof ExtensionalDataNode).map(c -> (ExtensionalDataNode)c).filter(d1 -> otherChildren.flatMap(t -> (Stream)t.acceptVisitor((IQVisitor)this.requiredExtensionalDataNodeExtractor)).anyMatch(d2 -> this.isDetectedAsRedundant((ExtensionalDataNode)d1, (ExtensionalDataNode)d2, discardedVariables))).isPresent();
        }

        private boolean isDetectedAsRedundant(ExtensionalDataNode dataNode, ExtensionalDataNode otherDataNode, ImmutableSet<Variable> discardedVariables) {
            if (!dataNode.getRelationDefinition().equals(otherDataNode.getRelationDefinition())) {
                return false;
            }
            ImmutableMap argumentMap = dataNode.getArgumentMap();
            ImmutableMap otherArgumentMap = otherDataNode.getArgumentMap();
            ImmutableSet firstIndexes = argumentMap.keySet();
            ImmutableSet otherIndexes = otherArgumentMap.keySet();
            Sets.SetView allIndexes = Sets.union((Set)firstIndexes, (Set)otherIndexes);
            Sets.SetView commonIndexes = Sets.intersection((Set)firstIndexes, (Set)otherIndexes);
            ImmutableList differentArguments = (ImmutableList)allIndexes.stream().filter(i -> !commonIndexes.contains(i) || !((VariableOrGroundTerm)argumentMap.get(i)).equals(otherArgumentMap.get(i))).flatMap(i -> Optional.ofNullable(argumentMap.get(i)).map(Stream::of).orElseGet(Stream::empty)).collect(ImmutableCollectors.toList());
            if (differentArguments.size() == allIndexes.size()) {
                return false;
            }
            return discardedVariables.containsAll((Collection)differentArguments);
        }
    }
}

