/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.iq.optimizer.impl;

import it.unibz.inf.ontop.iq.IntermediateQuery;
import it.unibz.inf.ontop.iq.node.QueryNode;
import it.unibz.inf.ontop.iq.proposal.NodeCentricOptimizationResults;
import java.util.Optional;

public class QueryNodeNavigationTools {
    public static Optional<QueryNode> getDepthFirstNextNode(IntermediateQuery query, QueryNode currentNode) {
        return QueryNodeNavigationTools.getDepthFirstNextNode(query, currentNode, false);
    }

    public static NextNodeAndQuery getNextNodeAndQuery(IntermediateQuery query, NodeCentricOptimizationResults<? extends QueryNode> results) {
        Optional<? extends QueryNode> optionalNewNode = results.getOptionalNewNode();
        if (optionalNewNode.isPresent()) {
            Optional<QueryNode> optionalNextNode = QueryNodeNavigationTools.getDepthFirstNextNode(query, optionalNewNode.get());
            return new NextNodeAndQuery(optionalNextNode, query);
        }
        Optional<QueryNode> optionalReplacingChild = results.getOptionalReplacingChild();
        if (optionalReplacingChild.isPresent()) {
            return new NextNodeAndQuery(optionalReplacingChild, query);
        }
        Optional<QueryNode> optionalNextSibling = results.getOptionalNextSibling();
        if (optionalNextSibling.isPresent()) {
            return new NextNodeAndQuery(optionalNextSibling, query);
        }
        Optional<QueryNode> optionalClosestAncestor = results.getOptionalClosestAncestor();
        if (optionalClosestAncestor.isPresent()) {
            Optional<QueryNode> optionalNextNode = QueryNodeNavigationTools.getDepthFirstNextNode(query, optionalClosestAncestor.get(), true);
            return new NextNodeAndQuery(optionalNextNode, query);
        }
        return new NextNodeAndQuery(Optional.empty(), query);
    }

    private static Optional<QueryNode> getDepthFirstNextNode(IntermediateQuery query, QueryNode currentNode, boolean alreadyExploredSubTree) {
        Optional optionalFirstChild;
        if (!alreadyExploredSubTree && (optionalFirstChild = query.getFirstChild(currentNode)).isPresent()) {
            return optionalFirstChild;
        }
        return QueryNodeNavigationTools.skipSubTreeAndContinueDepthFirst(query, currentNode);
    }

    public static Optional<QueryNode> skipSubTreeAndContinueDepthFirst(IntermediateQuery query, QueryNode currentNode) {
        Optional optionalNextSibling = query.getNextSibling(currentNode);
        if (optionalNextSibling.isPresent()) {
            return optionalNextSibling;
        }
        Optional optionalParent = query.getParent(currentNode);
        if (optionalParent.isPresent()) {
            return QueryNodeNavigationTools.getDepthFirstNextNode(query, (QueryNode)optionalParent.get(), true);
        }
        return Optional.empty();
    }

    public static class NextNodeAndQuery {
        private final Optional<QueryNode> optionalNextNode;
        private final IntermediateQuery nextQuery;

        public NextNodeAndQuery(Optional<QueryNode> optionalNextNode, IntermediateQuery nextQuery) {
            this.optionalNextNode = optionalNextNode;
            this.nextQuery = nextQuery;
        }

        public Optional<QueryNode> getOptionalNextNode() {
            return this.optionalNextNode;
        }

        public IntermediateQuery getNextQuery() {
            return this.nextQuery;
        }
    }
}

