/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.iq.executor.join;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import it.unibz.inf.ontop.com.google.common.collect.ImmutableCollection;
import it.unibz.inf.ontop.com.google.common.collect.ImmutableList;
import it.unibz.inf.ontop.com.google.common.collect.ImmutableMap;
import it.unibz.inf.ontop.com.google.common.collect.ImmutableMultimap;
import it.unibz.inf.ontop.com.google.common.collect.ImmutableSet;
import it.unibz.inf.ontop.dbschema.Attribute;
import it.unibz.inf.ontop.dbschema.FunctionalDependency;
import it.unibz.inf.ontop.dbschema.RelationDefinition;
import it.unibz.inf.ontop.injection.IntermediateQueryFactory;
import it.unibz.inf.ontop.iq.IntermediateQuery;
import it.unibz.inf.ontop.iq.executor.join.RedundantSelfJoinExecutor;
import it.unibz.inf.ontop.iq.executor.join.SelfJoinLikeExecutor;
import it.unibz.inf.ontop.iq.node.ExtensionalDataNode;
import it.unibz.inf.ontop.iq.node.InnerJoinNode;
import it.unibz.inf.ontop.model.term.ImmutableExpression;
import it.unibz.inf.ontop.model.term.ImmutableTerm;
import it.unibz.inf.ontop.model.term.TermFactory;
import it.unibz.inf.ontop.model.term.Variable;
import it.unibz.inf.ontop.model.term.VariableOrGroundTerm;
import it.unibz.inf.ontop.model.term.impl.GroundTermTools;
import it.unibz.inf.ontop.substitution.ImmutableSubstitution;
import it.unibz.inf.ontop.substitution.ProtoSubstitution;
import it.unibz.inf.ontop.substitution.SubstitutionFactory;
import it.unibz.inf.ontop.substitution.impl.ImmutableUnificationTools;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;

@Singleton
public class FunctionalDependencyUnificationExecutor
extends RedundantSelfJoinExecutor {
    private final SubstitutionFactory substitutionFactory;
    private final ImmutableUnificationTools unificationTools;
    private final TermFactory termFactory;

    @Inject
    private FunctionalDependencyUnificationExecutor(IntermediateQueryFactory iqFactory, SubstitutionFactory substitutionFactory, ImmutableUnificationTools unificationTools, TermFactory termFactory) {
        super(iqFactory, unificationTools, termFactory);
        this.substitutionFactory = substitutionFactory;
        this.unificationTools = unificationTools;
        this.termFactory = termFactory;
    }

    @Override
    protected Optional<SelfJoinLikeExecutor.PredicateLevelProposal> proposePerPredicate(InnerJoinNode joinNode, ImmutableCollection<ExtensionalDataNode> initialNodes, RelationDefinition relation, ImmutableList<Variable> priorityVariables, IntermediateQuery query) throws SelfJoinLikeExecutor.AtomUnificationException {
        if (initialNodes.size() < 2) {
            return Optional.empty();
        }
        if (relation == null) {
            return Optional.empty();
        }
        ImmutableMap constraintNodeMap = (ImmutableMap)relation.getOtherFunctionalDependencies().stream().collect(ImmutableCollectors.toMap(c -> c, c -> this.groupDataNodesPerConstraint((FunctionalDependency)c, initialNodes)));
        ImmutableList<ImmutableSubstitution<VariableOrGroundTerm>> dependentUnifiers = this.extractDependentUnifiers(relation, (ImmutableMap<FunctionalDependency, ImmutableCollection<Collection<ExtensionalDataNode>>>)constraintNodeMap);
        Optional<ImmutableExpression> isNotNullConjunction = Optional.empty();
        return dependentUnifiers.isEmpty() ? Optional.empty() : Optional.of(new SelfJoinLikeExecutor.PredicateLevelProposal((ImmutableCollection<ImmutableSubstitution<VariableOrGroundTerm>>)dependentUnifiers, isNotNullConjunction));
    }

    private ImmutableList<ImmutableSubstitution<VariableOrGroundTerm>> extractDependentUnifiers(RelationDefinition databaseRelation, ImmutableMap<FunctionalDependency, ImmutableCollection<Collection<ExtensionalDataNode>>> constraintNodeMap) throws SelfJoinLikeExecutor.AtomUnificationException {
        ImmutableSet nullableIndexes = (ImmutableSet)databaseRelation.getAttributes().stream().filter(Attribute::isNullable).map(a -> a.getIndex() - 1).collect(ImmutableCollectors.toSet());
        ImmutableList.Builder dependentUnifierBuilder = ImmutableList.builder();
        for (Map.Entry constraintEntry : constraintNodeMap.entrySet()) {
            dependentUnifierBuilder.addAll(this.extractDependentUnifiers((FunctionalDependency)constraintEntry.getKey(), (ImmutableCollection<Collection<ExtensionalDataNode>>)((ImmutableCollection)constraintEntry.getValue()), (ImmutableSet<Integer>)nullableIndexes));
        }
        return dependentUnifierBuilder.build();
    }

    private ImmutableCollection<Collection<ExtensionalDataNode>> groupDataNodesPerConstraint(FunctionalDependency constraint, ImmutableCollection<ExtensionalDataNode> initialNodes) {
        ImmutableList constraintDeterminantIndexes = (ImmutableList)constraint.getDeterminants().stream().map(Attribute::getIndex).collect(ImmutableCollectors.toList());
        ImmutableMultimap nodeMultiMap = (ImmutableMultimap)initialNodes.stream().collect(ImmutableCollectors.toMultimap(n -> this.extractDeterminantArguments((ExtensionalDataNode)n, (ImmutableList<Integer>)constraintDeterminantIndexes), n -> n));
        return nodeMultiMap.asMap().values();
    }

    private ImmutableList<VariableOrGroundTerm> extractDeterminantArguments(ExtensionalDataNode dataNode, ImmutableList<Integer> determinantIndexes) {
        ImmutableMap argumentMap = dataNode.getArgumentMap();
        return (ImmutableList)determinantIndexes.stream().map(i -> Optional.ofNullable((VariableOrGroundTerm)argumentMap.get((Object)(i - 1))).orElseGet(() -> this.termFactory.getVariable(UUID.randomUUID().toString()))).collect(ImmutableCollectors.toList());
    }

    private ImmutableCollection<ImmutableSubstitution<VariableOrGroundTerm>> extractDependentUnifiers(FunctionalDependency constraint, ImmutableCollection<Collection<ExtensionalDataNode>> dataNodeClusters, ImmutableSet<Integer> nullableIndexes) throws SelfJoinLikeExecutor.AtomUnificationException {
        ImmutableList dependentIndexes = (ImmutableList)constraint.getDependents().stream().map(d -> d.getIndex() - 1).collect(ImmutableCollectors.toList());
        ImmutableList.Builder substitutionCollectionBuilder = ImmutableList.builder();
        for (Collection cluster : dataNodeClusters) {
            substitutionCollectionBuilder.addAll(this.extractDependentUnifiersFromCluster((ImmutableList<Integer>)dependentIndexes, cluster, nullableIndexes));
        }
        return substitutionCollectionBuilder.build();
    }

    private Collection<ImmutableSubstitution<VariableOrGroundTerm>> extractDependentUnifiersFromCluster(ImmutableList<Integer> dependentIndexes, Collection<ExtensionalDataNode> cluster, ImmutableSet<Integer> nullableIndexes) throws SelfJoinLikeExecutor.AtomUnificationException {
        if (cluster.size() < 2) {
            return ImmutableList.of();
        }
        ExtensionalDataNode referenceDataNode = cluster.stream().findFirst().orElseGet(() -> (ExtensionalDataNode)cluster.iterator().next());
        ArrayList<ImmutableSubstitution<VariableOrGroundTerm>> substitutionCollection = new ArrayList<ImmutableSubstitution<VariableOrGroundTerm>>();
        for (ExtensionalDataNode currentDataNode : cluster) {
            if (currentDataNode == referenceDataNode) continue;
            this.unifyDependentTerms(referenceDataNode, currentDataNode, dependentIndexes, nullableIndexes).ifPresent(substitutionCollection::add);
        }
        return substitutionCollection;
    }

    private Optional<ImmutableSubstitution<VariableOrGroundTerm>> unifyDependentTerms(ExtensionalDataNode leftNode, ExtensionalDataNode rightNode, ImmutableList<Integer> dependentIndexes, ImmutableSet<Integer> nullableIndexes) throws SelfJoinLikeExecutor.AtomUnificationException {
        ImmutableMap leftArgumentMap = leftNode.getArgumentMap();
        ImmutableMap rightArgumentMap = rightNode.getArgumentMap();
        Optional<ImmutableSubstitution> currentUnifier = Optional.empty();
        for (Integer dependentIndex : dependentIndexes) {
            Optional<Object> leftArgument = Optional.ofNullable(leftArgumentMap.get((Object)dependentIndex));
            Optional<Object> rightArgument = Optional.ofNullable(rightArgumentMap.get((Object)dependentIndex));
            ImmutableSubstitution termUnifier = leftArgument.isPresent() && rightArgument.isPresent() ? this.unificationTools.computeDirectedMGU((ImmutableTerm)rightArgument.get(), (ImmutableTerm)leftArgument.get()).map(ProtoSubstitution::getImmutableMap).map(map -> (ImmutableMap)map.entrySet().stream().collect(ImmutableCollectors.toMap(Map.Entry::getKey, e -> GroundTermTools.convertIntoVariableOrGroundTerm((ImmutableTerm)((ImmutableTerm)e.getValue()))))).map(arg_0 -> ((SubstitutionFactory)this.substitutionFactory).getSubstitution(arg_0)).orElseThrow(SelfJoinLikeExecutor.AtomUnificationException::new) : this.substitutionFactory.getSubstitution();
            ImmutableSubstitution candidateUnifier = currentUnifier.isPresent() ? (ImmutableSubstitution)this.unificationTools.computeAtomMGUS((ImmutableSubstitution)currentUnifier.get(), termUnifier).orElseThrow(SelfJoinLikeExecutor.AtomUnificationException::new) : termUnifier;
            currentUnifier = !nullableIndexes.contains((Object)dependentIndex) ? Optional.of(candidateUnifier) : currentUnifier;
        }
        return currentUnifier.filter(s -> !s.isEmpty());
    }
}

