/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.iq.transformer.impl;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import it.unibz.inf.ontop.exception.MinorOntopInternalBugException;
import it.unibz.inf.ontop.injection.IntermediateQueryFactory;
import it.unibz.inf.ontop.injection.OptimizerFactory;
import it.unibz.inf.ontop.iq.IQTree;
import it.unibz.inf.ontop.iq.LeafIQTree;
import it.unibz.inf.ontop.iq.node.AggregationNode;
import it.unibz.inf.ontop.iq.node.BinaryNonCommutativeOperatorNode;
import it.unibz.inf.ontop.iq.node.ConstructionNode;
import it.unibz.inf.ontop.iq.node.DistinctNode;
import it.unibz.inf.ontop.iq.node.InnerJoinNode;
import it.unibz.inf.ontop.iq.node.LeftJoinNode;
import it.unibz.inf.ontop.iq.node.NaryOperatorNode;
import it.unibz.inf.ontop.iq.node.UnaryOperatorNode;
import it.unibz.inf.ontop.iq.node.UnionNode;
import it.unibz.inf.ontop.iq.request.DefinitionPushDownRequest;
import it.unibz.inf.ontop.iq.transform.IQTreeVisitingTransformer;
import it.unibz.inf.ontop.iq.transform.impl.DefaultRecursiveIQTreeVisitingTransformer;
import it.unibz.inf.ontop.iq.transformer.DefinitionPushDownTransformer;
import it.unibz.inf.ontop.model.term.ImmutableExpression;
import it.unibz.inf.ontop.model.term.ImmutableFunctionalTerm;
import it.unibz.inf.ontop.model.term.ImmutableTerm;
import it.unibz.inf.ontop.model.term.TermFactory;
import it.unibz.inf.ontop.model.term.Variable;
import it.unibz.inf.ontop.substitution.ImmutableSubstitution;
import it.unibz.inf.ontop.substitution.SubstitutionFactory;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import java.util.Collection;
import java.util.Optional;
import java.util.Set;
import java.util.stream.IntStream;
import java.util.stream.Stream;

public class DefinitionPushDownTransformerImpl
extends DefaultRecursiveIQTreeVisitingTransformer
implements DefinitionPushDownTransformer {
    private final DefinitionPushDownRequest request;
    private final OptimizerFactory optimizerFactory;
    private final SubstitutionFactory substitutionFactory;
    private final TermFactory termFactory;

    @AssistedInject
    protected DefinitionPushDownTransformerImpl(@Assisted DefinitionPushDownRequest request, IntermediateQueryFactory iqFactory, OptimizerFactory optimizerFactory, SubstitutionFactory substitutionFactory, TermFactory termFactory) {
        super(iqFactory);
        this.request = request;
        this.optimizerFactory = optimizerFactory;
        this.substitutionFactory = substitutionFactory;
        this.termFactory = termFactory;
    }

    public IQTree transformConstruction(IQTree tree, ConstructionNode rootNode, IQTree child) {
        ImmutableSubstitution initialSubstitution = rootNode.getSubstitution();
        ImmutableSet newProjectedVariables = Sets.union((Set)tree.getVariables(), (Set)ImmutableSet.of((Object)this.request.getNewVariable())).immutableCopy();
        DefinitionPushDownRequest newRequest = this.request.newRequest(rootNode.getSubstitution());
        if (newRequest.equals(this.request)) {
            return this.iqFactory.createUnaryIQTree((UnaryOperatorNode)this.iqFactory.createConstructionNode(newProjectedVariables, initialSubstitution), child.acceptTransformer((IQTreeVisitingTransformer)this));
        }
        ImmutableExpression newCondition = newRequest.getCondition();
        Optional<ImmutableTerm> optionalLocalDefinition = newCondition.evaluate2VL(this.termFactory.createDummyVariableNullability((ImmutableFunctionalTerm)newCondition)).getValue().map(v -> {
            switch (v) {
                case TRUE: {
                    return newRequest.getDefinitionWhenConditionSatisfied();
                }
            }
            return this.termFactory.getNullConstant();
        });
        return (IQTree)optionalLocalDefinition.map(d -> (ImmutableMap)Stream.concat(Stream.of(Maps.immutableEntry((Object)newRequest.getNewVariable(), (Object)d)), initialSubstitution.getImmutableMap().entrySet().stream()).collect(ImmutableCollectors.toMap())).map(arg_0 -> ((SubstitutionFactory)this.substitutionFactory).getSubstitution(arg_0)).map(s -> this.iqFactory.createConstructionNode(newProjectedVariables, s)).map(c -> this.iqFactory.createUnaryIQTree((UnaryOperatorNode)c, child)).orElseGet(() -> this.iqFactory.createUnaryIQTree((UnaryOperatorNode)this.iqFactory.createConstructionNode(newProjectedVariables, initialSubstitution), this.optimizerFactory.createDefinitionPushDownTransformer(newRequest).transform(child)));
    }

    public IQTree transformAggregation(IQTree tree, AggregationNode rootNode, IQTree child) {
        return this.blockDefinition(tree);
    }

    public IQTree transformDistinct(IQTree tree, DistinctNode rootNode, IQTree child) {
        return this.blockDefinition(tree);
    }

    public IQTree transformNonStandardUnaryNode(IQTree tree, UnaryOperatorNode rootNode, IQTree child) {
        return this.blockDefinition(tree);
    }

    public IQTree transformLeftJoin(IQTree tree, LeftJoinNode rootNode, IQTree leftChild, IQTree rightChild) {
        ImmutableSet requestVariables = this.request.getDefinitionAndConditionVariables();
        if (leftChild.getVariables().containsAll((Collection)requestVariables)) {
            return this.iqFactory.createBinaryNonCommutativeIQTree((BinaryNonCommutativeOperatorNode)rootNode, leftChild.acceptTransformer((IQTreeVisitingTransformer)this), rightChild);
        }
        if (rightChild.getVariables().containsAll((Collection)requestVariables)) {
            return this.iqFactory.createBinaryNonCommutativeIQTree((BinaryNonCommutativeOperatorNode)rootNode, leftChild, rightChild.acceptTransformer((IQTreeVisitingTransformer)this));
        }
        return this.blockDefinition(tree);
    }

    public IQTree transformNonStandardBinaryNonCommutativeNode(IQTree tree, BinaryNonCommutativeOperatorNode rootNode, IQTree leftChild, IQTree rightChild) {
        return this.blockDefinition(tree);
    }

    public IQTree transformInnerJoin(IQTree tree, InnerJoinNode rootNode, ImmutableList<IQTree> children) {
        ImmutableSet requestVariables = this.request.getDefinitionAndConditionVariables();
        return IntStream.range(0, children.size()).filter(i -> ((IQTree)children.get(i)).getVariables().containsAll((Collection)requestVariables)).boxed().findAny().map(i -> (ImmutableList)IntStream.range(0, children.size()).boxed().map(j -> i.equals(j) ? ((IQTree)children.get(j.intValue())).acceptTransformer((IQTreeVisitingTransformer)this) : (IQTree)children.get(j.intValue())).collect(ImmutableCollectors.toList())).map(newChildren -> this.iqFactory.createNaryIQTree((NaryOperatorNode)rootNode, newChildren)).orElseGet(() -> this.blockDefinition(tree));
    }

    public IQTree transformUnion(IQTree tree, UnionNode rootNode, ImmutableList<IQTree> children) {
        ImmutableList newChildren = (ImmutableList)children.stream().map(c -> c.acceptTransformer((IQTreeVisitingTransformer)this)).collect(ImmutableCollectors.toList());
        UnionNode newRootNode = newChildren.stream().findAny().map(IQTree::getVariables).map(arg_0 -> ((IntermediateQueryFactory)this.iqFactory).createUnionNode(arg_0)).orElseThrow(() -> new MinorOntopInternalBugException("An union always have multiple children"));
        return this.iqFactory.createNaryIQTree((NaryOperatorNode)newRootNode, newChildren);
    }

    public IQTree transformNonStandardNaryNode(IQTree tree, NaryOperatorNode rootNode, ImmutableList<IQTree> children) {
        return this.blockDefinition(tree);
    }

    protected IQTree transformLeaf(LeafIQTree leaf) {
        return this.blockDefinition((IQTree)leaf);
    }

    protected IQTree blockDefinition(IQTree tree) {
        Variable newVariable = this.request.getNewVariable();
        ConstructionNode constructionNode = this.iqFactory.createConstructionNode(Sets.union((Set)tree.getVariables(), (Set)ImmutableSet.of((Object)newVariable)).immutableCopy(), this.substitutionFactory.getSubstitution(newVariable, (ImmutableTerm)this.termFactory.getIfElseNull(this.request.getCondition(), this.request.getDefinitionWhenConditionSatisfied())));
        return this.iqFactory.createUnaryIQTree((UnaryOperatorNode)constructionNode, tree);
    }
}

