/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.iq.tools.impl;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import it.unibz.inf.ontop.injection.IntermediateQueryFactory;
import it.unibz.inf.ontop.injection.QueryTransformerFactory;
import it.unibz.inf.ontop.iq.IQ;
import it.unibz.inf.ontop.iq.IQTree;
import it.unibz.inf.ontop.iq.NaryIQTree;
import it.unibz.inf.ontop.iq.node.NaryOperatorNode;
import it.unibz.inf.ontop.iq.tools.UnionBasedQueryMerger;
import it.unibz.inf.ontop.iq.transform.QueryRenamer;
import it.unibz.inf.ontop.model.atom.DistinctVariableOnlyDataAtom;
import it.unibz.inf.ontop.model.term.Variable;
import it.unibz.inf.ontop.substitution.InjectiveVar2VarSubstitution;
import it.unibz.inf.ontop.substitution.SubstitutionFactory;
import it.unibz.inf.ontop.utils.CoreUtilsFactory;
import it.unibz.inf.ontop.utils.FunctionalTools;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import it.unibz.inf.ontop.utils.VariableGenerator;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;

@Singleton
public class UnionBasedQueryMergerImpl
implements UnionBasedQueryMerger {
    private final IntermediateQueryFactory iqFactory;
    private final SubstitutionFactory substitutionFactory;
    private final CoreUtilsFactory coreUtilsFactory;
    private final QueryTransformerFactory transformerFactory;

    @Inject
    private UnionBasedQueryMergerImpl(IntermediateQueryFactory iqFactory, SubstitutionFactory substitutionFactory, CoreUtilsFactory coreUtilsFactory, QueryTransformerFactory transformerFactory) {
        this.iqFactory = iqFactory;
        this.substitutionFactory = substitutionFactory;
        this.coreUtilsFactory = coreUtilsFactory;
        this.transformerFactory = transformerFactory;
    }

    @Override
    public Optional<IQ> mergeDefinitions(Collection<IQ> predicateDefinitions) {
        if (predicateDefinitions.isEmpty()) {
            return Optional.empty();
        }
        IQ firstDefinition = predicateDefinitions.iterator().next();
        if (predicateDefinitions.size() == 1) {
            return Optional.of(firstDefinition);
        }
        DistinctVariableOnlyDataAtom projectionAtom = firstDefinition.getProjectionAtom();
        VariableGenerator variableGenerator = this.coreUtilsFactory.createVariableGenerator((Collection)firstDefinition.getTree().getKnownVariables());
        Stream<IQTree> renamedDefinitions = predicateDefinitions.stream().skip(1L).map(def -> {
            InjectiveVar2VarSubstitution disjointVariableSetRenaming = this.substitutionFactory.generateNotConflictingRenaming(variableGenerator, def.getTree().getKnownVariables());
            ImmutableSet freshVariables = ImmutableSet.copyOf((Collection)disjointVariableSetRenaming.getImmutableMap().values());
            InjectiveVar2VarSubstitution headSubstitution = this.computeRenamingSubstitution(disjointVariableSetRenaming.applyToDistinctVariableOnlyDataAtom(def.getProjectionAtom()), projectionAtom).orElseThrow(() -> new IllegalStateException("Bug: unexpected incompatible atoms"));
            InjectiveVar2VarSubstitution renamingSubstitution = (InjectiveVar2VarSubstitution)headSubstitution.composeWithAndPreserveInjectivity(disjointVariableSetRenaming, (Set)freshVariables).orElseThrow(() -> new IllegalStateException("Bug: the renaming substitution is not injective"));
            QueryRenamer queryRenamer = this.transformerFactory.createRenamer(renamingSubstitution);
            return queryRenamer.transform(def).getTree();
        });
        ImmutableList unionChildren = (ImmutableList)Stream.concat(Stream.of(firstDefinition.getTree()), renamedDefinitions).collect(ImmutableCollectors.toList());
        NaryIQTree unionTree = this.iqFactory.createNaryIQTree((NaryOperatorNode)this.iqFactory.createUnionNode(projectionAtom.getVariables()), unionChildren);
        return Optional.of(this.iqFactory.createIQ(projectionAtom, (IQTree)unionTree));
    }

    private Optional<InjectiveVar2VarSubstitution> computeRenamingSubstitution(DistinctVariableOnlyDataAtom sourceProjectionAtom, DistinctVariableOnlyDataAtom targetProjectionAtom) {
        int arity = sourceProjectionAtom.getEffectiveArity();
        if (!sourceProjectionAtom.getPredicate().equals(targetProjectionAtom.getPredicate()) || arity != targetProjectionAtom.getEffectiveArity()) {
            return Optional.empty();
        }
        ImmutableMap newMap = (ImmutableMap)FunctionalTools.zip((List)sourceProjectionAtom.getArguments(), (List)targetProjectionAtom.getArguments()).stream().distinct().filter(e -> !((Variable)e.getKey()).equals(e.getValue())).collect(ImmutableCollectors.toMap());
        return Optional.of(this.substitutionFactory.getInjectiveVar2VarSubstitution((Map)newMap));
    }
}

