/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.iq.proposal.impl;

import it.unibz.inf.ontop.iq.exception.InvalidQueryOptimizationProposalException;
import it.unibz.inf.ontop.iq.node.ExplicitVariableProjectionNode;
import it.unibz.inf.ontop.iq.node.QueryNode;
import it.unibz.inf.ontop.iq.proposal.SubstitutionPropagationProposal;
import it.unibz.inf.ontop.model.term.ImmutableTerm;
import it.unibz.inf.ontop.substitution.ImmutableSubstitution;
import java.util.Collection;

public class SubstitutionPropagationProposalImpl<T extends QueryNode>
implements SubstitutionPropagationProposal<T> {
    private final T focusNode;
    private final ImmutableSubstitution<? extends ImmutableTerm> substitutionToPropagate;

    public SubstitutionPropagationProposalImpl(T focusNode, ImmutableSubstitution<? extends ImmutableTerm> substitutionToPropagate) {
        this(focusNode, substitutionToPropagate, true);
    }

    public SubstitutionPropagationProposalImpl(T focusNode, ImmutableSubstitution<? extends ImmutableTerm> substitutionToPropagate, boolean shouldCheckProjection) {
        this.focusNode = focusNode;
        this.substitutionToPropagate = substitutionToPropagate;
        if (shouldCheckProjection) {
            this.checkProjection();
        }
    }

    private void checkProjection() {
        ExplicitVariableProjectionNode node;
        if (this.focusNode instanceof ExplicitVariableProjectionNode && !(node = (ExplicitVariableProjectionNode)this.focusNode).getVariables().containsAll((Collection)this.substitutionToPropagate.getDomain())) {
            throw new InvalidQueryOptimizationProposalException("Only variables projected by " + this.focusNode + " can be propagated.\n Invalid substitution was " + this.substitutionToPropagate);
        }
    }

    @Override
    public ImmutableSubstitution<? extends ImmutableTerm> getSubstitution() {
        return this.substitutionToPropagate;
    }

    @Override
    public T getFocusNode() {
        return this.focusNode;
    }

    public String toString() {
        return "Propagation " + this.substitutionToPropagate + " from " + this.focusNode;
    }
}

