/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.iq.optimizer.impl;

import it.unibz.inf.ontop.iq.IntermediateQuery;
import it.unibz.inf.ontop.iq.exception.EmptyQueryException;
import it.unibz.inf.ontop.iq.node.QueryNode;
import it.unibz.inf.ontop.iq.optimizer.IntermediateQueryOptimizer;
import it.unibz.inf.ontop.iq.optimizer.impl.QueryNodeNavigationTools;
import it.unibz.inf.ontop.iq.proposal.NodeCentricOptimizationResults;
import it.unibz.inf.ontop.iq.proposal.QueryOptimizationProposal;
import it.unibz.inf.ontop.iq.proposal.SimpleNodeCentricOptimizationProposal;
import java.util.Optional;

public abstract class NodeCentricDepthFirstOptimizer<P extends SimpleNodeCentricOptimizationProposal<? extends QueryNode>>
implements IntermediateQueryOptimizer {
    private final boolean canEmptyQuery;

    protected NodeCentricDepthFirstOptimizer(boolean canEmptyQuery) {
        this.canEmptyQuery = canEmptyQuery;
    }

    @Override
    public IntermediateQuery optimize(IntermediateQuery query) throws EmptyQueryException {
        try {
            return this.optimizeQuery(query);
        }
        catch (EmptyQueryException e) {
            if (this.canEmptyQuery) {
                throw e;
            }
            throw new IllegalStateException("Inconsistency: " + this + " should not empty the query");
        }
    }

    protected IntermediateQuery optimizeQuery(IntermediateQuery initialQuery) throws EmptyQueryException {
        Optional<QueryNode> optionalNextNode = Optional.of(initialQuery.getRootNode());
        IntermediateQuery currentQuery = initialQuery;
        while (optionalNextNode.isPresent()) {
            QueryNode currentNode = optionalNextNode.get();
            Optional<P> optionalProposal = this.evaluateNode(currentNode, currentQuery);
            if (optionalProposal.isPresent()) {
                NodeCentricOptimizationResults optimizationResults = (NodeCentricOptimizationResults)currentQuery.applyProposal((QueryOptimizationProposal)optionalProposal.get());
                QueryNodeNavigationTools.NextNodeAndQuery nextNodeAndQuery = QueryNodeNavigationTools.getNextNodeAndQuery(currentQuery, optimizationResults);
                currentQuery = nextNodeAndQuery.getNextQuery();
                optionalNextNode = nextNodeAndQuery.getOptionalNextNode();
                continue;
            }
            optionalNextNode = QueryNodeNavigationTools.getDepthFirstNextNode(currentQuery, currentNode);
        }
        return currentQuery;
    }

    protected abstract Optional<P> evaluateNode(QueryNode var1, IntermediateQuery var2);
}

