/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.iq.optimizer.impl;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import it.unibz.inf.ontop.exception.MinorOntopInternalBugException;
import it.unibz.inf.ontop.injection.IntermediateQueryFactory;
import it.unibz.inf.ontop.iq.IQ;
import it.unibz.inf.ontop.iq.IQTree;
import it.unibz.inf.ontop.iq.IntermediateQuery;
import it.unibz.inf.ontop.iq.exception.EmptyQueryException;
import it.unibz.inf.ontop.iq.optimizer.InnerJoinIQOptimizer;
import it.unibz.inf.ontop.iq.optimizer.InnerJoinMutableOptimizer;
import it.unibz.inf.ontop.iq.optimizer.JoinLikeOptimizer;
import it.unibz.inf.ontop.iq.optimizer.LeftJoinIQOptimizer;
import it.unibz.inf.ontop.iq.optimizer.LeftJoinMutableOptimizer;
import it.unibz.inf.ontop.iq.tools.ExecutorRegistry;
import it.unibz.inf.ontop.iq.tools.IQConverter;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class FixedPointJoinLikeOptimizer
implements JoinLikeOptimizer {
    private static final Logger LOGGER = LoggerFactory.getLogger(FixedPointJoinLikeOptimizer.class);
    private static final int MAX_LOOP = 100;
    private final InnerJoinMutableOptimizer joinMutableOptimizer;
    private final LeftJoinMutableOptimizer leftJoinMutableOptimizer;
    private final InnerJoinIQOptimizer innerJoinIQOptimizer;
    private final LeftJoinIQOptimizer leftJoinIQOptimizer;
    private final IQConverter iqConverter;
    private final IntermediateQueryFactory iqFactory;

    @Inject
    private FixedPointJoinLikeOptimizer(InnerJoinMutableOptimizer joinMutableOptimizer, LeftJoinMutableOptimizer leftJoinMutableOptimizer, InnerJoinIQOptimizer innerJoinIQOptimizer, LeftJoinIQOptimizer leftJoinIQOptimizer, IQConverter iqConverter, IntermediateQueryFactory iqFactory) {
        this.joinMutableOptimizer = joinMutableOptimizer;
        this.leftJoinMutableOptimizer = leftJoinMutableOptimizer;
        this.innerJoinIQOptimizer = innerJoinIQOptimizer;
        this.leftJoinIQOptimizer = leftJoinIQOptimizer;
        this.iqConverter = iqConverter;
        this.iqFactory = iqFactory;
    }

    @Override
    public IQ optimize(IQ initialIQ, ExecutorRegistry executorRegistry) {
        boolean isLogDebugEnabled = LOGGER.isDebugEnabled();
        IQ iq = initialIQ;
        boolean isFirstRound = true;
        try {
            boolean hasMutableQueryChanged;
            do {
                UUID oldVersionNumber;
                IQ oldIq = iq;
                iq = this.optimizeIQ(oldIq);
                if (!isFirstRound && oldIq.equals(iq)) {
                    return iq;
                }
                IntermediateQuery mutableQuery = this.iqConverter.convert(iq, executorRegistry);
                UUID initialVersionNumber = mutableQuery.getVersionNumber();
                do {
                    oldVersionNumber = mutableQuery.getVersionNumber();
                    mutableQuery = this.leftJoinMutableOptimizer.optimize(mutableQuery);
                    if (isLogDebugEnabled) {
                        LOGGER.debug("New query after left join mutable optimization: \n" + mutableQuery.toString());
                    }
                    mutableQuery = this.joinMutableOptimizer.optimize(mutableQuery);
                    if (!isLogDebugEnabled) continue;
                    LOGGER.debug("New query after join mutable optimization: \n" + mutableQuery.toString());
                } while (oldVersionNumber != mutableQuery.getVersionNumber());
                boolean bl = hasMutableQueryChanged = initialVersionNumber != mutableQuery.getVersionNumber();
                if (hasMutableQueryChanged) {
                    iq = this.iqConverter.convert(mutableQuery);
                }
                isFirstRound = false;
            } while (hasMutableQueryChanged);
        }
        catch (EmptyQueryException e) {
            return this.iqFactory.createIQ(initialIQ.getProjectionAtom(), (IQTree)this.iqFactory.createEmptyNode(initialIQ.getTree().getVariables()));
        }
        return iq;
    }

    private IQ optimizeIQ(IQ initialIQ) {
        IQ currentIQ = initialIQ;
        for (int i = 0; i < 100; ++i) {
            IQ optimizedIQ = this.leftJoinIQOptimizer.optimize(this.innerJoinIQOptimizer.optimize(currentIQ)).normalizeForOptimization();
            if (optimizedIQ.equals(currentIQ)) {
                return optimizedIQ;
            }
            currentIQ = optimizedIQ;
        }
        throw new MinorOntopInternalBugException("MAX_LOOP reached");
    }
}

