/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.iq.optimizer.impl;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import it.unibz.inf.ontop.dbschema.FunctionalDependency;
import it.unibz.inf.ontop.dbschema.RelationDefinition;
import it.unibz.inf.ontop.dbschema.UniqueConstraint;
import it.unibz.inf.ontop.exception.MinorOntopInternalBugException;
import it.unibz.inf.ontop.injection.CoreSingletons;
import it.unibz.inf.ontop.injection.IntermediateQueryFactory;
import it.unibz.inf.ontop.iq.IQTree;
import it.unibz.inf.ontop.iq.NaryIQTree;
import it.unibz.inf.ontop.iq.node.ExtensionalDataNode;
import it.unibz.inf.ontop.iq.node.InnerJoinNode;
import it.unibz.inf.ontop.iq.node.NaryOperatorNode;
import it.unibz.inf.ontop.iq.node.UnaryOperatorNode;
import it.unibz.inf.ontop.iq.node.normalization.ConstructionSubstitutionNormalizer;
import it.unibz.inf.ontop.model.term.GroundFunctionalTerm;
import it.unibz.inf.ontop.model.term.ImmutableExpression;
import it.unibz.inf.ontop.model.term.ImmutableTerm;
import it.unibz.inf.ontop.model.term.TermFactory;
import it.unibz.inf.ontop.model.term.Variable;
import it.unibz.inf.ontop.model.term.VariableOrGroundTerm;
import it.unibz.inf.ontop.substitution.ImmutableSubstitution;
import it.unibz.inf.ontop.substitution.SubstitutionFactory;
import it.unibz.inf.ontop.substitution.impl.ImmutableUnificationTools;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Stream;

public abstract class AbstractSelfJoinSimplifier<C extends FunctionalDependency> {
    private final OptimizationState noSolutionState;
    protected final IntermediateQueryFactory iqFactory;
    protected final TermFactory termFactory;
    protected final ImmutableUnificationTools unificationTools;
    protected final SubstitutionFactory substitutionFactory;
    private final ConstructionSubstitutionNormalizer substitutionNormalizer;

    public AbstractSelfJoinSimplifier(CoreSingletons coreSingletons) {
        this.iqFactory = coreSingletons.getIQFactory();
        this.termFactory = coreSingletons.getTermFactory();
        this.unificationTools = coreSingletons.getUnificationTools();
        this.substitutionFactory = coreSingletons.getSubstitutionFactory();
        this.substitutionNormalizer = coreSingletons.getConstructionSubstitutionNormalizer();
        this.noSolutionState = new OptimizationState((ImmutableSet<ImmutableExpression>)ImmutableSet.of(), (Collection<ExtensionalDataNode>)ImmutableList.of(), (ImmutableSubstitution<VariableOrGroundTerm>)this.substitutionFactory.getSubstitution());
    }

    public IQTree transformInnerJoin(InnerJoinNode rootNode, ImmutableList<IQTree> children, ImmutableSet<Variable> projectedVariables) {
        ImmutableMap childPartitions = (ImmutableMap)children.stream().collect(ImmutableCollectors.partitioningBy(n -> n instanceof ExtensionalDataNode));
        Optional<Object> nonExtensionalChildren = Optional.ofNullable(childPartitions.get((Object)false));
        Optional<Object> extensionalChildren = Optional.ofNullable(childPartitions.get((Object)true));
        Optional<ImmutableMultimap> optionalDataNodeMap = extensionalChildren.map(ns -> (ImmutableMultimap)ns.stream().map(n -> (ExtensionalDataNode)n).collect(ImmutableCollectors.toMultimap(ExtensionalDataNode::getRelationDefinition, n -> n)));
        ImmutableList optimizationStates = optionalDataNodeMap.map(m -> (ImmutableList)m.asMap().entrySet().stream().map(e -> this.optimizeExtensionalDataNodes((RelationDefinition)e.getKey(), (Collection)e.getValue())).collect(ImmutableCollectors.toList())).orElseGet(ImmutableList::of);
        if (optimizationStates.stream().anyMatch(s -> s.extensionalDataNodes.isEmpty())) {
            return this.iqFactory.createEmptyNode(projectedVariables);
        }
        Optional<ImmutableSubstitution<VariableOrGroundTerm>> optionalUnifier = this.unifySubstitutions(optimizationStates.stream().map(s -> s.substitution));
        if (!optionalUnifier.isPresent()) {
            return this.iqFactory.createEmptyNode(projectedVariables);
        }
        ImmutableSubstitution<VariableOrGroundTerm> unifier = optionalUnifier.get();
        ImmutableList optimizedExtensionalDataNodes = (ImmutableList)optimizationStates.stream().flatMap(s -> s.extensionalDataNodes.stream()).collect(ImmutableCollectors.toList());
        if (optimizedExtensionalDataNodes.size() == extensionalChildren.map(AbstractCollection::size).orElse(0).intValue()) {
            return this.iqFactory.createNaryIQTree((NaryOperatorNode)rootNode, children);
        }
        ImmutableList newChildren = nonExtensionalChildren.map(nes -> (ImmutableList)Stream.concat(optimizedExtensionalDataNodes.stream(), nes.stream()).collect(ImmutableCollectors.toList())).orElse(optimizedExtensionalDataNodes);
        Optional newExpression = this.termFactory.getConjunction(Stream.concat(rootNode.getOptionalFilterCondition().map(ImmutableExpression::flattenAND).orElseGet(Stream::empty), optimizationStates.stream().flatMap(s -> s.newExpressions.stream())));
        return this.buildNewTree((ImmutableList<IQTree>)newChildren, newExpression, unifier, projectedVariables);
    }

    private IQTree buildNewTree(ImmutableList<IQTree> children, Optional<ImmutableExpression> expression, ImmutableSubstitution<VariableOrGroundTerm> unifier, ImmutableSet<Variable> projectedVariables) {
        NaryIQTree newTree;
        ImmutableList newChildren = unifier.isEmpty() ? children : (ImmutableList)children.stream().map(t -> t.applyDescendingSubstitution(unifier, Optional.empty())).collect(ImmutableCollectors.toList());
        Optional<ImmutableExpression> newExpression = expression.map(arg_0 -> unifier.applyToBooleanExpression(arg_0));
        switch (newChildren.size()) {
            case 0: {
                throw new MinorOntopInternalBugException("Should have been detected before");
            }
            case 1: {
                IQTree child = (IQTree)newChildren.iterator().next();
                newTree = newExpression.map(e -> this.iqFactory.createUnaryIQTree((UnaryOperatorNode)this.iqFactory.createFilterNode(e), child)).orElse(child);
                break;
            }
            default: {
                newTree = this.iqFactory.createNaryIQTree((NaryOperatorNode)this.iqFactory.createInnerJoinNode(newExpression), newChildren);
            }
        }
        ConstructionSubstitutionNormalizer.ConstructionSubstitutionNormalization normalization = this.substitutionNormalizer.normalizeSubstitution(unifier, projectedVariables);
        IQTree normalizedNewTree = normalization.updateChild((IQTree)newTree);
        ImmutableSubstitution normalizedTopSubstitution = normalization.getNormalizedSubstitution();
        return normalizedTopSubstitution.isEmpty() ? (normalizedNewTree.getVariables().size() == projectedVariables.size() ? normalizedNewTree : this.iqFactory.createUnaryIQTree((UnaryOperatorNode)this.iqFactory.createConstructionNode(projectedVariables), normalizedNewTree)) : this.iqFactory.createUnaryIQTree((UnaryOperatorNode)this.iqFactory.createConstructionNode(projectedVariables, normalizedTopSubstitution), normalizedNewTree);
    }

    protected OptimizationState optimizeExtensionalDataNodes(RelationDefinition relationDefinition, Collection<ExtensionalDataNode> dataNodes) {
        OptimizationState initialState = new OptimizationState((ImmutableSet<ImmutableExpression>)ImmutableSet.of(), dataNodes, (ImmutableSubstitution<VariableOrGroundTerm>)this.substitutionFactory.getSubstitution());
        if (dataNodes.size() < 2) {
            return initialState;
        }
        return this.extractConstraints(relationDefinition).reduce(initialState, (s, c) -> this.simplifyUsingConstraint((C)c, (OptimizationState)s), (ns1, ns2) -> {
            throw new MinorOntopInternalBugException("Not expected to be executed in //");
        });
    }

    protected abstract Stream<C> extractConstraints(RelationDefinition var1);

    private OptimizationState simplifyUsingConstraint(C constraint, OptimizationState state) {
        if (state.extensionalDataNodes.size() < 2) {
            return state;
        }
        ImmutableList ucIndexes = (ImmutableList)constraint.getDeterminants().stream().map(a -> a.getIndex() - 1).collect(ImmutableCollectors.toList());
        ImmutableMap map = ((ImmutableMultimap)state.extensionalDataNodes.stream().collect(ImmutableCollectors.toMultimap(n -> (ImmutableList)ucIndexes.stream().map(i -> Optional.ofNullable(n.getArgumentMap().get(i)).map(t -> t)).collect(ImmutableCollectors.toList()), n -> n))).asMap();
        ImmutableList simplifications = (ImmutableList)map.entrySet().stream().filter(e -> ((Collection)e.getValue()).size() > 1).filter(e -> ((ImmutableList)e.getKey()).stream().allMatch(Optional::isPresent)).map(e -> this.evaluateDeterminantGroup((ImmutableList<VariableOrGroundTerm>)((ImmutableList)((ImmutableList)e.getKey()).stream().map(Optional::get).collect(ImmutableCollectors.toList())), (Collection)e.getValue(), constraint)).collect(ImmutableCollectors.toList());
        if (simplifications.stream().anyMatch(s -> !s.isPresent())) {
            return this.noSolutionState;
        }
        Optional<ImmutableSubstitution<VariableOrGroundTerm>> optionalUnifier = this.unifySubstitutions(Stream.concat(simplifications.stream().map(Optional::get).map(s -> s.substitution), Stream.of(state.substitution)));
        if (!optionalUnifier.isPresent()) {
            return this.noSolutionState;
        }
        ImmutableSubstitution<VariableOrGroundTerm> unifier = optionalUnifier.get();
        ImmutableSet newExpressions = (ImmutableSet)Stream.concat(state.newExpressions.stream(), simplifications.stream().map(Optional::get).flatMap(s -> s.expressions.stream())).collect(ImmutableCollectors.toSet());
        ImmutableList newDataNodes = (ImmutableList)Stream.concat(simplifications.stream().map(Optional::get).flatMap(s -> s.dataNodes.stream()), map.entrySet().stream().filter(e -> ((ImmutableList)e.getKey()).stream().anyMatch(o -> !o.isPresent()) || ((Collection)e.getValue()).size() < 2).flatMap(e -> ((Collection)e.getValue()).stream())).map(n -> this.applySubstitution(unifier, (ExtensionalDataNode)n)).collect(ImmutableCollectors.toList());
        return new OptimizationState((ImmutableSet<ImmutableExpression>)newExpressions, (Collection<ExtensionalDataNode>)newDataNodes, unifier);
    }

    private ExtensionalDataNode applySubstitution(ImmutableSubstitution<VariableOrGroundTerm> substitution, ExtensionalDataNode dataNode) {
        return this.iqFactory.createExtensionalDataNode(dataNode.getRelationDefinition(), substitution.applyToArgumentMap(dataNode.getArgumentMap()));
    }

    protected abstract Optional<DeterminantGroupEvaluation> evaluateDeterminantGroup(ImmutableList<VariableOrGroundTerm> var1, Collection<ExtensionalDataNode> var2, C var3);

    protected Optional<ImmutableUnificationTools.ArgumentMapUnification> unifyDataNodes(Stream<ExtensionalDataNode> dataNodes) {
        return dataNodes.reduce(null, (o, n) -> o == null ? Optional.of(new ImmutableUnificationTools.ArgumentMapUnification(n.getArgumentMap(), this.substitutionFactory.getSubstitution())) : o.flatMap(u -> this.unify((ImmutableUnificationTools.ArgumentMapUnification)u, (ImmutableMap<Integer, ? extends VariableOrGroundTerm>)((ImmutableMap<Integer, VariableOrGroundTerm>)n.getArgumentMap()))), (m1, m2) -> {
            throw new MinorOntopInternalBugException("Was not expected to be runned in //");
        });
    }

    private Optional<ImmutableUnificationTools.ArgumentMapUnification> unify(ImmutableUnificationTools.ArgumentMapUnification previousUnification, ImmutableMap<Integer, ? extends VariableOrGroundTerm> argumentMap) {
        ImmutableMap updatedArgumentMap = previousUnification.substitution.applyToArgumentMap(argumentMap);
        return this.unificationTools.computeArgumentMapMGU(previousUnification.argumentMap, updatedArgumentMap).flatMap(u -> previousUnification.substitution.isEmpty() ? Optional.of(u) : this.unificationTools.computeAtomMGUS(previousUnification.substitution, u.substitution).map(s -> new ImmutableUnificationTools.ArgumentMapUnification(u.argumentMap, s)));
    }

    private Optional<ImmutableSubstitution<VariableOrGroundTerm>> unifySubstitutions(Stream<ImmutableSubstitution<VariableOrGroundTerm>> substitutions) {
        return substitutions.reduce(Optional.of(this.substitutionFactory.getSubstitution()), (o, s) -> o.flatMap(s1 -> this.unificationTools.computeAtomMGUS(s1, s)), (s1, s2) -> {
            throw new MinorOntopInternalBugException("No //");
        });
    }

    protected NormalizationBeforeUnification normalizeDataNodes(Collection<ExtensionalDataNode> dataNodes, UniqueConstraint constraint) {
        ImmutableSet groundFunctionalTerms = (ImmutableSet)dataNodes.stream().flatMap(n -> n.getArgumentMap().values().stream()).filter(t -> t instanceof GroundFunctionalTerm).map(t -> (GroundFunctionalTerm)t).collect(ImmutableCollectors.toSet());
        if (groundFunctionalTerms.isEmpty()) {
            return new NormalizationBeforeUnification(dataNodes, (ImmutableSet<ImmutableExpression>)ImmutableSet.of());
        }
        ImmutableMap groundFunctionalTermMap = (ImmutableMap)groundFunctionalTerms.stream().collect(ImmutableCollectors.toMap(t -> t, t -> this.termFactory.getVariable("v" + UUID.randomUUID().toString())));
        ImmutableList newDataNodes = (ImmutableList)dataNodes.stream().map(d -> this.normalizeDataNode((ExtensionalDataNode)d, (ImmutableMap<GroundFunctionalTerm, Variable>)groundFunctionalTermMap)).collect(ImmutableCollectors.toList());
        ImmutableSet equalities = (ImmutableSet)groundFunctionalTermMap.entrySet().stream().map(e -> this.termFactory.getStrictEquality((ImmutableTerm)e.getKey(), (ImmutableTerm)e.getValue(), new ImmutableTerm[0])).collect(ImmutableCollectors.toSet());
        return new NormalizationBeforeUnification((Collection<ExtensionalDataNode>)newDataNodes, (ImmutableSet<ImmutableExpression>)equalities);
    }

    private ExtensionalDataNode normalizeDataNode(ExtensionalDataNode dataNode, ImmutableMap<GroundFunctionalTerm, Variable> groundFunctionalTermMap) {
        ImmutableMap newArgumentMap = (ImmutableMap)dataNode.getArgumentMap().entrySet().stream().collect(ImmutableCollectors.toMap(Map.Entry::getKey, e -> Optional.ofNullable((VariableOrGroundTerm)groundFunctionalTermMap.get(e.getValue())).orElseGet(e::getValue)));
        return this.iqFactory.createExtensionalDataNode(dataNode.getRelationDefinition(), newArgumentMap);
    }

    protected static class NormalizationBeforeUnification {
        public final Collection<ExtensionalDataNode> dataNodes;
        public final ImmutableSet<ImmutableExpression> equalities;

        protected NormalizationBeforeUnification(Collection<ExtensionalDataNode> dataNodes, ImmutableSet<ImmutableExpression> equalities) {
            this.dataNodes = dataNodes;
            this.equalities = equalities;
        }
    }

    protected static class DeterminantGroupEvaluation {
        public final ImmutableSet<ImmutableExpression> expressions;
        public final ImmutableList<ExtensionalDataNode> dataNodes;
        public final ImmutableSubstitution<VariableOrGroundTerm> substitution;

        protected DeterminantGroupEvaluation(ImmutableSet<ImmutableExpression> expressions, ImmutableList<ExtensionalDataNode> dataNodes, ImmutableSubstitution<VariableOrGroundTerm> substitution) {
            this.expressions = expressions;
            this.dataNodes = dataNodes;
            this.substitution = substitution;
        }
    }

    protected static class OptimizationState {
        public final ImmutableSet<ImmutableExpression> newExpressions;
        public final Collection<ExtensionalDataNode> extensionalDataNodes;
        public final ImmutableSubstitution<VariableOrGroundTerm> substitution;

        protected OptimizationState(ImmutableSet<ImmutableExpression> newExpressions, Collection<ExtensionalDataNode> extensionalDataNodes, ImmutableSubstitution<VariableOrGroundTerm> substitution) {
            this.newExpressions = newExpressions;
            this.extensionalDataNodes = extensionalDataNodes;
            this.substitution = substitution;
        }
    }
}

