/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.iq.optimizer.impl;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import it.unibz.inf.ontop.injection.CoreSingletons;
import it.unibz.inf.ontop.iq.IQTree;
import it.unibz.inf.ontop.iq.node.BinaryNonCommutativeOperatorNode;
import it.unibz.inf.ontop.iq.node.ConstructionNode;
import it.unibz.inf.ontop.iq.node.FilterNode;
import it.unibz.inf.ontop.iq.node.InnerJoinNode;
import it.unibz.inf.ontop.iq.node.LeftJoinNode;
import it.unibz.inf.ontop.iq.node.NaryOperatorNode;
import it.unibz.inf.ontop.iq.node.OrderByNode;
import it.unibz.inf.ontop.iq.node.SliceNode;
import it.unibz.inf.ontop.iq.node.UnaryOperatorNode;
import it.unibz.inf.ontop.iq.node.UnionNode;
import it.unibz.inf.ontop.iq.transform.IQTreeTransformer;
import it.unibz.inf.ontop.iq.transform.IQTreeVisitingTransformer;
import it.unibz.inf.ontop.iq.transform.impl.DefaultNonRecursiveIQTreeTransformer;
import it.unibz.inf.ontop.model.term.ImmutableExpression;
import it.unibz.inf.ontop.model.term.Variable;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import java.util.Optional;
import java.util.Set;
import java.util.stream.IntStream;

public abstract class AbstractDiscardedVariablesTransformer
extends DefaultNonRecursiveIQTreeTransformer {
    private final IQTreeTransformer lookForDistinctTransformer;
    private final ImmutableSet<Variable> discardedVariables;
    protected final CoreSingletons coreSingletons;

    protected AbstractDiscardedVariablesTransformer(ImmutableSet<Variable> discardedVariables, IQTreeTransformer lookForDistinctTransformer, CoreSingletons coreSingletons) {
        this.discardedVariables = discardedVariables;
        this.coreSingletons = coreSingletons;
        this.lookForDistinctTransformer = lookForDistinctTransformer;
    }

    protected abstract AbstractDiscardedVariablesTransformer update(ImmutableSet<Variable> var1);

    public IQTree transformInnerJoin(IQTree tree, InnerJoinNode rootNode, ImmutableList<IQTree> children) {
        ImmutableSet<Variable> discardedVariablesAfterJoiningCondition = rootNode.getOptionalFilterCondition().map(c -> Sets.difference(this.discardedVariables, (Set)c.getVariables()).immutableCopy()).orElse(this.discardedVariables);
        ImmutableList discardedVariablesPerChild = (ImmutableList)IntStream.range(0, children.size()).boxed().map(i -> this.extractDiscardedVariablesForInnerJoinChild((int)i, children, discardedVariablesAfterJoiningCondition)).collect(ImmutableCollectors.toList());
        ImmutableList partiallySimplifiedChildren = (ImmutableList)IntStream.range(0, children.size()).boxed().map(i -> this.update((ImmutableSet<Variable>)((ImmutableSet)discardedVariablesPerChild.get(i.intValue()))).transform((IQTree)children.get(i.intValue()))).collect(ImmutableCollectors.toList());
        return this.furtherSimplifyInnerJoinChildren((ImmutableList<ImmutableSet<Variable>>)discardedVariablesPerChild, rootNode.getOptionalFilterCondition(), (ImmutableList<IQTree>)partiallySimplifiedChildren).orElseGet(() -> partiallySimplifiedChildren.equals((Object)children) ? tree : this.coreSingletons.getIQFactory().createNaryIQTree((NaryOperatorNode)rootNode, partiallySimplifiedChildren));
    }

    private ImmutableSet<Variable> extractDiscardedVariablesForInnerJoinChild(int childPosition, ImmutableList<IQTree> children, ImmutableSet<Variable> discardedVariablesAfterJoiningCondition) {
        return Sets.difference(discardedVariablesAfterJoiningCondition, (Set)((Set)IntStream.range(0, children.size()).filter(i -> i != childPosition).boxed().map(arg_0 -> children.get(arg_0)).flatMap(c -> c.getVariables().stream()).collect(ImmutableCollectors.toSet()))).immutableCopy();
    }

    protected abstract Optional<IQTree> furtherSimplifyInnerJoinChildren(ImmutableList<ImmutableSet<Variable>> var1, Optional<ImmutableExpression> var2, ImmutableList<IQTree> var3);

    public IQTree transformConstruction(IQTree tree, ConstructionNode rootNode, IQTree child) {
        ImmutableSet newDiscardedVariables = Sets.difference((Set)child.getVariables(), (Set)rootNode.getLocallyRequiredVariables()).immutableCopy();
        AbstractDiscardedVariablesTransformer newTransformer = this.update((ImmutableSet<Variable>)newDiscardedVariables);
        IQTree newChild = child.acceptTransformer((IQTreeVisitingTransformer)newTransformer);
        return newChild.equals(child) ? tree : this.coreSingletons.getIQFactory().createUnaryIQTree((UnaryOperatorNode)rootNode, newChild);
    }

    public IQTree transformSlice(IQTree tree, SliceNode sliceNode, IQTree child) {
        IQTree newChild = this.transform(child);
        return newChild.equals(child) ? tree : this.coreSingletons.getIQFactory().createUnaryIQTree((UnaryOperatorNode)sliceNode, newChild);
    }

    public IQTree transformOrderBy(IQTree tree, OrderByNode rootNode, IQTree child) {
        IQTree newChild = this.transform(child);
        return newChild.equals(child) ? tree : this.coreSingletons.getIQFactory().createUnaryIQTree((UnaryOperatorNode)rootNode, newChild);
    }

    public IQTree transformFilter(IQTree tree, FilterNode rootNode, IQTree child) {
        ImmutableSet newDiscardedVariables = Sets.difference(this.discardedVariables, (Set)rootNode.getFilterCondition().getVariables()).immutableCopy();
        AbstractDiscardedVariablesTransformer newTransformer = this.update((ImmutableSet<Variable>)newDiscardedVariables);
        IQTree newChild = child.acceptTransformer((IQTreeVisitingTransformer)newTransformer);
        return newChild.equals(child) ? tree : this.coreSingletons.getIQFactory().createUnaryIQTree((UnaryOperatorNode)rootNode, newChild);
    }

    public IQTree transformUnion(IQTree tree, UnionNode rootNode, ImmutableList<IQTree> children) {
        ImmutableList newChildren = (ImmutableList)children.stream().map(arg_0 -> ((AbstractDiscardedVariablesTransformer)this).transform(arg_0)).collect(ImmutableCollectors.toList());
        return newChildren.equals(children) ? tree : this.coreSingletons.getIQFactory().createNaryIQTree((NaryOperatorNode)rootNode, newChildren);
    }

    public IQTree transformLeftJoin(IQTree tree, LeftJoinNode rootNode, IQTree leftChild, IQTree rightChild) {
        ImmutableSet<Variable> newDiscardedVariables = rootNode.getOptionalFilterCondition().map(c -> Sets.difference(this.discardedVariables, (Set)c.getVariables()).immutableCopy()).orElse(this.discardedVariables);
        AbstractDiscardedVariablesTransformer newTransformer = this.update(newDiscardedVariables);
        IQTree newLeftChild = leftChild.acceptTransformer((IQTreeVisitingTransformer)newTransformer);
        IQTree newRightChild = rightChild.acceptTransformer((IQTreeVisitingTransformer)newTransformer);
        return newLeftChild.equals(leftChild) && newRightChild.equals(rightChild) ? tree : this.coreSingletons.getIQFactory().createBinaryNonCommutativeIQTree((BinaryNonCommutativeOperatorNode)rootNode, newLeftChild, newRightChild);
    }

    protected IQTree transformUnaryNode(IQTree tree, UnaryOperatorNode rootNode, IQTree child) {
        return this.lookForDistinctTransformer.transform(tree);
    }

    protected IQTree transformNaryCommutativeNode(IQTree tree, NaryOperatorNode rootNode, ImmutableList<IQTree> children) {
        return this.lookForDistinctTransformer.transform(tree);
    }

    protected IQTree transformBinaryNonCommutativeNode(IQTree tree, BinaryNonCommutativeOperatorNode rootNode, IQTree leftChild, IQTree rightChild) {
        return this.lookForDistinctTransformer.transform(tree);
    }
}

