/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.iq.executor.leftjoin;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import it.unibz.inf.ontop.exception.MinorOntopInternalBugException;
import it.unibz.inf.ontop.injection.IntermediateQueryFactory;
import it.unibz.inf.ontop.iq.IntermediateQuery;
import it.unibz.inf.ontop.iq.exception.EmptyQueryException;
import it.unibz.inf.ontop.iq.exception.InvalidIntermediateQueryException;
import it.unibz.inf.ontop.iq.exception.InvalidQueryOptimizationProposalException;
import it.unibz.inf.ontop.iq.executor.SimpleNodeCentricExecutor;
import it.unibz.inf.ontop.iq.executor.leftjoin.LeftJoinRightChildNormalizationAnalyzer;
import it.unibz.inf.ontop.iq.impl.QueryTreeComponent;
import it.unibz.inf.ontop.iq.node.BinaryOrderedOperatorNode;
import it.unibz.inf.ontop.iq.node.ConstructionNode;
import it.unibz.inf.ontop.iq.node.ExtensionalDataNode;
import it.unibz.inf.ontop.iq.node.FilterNode;
import it.unibz.inf.ontop.iq.node.InnerJoinNode;
import it.unibz.inf.ontop.iq.node.LeftJoinNode;
import it.unibz.inf.ontop.iq.node.QueryNode;
import it.unibz.inf.ontop.iq.node.UnionNode;
import it.unibz.inf.ontop.iq.node.VariableNullability;
import it.unibz.inf.ontop.iq.proposal.LeftJoinOptimizationProposal;
import it.unibz.inf.ontop.iq.proposal.NodeCentricOptimizationResults;
import it.unibz.inf.ontop.iq.proposal.impl.NodeCentricOptimizationResultsImpl;
import it.unibz.inf.ontop.iq.proposal.impl.SubstitutionPropagationProposalImpl;
import it.unibz.inf.ontop.iq.tools.IQConverter;
import it.unibz.inf.ontop.model.term.ImmutableExpression;
import it.unibz.inf.ontop.model.term.ImmutableTerm;
import it.unibz.inf.ontop.model.term.TermFactory;
import it.unibz.inf.ontop.model.term.Variable;
import it.unibz.inf.ontop.model.term.functionsymbol.db.DBFunctionSymbolFactory;
import it.unibz.inf.ontop.substitution.ImmutableSubstitution;
import it.unibz.inf.ontop.substitution.InjectiveVar2VarSubstitution;
import it.unibz.inf.ontop.substitution.SubstitutionFactory;
import it.unibz.inf.ontop.utils.CoreUtilsFactory;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import it.unibz.inf.ontop.utils.VariableGenerator;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;

@Singleton
public class LeftToInnerJoinExecutor
implements SimpleNodeCentricExecutor<LeftJoinNode, LeftJoinOptimizationProposal> {
    private final LeftJoinRightChildNormalizationAnalyzer normalizer;
    private final IntermediateQueryFactory iqFactory;
    private final TermFactory termFactory;
    private final SubstitutionFactory substitutionFactory;
    private final DBFunctionSymbolFactory dbFunctionSymbolFactory;
    private final CoreUtilsFactory coreUtilsFactory;
    private final IQConverter iqConverter;

    @Inject
    private LeftToInnerJoinExecutor(LeftJoinRightChildNormalizationAnalyzer normalizer, IntermediateQueryFactory iqFactory, TermFactory termFactory, SubstitutionFactory substitutionFactory, DBFunctionSymbolFactory dbFunctionSymbolFactory, CoreUtilsFactory coreUtilsFactory, IQConverter iqConverter) {
        this.normalizer = normalizer;
        this.iqFactory = iqFactory;
        this.termFactory = termFactory;
        this.substitutionFactory = substitutionFactory;
        this.dbFunctionSymbolFactory = dbFunctionSymbolFactory;
        this.coreUtilsFactory = coreUtilsFactory;
        this.iqConverter = iqConverter;
    }

    public NodeCentricOptimizationResults<LeftJoinNode> apply(LeftJoinOptimizationProposal proposal, IntermediateQuery query, QueryTreeComponent treeComponent) throws InvalidQueryOptimizationProposalException {
        LeftJoinNode leftJoinNode = (LeftJoinNode)proposal.getFocusNode();
        QueryNode leftChild = (QueryNode)query.getChild((QueryNode)leftJoinNode, BinaryOrderedOperatorNode.ArgumentPosition.LEFT).orElseThrow(() -> new InvalidIntermediateQueryException("A LJ must have a left child"));
        QueryNode rightChild = (QueryNode)query.getChild((QueryNode)leftJoinNode, BinaryOrderedOperatorNode.ArgumentPosition.RIGHT).orElseThrow(() -> new InvalidIntermediateQueryException("A LJ must have a right child"));
        Optional<ImmutableList<ExtensionalDataNode>> optionalLeftDataNodes = this.extractLeftDataNodes(query, leftChild);
        if (optionalLeftDataNodes.isPresent()) {
            ImmutableList<ExtensionalDataNode> leftDataNodes = optionalLeftDataNodes.get();
            if (rightChild instanceof ExtensionalDataNode) {
                return this.optimizeRightDataNode(leftJoinNode, query, treeComponent, leftChild, leftDataNodes, DataNodeAndSubstitution.extract((ExtensionalDataNode)rightChild));
            }
            if (rightChild instanceof ConstructionNode) {
                return DataNodeAndSubstitution.extract((ConstructionNode)rightChild, query).map(n -> this.optimizeRightDataNode(leftJoinNode, query, treeComponent, leftChild, leftDataNodes, (DataNodeAndSubstitution)n)).orElseGet(() -> new NodeCentricOptimizationResultsImpl<LeftJoinNode>(query, leftJoinNode));
            }
            if (rightChild instanceof UnionNode) {
                return this.optimizeRightUnion(leftJoinNode, query, treeComponent, leftChild, leftDataNodes, (UnionNode)rightChild);
            }
        }
        return new NodeCentricOptimizationResultsImpl<LeftJoinNode>(query, leftJoinNode);
    }

    private Optional<ImmutableList<ExtensionalDataNode>> extractLeftDataNodes(IntermediateQuery query, QueryNode leftNode) {
        ImmutableList children;
        if (leftNode instanceof ExtensionalDataNode) {
            return Optional.of(ImmutableList.of((Object)((ExtensionalDataNode)leftNode)));
        }
        if (leftNode instanceof InnerJoinNode && (children = query.getChildren(leftNode)).stream().allMatch(c -> c instanceof ExtensionalDataNode)) {
            return Optional.of(children.stream().map(c -> (ExtensionalDataNode)c).collect(ImmutableCollectors.toList()));
        }
        return Optional.empty();
    }

    private NodeCentricOptimizationResults<LeftJoinNode> optimizeRightDataNode(LeftJoinNode leftJoinNode, IntermediateQuery query, QueryTreeComponent treeComponent, QueryNode leftChild, ImmutableList<ExtensionalDataNode> leftChildren, DataNodeAndSubstitution rightComponent) {
        ExtensionalDataNode newRightChild;
        VariableNullability variableNullability;
        VariableGenerator variableGenerator;
        ImmutableSet leftVariables = query.getVariables(leftChild);
        LeftJoinRightChildNormalizationAnalyzer.LeftJoinRightChildNormalizationAnalysis analysis = this.normalizer.analyze((ImmutableSet<Variable>)leftVariables, leftChildren, rightComponent.dataNode, variableGenerator = this.coreUtilsFactory.createVariableGenerator((Collection)query.getKnownVariables()), variableNullability = this.extractVariableNullability(query, leftJoinNode));
        if (!analysis.isMatchingAConstraint()) {
            return new NodeCentricOptimizationResultsImpl<LeftJoinNode>(query, leftJoinNode);
        }
        ImmutableSet requiredVariablesAboveLJ = query.getVariablesRequiredByAncestors((QueryNode)leftJoinNode);
        Optional newLJCondition = this.termFactory.getConjunction(Stream.concat(Stream.of(leftJoinNode.getOptionalFilterCondition(), analysis.getAdditionalExpression(), rightComponent.filterNode.map(FilterNode::getFilterCondition)).filter(Optional::isPresent).map(Optional::get), rightComponent.constructionNode.map(n -> this.extractEqualities((ImmutableSubstitution<ImmutableTerm>)n.getSubstitution(), (ImmutableSet<Variable>)leftVariables)).orElseGet(Stream::empty)));
        Optional<ImmutableSubstitution> remainingRightSubstitution = rightComponent.constructionNode.map(ConstructionNode::getSubstitution).filter(s -> !s.isEmpty()).map(s -> this.substitutionFactory.getSubstitution((ImmutableMap)s.getImmutableMap().entrySet().stream().filter(e -> !leftVariables.contains(e.getKey())).collect(ImmutableCollectors.toMap()))).filter(s -> !s.isEmpty());
        LeftJoinNode normalizedLeftJoin = this.updateRightNodesAndLJ(leftJoinNode, rightComponent, newLJCondition, analysis.getProposedRightDataNode(), treeComponent);
        LeftJoinNode leftJoinNodeToUpgrade = newLJCondition.map(arg_0 -> this.lambda$optimizeRightDataNode$11(normalizedLeftJoin, leftChild, newRightChild = analysis.getProposedRightDataNode().orElse(rightComponent.dataNode), requiredVariablesAboveLJ, treeComponent, remainingRightSubstitution, variableGenerator, query, arg_0)).orElseGet(() -> remainingRightSubstitution.map(s -> this.liftSubstitution(normalizedLeftJoin, (ImmutableSubstitution<ImmutableTerm>)s, query)).orElse(normalizedLeftJoin));
        if (leftJoinNodeToUpgrade.getOptionalFilterCondition().isPresent()) {
            throw new MinorOntopInternalBugException("Bug: at this point the lj must not have a joining condition");
        }
        InnerJoinNode innerJoinNode = this.iqFactory.createInnerJoinNode();
        treeComponent.replaceNode((QueryNode)leftJoinNodeToUpgrade, (QueryNode)innerJoinNode);
        return new NodeCentricOptimizationResultsImpl<LeftJoinNode>(query, Optional.of(innerJoinNode));
    }

    private VariableNullability extractVariableNullability(IntermediateQuery query, LeftJoinNode leftJoinNode) {
        return this.iqConverter.convertTree(query, this.findAncestorForVariableNullability(query, (QueryNode)leftJoinNode)).getVariableNullability();
    }

    private QueryNode findAncestorForVariableNullability(IntermediateQuery query, QueryNode queryNode) {
        return query.getParent(queryNode).filter(p -> p instanceof LeftJoinNode && query.getOptionalPosition(p, queryNode).filter(pos -> pos.equals((Object)BinaryOrderedOperatorNode.ArgumentPosition.LEFT)).isPresent() || p instanceof InnerJoinNode || p instanceof FilterNode).map(p -> this.findAncestorForVariableNullability(query, (QueryNode)p)).orElse(queryNode);
    }

    private Stream<ImmutableExpression> extractEqualities(ImmutableSubstitution<ImmutableTerm> substitution, ImmutableSet<Variable> leftVariables) {
        return substitution.getImmutableMap().entrySet().stream().filter(e -> leftVariables.contains(e.getKey()) || leftVariables.contains(e.getValue())).map(e -> this.termFactory.getStrictEquality((ImmutableTerm)e.getKey(), (ImmutableTerm)e.getValue(), new ImmutableTerm[0]));
    }

    private LeftJoinNode updateRightNodesAndLJ(LeftJoinNode leftJoinNode, DataNodeAndSubstitution rightComponent, Optional<ImmutableExpression> newLJCondition, Optional<ExtensionalDataNode> proposedRightDataNode, QueryTreeComponent treeComponent) {
        ImmutableSet projectedVariables = treeComponent.getVariables((QueryNode)leftJoinNode);
        rightComponent.constructionNode.ifPresent(n -> treeComponent.replaceNodeByChild((QueryNode)n, Optional.empty()));
        rightComponent.filterNode.ifPresent(n -> treeComponent.replaceNodeByChild((QueryNode)n, Optional.empty()));
        proposedRightDataNode.ifPresent(n -> treeComponent.replaceNode((QueryNode)rightComponent.dataNode, (QueryNode)n));
        LeftJoinNode newLeftJoinNode = leftJoinNode.changeOptionalFilterCondition(newLJCondition);
        treeComponent.replaceNode((QueryNode)leftJoinNode, (QueryNode)newLeftJoinNode);
        ImmutableSet tmpProjectedVariables = treeComponent.getVariables((QueryNode)newLeftJoinNode);
        if (!projectedVariables.equals((Object)tmpProjectedVariables)) {
            treeComponent.insertParent((QueryNode)newLeftJoinNode, (QueryNode)this.iqFactory.createConstructionNode(projectedVariables));
        }
        return newLeftJoinNode;
    }

    private LeftJoinNode liftCondition(LeftJoinNode leftJoinNode, QueryNode leftChild, ExtensionalDataNode rightChild, ImmutableSet<Variable> requiredVariablesAboveLJ, QueryTreeComponent treeComponent, Optional<ImmutableSubstitution<ImmutableTerm>> remainingRightSubstitution, VariableGenerator variableGenerator, IntermediateQuery query) {
        ImmutableExpression ljCondition = (ImmutableExpression)leftJoinNode.getOptionalFilterCondition().orElseThrow(() -> new IllegalArgumentException("The LJ is expected to have a joining condition"));
        ImmutableSet leftVariables = query.getVariables(leftChild);
        ImmutableSet requiredRightVariables = (ImmutableSet)requiredVariablesAboveLJ.stream().filter(v -> !leftVariables.contains(v)).collect(ImmutableCollectors.toSet());
        ImmutableSet rightVariablesToUpdate = Optional.of(ljCondition).filter(c -> c.getFunctionSymbol().equals(this.dbFunctionSymbolFactory.getDBIsNotNull())).map(c -> (ImmutableTerm)c.getTerms().get(0)).filter(t -> t instanceof Variable).map(v -> (Variable)v).map(specialVariable -> (ImmutableSet)requiredRightVariables.stream().filter(v -> !v.equals(specialVariable)).collect(ImmutableCollectors.toSet())).orElse(requiredRightVariables);
        LeftJoinNode newLeftJoinNode = leftJoinNode.changeOptionalFilterCondition(Optional.empty());
        treeComponent.replaceNode((QueryNode)leftJoinNode, (QueryNode)newLeftJoinNode);
        return rightVariablesToUpdate.isEmpty() && !remainingRightSubstitution.isPresent() ? newLeftJoinNode : this.updateConditionalVariables((ImmutableSet<Variable>)rightVariablesToUpdate, rightChild, newLeftJoinNode, ljCondition, query, treeComponent, remainingRightSubstitution, variableGenerator);
    }

    private LeftJoinNode updateConditionalVariables(ImmutableSet<Variable> rightVariablesToUpdate, ExtensionalDataNode rightChild, LeftJoinNode newLeftJoinNode, ImmutableExpression ljCondition, IntermediateQuery query, QueryTreeComponent treeComponent, Optional<ImmutableSubstitution<ImmutableTerm>> remainingRightSubstitution, VariableGenerator variableGenerator) {
        ImmutableMap newVariableMap = (ImmutableMap)rightVariablesToUpdate.stream().collect(ImmutableCollectors.toMap(v -> v, arg_0 -> ((VariableGenerator)variableGenerator).generateNewVariableFromVar(arg_0)));
        InjectiveVar2VarSubstitution localSubstitution = this.substitutionFactory.getInjectiveVar2VarSubstitution((Map)newVariableMap);
        ExtensionalDataNode newRightChild = this.iqFactory.createExtensionalDataNode(rightChild.getRelationDefinition(), localSubstitution.applyToArgumentMap(rightChild.getArgumentMap()));
        treeComponent.replaceNode((QueryNode)rightChild, (QueryNode)newRightChild);
        ImmutableExpression newCondition = localSubstitution.applyToBooleanExpression(ljCondition);
        ImmutableSubstitution conditionalVarSubstitution = this.substitutionFactory.getSubstitution((ImmutableMap)newVariableMap.entrySet().stream().collect(ImmutableCollectors.toMap(Map.Entry::getKey, e -> this.termFactory.getIfElseNull(newCondition, (ImmutableTerm)e.getValue()))));
        ImmutableSubstitution substitutionToPropagate = remainingRightSubstitution.map(arg_0 -> ((InjectiveVar2VarSubstitution)localSubstitution).applyRenaming(arg_0)).map(s -> s.composeWith(conditionalVarSubstitution)).orElse(conditionalVarSubstitution);
        SubstitutionPropagationProposalImpl<LeftJoinNode> proposal = new SubstitutionPropagationProposalImpl<LeftJoinNode>(newLeftJoinNode, (ImmutableSubstitution<? extends ImmutableTerm>)substitutionToPropagate);
        try {
            return ((NodeCentricOptimizationResults)query.applyProposal(proposal, true)).getNewNodeOrReplacingChild().flatMap(arg_0 -> ((IntermediateQuery)query).getFirstChild(arg_0)).filter(n -> n instanceof LeftJoinNode).map(n -> (LeftJoinNode)n).orElseThrow(() -> new MinorOntopInternalBugException("Was expected to keep the LJ node under a fresh construction node"));
        }
        catch (EmptyQueryException e2) {
            throw new MinorOntopInternalBugException("This substitution propagation was not expected to make the query be empty");
        }
    }

    private LeftJoinNode liftSubstitution(LeftJoinNode normalizedLeftJoin, ImmutableSubstitution<ImmutableTerm> remainingRightSubstitution, IntermediateQuery query) {
        SubstitutionPropagationProposalImpl<LeftJoinNode> proposal = new SubstitutionPropagationProposalImpl<LeftJoinNode>(normalizedLeftJoin, remainingRightSubstitution);
        try {
            NodeCentricOptimizationResults results = (NodeCentricOptimizationResults)query.applyProposal(proposal, true);
            return results.getNewNodeOrReplacingChild().flatMap(arg_0 -> ((IntermediateQuery)query).getFirstChild(arg_0)).filter(n -> n instanceof LeftJoinNode).map(n -> (LeftJoinNode)n).orElseThrow(() -> new MinorOntopInternalBugException("Was expected to insert a construction node followed by a LJ"));
        }
        catch (EmptyQueryException e) {
            throw new MinorOntopInternalBugException("This substitution propagation was not expected to make the query be empty");
        }
    }

    private NodeCentricOptimizationResults<LeftJoinNode> optimizeRightUnion(LeftJoinNode leftJoinNode, IntermediateQuery query, QueryTreeComponent treeComponent, QueryNode leftChild, ImmutableList<ExtensionalDataNode> leftDataNodes, UnionNode rightChild) {
        return new NodeCentricOptimizationResultsImpl<LeftJoinNode>(query, leftJoinNode);
    }

    private /* synthetic */ LeftJoinNode lambda$optimizeRightDataNode$11(LeftJoinNode normalizedLeftJoin, QueryNode leftChild, ExtensionalDataNode newRightChild, ImmutableSet requiredVariablesAboveLJ, QueryTreeComponent treeComponent, Optional remainingRightSubstitution, VariableGenerator variableGenerator, IntermediateQuery query, ImmutableExpression ljCondition) {
        return this.liftCondition(normalizedLeftJoin, leftChild, newRightChild, (ImmutableSet<Variable>)requiredVariablesAboveLJ, treeComponent, remainingRightSubstitution, variableGenerator, query);
    }

    private static class DataNodeAndSubstitution {
        public final ExtensionalDataNode dataNode;
        public final Optional<FilterNode> filterNode;
        public final Optional<ConstructionNode> constructionNode;

        private DataNodeAndSubstitution(ExtensionalDataNode dataNode, Optional<FilterNode> filterNode, Optional<ConstructionNode> constructionNode) {
            this.dataNode = dataNode;
            this.filterNode = filterNode;
            this.constructionNode = constructionNode;
        }

        private DataNodeAndSubstitution(ExtensionalDataNode dataNode) {
            this.dataNode = dataNode;
            this.filterNode = Optional.empty();
            this.constructionNode = Optional.empty();
        }

        static Optional<DataNodeAndSubstitution> extract(ConstructionNode rightChild, IntermediateQuery query) {
            QueryNode grandChild = (QueryNode)query.getFirstChild((QueryNode)rightChild).get();
            if (grandChild instanceof ExtensionalDataNode) {
                return Optional.of(new DataNodeAndSubstitution((ExtensionalDataNode)grandChild, Optional.empty(), Optional.of(rightChild)));
            }
            if (grandChild instanceof FilterNode) {
                FilterNode filterNode = (FilterNode)grandChild;
                return query.getFirstChild(grandChild).filter(n -> n instanceof ExtensionalDataNode).map(n -> (ExtensionalDataNode)n).map(n -> new DataNodeAndSubstitution((ExtensionalDataNode)n, Optional.of(filterNode), Optional.of(rightChild)));
            }
            return Optional.empty();
        }

        static DataNodeAndSubstitution extract(ExtensionalDataNode rightChild) {
            return new DataNodeAndSubstitution(rightChild);
        }
    }
}

