/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.iq.executor.join;

import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.inject.Inject;
import it.unibz.inf.ontop.dbschema.ForeignKeyConstraint;
import it.unibz.inf.ontop.dbschema.RelationDefinition;
import it.unibz.inf.ontop.injection.IntermediateQueryFactory;
import it.unibz.inf.ontop.iq.IntermediateQuery;
import it.unibz.inf.ontop.iq.exception.InvalidQueryOptimizationProposalException;
import it.unibz.inf.ontop.iq.executor.join.InnerJoinExecutor;
import it.unibz.inf.ontop.iq.impl.QueryTreeComponent;
import it.unibz.inf.ontop.iq.node.ExtensionalDataNode;
import it.unibz.inf.ontop.iq.node.FilterNode;
import it.unibz.inf.ontop.iq.node.InnerJoinNode;
import it.unibz.inf.ontop.iq.node.QueryNode;
import it.unibz.inf.ontop.iq.proposal.InnerJoinOptimizationProposal;
import it.unibz.inf.ontop.iq.proposal.NodeCentricOptimizationResults;
import it.unibz.inf.ontop.iq.proposal.impl.NodeCentricOptimizationResultsImpl;
import it.unibz.inf.ontop.iq.tools.impl.NaiveVariableOccurrenceAnalyzerImpl;
import it.unibz.inf.ontop.model.term.ImmutableExpression;
import it.unibz.inf.ontop.model.term.TermFactory;
import it.unibz.inf.ontop.model.term.Variable;
import it.unibz.inf.ontop.model.term.VariableOrGroundTerm;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;

public class RedundantJoinFKExecutor
implements InnerJoinExecutor {
    private final IntermediateQueryFactory iqFactory;
    private final TermFactory termFactory;

    @Inject
    private RedundantJoinFKExecutor(IntermediateQueryFactory iqFactory, TermFactory termFactory) {
        this.iqFactory = iqFactory;
        this.termFactory = termFactory;
    }

    public NodeCentricOptimizationResults<InnerJoinNode> apply(InnerJoinOptimizationProposal proposal, IntermediateQuery query, QueryTreeComponent treeComponent) throws InvalidQueryOptimizationProposalException {
        InnerJoinNode joinNode = (InnerJoinNode)proposal.getFocusNode();
        ImmutableMultimap<RelationDefinition, ExtensionalDataNode> dataNodeMap = this.extractDataNodeMap(query, joinNode);
        ImmutableList<Redundancy> redundancies = this.findRedundancies(query, joinNode, dataNodeMap);
        ImmutableSet nodesToRemove = (ImmutableSet)redundancies.stream().map(r -> ((Redundancy)r).dataNode).collect(ImmutableCollectors.toSet());
        ImmutableSet variablesToRequireNonNull = (ImmutableSet)redundancies.stream().flatMap(r -> ((Redundancy)r).fkVariables.stream()).collect(ImmutableCollectors.toSet());
        if (!nodesToRemove.isEmpty()) {
            NodeCentricOptimizationResults<InnerJoinNode> result = this.applyOptimization(query, treeComponent, joinNode, (ImmutableSet<ExtensionalDataNode>)nodesToRemove, (ImmutableSet<Variable>)variablesToRequireNonNull);
            return result;
        }
        return new NodeCentricOptimizationResultsImpl<InnerJoinNode>(query, joinNode);
    }

    private NodeCentricOptimizationResults<InnerJoinNode> applyOptimization(IntermediateQuery query, QueryTreeComponent treeComponent, InnerJoinNode joinNode, ImmutableSet<ExtensionalDataNode> nodesToRemove, ImmutableSet<Variable> variablesToRequireNonNull) {
        nodesToRemove.forEach(arg_0 -> ((QueryTreeComponent)treeComponent).removeSubTree(arg_0));
        Optional newCondition = joinNode.getOptionalFilterCondition().map(c -> this.termFactory.getConjunction(Stream.concat(c.flattenAND(), variablesToRequireNonNull.stream().map(arg_0 -> ((TermFactory)this.termFactory).getDBIsNotNull(arg_0))))).orElseGet(() -> this.termFactory.getConjunction(variablesToRequireNonNull.stream().map(arg_0 -> ((TermFactory)this.termFactory).getDBIsNotNull(arg_0))));
        switch (query.getChildren((QueryNode)joinNode).size()) {
            case 0: {
                throw new IllegalStateException("Redundant join elimination should not eliminate all the children");
            }
            case 1: {
                QueryNode replacingChild = (QueryNode)query.getFirstChild((QueryNode)joinNode).get();
                if (newCondition.isPresent()) {
                    FilterNode newFilterNode = this.iqFactory.createFilterNode((ImmutableExpression)newCondition.get());
                    treeComponent.replaceNode((QueryNode)joinNode, (QueryNode)newFilterNode);
                } else {
                    treeComponent.replaceNodeByChild((QueryNode)joinNode, Optional.empty());
                }
                return new NodeCentricOptimizationResultsImpl<InnerJoinNode>(query, Optional.of(replacingChild));
            }
        }
        InnerJoinNode newJoinNode = this.iqFactory.createInnerJoinNode(newCondition);
        treeComponent.replaceNode((QueryNode)joinNode, (QueryNode)newJoinNode);
        return new NodeCentricOptimizationResultsImpl<InnerJoinNode>(query, newJoinNode);
    }

    private ImmutableMultimap<RelationDefinition, ExtensionalDataNode> extractDataNodeMap(IntermediateQuery query, InnerJoinNode joinNode) {
        return (ImmutableMultimap)query.getChildren((QueryNode)joinNode).stream().filter(c -> c instanceof ExtensionalDataNode).map(c -> (ExtensionalDataNode)c).map(c -> Maps.immutableEntry((Object)c.getRelationDefinition(), (Object)c)).collect(ImmutableCollectors.toMultimap());
    }

    private ImmutableList<Redundancy> findRedundancies(IntermediateQuery query, InnerJoinNode joinNode, ImmutableMultimap<RelationDefinition, ExtensionalDataNode> dataNodeMap) {
        return (ImmutableList)dataNodeMap.keySet().stream().flatMap(r -> r.getForeignKeys().stream().flatMap(c -> this.selectRedundantNodesForConstraint((RelationDefinition)r, (ForeignKeyConstraint)c, query, joinNode, dataNodeMap))).collect(ImmutableCollectors.toList());
    }

    private Stream<Redundancy> selectRedundantNodesForConstraint(RelationDefinition sourceRelation, ForeignKeyConstraint constraint, IntermediateQuery query, InnerJoinNode joinNode, ImmutableMultimap<RelationDefinition, ExtensionalDataNode> dataNodeMap) {
        ImmutableCollection targetDataNodes = dataNodeMap.get((Object)constraint.getReferencedRelation());
        if (targetDataNodes.isEmpty()) {
            return Stream.empty();
        }
        return dataNodeMap.get((Object)sourceRelation).stream().flatMap(s -> targetDataNodes.stream().filter(t -> this.areMatching((ExtensionalDataNode)s, (ExtensionalDataNode)t, constraint))).distinct().filter(t -> this.areNonFKColumnsUnused((ExtensionalDataNode)t, query, constraint)).map(t -> new Redundancy((ExtensionalDataNode)t, (ImmutableSet)this.extractJoiningVariables((ExtensionalDataNode)t, constraint)));
    }

    private boolean areMatching(ExtensionalDataNode sourceDataNode, ExtensionalDataNode targetDataNode, ForeignKeyConstraint constraint) {
        ImmutableMap sourceArgumentMap = sourceDataNode.getArgumentMap();
        ImmutableMap targetArgumentMap = targetDataNode.getArgumentMap();
        return constraint.getComponents().stream().allMatch(c -> {
            Optional<Object> source = Optional.ofNullable(sourceArgumentMap.get((Object)(c.getAttribute().getIndex() - 1)));
            return source.isPresent() && source.equals(Optional.ofNullable(targetArgumentMap.get((Object)(c.getReferencedAttribute().getIndex() - 1))));
        });
    }

    private boolean areNonFKColumnsUnused(ExtensionalDataNode targetDataNode, IntermediateQuery query, ForeignKeyConstraint constraint) {
        ImmutableList remainingTerms;
        block3: {
            block2: {
                ImmutableMap targetArguments = targetDataNode.getArgumentMap();
                ImmutableSet fkTargetIndexes = (ImmutableSet)constraint.getComponents().stream().map(c -> c.getReferencedAttribute().getIndex() - 1).collect(ImmutableCollectors.toSet());
                remainingTerms = (ImmutableList)targetArguments.entrySet().stream().filter(e -> !fkTargetIndexes.contains(e.getKey())).map(Map.Entry::getValue).collect(ImmutableCollectors.toList());
                if (!remainingTerms.stream().allMatch(t -> t instanceof Variable) || ImmutableSet.copyOf((Collection)remainingTerms).size() < remainingTerms.size()) break block2;
                if (!fkTargetIndexes.stream().map(arg_0 -> ((ImmutableMap)targetArguments).get(arg_0)).anyMatch(arg_0 -> ((ImmutableList)remainingTerms).contains(arg_0))) break block3;
            }
            return false;
        }
        NaiveVariableOccurrenceAnalyzerImpl analyzer = new NaiveVariableOccurrenceAnalyzerImpl();
        return remainingTerms.stream().map(v -> (Variable)v).noneMatch(v -> analyzer.isVariableUsedSomewhereElse(query, (QueryNode)targetDataNode, (Variable)v));
    }

    private ImmutableSet<Variable> extractJoiningVariables(ExtensionalDataNode node, ForeignKeyConstraint constraint) {
        ImmutableMap targetArgumentMap = node.getArgumentMap();
        return (ImmutableSet)constraint.getComponents().stream().map(c -> (VariableOrGroundTerm)targetArgumentMap.get((Object)(c.getReferencedAttribute().getIndex() - 1))).filter(t -> t instanceof Variable).map(t -> (Variable)t).collect(ImmutableCollectors.toSet());
    }

    private static class Redundancy {
        private final ExtensionalDataNode dataNode;
        private final ImmutableSet<Variable> fkVariables;

        private Redundancy(ExtensionalDataNode dataNode, ImmutableSet<Variable> fkVariables) {
            this.dataNode = dataNode;
            this.fkVariables = fkVariables;
        }
    }
}

