/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.iq.visitor.impl;

import com.google.common.collect.ImmutableList;
import it.unibz.inf.ontop.iq.IQTree;
import it.unibz.inf.ontop.iq.LeafIQTree;
import it.unibz.inf.ontop.iq.node.AggregationNode;
import it.unibz.inf.ontop.iq.node.BinaryNonCommutativeOperatorNode;
import it.unibz.inf.ontop.iq.node.ConstructionNode;
import it.unibz.inf.ontop.iq.node.DistinctNode;
import it.unibz.inf.ontop.iq.node.EmptyNode;
import it.unibz.inf.ontop.iq.node.ExtensionalDataNode;
import it.unibz.inf.ontop.iq.node.FilterNode;
import it.unibz.inf.ontop.iq.node.InnerJoinNode;
import it.unibz.inf.ontop.iq.node.IntensionalDataNode;
import it.unibz.inf.ontop.iq.node.LeftJoinNode;
import it.unibz.inf.ontop.iq.node.NaryOperatorNode;
import it.unibz.inf.ontop.iq.node.NativeNode;
import it.unibz.inf.ontop.iq.node.OrderByNode;
import it.unibz.inf.ontop.iq.node.SliceNode;
import it.unibz.inf.ontop.iq.node.TrueNode;
import it.unibz.inf.ontop.iq.node.UnaryOperatorNode;
import it.unibz.inf.ontop.iq.node.UnionNode;
import it.unibz.inf.ontop.iq.visit.IQVisitor;
import it.unibz.inf.ontop.iq.visitor.RequiredDataAtomExtractor;
import it.unibz.inf.ontop.model.atom.DataAtom;
import it.unibz.inf.ontop.model.atom.RelationPredicate;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class RequiredDataAtomExtractorImpl
implements RequiredDataAtomExtractor {
    @Inject
    protected RequiredDataAtomExtractorImpl() {
    }

    public Stream<DataAtom<RelationPredicate>> visitIntensionalData(IntensionalDataNode dataNode) {
        return Stream.empty();
    }

    public Stream<DataAtom<RelationPredicate>> visitExtensionalData(ExtensionalDataNode dataNode) {
        return Stream.of(dataNode.getProjectionAtom());
    }

    public Stream<DataAtom<RelationPredicate>> visitEmpty(EmptyNode node) {
        return Stream.empty();
    }

    public Stream<DataAtom<RelationPredicate>> visitTrue(TrueNode node) {
        return Stream.empty();
    }

    public Stream<DataAtom<RelationPredicate>> visitNative(NativeNode nativeNode) {
        return Stream.empty();
    }

    public Stream<DataAtom<RelationPredicate>> visitNonStandardLeafNode(LeafIQTree leafNode) {
        return Stream.empty();
    }

    public Stream<DataAtom<RelationPredicate>> visitConstruction(ConstructionNode rootNode, IQTree child) {
        return (Stream)child.acceptVisitor((IQVisitor)this);
    }

    public Stream<DataAtom<RelationPredicate>> visitAggregation(AggregationNode aggregationNode, IQTree child) {
        return Stream.empty();
    }

    public Stream<DataAtom<RelationPredicate>> visitFilter(FilterNode rootNode, IQTree child) {
        return (Stream)child.acceptVisitor((IQVisitor)this);
    }

    public Stream<DataAtom<RelationPredicate>> visitDistinct(DistinctNode rootNode, IQTree child) {
        return (Stream)child.acceptVisitor((IQVisitor)this);
    }

    public Stream<DataAtom<RelationPredicate>> visitSlice(SliceNode sliceNode, IQTree child) {
        return (Stream)child.acceptVisitor((IQVisitor)this);
    }

    public Stream<DataAtom<RelationPredicate>> visitOrderBy(OrderByNode rootNode, IQTree child) {
        return (Stream)child.acceptVisitor((IQVisitor)this);
    }

    public Stream<DataAtom<RelationPredicate>> visitNonStandardUnaryNode(UnaryOperatorNode rootNode, IQTree child) {
        return Stream.empty();
    }

    public Stream<DataAtom<RelationPredicate>> visitLeftJoin(LeftJoinNode rootNode, IQTree leftChild, IQTree rightChild) {
        return (Stream)leftChild.acceptVisitor((IQVisitor)this);
    }

    public Stream<DataAtom<RelationPredicate>> visitNonStandardBinaryNonCommutativeNode(BinaryNonCommutativeOperatorNode rootNode, IQTree leftChild, IQTree rightChild) {
        return Stream.empty();
    }

    public Stream<DataAtom<RelationPredicate>> visitInnerJoin(InnerJoinNode rootNode, ImmutableList<IQTree> children) {
        return children.stream().flatMap(c -> (Stream)c.acceptVisitor((IQVisitor)this));
    }

    public Stream<DataAtom<RelationPredicate>> visitUnion(UnionNode rootNode, ImmutableList<IQTree> children) {
        return Stream.empty();
    }

    public Stream<DataAtom<RelationPredicate>> visitNonStandardNaryNode(NaryOperatorNode rootNode, ImmutableList<IQTree> children) {
        return Stream.empty();
    }
}

