/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.iq.optimizer.impl;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import it.unibz.inf.ontop.exception.MinorOntopInternalBugException;
import it.unibz.inf.ontop.iq.IQ;
import it.unibz.inf.ontop.iq.IntermediateQuery;
import it.unibz.inf.ontop.iq.exception.EmptyQueryException;
import it.unibz.inf.ontop.iq.optimizer.InnerJoinIQOptimizer;
import it.unibz.inf.ontop.iq.optimizer.InnerJoinMutableOptimizer;
import it.unibz.inf.ontop.iq.optimizer.JoinLikeOptimizer;
import it.unibz.inf.ontop.iq.optimizer.LeftJoinIQOptimizer;
import it.unibz.inf.ontop.iq.optimizer.LeftJoinMutableOptimizer;
import it.unibz.inf.ontop.iq.tools.IQConverter;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class FixedPointJoinLikeOptimizer
implements JoinLikeOptimizer {
    private static final Logger log = LoggerFactory.getLogger(FixedPointJoinLikeOptimizer.class);
    private static final int MAX_LOOP = 100;
    private final InnerJoinMutableOptimizer joinMutableOptimizer;
    private final LeftJoinMutableOptimizer leftJoinMutableOptimizer;
    private final InnerJoinIQOptimizer innerJoinIQOptimizer;
    private final LeftJoinIQOptimizer leftJoinIQOptimizer;
    private final IQConverter iqConverter;

    @Inject
    private FixedPointJoinLikeOptimizer(InnerJoinMutableOptimizer joinMutableOptimizer, LeftJoinMutableOptimizer leftJoinMutableOptimizer, InnerJoinIQOptimizer innerJoinIQOptimizer, LeftJoinIQOptimizer leftJoinIQOptimizer, IQConverter iqConverter) {
        this.joinMutableOptimizer = joinMutableOptimizer;
        this.leftJoinMutableOptimizer = leftJoinMutableOptimizer;
        this.innerJoinIQOptimizer = innerJoinIQOptimizer;
        this.leftJoinIQOptimizer = leftJoinIQOptimizer;
        this.iqConverter = iqConverter;
    }

    @Override
    public IntermediateQuery optimize(IntermediateQuery query) throws EmptyQueryException {
        UUID conversionVersion = UUID.randomUUID();
        while (true) {
            boolean converged;
            UUID oldVersionNumber = query.getVersionNumber();
            query = this.leftJoinMutableOptimizer.optimize(query);
            log.debug("New query after left join mutable optimization: \n" + query.toString());
            query = this.joinMutableOptimizer.optimize(query);
            log.debug("New query after join mutable optimization: \n" + query.toString());
            if (oldVersionNumber != query.getVersionNumber()) continue;
            boolean bl = converged = conversionVersion == query.getVersionNumber();
            if (!converged) {
                IQ newIQ = this.optimizeIQ(this.iqConverter.convert(query));
                query = this.iqConverter.convert(newIQ, query.getExecutorRegistry());
                conversionVersion = query.getVersionNumber();
            }
            if (converged) break;
        }
        return query;
    }

    private IQ optimizeIQ(IQ initialIQ) {
        IQ currentIQ = initialIQ;
        for (int i = 0; i < 100; ++i) {
            IQ optimizedIQ = this.leftJoinIQOptimizer.optimize(this.innerJoinIQOptimizer.optimize(currentIQ)).normalizeForOptimization();
            if (optimizedIQ.equals(currentIQ)) {
                return optimizedIQ;
            }
            currentIQ = optimizedIQ;
        }
        throw new MinorOntopInternalBugException("MAX_LOOP reached");
    }
}

