/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.iq.optimizer.impl;

import com.google.common.collect.ImmutableList;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import it.unibz.inf.ontop.exception.MinorOntopInternalBugException;
import it.unibz.inf.ontop.injection.IntermediateQueryFactory;
import it.unibz.inf.ontop.iq.BinaryNonCommutativeIQTree;
import it.unibz.inf.ontop.iq.IQ;
import it.unibz.inf.ontop.iq.IQTree;
import it.unibz.inf.ontop.iq.NaryIQTree;
import it.unibz.inf.ontop.iq.UnaryIQTree;
import it.unibz.inf.ontop.iq.node.BinaryNonCommutativeOperatorNode;
import it.unibz.inf.ontop.iq.node.InnerJoinNode;
import it.unibz.inf.ontop.iq.node.LeftJoinNode;
import it.unibz.inf.ontop.iq.node.NaryOperatorNode;
import it.unibz.inf.ontop.iq.node.UnaryOperatorNode;
import it.unibz.inf.ontop.iq.optimizer.UnionAndBindingLiftOptimizer;
import it.unibz.inf.ontop.model.term.ImmutableExpression;
import it.unibz.inf.ontop.model.term.ImmutableTerm;
import it.unibz.inf.ontop.model.term.Variable;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import it.unibz.inf.ontop.utils.VariableGenerator;
import java.util.Optional;
import java.util.stream.IntStream;
import java.util.stream.Stream;

@Singleton
public class BottomUpUnionAndBindingLiftOptimizer
implements UnionAndBindingLiftOptimizer {
    private static final int ITERATION_BOUND = 10000;
    private final IntermediateQueryFactory iqFactory;

    @Inject
    private BottomUpUnionAndBindingLiftOptimizer(IntermediateQueryFactory iqFactory) {
        this.iqFactory = iqFactory;
    }

    @Override
    public IQ optimize(IQ query) {
        IQ bindingLiftedQuery = query.normalizeForOptimization();
        return this.liftUnionsInTree(bindingLiftedQuery);
    }

    private IQ liftUnionsInTree(IQ query) {
        IQTree previousTree;
        VariableGenerator variableGenerator = query.getVariableGenerator();
        IQTree newTree = query.getTree();
        int i = 0;
        while (!(newTree = this.liftTree(previousTree = newTree, variableGenerator).normalizeForOptimization(variableGenerator)).equals(previousTree) && ++i < 10000) {
        }
        if (i >= 10000) {
            throw new MinorOntopInternalBugException(this.getClass().getName() + " did not converge after " + 10000 + " iterations");
        }
        return newTree.equals(query.getTree()) ? query : this.iqFactory.createIQ(query.getProjectionAtom(), newTree);
    }

    private IQTree liftTree(IQTree queryTree, VariableGenerator variableGenerator) {
        if (queryTree instanceof UnaryIQTree) {
            return this.liftUnary((UnaryIQTree)queryTree, variableGenerator);
        }
        if (queryTree instanceof NaryIQTree) {
            return this.liftNary((NaryIQTree)queryTree, variableGenerator);
        }
        if (queryTree instanceof BinaryNonCommutativeIQTree) {
            return this.liftBinaryNonCommutative((BinaryNonCommutativeIQTree)queryTree, variableGenerator);
        }
        return queryTree;
    }

    private UnaryIQTree liftUnary(UnaryIQTree queryTree, VariableGenerator variableGenerator) {
        IQTree newChild = this.liftTree(queryTree.getChild(), variableGenerator);
        return newChild.equals(queryTree.getChild()) ? queryTree : this.iqFactory.createUnaryIQTree((UnaryOperatorNode)queryTree.getRootNode(), newChild);
    }

    private IQTree liftNary(NaryIQTree queryTree, VariableGenerator variableGenerator) {
        NaryOperatorNode root = (NaryOperatorNode)queryTree.getRootNode();
        ImmutableList newChildren = (ImmutableList)queryTree.getChildren().stream().map(queryTree1 -> this.liftTree((IQTree)queryTree1, variableGenerator)).collect(ImmutableCollectors.toList());
        if (root instanceof InnerJoinNode) {
            return this.liftInnerJoin(queryTree, (ImmutableList<IQTree>)newChildren, variableGenerator);
        }
        return newChildren.equals((Object)queryTree.getChildren()) ? queryTree : this.iqFactory.createNaryIQTree(root, newChildren);
    }

    private IQTree liftInnerJoin(NaryIQTree queryTree, ImmutableList<IQTree> newChildren, VariableGenerator variableGenerator) {
        InnerJoinNode joinNode = (InnerJoinNode)queryTree.getRootNode();
        NaryIQTree newQueryTree = newChildren.equals((Object)queryTree.getChildren()) ? queryTree : this.iqFactory.createNaryIQTree((NaryOperatorNode)joinNode, newChildren);
        return this.extractCandidateVariables((IQTree)queryTree, joinNode.getOptionalFilterCondition(), newChildren).map(variable -> newQueryTree.liftIncompatibleDefinitions(variable, variableGenerator)).filter(t -> !t.equals(queryTree)).findFirst().orElse((IQTree)newQueryTree).normalizeForOptimization(variableGenerator);
    }

    private Stream<Variable> extractCandidateVariables(IQTree tree, Optional<ImmutableExpression> optionalFilterCondition, ImmutableList<IQTree> newChildren) {
        Stream coOccurringVariables = IntStream.range(0, newChildren.size() - 1).boxed().flatMap(i -> ((IQTree)newChildren.get(i.intValue())).getVariables().stream().filter(v1 -> IntStream.range(i + 1, newChildren.size()).anyMatch(j -> ((IQTree)newChildren.get(j)).getVariables().stream().anyMatch(v1::equals))));
        return Stream.concat(optionalFilterCondition.map(ImmutableTerm::getVariableStream).orElseGet(Stream::empty), coOccurringVariables).distinct().filter(arg_0 -> ((IQTree)tree).isConstructed(arg_0));
    }

    private IQTree liftBinaryNonCommutative(BinaryNonCommutativeIQTree queryTree, VariableGenerator variableGenerator) {
        BinaryNonCommutativeOperatorNode root = (BinaryNonCommutativeOperatorNode)queryTree.getRootNode();
        IQTree newLeftChild = this.liftTree(queryTree.getLeftChild(), variableGenerator);
        IQTree newRightChild = this.liftTree(queryTree.getRightChild(), variableGenerator);
        if (root instanceof LeftJoinNode) {
            return this.liftLJJoin(queryTree, newLeftChild, newRightChild, variableGenerator);
        }
        return newLeftChild.equals(queryTree.getLeftChild()) && newRightChild.equals(queryTree.getRightChild()) ? queryTree : this.iqFactory.createBinaryNonCommutativeIQTree(root, newLeftChild, newRightChild);
    }

    private IQTree liftLJJoin(BinaryNonCommutativeIQTree queryTree, IQTree newLeftChild, IQTree newRightChild, VariableGenerator variableGenerator) {
        LeftJoinNode leftJoinNode = (LeftJoinNode)queryTree.getRootNode();
        BinaryNonCommutativeIQTree newQueryTree = newLeftChild.equals(queryTree.getLeftChild()) && newRightChild.equals(queryTree.getRightChild()) ? queryTree : this.iqFactory.createBinaryNonCommutativeIQTree((BinaryNonCommutativeOperatorNode)leftJoinNode, newLeftChild, newRightChild);
        return this.extractCandidateVariables((IQTree)queryTree, leftJoinNode.getOptionalFilterCondition(), (ImmutableList<IQTree>)ImmutableList.of((Object)newLeftChild, (Object)newRightChild)).filter(v -> newLeftChild.getVariables().contains(v)).map(variable -> newQueryTree.liftIncompatibleDefinitions(variable, variableGenerator)).filter(t -> !t.equals(queryTree)).findFirst().orElse((IQTree)newQueryTree).normalizeForOptimization(variableGenerator);
    }
}

