/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.iq.optimizer;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import it.unibz.inf.ontop.iq.IntermediateQuery;
import it.unibz.inf.ontop.iq.exception.EmptyQueryException;
import it.unibz.inf.ontop.iq.node.ConstructionNode;
import it.unibz.inf.ontop.iq.node.DistinctNode;
import it.unibz.inf.ontop.iq.node.ExplicitVariableProjectionNode;
import it.unibz.inf.ontop.iq.node.ExtendedProjectionNode;
import it.unibz.inf.ontop.iq.node.JoinLikeNode;
import it.unibz.inf.ontop.iq.node.JoinOrFilterNode;
import it.unibz.inf.ontop.iq.node.OrderByNode;
import it.unibz.inf.ontop.iq.node.QueryNode;
import it.unibz.inf.ontop.iq.node.UnionNode;
import it.unibz.inf.ontop.iq.optimizer.IntermediateQueryOptimizer;
import it.unibz.inf.ontop.iq.proposal.NodeCentricOptimizationResults;
import it.unibz.inf.ontop.iq.proposal.ProjectionShrinkingProposal;
import it.unibz.inf.ontop.iq.proposal.QueryOptimizationProposal;
import it.unibz.inf.ontop.iq.proposal.impl.ProjectionShrinkingProposalImpl;
import it.unibz.inf.ontop.model.term.ImmutableExpression;
import it.unibz.inf.ontop.model.term.ImmutableTerm;
import it.unibz.inf.ontop.model.term.Variable;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class ProjectionShrinkingOptimizer
implements IntermediateQueryOptimizer {
    @Override
    public IntermediateQuery optimize(IntermediateQuery query) {
        return this.optimizeSubtree(query.getRootNode(), query, (ImmutableSet<Variable>)query.getProjectionAtom().getVariables());
    }

    private IntermediateQuery optimizeSubtree(QueryNode focusNode, IntermediateQuery query, ImmutableSet<Variable> retainedVariables) {
        Optional<Object> optionalProposal = Optional.empty();
        if (focusNode instanceof UnionNode || focusNode instanceof ConstructionNode) {
            optionalProposal = this.makeProposal((ExplicitVariableProjectionNode)focusNode, retainedVariables);
        }
        if (focusNode instanceof DistinctNode) {
            retainedVariables = query.getVariables(focusNode);
        } else if (focusNode instanceof JoinOrFilterNode) {
            retainedVariables = this.updateRetainedVariables((JoinOrFilterNode)focusNode, query, retainedVariables);
        } else if (focusNode instanceof ExtendedProjectionNode) {
            retainedVariables = this.updateRetainedVariables((ExtendedProjectionNode)focusNode);
        } else if (focusNode instanceof OrderByNode) {
            retainedVariables = this.updateRetainedVariables((OrderByNode)focusNode, retainedVariables);
        }
        if (optionalProposal.isPresent()) {
            NodeCentricOptimizationResults optimizationResults;
            try {
                optimizationResults = (NodeCentricOptimizationResults)query.applyProposal((QueryOptimizationProposal)optionalProposal.get());
            }
            catch (EmptyQueryException e) {
                throw new IllegalStateException("The projection shrinker should not empty the query");
            }
            focusNode = optimizationResults.getNewNodeOrReplacingChild().orElseThrow(() -> new IllegalStateException("A replacing node should be generated"));
        }
        for (QueryNode childNode : query.getChildren(focusNode)) {
            query = this.optimizeSubtree(childNode, query, retainedVariables);
        }
        return query;
    }

    private ImmutableSet<Variable> updateRetainedVariables(OrderByNode focusNode, ImmutableSet<Variable> retainedVariables) {
        return Sets.union(retainedVariables, (Set)focusNode.getLocalVariables()).immutableCopy();
    }

    private Optional<ProjectionShrinkingProposal> makeProposal(ExplicitVariableProjectionNode node, ImmutableSet<Variable> retainedVariables) {
        if (node instanceof UnionNode || node instanceof ConstructionNode) {
            ImmutableSet<Variable> locallyRetainedVariables = node instanceof ConstructionNode ? this.getLocallyRequiredVariables((ConstructionNode)node) : ImmutableSet.of();
            Map<Boolean, List<Variable>> splitVariables = node.getVariables().stream().collect(Collectors.partitioningBy(v -> retainedVariables.contains(v) || locallyRetainedVariables.contains(v)));
            if (splitVariables.get(false).iterator().hasNext()) {
                return Optional.of(new ProjectionShrinkingProposalImpl(node, (ImmutableSet<Variable>)((ImmutableSet)splitVariables.get(true).stream().collect(ImmutableCollectors.toSet()))));
            }
            return Optional.empty();
        }
        throw new IllegalStateException("A projection shrinking proposal can only be made for a Union or Construction node");
    }

    private ImmutableSet<Variable> getLocallyRequiredVariables(ConstructionNode node) {
        return (ImmutableSet)node.getSubstitution().getImmutableMap().values().stream().filter(t -> t instanceof Variable).map(v -> (Variable)v).collect(ImmutableCollectors.toSet());
    }

    private ImmutableSet<Variable> updateRetainedVariables(JoinOrFilterNode joinOrFilterNode, IntermediateQuery query, ImmutableSet<Variable> allRetainedVariables) {
        HashSet joinOrFilterVariables = new HashSet();
        Optional explicitJoiningCondition = joinOrFilterNode.getOptionalFilterCondition();
        if (explicitJoiningCondition.isPresent()) {
            joinOrFilterVariables.addAll(((ImmutableExpression)explicitJoiningCondition.get()).getVariables());
        }
        HashSet<Variable> repeatedVariables = new HashSet<Variable>();
        if (joinOrFilterNode instanceof JoinLikeNode) {
            HashSet<Variable> encounteredVariables = new HashSet<Variable>();
            for (QueryNode child : query.getChildren((QueryNode)joinOrFilterNode)) {
                for (Variable v : query.getVariables(child)) {
                    if (encounteredVariables.contains(v)) {
                        repeatedVariables.add(v);
                    }
                    encounteredVariables.add(v);
                }
            }
        }
        joinOrFilterVariables.addAll(repeatedVariables);
        return ImmutableSet.copyOf((Collection)Sets.union(allRetainedVariables, joinOrFilterVariables));
    }

    private ImmutableSet<Variable> updateRetainedVariables(ExtendedProjectionNode extendedProjectionNode) {
        ImmutableSet projectedVariables = extendedProjectionNode.getVariables();
        ImmutableSet substitutionOutput = extendedProjectionNode.getSubstitution().getDomain();
        ImmutableSet simpleProjectionVariables = (ImmutableSet)projectedVariables.stream().filter(v -> !substitutionOutput.contains(v)).collect(ImmutableCollectors.toSet());
        ImmutableSet variablesRequiredBySubstitution = (ImmutableSet)extendedProjectionNode.getSubstitution().getImmutableMap().values().stream().flatMap(ImmutableTerm::getVariableStream).collect(ImmutableCollectors.toSet());
        return ImmutableSet.builder().addAll((Iterable)simpleProjectionVariables).addAll((Iterable)variablesRequiredBySubstitution).build();
    }
}

