/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.iq.optimizer;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import it.unibz.inf.ontop.iq.IntermediateQuery;
import it.unibz.inf.ontop.iq.exception.EmptyQueryException;
import it.unibz.inf.ontop.iq.node.QueryNode;
import it.unibz.inf.ontop.iq.node.UnionNode;
import it.unibz.inf.ontop.iq.optimizer.impl.NodeCentricDepthFirstOptimizer;
import it.unibz.inf.ontop.iq.proposal.FlattenUnionProposal;
import it.unibz.inf.ontop.iq.proposal.impl.FlattenUnionProposalImpl;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import java.util.Optional;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlattenUnionOptimizer
extends NodeCentricDepthFirstOptimizer<FlattenUnionProposal> {
    private static final Logger log = LoggerFactory.getLogger(FlattenUnionOptimizer.class);

    public FlattenUnionOptimizer() {
        super(false);
    }

    @Override
    public IntermediateQuery optimize(IntermediateQuery query) throws EmptyQueryException {
        IntermediateQuery optimizedQuery = super.optimize(query);
        log.trace("New query after union flattening: \n" + optimizedQuery.toString());
        return optimizedQuery;
    }

    @Override
    protected Optional<FlattenUnionProposal> evaluateNode(QueryNode node, IntermediateQuery query) {
        if (node instanceof UnionNode) {
            return this.evaluateUnionNode((UnionNode)node, query);
        }
        return Optional.empty();
    }

    private Optional<FlattenUnionProposal> evaluateUnionNode(UnionNode node, IntermediateQuery query) {
        ImmutableList unionNodesToMerge = (ImmutableList)this.getUnionCluster(node, query).collect(ImmutableCollectors.toList());
        return unionNodesToMerge.size() > 1 ? Optional.of(this.makeFlattenProposal(node, (ImmutableList<UnionNode>)unionNodesToMerge, query)) : Optional.empty();
    }

    private Stream<UnionNode> getUnionCluster(UnionNode focusNode, IntermediateQuery query) {
        return Stream.concat(Stream.of(focusNode), query.getChildren((QueryNode)focusNode).stream().filter(n -> n instanceof UnionNode).flatMap(n -> this.getUnionCluster((UnionNode)n, query)));
    }

    private FlattenUnionProposal makeFlattenProposal(UnionNode focusNode, ImmutableList<UnionNode> unionNodesToMerge, IntermediateQuery query) {
        return new FlattenUnionProposalImpl(focusNode, (ImmutableSet<QueryNode>)((ImmutableSet)unionNodesToMerge.stream().flatMap(n -> query.getChildren((QueryNode)n).stream()).filter(n -> !(n instanceof UnionNode)).collect(ImmutableCollectors.toSet())));
    }
}

