/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.iq.executor.union.impl;

import com.google.inject.Inject;
import it.unibz.inf.ontop.injection.IntermediateQueryFactory;
import it.unibz.inf.ontop.iq.IntermediateQuery;
import it.unibz.inf.ontop.iq.exception.InvalidQueryOptimizationProposalException;
import it.unibz.inf.ontop.iq.executor.union.UnionLiftExecutor;
import it.unibz.inf.ontop.iq.impl.QueryTreeComponent;
import it.unibz.inf.ontop.iq.node.BinaryOrderedOperatorNode;
import it.unibz.inf.ontop.iq.node.LeftJoinNode;
import it.unibz.inf.ontop.iq.node.QueryNode;
import it.unibz.inf.ontop.iq.node.UnionNode;
import it.unibz.inf.ontop.iq.proposal.NodeCentricOptimizationResults;
import it.unibz.inf.ontop.iq.proposal.UnionLiftProposal;
import it.unibz.inf.ontop.iq.proposal.impl.NodeCentricOptimizationResultsImpl;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Optional;

public class UnionLiftExecutorImpl
implements UnionLiftExecutor {
    private final IntermediateQueryFactory iqFactory;

    @Inject
    private UnionLiftExecutorImpl(IntermediateQueryFactory iqFactory) {
        this.iqFactory = iqFactory;
    }

    public NodeCentricOptimizationResults<UnionNode> apply(UnionLiftProposal proposal, IntermediateQuery query, QueryTreeComponent treeComponent) throws InvalidQueryOptimizationProposalException {
        this.validateProposal(proposal, query);
        UnionNode newUnionNode = this.liftUnionNode(proposal, query, treeComponent);
        return new NodeCentricOptimizationResultsImpl<UnionNode>(query, newUnionNode);
    }

    private void validateProposal(UnionLiftProposal proposal, IntermediateQuery query) throws InvalidQueryOptimizationProposalException {
        UnionNode focusNode = (UnionNode)proposal.getFocusNode();
        QueryNode targetNode = proposal.getTargetNode();
        if (targetNode instanceof UnionNode) {
            throw new InvalidQueryOptimizationProposalException("The target node of UnionLiftProposal cannot be an union node");
        }
        if (targetNode instanceof LeftJoinNode && this.getDescendantPosition((LeftJoinNode)targetNode, (QueryNode)focusNode, query) == BinaryOrderedOperatorNode.ArgumentPosition.RIGHT) {
            throw new InvalidQueryOptimizationProposalException("Lifting a UNION from the right part of a LJ is not allowed");
        }
        if (!query.hasAncestor((QueryNode)focusNode, targetNode)) {
            throw new InvalidQueryOptimizationProposalException("The focus must be a descendant of the target node");
        }
    }

    private BinaryOrderedOperatorNode.ArgumentPosition getDescendantPosition(LeftJoinNode ancestorNode, QueryNode descendantNode, IntermediateQuery query) throws InvalidQueryOptimizationProposalException {
        Optional optionalCurrentAncestor = query.getParent(descendantNode);
        QueryNode currentChild = descendantNode;
        while (optionalCurrentAncestor.isPresent()) {
            QueryNode currentAncestor = (QueryNode)optionalCurrentAncestor.get();
            if (currentAncestor == ancestorNode) {
                return (BinaryOrderedOperatorNode.ArgumentPosition)query.getOptionalPosition(currentAncestor, currentChild).orElseThrow(() -> new IllegalStateException("The child of a LJ must have a position"));
            }
            optionalCurrentAncestor = query.getParent(currentAncestor);
            currentChild = currentAncestor;
        }
        throw new InvalidQueryOptimizationProposalException("The focus must be a descendant of the target node");
    }

    private UnionNode liftUnionNode(UnionLiftProposal proposal, IntermediateQuery query, QueryTreeComponent treeComponent) {
        QueryNode targetNode = proposal.getTargetNode();
        UnionNode focusNode = (UnionNode)proposal.getFocusNode();
        UnionNode newTopUnionNode = this.iqFactory.createUnionNode(query.getVariables(targetNode));
        IntermediateQuery querySnapshot = query.createSnapshot();
        treeComponent.replaceSubTree(targetNode, (QueryNode)newTopUnionNode);
        querySnapshot.getChildren((QueryNode)focusNode).forEach(c -> this.appendUnionChildBranch((QueryNode)c, focusNode, targetNode, newTopUnionNode, query, querySnapshot, treeComponent));
        return newTopUnionNode;
    }

    private void appendUnionChildBranch(QueryNode child, UnionNode focusNode, QueryNode targetNode, UnionNode newTopUnionNode, IntermediateQuery query, IntermediateQuery querySnapshot, QueryTreeComponent treeComponent) {
        HashMap<Object, Object> snapshotToQuery = new HashMap<Object, Object>();
        snapshotToQuery.put(focusNode, newTopUnionNode);
        QueryNode targetNodeClone = targetNode.clone();
        snapshotToQuery.put(targetNode, targetNodeClone);
        treeComponent.addChild((QueryNode)newTopUnionNode, targetNodeClone, Optional.empty(), false);
        LinkedList originalNodesToVisit = new LinkedList();
        originalNodesToVisit.addAll(querySnapshot.getChildren(targetNode));
        while (!originalNodesToVisit.isEmpty()) {
            QueryNode newNode;
            QueryNode originalNode = (QueryNode)originalNodesToVisit.poll();
            QueryNode originalParent = (QueryNode)querySnapshot.getParent(originalNode).get();
            QueryNode newParentNode = (QueryNode)snapshotToQuery.get(originalParent);
            if (originalNode == focusNode) {
                newNode = child;
                originalNodesToVisit.addAll(querySnapshot.getChildren(child));
                snapshotToQuery.put(child, child);
            } else {
                newNode = originalNode.clone();
                originalNodesToVisit.addAll(querySnapshot.getChildren(originalNode));
                snapshotToQuery.put(originalNode, newNode);
            }
            treeComponent.addChild(newParentNode, newNode, querySnapshot.getOptionalPosition(originalParent, originalNode), false);
        }
    }
}

