/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.iq.executor.leftjoin;

import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import it.unibz.inf.ontop.dbschema.ForeignKeyConstraint;
import it.unibz.inf.ontop.dbschema.RelationDefinition;
import it.unibz.inf.ontop.dbschema.UniqueConstraint;
import it.unibz.inf.ontop.exception.MinorOntopInternalBugException;
import it.unibz.inf.ontop.iq.executor.leftjoin.LeftJoinRightChildNormalizationAnalyzer;
import it.unibz.inf.ontop.iq.node.DataNode;
import it.unibz.inf.ontop.iq.node.ExtensionalDataNode;
import it.unibz.inf.ontop.iq.node.VariableNullability;
import it.unibz.inf.ontop.model.atom.AtomFactory;
import it.unibz.inf.ontop.model.atom.AtomPredicate;
import it.unibz.inf.ontop.model.atom.DataAtom;
import it.unibz.inf.ontop.model.atom.RelationPredicate;
import it.unibz.inf.ontop.model.term.GroundTerm;
import it.unibz.inf.ontop.model.term.ImmutableExpression;
import it.unibz.inf.ontop.model.term.ImmutableTerm;
import it.unibz.inf.ontop.model.term.TermFactory;
import it.unibz.inf.ontop.model.term.Variable;
import it.unibz.inf.ontop.model.term.VariableOrGroundTerm;
import it.unibz.inf.ontop.model.term.impl.ImmutabilityTools;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import it.unibz.inf.ontop.utils.VariableGenerator;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.annotation.Nullable;

@Singleton
public class LeftJoinRightChildNormalizationAnalyzerImpl
implements LeftJoinRightChildNormalizationAnalyzer {
    private final TermFactory termFactory;
    private final AtomFactory atomFactory;
    private final ImmutabilityTools immutabilityTools;

    @Inject
    private LeftJoinRightChildNormalizationAnalyzerImpl(TermFactory termFactory, AtomFactory atomFactory, ImmutabilityTools immutabilityTools) {
        this.termFactory = termFactory;
        this.atomFactory = atomFactory;
        this.immutabilityTools = immutabilityTools;
    }

    @Override
    public LeftJoinRightChildNormalizationAnalyzer.LeftJoinRightChildNormalizationAnalysis analyze(ImmutableSet<Variable> leftVariables, ImmutableList<ExtensionalDataNode> leftDataNodes, ExtensionalDataNode rightDataNode, VariableGenerator variableGenerator, VariableNullability variableNullability) {
        ImmutableMultimap leftRelationArgumentMultimap = (ImmutableMultimap)leftDataNodes.stream().map(DataNode::getProjectionAtom).map(a -> Maps.immutableEntry((Object)((RelationPredicate)a.getPredicate()).getRelationDefinition(), (Object)a.getArguments())).collect(ImmutableCollectors.toMultimap(Map.Entry::getKey, Map.Entry::getValue));
        DataAtom rightProjectionAtom = rightDataNode.getProjectionAtom();
        ImmutableList rightArguments = rightProjectionAtom.getArguments();
        if (leftRelationArgumentMultimap.isEmpty()) {
            return new LeftJoinRightChildNormalizationAnalysisImpl(false);
        }
        RelationDefinition rightRelation = ((RelationPredicate)rightDataNode.getProjectionAtom().getPredicate()).getRelationDefinition();
        ImmutableSet<UniqueConstraint> matchedUCs = this.extractMatchedUCs((ImmutableMultimap<RelationDefinition, ImmutableList<? extends VariableOrGroundTerm>>)leftRelationArgumentMultimap, (ImmutableList<? extends VariableOrGroundTerm>)rightArguments, rightRelation, variableNullability);
        ImmutableSet<ForeignKeyConstraint> matchedFKs = this.extractMatchedFKs((ImmutableMultimap<RelationDefinition, ImmutableList<? extends VariableOrGroundTerm>>)leftRelationArgumentMultimap, (ImmutableList<? extends VariableOrGroundTerm>)rightArguments, rightRelation, variableNullability);
        if (matchedUCs.isEmpty() && matchedFKs.isEmpty()) {
            return new LeftJoinRightChildNormalizationAnalysisImpl(false);
        }
        ImmutableSet<Integer> nonMatchedRightAttributeIndexes = this.extractNonMatchedRightAttributeIndexes((ImmutableCollection<UniqueConstraint>)matchedUCs, (ImmutableCollection<ForeignKeyConstraint>)matchedFKs, rightArguments.size());
        ImmutableList conflictingRightArgumentIndexes = (ImmutableList)nonMatchedRightAttributeIndexes.stream().filter(i -> this.isRightArgumentConflicting((int)i, (ImmutableCollection<Variable>)leftVariables, (ImmutableList<? extends VariableOrGroundTerm>)rightArguments, nonMatchedRightAttributeIndexes)).collect(ImmutableCollectors.toList());
        if (!conflictingRightArgumentIndexes.isEmpty()) {
            ExtensionalDataNode newRightDataNode = rightDataNode.newAtom(this.computeNewRightAtom((RelationPredicate)rightProjectionAtom.getPredicate(), (ImmutableList<? extends VariableOrGroundTerm>)rightArguments, (ImmutableList<Integer>)conflictingRightArgumentIndexes, variableGenerator));
            ImmutableExpression newExpression = this.computeExpression((ImmutableList<? extends VariableOrGroundTerm>)rightArguments, (ImmutableList<? extends VariableOrGroundTerm>)newRightDataNode.getProjectionAtom().getArguments());
            return new LeftJoinRightChildNormalizationAnalysisImpl((DataNode)newRightDataNode, newExpression);
        }
        return new LeftJoinRightChildNormalizationAnalysisImpl(true);
    }

    private ImmutableSet<UniqueConstraint> extractMatchedUCs(ImmutableMultimap<RelationDefinition, ImmutableList<? extends VariableOrGroundTerm>> leftRelationArgumentMultimap, ImmutableList<? extends VariableOrGroundTerm> rightArguments, RelationDefinition rightRelation, VariableNullability variableNullability) {
        return (ImmutableSet)leftRelationArgumentMultimap.get((Object)rightRelation).stream().flatMap(leftArguments -> rightRelation.getUniqueConstraints().stream().filter(uc -> this.isUcMatching((UniqueConstraint)uc, (ImmutableList<? extends VariableOrGroundTerm>)leftArguments, rightArguments, variableNullability))).collect(ImmutableCollectors.toSet());
    }

    private boolean isUcMatching(UniqueConstraint uniqueConstraint, ImmutableList<? extends VariableOrGroundTerm> leftArguments, ImmutableList<? extends VariableOrGroundTerm> rightArguments, VariableNullability variableNullability) {
        return uniqueConstraint.getAttributes().stream().allMatch(a -> ((VariableOrGroundTerm)leftArguments.get(a.getIndex() - 1)).equals(rightArguments.get(a.getIndex() - 1)) && !((VariableOrGroundTerm)leftArguments.get(a.getIndex() - 1)).isNullable(variableNullability.getNullableVariables()));
    }

    private ImmutableSet<ForeignKeyConstraint> extractMatchedFKs(ImmutableMultimap<RelationDefinition, ImmutableList<? extends VariableOrGroundTerm>> leftRelationArgumentMultimap, ImmutableList<? extends VariableOrGroundTerm> rightArguments, RelationDefinition rightRelation, VariableNullability variableNullability) {
        return (ImmutableSet)leftRelationArgumentMultimap.asMap().entrySet().stream().flatMap(e -> this.extractMatchedFKsForARelation((RelationDefinition)e.getKey(), (Collection)e.getValue(), rightArguments, rightRelation, variableNullability)).collect(ImmutableCollectors.toSet());
    }

    private Stream<ForeignKeyConstraint> extractMatchedFKsForARelation(RelationDefinition leftRelation, Collection<ImmutableList<? extends VariableOrGroundTerm>> leftArgumentLists, ImmutableList<? extends VariableOrGroundTerm> rightArguments, RelationDefinition rightRelation, VariableNullability variableNullability) {
        return leftRelation.getForeignKeys().stream().filter(fk -> fk.getReferencedRelation().equals(rightRelation)).filter(fk -> leftArgumentLists.stream().anyMatch(leftArguments -> this.isFkMatching((ForeignKeyConstraint)fk, (ImmutableList<? extends VariableOrGroundTerm>)leftArguments, rightArguments, variableNullability)));
    }

    private boolean isFkMatching(ForeignKeyConstraint foreignKey, ImmutableList<? extends VariableOrGroundTerm> leftArguments, ImmutableList<? extends VariableOrGroundTerm> rightArguments, VariableNullability variableNullability) {
        return foreignKey.getComponents().stream().allMatch(c -> ((VariableOrGroundTerm)leftArguments.get(c.getAttribute().getIndex() - 1)).equals(rightArguments.get(c.getReference().getIndex() - 1)) && !((VariableOrGroundTerm)leftArguments.get(c.getAttribute().getIndex() - 1)).isNullable(variableNullability.getNullableVariables()));
    }

    private ImmutableSet<Integer> extractNonMatchedRightAttributeIndexes(ImmutableCollection<UniqueConstraint> matchedUCs, ImmutableCollection<ForeignKeyConstraint> matchedFKs, int arity) {
        return (ImmutableSet)IntStream.range(0, arity).filter(i -> matchedUCs.stream().noneMatch(uc -> uc.getAttributes().stream().anyMatch(a -> a.getIndex() == i + 1))).filter(i -> matchedFKs.stream().noneMatch(fk -> fk.getComponents().stream().anyMatch(c -> c.getReference().getIndex() == i + 1))).boxed().collect(ImmutableCollectors.toSet());
    }

    private boolean isRightArgumentConflicting(int rightArgumentIndex, ImmutableCollection<Variable> leftVariables, ImmutableList<? extends VariableOrGroundTerm> rightArguments, ImmutableSet<Integer> nonMatchedRightAttributeIndexes) {
        VariableOrGroundTerm rightArgument = (VariableOrGroundTerm)rightArguments.get(rightArgumentIndex);
        if (rightArgument instanceof GroundTerm) {
            return true;
        }
        Variable rightVariable = (Variable)rightArgument;
        if (leftVariables.contains((Object)rightVariable)) {
            return true;
        }
        return IntStream.range(0, rightArguments.size()).filter(i -> i < rightArgumentIndex || !nonMatchedRightAttributeIndexes.contains((Object)i)).anyMatch(i -> ((VariableOrGroundTerm)rightArguments.get(i)).equals(rightVariable));
    }

    private DataAtom<RelationPredicate> computeNewRightAtom(RelationPredicate predicate, ImmutableList<? extends VariableOrGroundTerm> rightArguments, ImmutableList<Integer> conflictingRightArgumentIndexes, VariableGenerator variableGenerator) {
        ImmutableList newArguments = (ImmutableList)IntStream.range(0, rightArguments.size()).boxed().map(i -> conflictingRightArgumentIndexes.contains(i) ? variableGenerator.generateNewVariable() : (VariableOrGroundTerm)rightArguments.get(i.intValue())).collect(ImmutableCollectors.toList());
        return this.atomFactory.getDataAtom((AtomPredicate)predicate, newArguments);
    }

    private ImmutableExpression computeExpression(ImmutableList<? extends VariableOrGroundTerm> formerRightArguments, ImmutableList<? extends VariableOrGroundTerm> newRightArguments) {
        Stream<ImmutableExpression> expressions = IntStream.range(0, formerRightArguments.size()).filter(i -> !((VariableOrGroundTerm)formerRightArguments.get(i)).equals(newRightArguments.get(i))).boxed().map(i -> this.termFactory.getStrictEquality((ImmutableTerm)newRightArguments.get(i.intValue()), (ImmutableTerm)formerRightArguments.get(i.intValue()), new ImmutableTerm[0]));
        return (ImmutableExpression)this.termFactory.getConjunction(expressions).orElseThrow(() -> new MinorOntopInternalBugException("A boolean expression was expected"));
    }

    public static class LeftJoinRightChildNormalizationAnalysisImpl
    implements LeftJoinRightChildNormalizationAnalyzer.LeftJoinRightChildNormalizationAnalysis {
        @Nullable
        private final DataNode newRightDataNode;
        @Nullable
        private final ImmutableExpression expression;
        private final boolean isMatchingAConstraint;

        private LeftJoinRightChildNormalizationAnalysisImpl(DataNode newRightDataNode, ImmutableExpression expression) {
            this.newRightDataNode = newRightDataNode;
            this.expression = expression;
            this.isMatchingAConstraint = true;
        }

        private LeftJoinRightChildNormalizationAnalysisImpl(boolean isMatchingAConstraint) {
            this.newRightDataNode = null;
            this.expression = null;
            this.isMatchingAConstraint = isMatchingAConstraint;
        }

        @Override
        public boolean isMatchingAConstraint() {
            return this.isMatchingAConstraint;
        }

        @Override
        public Optional<DataNode> getProposedRightDataNode() {
            return Optional.ofNullable(this.newRightDataNode);
        }

        @Override
        public Optional<ImmutableExpression> getAdditionalExpression() {
            return Optional.ofNullable(this.expression);
        }
    }
}

